/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureParsing {
    private SignatureParsing() {
    }

    @NotNull
    public static List<Pair<String, String[]>> parseTypeParametersDeclaration(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        if (signature2.current() != '<') {
            List<Pair<String, String[]>> list2 = Collections.emptyList();
            if (list2 == null) {
                SignatureParsing.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<Pair<String, String[]>> typeParameters2 = new ArrayList<Pair<String, String[]>>();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters2.add(SignatureParsing.parseTypeParameter(signature2, mapping2));
        }
        signature2.next();
        ArrayList<Pair<String, String[]>> arrayList = typeParameters2;
        if (arrayList == null) {
            SignatureParsing.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static Pair<String, String[]> parseTypeParameter(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        StringBuilder name = new StringBuilder();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            name.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping2.fun(name.toString());
        SmartList<String> bounds = null;
        boolean jlo = false;
        while (signature2.current() == ':') {
            signature2.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(signature2, mapping2);
            if (bound == null) continue;
            if (bounds == null) {
                if ("java.lang.Object".equals(bound)) {
                    jlo = true;
                    continue;
                }
                bounds = new SmartList<String>();
                if (jlo) {
                    bounds.add("java.lang.Object");
                }
            }
            bounds.add(bound);
        }
        return Pair.pair(parameterName, ArrayUtilRt.toStringArray(bounds));
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        switch (signature2.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignature(signature2, mapping2);
            }
            case 'T': {
                return SignatureParsing.parseTypeVariableRefSignature(signature2);
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature2) throws ClsFormatException {
        StringBuilder id = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        StringBuilder canonicalText = new StringBuilder();
        boolean mapped = false;
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            char c = signature2.current();
            if (c == '<') {
                canonicalText = new StringBuilder(mapping2.fun(canonicalText.toString()));
                mapped = true;
                boolean firstArg = true;
                signature2.next();
                do {
                    canonicalText.append(firstArg ? (char)'<' : ',').append(SignatureParsing.parseClassOrTypeVariableElement(signature2, mapping2));
                    firstArg = false;
                } while (signature2.current() != '>');
                canonicalText.append('>');
            } else if (c != ' ') {
                canonicalText.append(c);
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        signature2.next();
        String text2 = canonicalText.toString();
        if (!mapped) {
            text2 = mapping2.fun(text2);
        }
        return text2;
    }

    private static String parseClassOrTypeVariableElement(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature2);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText(null, variance);
        }
        int dimensions = SignatureParsing.parseDimensions(signature2);
        String text2 = SignatureParsing.parseTypeWithoutVariance(signature2, mapping2);
        if (text2 == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text2 = text2 + StringUtil.repeat("[]", dimensions);
        }
        return SignatureParsing.decorateTypeText(text2, variance);
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return "? extends " + canonical;
            }
            case '-': {
                return "? super " + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature2) {
        char variance;
        switch (signature2.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature2.current();
                signature2.next();
                break;
            }
            case '.': 
            case '=': {
                signature2.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    private static int parseDimensions(CharacterIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            ++dimensions;
            signature2.next();
        }
        return dimensions;
    }

    @NotNull
    public static String parseTypeString(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        int dimensions = SignatureParsing.parseDimensions(signature2);
        String text2 = SignatureParsing.parseTypeWithoutVariance(signature2, mapping2);
        if (text2 == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text2 = text2 + StringUtil.repeat("[]", dimensions);
        }
        String string2 = text2;
        if (string2 == null) {
            SignatureParsing.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature2, Function<String, String> mapping2) throws ClsFormatException {
        String text2 = null;
        switch (signature2.current()) {
            case 'L': {
                text2 = SignatureParsing.parseParameterizedClassRefSignature(signature2, mapping2);
                break;
            }
            case 'T': {
                text2 = SignatureParsing.parseTypeVariableRefSignature(signature2);
                break;
            }
            case 'B': {
                text2 = "byte";
                signature2.next();
                break;
            }
            case 'C': {
                text2 = "char";
                signature2.next();
                break;
            }
            case 'D': {
                text2 = "double";
                signature2.next();
                break;
            }
            case 'F': {
                text2 = "float";
                signature2.next();
                break;
            }
            case 'I': {
                text2 = "int";
                signature2.next();
                break;
            }
            case 'J': {
                text2 = "long";
                signature2.next();
                break;
            }
            case 'S': {
                text2 = "short";
                signature2.next();
                break;
            }
            case 'Z': {
                text2 = "boolean";
                signature2.next();
                break;
            }
            case 'V': {
                text2 = "void";
                signature2.next();
            }
        }
        return text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/compiled/SignatureParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParametersDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

