/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u0010\u0011B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Node", "", "node", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getNode", "()Ljava/lang/Object;", "Ljava/lang/Object;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getToken", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "FirLightModifier", "FirPsiModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier;", "checkers"})
public abstract class FirModifier<Node> {
    @NotNull
    private final Node node;
    @NotNull
    private final KtModifierKeywordToken token;

    private FirModifier(Node node, KtModifierKeywordToken token) {
        this.node = node;
        this.token = token;
    }

    @NotNull
    public final Node getNode() {
        return this.node;
    }

    @NotNull
    public final KtModifierKeywordToken getToken() {
        return this.token;
    }

    @NotNull
    public abstract FirSourceElement getSource();

    public /* synthetic */ FirModifier(Object node, KtModifierKeywordToken token, DefaultConstructorMarker $constructor_marker) {
        this(node, token);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirPsiModifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Lcom/intellij/lang/ASTNode;", "node", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lcom/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkers"})
    public static final class FirPsiModifier
    extends FirModifier<ASTNode> {
        public FirPsiModifier(@NotNull ASTNode node, @NotNull KtModifierKeywordToken token) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            super(node, token, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirSourceElement getSource() {
            FirPsiSourceElement firPsiSourceElement;
            void $this$toFirPsiSourceElement_u24default$iv;
            PsiElement psiElement = ((ASTNode)this.getNode()).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"node.psi");
            FirSourceElementKind kind$iv = FirRealSourceElementKind.INSTANCE;
            boolean $i$f$toFirPsiSourceElement = false;
            FirSourceElementKind firSourceElementKind = kind$iv;
            if (firSourceElementKind instanceof FirRealSourceElementKind) {
                firPsiSourceElement = new FirRealPsiSourceElement<void>($this$toFirPsiSourceElement_u24default$iv);
            } else if (firSourceElementKind instanceof FirFakeSourceElementKind) {
                firPsiSourceElement = new FirFakeSourceElement<void>($this$toFirPsiSourceElement_u24default$iv, (FirFakeSourceElementKind)kind$iv);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return firPsiSourceElement;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier$FirLightModifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Lcom/intellij/lang/LighterASTNode;", "node", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "offsetDelta", "", "(Lcom/intellij/lang/LighterASTNode;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;I)V", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getSource", "()Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getTree", "()Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "checkers"})
    public static final class FirLightModifier
    extends FirModifier<LighterASTNode> {
        @NotNull
        private final FlyweightCapableTreeStructure<LighterASTNode> tree;
        private final int offsetDelta;

        public FirLightModifier(@NotNull LighterASTNode node, @NotNull KtModifierKeywordToken token, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, int offsetDelta) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            super(node, token, null);
            this.tree = tree;
            this.offsetDelta = offsetDelta;
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> getTree() {
            return this.tree;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirSourceElement getSource() {
            void tree$iv;
            void endOffset$iv;
            void startOffset$iv;
            void $this$toFirLightSourceElement_u24default$iv;
            LighterASTNode lighterASTNode2 = (LighterASTNode)this.getNode();
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = this.tree;
            int n = ((LighterASTNode)this.getNode()).getStartOffset() + this.offsetDelta;
            int n2 = ((LighterASTNode)this.getNode()).getEndOffset() + this.offsetDelta;
            FirSourceElementKind kind$iv = FirRealSourceElementKind.INSTANCE;
            boolean $i$f$toFirLightSourceElement = false;
            return new FirLightSourceElement((LighterASTNode)$this$toFirLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, (FlyweightCapableTreeStructure<LighterASTNode>)tree$iv, kind$iv);
        }
    }
}

