/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalMarkerDeclarationAnnotationChecker;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.Experimentality;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000f\u001a\u00020\u00062\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0002J$\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalMarkerDeclarationAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkMarkerTargetsAndRetention", "checkUseExperimentalUsage", "annotationClasses", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "hasExperimentalOverriddenDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "experimentalFqName", "Lorg/jetbrains/kotlin/name/FqName;", "visited", "", "frontend"})
public final class ExperimentalMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    private final ModuleDescriptor module;

    public ExperimentalMarkerDeclarationAnnotationChecker(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Intrinsics.checkNotNullParameter(actualTargets, (String)"actualTargets");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        boolean isAnnotatedWithExperimental = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            DeclarationDescriptor descriptor2;
            KtAnnotated annotated;
            AnnotationUseSiteTarget annotationUseSiteTarget;
            boolean bl;
            ClassDescriptor annotationClass;
            block14: {
                Object annotationClasses;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry);
                if (annotationDescriptor == null) continue;
                Object object = annotationDescriptor;
                AnnotationDescriptor annotation2 = object;
                object = annotation2.getFqName();
                if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getUSE_EXPERIMENTAL_FQ_NAMES(), (Object)object)) {
                    ArrayValue arrayValue;
                    void $this$safeAs$iv232;
                    ConstantValue<?> constantValue = annotation2.getAllValueArguments().get(OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    boolean $i$f$safeAs = false;
                    Object v0 = $this$safeAs$iv232;
                    if (!(v0 instanceof ArrayValue)) {
                        v0 = null;
                    }
                    arrayValue = (arrayValue = (ArrayValue)v0) == null ? null : (List)arrayValue.getValue();
                    boolean $this$safeAs$iv232 = false;
                    Object object2 = arrayValue;
                    if (object2 == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    annotationClasses = object2;
                    this.checkUseExperimentalUsage((List<? extends ConstantValue<?>>)annotationClasses, trace, ktAnnotationEntry);
                } else if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getEXPERIMENTAL_FQ_NAMES(), (Object)object)) {
                    isAnnotatedWithExperimental = true;
                }
                annotationClasses = DescriptorUtilsKt.getAnnotationClass(annotation2);
                if (annotationClasses == null) continue;
                annotationClass = annotationClasses;
                Iterable $this$any$iv = annotationClass.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getEXPERIMENTAL_FQ_NAMES(), (Object)it.getFqName())) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            KtAnnotationUseSiteTarget $i$f$any = ktAnnotationEntry.getUseSiteTarget();
            AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget = $i$f$any == null ? null : $i$f$any.getAnnotationUseSiteTarget();
            if (actualTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "getter"));
            }
            if (actualTargets.contains((Object)KotlinTarget.VALUE_PARAMETER) && annotationUseSiteTarget == null || annotationUseSiteTarget == AnnotationUseSiteTarget.RECEIVER || annotationUseSiteTarget == AnnotationUseSiteTarget.SETTER_PARAMETER || annotationUseSiteTarget == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "parameter"));
            }
            if (actualTargets.contains((Object)KotlinTarget.LOCAL_VARIABLE)) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "variable"));
            }
            if (annotationUseSiteTarget == AnnotationUseSiteTarget.FIELD || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "field"));
            }
            PsiElement $this$getStrictParentOfType$iv = ktAnnotationEntry;
            boolean $i$f$getStrictParentOfType = false;
            KtAnnotated $this$safeAs$iv232 = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtAnnotated.class, true);
            if ($this$safeAs$iv232 == null || !((annotated = $this$safeAs$iv232) instanceof KtCallableDeclaration) || annotated instanceof KtPropertyAccessor || annotationUseSiteTarget != null || !((KtCallableDeclaration)annotated).hasModifier(KtTokens.OVERRIDE_KEYWORD) || !((descriptor2 = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, annotated)) instanceof CallableMemberDescriptor) || ExperimentalMarkerDeclarationAnnotationChecker.hasExperimentalOverriddenDescriptors$default(this, (CallableMemberDescriptor)descriptor2, DescriptorUtilsKt.getFqNameSafe(annotationClass), null, 2, null)) continue;
            trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_OVERRIDE.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry)));
        }
        if (isAnnotatedWithExperimental) {
            this.checkMarkerTargetsAndRetention(entries, trace);
        }
    }

    private final boolean hasExperimentalOverriddenDescriptors(CallableMemberDescriptor $this$hasExperimentalOverriddenDescriptors, FqName experimentalFqName, Set<CallableMemberDescriptor> visited2) {
        if (!visited2.add($this$hasExperimentalOverriddenDescriptors)) {
            return false;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : $this$hasExperimentalOverriddenDescriptors.getOverriddenDescriptors()) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = callableMemberDescriptor.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)experimentalFqName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            if (callableMemberDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"overridden");
            if (!ExperimentalMarkerDeclarationAnnotationChecker.hasExperimentalOverriddenDescriptors$default(this, callableMemberDescriptor, experimentalFqName, null, 2, null)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean hasExperimentalOverriddenDescriptors$default(ExperimentalMarkerDeclarationAnnotationChecker experimentalMarkerDeclarationAnnotationChecker, CallableMemberDescriptor callableMemberDescriptor, FqName fqName2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            set = new LinkedHashSet();
        }
        return experimentalMarkerDeclarationAnnotationChecker.hasExperimentalOverriddenDescriptors(callableMemberDescriptor, fqName2, set);
    }

    private final void checkUseExperimentalUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.USE_EXPERIMENTAL_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        for (ConstantValue<?> annotationClass : annotationClasses) {
            ClassDescriptor classDescriptor;
            TypeConstructor typeConstructor2;
            KotlinType kotlinType;
            KClassValue kClassValue;
            KClassValue kClassValue2 = kClassValue = annotationClass instanceof KClassValue ? (KClassValue)annotationClass : null;
            ExperimentalUsageChecker.Companion companion = kClassValue == null ? null : ((kotlinType = kClassValue.getArgumentType(this.module)) == null ? null : ((typeConstructor2 = kotlinType.getConstructor()) == null ? null : typeConstructor2.getDeclarationDescriptor()));
            ClassDescriptor classDescriptor2 = classDescriptor = companion instanceof ClassDescriptor ? (ClassDescriptor)((Object)companion) : null;
            if (classDescriptor == null) continue;
            ClassDescriptor classDescriptor3 = classDescriptor;
            companion = ExperimentalUsageChecker.Companion;
            boolean bl = false;
            boolean bl2 = false;
            ExperimentalUsageChecker.Companion $this$checkUseExperimentalUsage_u24lambda_u2d2 = companion;
            boolean bl3 = false;
            Experimentality experimentality = $this$checkUseExperimentalUsage_u24lambda_u2d2.loadExperimentalityForMarkerAnnotation$frontend(classDescriptor3);
            if (experimentality != null) continue;
            trace.report(Errors.USE_EXPERIMENTAL_ARGUMENT_IS_NOT_MARKER.on((KtAnnotationEntry)((PsiElement)entry), DescriptorUtilsKt.getFqNameSafe(classDescriptor3)));
        }
    }

    private final void checkMarkerTargetsAndRetention(List<? extends KtAnnotationEntry> entries, BindingTrace trace) {
        Object v2;
        block9: {
            Object v0;
            Object $dstr$_u24__u24$descriptor22;
            Object $this$firstOrNull$iv;
            Set associatedEntries;
            Object $this$associateWithTo$iv$iv;
            block8: {
                Object entry2;
                Iterable $this$associateWith$iv = entries;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                Iterator iterator2 = $this$associateWithTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map = result$iv;
                    boolean bl = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, entry2);
                    map.put(t, annotationDescriptor);
                }
                associatedEntries = ((Map)result$iv).entrySet();
                $this$firstOrNull$iv = associatedEntries;
                boolean $i$f$firstOrNull = false;
                $this$associateWithTo$iv$iv = $this$firstOrNull$iv.iterator();
                while ($this$associateWithTo$iv$iv.hasNext()) {
                    Object element$iv22 = $this$associateWithTo$iv$iv.next();
                    $dstr$_u24__u24$descriptor22 = (Map.Entry)element$iv22;
                    boolean bl = false;
                    entry2 = $dstr$_u24__u24$descriptor22;
                    boolean bl2 = false;
                    AnnotationDescriptor descriptor2 = (AnnotationDescriptor)entry2.getValue();
                    if (!Intrinsics.areEqual((Object)((entry2 = descriptor2) == null ? null : entry2.getFqName()), (Object)StandardNames.FqNames.target)) continue;
                    v0 = element$iv22;
                    break block8;
                }
                v0 = null;
            }
            Map.Entry targetEntry = v0;
            if (targetEntry != null) {
                AnnotationDescriptor descriptor3;
                $this$associateWithTo$iv$iv = $this$firstOrNull$iv = targetEntry;
                boolean element$iv22 = false;
                KtAnnotationEntry entry = (KtAnnotationEntry)$this$associateWithTo$iv$iv.getKey();
                Object element$iv22 = $this$firstOrNull$iv;
                boolean $dstr$_u24__u24$descriptor22 = false;
                AnnotationDescriptor annotationDescriptor = descriptor3 = (AnnotationDescriptor)element$iv22.getValue();
                Intrinsics.checkNotNull((Object)annotationDescriptor);
                Object bl = annotationDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"descriptor!!");
                $dstr$_u24__u24$descriptor22 = AnnotationChecker.Companion.loadAnnotationTargets((AnnotationDescriptor)bl);
                if ($dstr$_u24__u24$descriptor22 == null) {
                    return;
                }
                Object allowedTargets = $dstr$_u24__u24$descriptor22;
                Set wrongTargets = CollectionsKt.intersect((Iterable)((Iterable)allowedTargets), (Iterable)Experimentality.Companion.getWRONG_TARGETS_FOR_MARKER());
                bl = wrongTargets;
                boolean entry2 = false;
                if (!bl.isEmpty()) {
                    trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry), CollectionsKt.joinToString$default((Iterable)wrongTargets, null, null, null, (int)0, null, (Function1)((Function1)checkMarkerTargetsAndRetention.1.INSTANCE), (int)31, null)));
                }
            }
            Iterable $this$firstOrNull$iv2 = associatedEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv2) {
                Map.Entry $dstr$_u24__u24$descriptor = (Map.Entry)element$iv;
                boolean bl = false;
                Object object = $dstr$_u24__u24$descriptor;
                boolean bl3 = false;
                AnnotationDescriptor descriptor4 = (AnnotationDescriptor)object.getValue();
                if (!Intrinsics.areEqual((Object)((object = descriptor4) == null ? null : object.getFqName()), (Object)StandardNames.FqNames.retention)) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        Map.Entry retentionEntry = v2;
        if (retentionEntry != null) {
            Map.Entry entry = retentionEntry;
            Map.Entry allowedTargets = entry;
            boolean bl = false;
            KtAnnotationEntry entry3 = (KtAnnotationEntry)allowedTargets.getKey();
            Object object = entry;
            boolean bl4 = false;
            AnnotationDescriptor descriptor5 = (AnnotationDescriptor)object.getValue();
            if (((object = descriptor5) == null ? null : DescriptorUtilsKt.getAnnotationRetention((AnnotationDescriptor)object)) == KotlinRetention.SOURCE) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_RETENTION.on(entry3));
            }
        }
    }
}

