/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a?\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u000f*\u00020\u00052\"\u0010\u0013\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00120\u00150\u0014\"\n\u0012\u0006\b\u0001\u0012\u0002H\u00120\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0018*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0007*\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010 \u001a\u00020\u001f*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010!\u001a\u00020\u001f*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\"\u001a\u00020#\"\u000e\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0%*\b\u0012\u0004\u0012\u0002H$0%2\b\u0010&\u001a\u0004\u0018\u00010\u0019\u001a\u001c\u0010'\u001a\u00020#*\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006+"}, d2={"getEnclosingDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getEnclosingFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getAbbreviatedTypeOrType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getDataFlowInfoAfter", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lcom/intellij/psi/PsiElement;", "getDataFlowInfoBefore", "getParentOfTypeCodeFragmentAware", "T", "parentClasses", "", "Ljava/lang/Class;", "(Lorg/jetbrains/kotlin/psi/KtElement;[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "isUsedAsExpression", "", "isUsedAsResultOfLambda", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "frontend"})
public final class BindingContextUtilsKt {
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(@NotNull KtReturnExpression $this$getTargetFunctionDescriptor, @NotNull BindingContext context2) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getTargetFunctionDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtSimpleNameExpression targetLabel = $this$getTargetFunctionDescriptor.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement = (PsiElement)context2.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement == null) {
                simpleFunctionDescriptor = null;
            } else {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context2.get(BindingContext.FUNCTION, it);
            }
            return simpleFunctionDescriptor;
        }
        PsiElement $this$getNonStrictParentOfType$iv = $this$getTargetFunctionDescriptor;
        boolean $i$f$getNonStrictParentOfType = false;
        DeclarationDescriptor declarationDescriptor = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtDeclarationWithBody.class, false));
        FunctionDescriptor functionDescriptor2 = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor containingFunctionDescriptor = functionDescriptor = functionDescriptor2;
        return (FunctionDescriptor)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.generateSequence((Object)containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), (Function1)getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(@NotNull KtReturnExpression $this$getTargetFunction, @NotNull BindingContext context2) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$getTargetFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($this$getTargetFunction, context2);
        if (functionDescriptor == null) {
            ktCallableDeclaration = null;
        } else {
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            boolean bl = false;
            boolean bl2 = false;
            FunctionDescriptor it = functionDescriptor2;
            boolean bl3 = false;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
            ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(@NotNull KtExpression $this$isUsedAsExpression, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Boolean bl = (Boolean)context2.get(BindingContext.USED_AS_EXPRESSION, $this$isUsedAsExpression);
        if (bl == null) {
            String string2;
            if (Intrinsics.areEqual((Object)context2, (Object)BindingContext.EMPTY)) {
                string2 = "BindingContext.EMPTY";
            } else {
                String string3 = context2.getClass().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.javaClass.toString()");
                string2 = string3;
            }
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"BindingContext returned null for Boolean slice: ", (Object)string2));
        }
        return bl;
    }

    public static final boolean isUsedAsResultOfLambda(@NotNull KtExpression $this$isUsedAsResultOfLambda, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsResultOfLambda, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object v = context2.get(BindingContext.USED_AS_RESULT_OF_LAMBDA, $this$isUsedAsResultOfLambda);
        Intrinsics.checkNotNull(v);
        Object v2 = v;
        Intrinsics.checkNotNullExpressionValue(v2, (String)"context[USED_AS_RESULT_OF_LAMBDA, this]!!");
        return (Boolean)v2;
    }

    public static final boolean isUsedAsStatement(@NotNull KtExpression $this$isUsedAsStatement, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isUsedAsStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return !BindingContextUtilsKt.isUsedAsExpression($this$isUsedAsStatement, context2);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(@NotNull ResolutionContext<C> $this$recordDataFlowInfo, @Nullable KtExpression expression2) {
        Intrinsics.checkNotNullParameter($this$recordDataFlowInfo, (String)"<this>");
        if (expression2 == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$this$recordDataFlowInfo.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (!Intrinsics.areEqual((Object)$this$recordDataFlowInfo.dataFlowInfo, (Object)DataFlowInfo.Companion.getEMPTY())) {
            BindingTrace bindingTrace = $this$recordDataFlowInfo.trace;
            DataFlowInfo dataFlowInfo = $this$recordDataFlowInfo.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(@NotNull BindingTrace $this$recordScope, @NotNull LexicalScope scope2, @Nullable KtElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$recordScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (element != null) {
            $this$recordScope.record(BindingContext.LEXICAL_SCOPE, element, (LexicalScope)ScopeUtilsKt.takeSnapshot(scope2));
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoAfter(@NotNull BindingContext $this$getDataFlowInfoAfter, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFlowInfoAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf(position)) {
            KtExpression ktExpression;
            KtExpression ktExpression2 = ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) continue;
            Object object = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            PsiElement parent2 = it.getParent();
            KotlinTypeInfo kotlinTypeInfo = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)it, (Object)((KtQualifiedExpression)parent2).getSelectorExpression()) ? null : (KotlinTypeInfo)$this$getDataFlowInfoAfter.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            if (kotlinTypeInfo == null) continue;
            object = kotlinTypeInfo;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfoBefore(@NotNull BindingContext $this$getDataFlowInfoBefore, @NotNull PsiElement position) {
        Intrinsics.checkNotNullParameter((Object)$this$getDataFlowInfoBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        for (PsiElement element : PsiUtilsKt.getParentsWithSelf(position)) {
            KtExpression ktExpression;
            KtExpression ktExpression2 = ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
            if (ktExpression == null) continue;
            Object object = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            DataFlowInfo dataFlowInfo = (DataFlowInfo)$this$getDataFlowInfoBefore.get(BindingContext.DATA_FLOW_INFO_BEFORE, it);
            if (dataFlowInfo == null) continue;
            object = dataFlowInfo;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            return it;
        }
        return DataFlowInfo.Companion.getEMPTY();
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(@NotNull KtExpression $this$getReferenceTargets, @NotNull BindingContext context2) {
        Object object;
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$getReferenceTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeclarationDescriptor targetDescriptor = $this$getReferenceTargets instanceof KtReferenceExpression ? (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, $this$getReferenceTargets) : null;
        Object object2 = targetDescriptor;
        if (object2 == null) {
            list2 = null;
        } else {
            DeclarationDescriptor declarationDescriptor = object2;
            boolean bl = false;
            boolean bl2 = false;
            DeclarationDescriptor it = declarationDescriptor;
            boolean bl3 = false;
            list2 = CollectionsKt.listOf((Object)it);
        }
        List list3 = list2;
        if (list3 == null) {
            object2 = (Collection)context2.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $this$getReferenceTargets);
            boolean bl = false;
            object = object2;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
        } else {
            object = list3;
        }
        return object;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeReference $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getAbbreviatedTypeOrType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinType kotlinType = (KotlinType)context2.get(BindingContext.ABBREVIATED_TYPE, $this$getAbbreviatedTypeOrType);
        return kotlinType == null ? (KotlinType)context2.get(BindingContext.TYPE, $this$getAbbreviatedTypeOrType) : kotlinType;
    }

    @Nullable
    public static final KotlinType getAbbreviatedTypeOrType(@NotNull KtTypeElement $this$getAbbreviatedTypeOrType, @NotNull BindingContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getAbbreviatedTypeOrType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement parent2 = $this$getAbbreviatedTypeOrType.getParent();
        if (parent2 instanceof KtTypeReference) {
            object = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)parent2, context2);
        } else if (parent2 instanceof KtNullableType) {
            KotlinType kotlinType;
            KotlinType outerType = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeElement)parent2, context2);
            object = $this$getAbbreviatedTypeOrType instanceof KtNullableType ? outerType : ((kotlinType = outerType) == null ? null : TypeUtilsKt.makeNotNullable(kotlinType));
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final <T extends PsiElement> T getParentOfTypeCodeFragmentAware(@NotNull KtElement $this$getParentOfTypeCodeFragmentAware, Class<? extends T> ... parentClasses) {
        PsiElement context2;
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeCodeFragmentAware, (String)"<this>");
        Intrinsics.checkNotNullParameter(parentClasses, (String)"parentClasses");
        T t = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypeCodeFragmentAware, Arrays.copyOf(parentClasses, parentClasses.length));
        if (t != null) {
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            return it;
        }
        PsiFile containingFile = $this$getParentOfTypeCodeFragmentAware.getContainingFile();
        if (containingFile instanceof KtCodeFragment && (context2 = ((KtCodeFragment)containingFile).getContext()) != null) {
            return PsiTreeUtil.getParentOfType(context2, Arrays.copyOf(parentClasses, parentClasses.length));
        }
        return null;
    }

    @NotNull
    public static final DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context2, @NotNull KtElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object2 = new Class[]{KtNamedDeclaration.class};
        Object object3 = BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(element, object2);
        if (object3 == null) {
            throw new KotlinExceptionWithAttachments(Intrinsics.stringPlus((String)"No parent KtNamedDeclaration for of type ", element.getClass())).withAttachment("element.kt", element.getText());
        }
        Object declaration2 = object3;
        if (declaration2 instanceof KtFunctionLiteral) {
            object = BindingContextUtilsKt.getEnclosingDescriptor(context2, (KtElement)declaration2);
        } else {
            object2 = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration2);
            if (object2 == null) {
                throw new KotlinExceptionWithAttachments(Intrinsics.stringPlus((String)"No descriptor for named declaration of type ", declaration2.getClass())).withAttachment("declaration.kt", declaration2.getText());
            }
            object = object3 = object2;
        }
        return object;
    }

    @Nullable
    public static final FunctionDescriptor getEnclosingFunctionDescriptor(@NotNull BindingContext context2, @NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Class[] classArray = new Class[]{KtFunction.class, KtClassOrObject.class};
        KtTypeParameterListOwner functionOrClass = (KtTypeParameterListOwner)BindingContextUtilsKt.getParentOfTypeCodeFragmentAware(element, classArray);
        DeclarationDescriptor descriptor2 = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionOrClass);
        return functionOrClass instanceof KtFunction ? (descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null) : (FunctionDescriptor)(descriptor2 instanceof ClassDescriptor ? ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() : null);
    }
}

