/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirStubStatement;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.SymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty2TypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00ba\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001c\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b\u001a,\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!\u001a8\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#\u001a\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0000\u001a\u0016\u0010'\u001a\u00020(*\u00020!2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002\u001a0\u0010)\u001a\u00020**\u00020!2\b\u0010+\u001a\u0004\u0018\u00010\u00152\b\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a\u001c\u0010/\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000101\u0012\u0006\u0012\u0004\u0018\u00010200*\u0004\u0018\u000101\u001aS\u00103\u001a\u000204*\u0002052\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u00108\u001a\u00020(2\u0006\u00109\u001a\u00020(2\b\u0010:\u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010;\u001a.\u0010<\u001a\u00020=*\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u0010>\u001a\u00020?2\b\u0010,\u001a\u0004\u0018\u00010\u00152\b\u0010+\u001a\u0004\u0018\u00010\u0015\u001a.\u0010@\u001a\u00020**\u00020!2\u0006\u0010-\u001a\u00020!2\u0006\u0010A\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010\u00152\b\u0010+\u001a\u0004\u0018\u00010\u0015\u001a$\u0010B\u001a\u00020C*\u00020!2\u0006\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010\u0015\u001a\u001c\u0010F\u001a\u00020G*\u00020!2\u0006\u0010D\u001a\u00020!2\b\u0010,\u001a\u0004\u0018\u00010\u0015\u001a\n\u0010H\u001a\u00020(*\u000201\u001a\n\u0010I\u001a\u00020\u000f*\u00020\u0011\u001a\f\u0010J\u001a\u0004\u0018\u00010\u0001*\u00020?\u001a\n\u0010K\u001a\u00020L*\u00020?\u001a\f\u0010M\u001a\u0004\u0018\u00010\u0001*\u00020?\u001a\u001a\u0010N\u001a\u00020O*\u00020P2\u0006\u0010:\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001b\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006Q"}, d2={"DELEGATED_SETTER_PARAM", "Lorg/jetbrains/kotlin/name/Name;", "GET_VALUE", "PROVIDE_DELEGATE", "SET_VALUE", "ownerRegularClassTypeParametersCount", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularClassTypeParametersCount", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Ljava/lang/Integer;", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "escapedStringToCharacter", "Lorg/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "text", "", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "calleeReferenceSource", "name", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "generateTemporaryVariable", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "specialName", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "translateEscape", "c", "", "checkReceiver", "", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "extractContractDescriptionIfPossible", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "isExtension", "stubMode", "receiver", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Ljava/lang/Integer;ZZLorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lcom/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "isContractPresentFirCheck", "parseCharacter", "toBinaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toUnaryName", "wrapWithSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "raw-fir.common"})
public final class ConversionUtilsKt {
    @NotNull
    private static final Name GET_VALUE;
    @NotNull
    private static final Name SET_VALUE;
    @NotNull
    private static final Name PROVIDE_DELEGATE;
    @NotNull
    private static final Name DELEGATED_SETTER_PARAM;

    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter((Object)$this$parseCharacter, (String)"<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        CharSequence charSequence = $this$parseCharacter;
        int n = 1;
        int n2 = $this$parseCharacter.length() - 1;
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text2 = string2;
        charSequence = text2;
        n = 0;
        if (charSequence.length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? new CharacterWithDiagnostic(text2.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0 && text2.charAt(0) == '\\';
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$22 = false;
            String $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$22 = Intrinsics.stringPlus((String)"Only escaped sequences must be passed to this routine: ", (Object)text2);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$22));
        }
        String string2 = text2;
        int $i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$22 = 1;
        boolean bl3 = false;
        String string3 = string2.substring($i$a$-assert-ConversionUtilsKt$escapedStringToCharacter$22);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String escape = string3;
        int n = escape.length();
        switch (n) {
            case 0: {
                return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    String string4 = escape;
                    int n2 = 1;
                    boolean bl4 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer intValue = Integer.valueOf(string6, 16);
                    return new CharacterWithDiagnostic((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c) {
        char c2 = c;
        return c2 == 't' ? new CharacterWithDiagnostic('\t') : (c2 == 'b' ? new CharacterWithDiagnostic('\b') : (c2 == 'n' ? new CharacterWithDiagnostic('\n') : (c2 == 'r' ? new CharacterWithDiagnostic('\r') : (c2 == '\'' ? new CharacterWithDiagnostic('\'') : (c2 == '\"' ? new CharacterWithDiagnostic('\"') : (c2 == '\\' ? new CharacterWithDiagnostic('\\') : (c2 == '$' ? new CharacterWithDiagnostic('$') : new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape))))))));
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinaryName, (String)"<this>");
        Map<KtSingleValueToken, Name> map = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(map, (String)"BINARY_OPERATION_NAMES");
        map = map;
        boolean bl = false;
        return map.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnaryName, (String)"<this>");
        Map<KtSingleValueToken, Name> map = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(map, (String)"UNARY_OPERATION_NAMES");
        map = map;
        boolean bl = false;
        return map.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$toFirOperation, (String)"<this>");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ)) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_KEYWORD)) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_SAFE)) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw new AssertionError((Object)$this$toFirOperation.toString());
        }
        return firOperation;
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkNotNullParameter((Object)$this$generateNotNullOrOther, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildElvisExpression = false;
        boolean bl = false;
        FirElvisExpressionBuilder firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u2d1 = firElvisExpressionBuilder;
        boolean bl4 = false;
        $this$generateNotNullOrOther_u24lambda_u2d1.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u2d1.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u2d1.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable FirSourceElement baseSource) {
        Intrinsics.checkNotNullParameter((Object)$this$generateLazyLogicalOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$buildBinaryLogicExpression = false;
        boolean bl = false;
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u2d2 = firBinaryLogicExpressionBuilder;
        boolean bl4 = false;
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument2, boolean inverted, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3;
        Intrinsics.checkNotNullParameter((Object)$this$generateContainsOperation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument2, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        boolean bl = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u2d4 = firFunctionCallBuilder;
        boolean bl4 = false;
        FirSourceElement firSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u2d4.setSource(firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.DesugaredInvertedContains.INSTANCE));
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u2d4;
        boolean bl8 = false;
        FirSourceElement firSourceElement2 = operationReferenceSource;
        $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3.setSource(firSourceElement2 == null ? null : FirSourceElementKt.fakeElement(firSourceElement2, FirFakeSourceElementKind.DesugaredInvertedContains.INSTANCE));
        $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3.setName(OperatorNameConventions.NOT);
        Unit unit = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u2d4.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u2d4.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument2, @NotNull IElementType operatorToken, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter((Object)$this$generateComparisonExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorToken, (String)"operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, (String)"COMPARISON_OPERATIONS");
        boolean bl = CollectionsKt.contains((Iterable)immutableSet, (Object)operatorToken);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirSourceElement firSourceElement = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE), argument2, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else {
            String string3 = Intrinsics.stringPlus((String)"Unknown ", (Object)operatorToken);
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        boolean bl6 = false;
        FirComparisonExpressionBuilder firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl7 = false;
        boolean bl8 = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u2d6 = firComparisonExpressionBuilder;
        boolean bl9 = false;
        $this$generateComparisonExpression_u24lambda_u2d6.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u2d6.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u2d6.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, FirSourceElement operationReferenceSource, FirSourceElement baseSource, FirExpression argument2, Name conventionName) {
        void $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7;
        boolean $i$f$buildFunctionCall = false;
        boolean bl = false;
        FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u2d8 = firFunctionCallBuilder;
        boolean bl4 = false;
        $this$createConventionCall_u24lambda_u2d8.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u2d8;
        boolean bl8 = false;
        $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7.setName(conventionName);
        Unit unit = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u2d8.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u2d8.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument2));
        $this$createConventionCall_u24lambda_u2d8.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable FirSourceElement qualifiedSource, @Nullable FirSourceElement calleeReferenceSource, @NotNull Name name) {
        void $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2d10 = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$generateAccessExpression_u24lambda_u2d10.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        boolean bl5 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2d10;
        boolean bl8 = false;
        $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9.setSource(calleeReferenceSource);
        $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9.setName(name);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable FirSourceElement source, @NotNull FirVariable<?> variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11;
        Intrinsics.checkNotNullParameter(variable2, (String)"variable");
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2d12 = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2d12.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        boolean bl5 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2d12;
        boolean bl8 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setResolvedSymbol((AbstractFirBasedSymbol)variable2.getSymbol());
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirModuleData moduleData, @Nullable FirSourceElement source, @NotNull Name name, @NotNull FirExpression initializer2, @Nullable FirTypeRef typeRef) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        boolean $i$f$buildProperty = false;
        boolean bl = false;
        FirPropertyBuilder firPropertyBuilder = new FirPropertyBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirPropertyBuilder $this$generateTemporaryVariable_u24lambda_u2d14 = firPropertyBuilder;
        boolean bl4 = false;
        $this$generateTemporaryVariable_u24lambda_u2d14.setSource(source);
        $this$generateTemporaryVariable_u24lambda_u2d14.setModuleData(moduleData);
        $this$generateTemporaryVariable_u24lambda_u2d14.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        FirPropertyBuilder firPropertyBuilder2 = $this$generateTemporaryVariable_u24lambda_u2d14;
        FirTypeRef firTypeRef2 = typeRef;
        if (firTypeRef2 == null) {
            void $this$generateTemporaryVariable_u24lambda_u2d14_u24lambda_u2d13;
            boolean $i$f$buildImplicitTypeRef = false;
            boolean bl5 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder2 = firImplicitTypeRefBuilder;
            FirPropertyBuilder firPropertyBuilder3 = firPropertyBuilder2;
            boolean bl8 = false;
            $this$generateTemporaryVariable_u24lambda_u2d14_u24lambda_u2d13.setSource(source);
            Unit unit = Unit.INSTANCE;
            firPropertyBuilder2 = firPropertyBuilder3;
            firTypeRef = firImplicitTypeRefBuilder.build();
        } else {
            firTypeRef = firTypeRef2;
        }
        firPropertyBuilder2.setReturnTypeRef(firTypeRef);
        $this$generateTemporaryVariable_u24lambda_u2d14.setName(name);
        $this$generateTemporaryVariable_u24lambda_u2d14.setInitializer(initializer2);
        $this$generateTemporaryVariable_u24lambda_u2d14.setSymbol(new FirPropertySymbol(name));
        $this$generateTemporaryVariable_u24lambda_u2d14.setVar(false);
        $this$generateTemporaryVariable_u24lambda_u2d14.setLocal(true);
        $this$generateTemporaryVariable_u24lambda_u2d14.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
        return firPropertyBuilder.build();
    }

    public static /* synthetic */ FirVariable generateTemporaryVariable$default(FirModuleData firModuleData, FirSourceElement firSourceElement, Name name, FirExpression firExpression2, FirTypeRef firTypeRef, int n, Object object) {
        if ((n & 0x10) != 0) {
            firTypeRef = null;
        }
        return ConversionUtilsKt.generateTemporaryVariable(firModuleData, firSourceElement, name, firExpression2, firTypeRef);
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirModuleData moduleData, @Nullable FirSourceElement source, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter((Object)specialName, (String)"specialName");
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        Name name = Name.special('<' + specialName + '>');
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable$default(moduleData, source, name, initializer2, null, 16, null);
    }

    @Nullable
    public static final FirClassSymbol<?> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularOrAnonymousObjectSymbol, (String)"<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        return firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : null);
    }

    @Nullable
    public static final Integer getOwnerRegularClassTypeParametersCount(@NotNull FirClassBuilder $this$ownerRegularClassTypeParametersCount) {
        Intrinsics.checkNotNullParameter((Object)$this$ownerRegularClassTypeParametersCount, (String)"<this>");
        return $this$ownerRegularClassTypeParametersCount instanceof FirRegularClassBuilder ? Integer.valueOf($this$ownerRegularClassTypeParametersCount.getTypeParameters().size()) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @Nullable Integer ownerRegularClassTypeParametersCount, boolean isExtension, boolean stubMode, @Nullable FirExpression receiver) {
        FirPropertyAccessorBuilder it;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        List<FirAnnotationCall> annotations2;
        Unit unit;
        FirReturnExpressionBuilder firReturnExpressionBuilder;
        boolean bl;
        boolean bl2;
        FirExpression firExpression2;
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder;
        Unit unit2;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2;
        boolean bl3;
        boolean bl4;
        boolean $i$f$buildExpressionStub22;
        Intrinsics.checkNotNullParameter((Object)$this$generateAccessorsByDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol<FirProperty> firDelegateFieldSymbol = new FirDelegateFieldSymbol<FirProperty>($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean bl5 = false;
        boolean bl6 = false;
        FirDelegateFieldSymbol<FirProperty> it2 = firDelegateFieldSymbol;
        boolean bl7 = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it2);
        FirDelegateFieldSymbol<FirProperty> delegateFieldSymbol = firDelegateFieldSymbol;
        boolean isMember = ownerRegularOrAnonymousObjectSymbol != null;
        FirSourceElement firSourceElement = delegateBuilder.getSource();
        FirSourceElement fakeSource = firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE);
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder2 = delegateBuilder;
        if (stubMode) {
            $i$f$buildExpressionStub22 = false;
            boolean bl8 = false;
            FirExpressionStubBuilder firExpressionStubBuilder = new FirExpressionStubBuilder();
            bl4 = false;
            bl3 = false;
            FirExpressionStubBuilder firExpressionStubBuilder2 = firExpressionStubBuilder;
            firAnnotationContainerBuilder2 = firWrappedDelegateExpressionBuilder2;
            unit2 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder2;
            firExpression2 = firExpressionStubBuilder.build();
        } else {
            void $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25;
            void $this$generateAccessorsByDelegate_u24lambda_u2d26;
            boolean $i$f$buildFunctionCall = false;
            $i$f$buildExpressionStub22 = false;
            FirFunctionCallBuilder $i$f$buildExpressionStub22 = new FirFunctionCallBuilder();
            boolean bl9 = false;
            bl4 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = $i$f$buildExpressionStub22;
            firAnnotationContainerBuilder2 = firWrappedDelegateExpressionBuilder2;
            boolean $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$22 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setExplicitReceiver(receiver);
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl10 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = new FirSimpleNamedReferenceBuilder();
            bl2 = false;
            bl = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder2;
            firReturnExpressionBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d26;
            boolean bl11 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25.setName(PROVIDE_DELEGATE);
            unit = Unit.INSTANCE;
            ((FirFunctionCallBuilder)((Object)firReturnExpressionBuilder)).setCalleeReference(firSimpleNamedReferenceBuilder2.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setOrigin(FirFunctionCallOrigin.Operator);
            unit2 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder2;
            firExpression2 = $i$f$buildExpressionStub22.build();
        }
        firWrappedDelegateExpressionBuilder.setDelegateProvider(firExpression2);
        $this$generateAccessorsByDelegate.setDelegate(delegateBuilder.build());
        if (stubMode) {
            return;
        }
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28_u24lambda_u2d27;
            void $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28;
            void $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29;
            void $this$generateAccessorsByDelegate_u24lambda_u2d30;
            FirPropertyAccessor $i$f$buildExpressionStub22 = $this$generateAccessorsByDelegate.getGetter();
            annotations2 = $i$f$buildExpressionStub22 == null ? null : $i$f$buildExpressionStub22.getAnnotations();
            FirFunctionTarget returnTarget = new FirFunctionTarget(null, false);
            boolean $i$f$buildPropertyAccessor = false;
            bl4 = false;
            FirPropertyAccessorBuilder firPropertyAccessorBuilder = new FirPropertyAccessorBuilder();
            bl3 = false;
            boolean $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$22 = false;
            FirPropertyAccessorBuilder $i$f$buildSimpleNamedReference = firPropertyAccessorBuilder;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl12 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            bl = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl13 = false;
            boolean bl14 = false;
            FirImplicitTypeRefBuilder bl11 = firImplicitTypeRefBuilder;
            unit = $this$generateAccessorsByDelegate_u24lambda_u2d30;
            Unit unit3 = Unit.INSTANCE;
            unit.setReturnTypeRef(firImplicitTypeRefBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setGetter(true);
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setStatus(new FirDeclarationStatusImpl(Visibilities.Unknown.INSTANCE, Modality.FINAL));
            $this$generateAccessorsByDelegate_u24lambda_u2d30.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            bl2 = false;
            FirReturnExpressionBuilder firReturnExpressionBuilder2 = new FirReturnExpressionBuilder();
            bl = false;
            bl13 = false;
            firReturnExpressionBuilder = firReturnExpressionBuilder2;
            unit = $this$generateAccessorsByDelegate_u24lambda_u2d30;
            boolean bl15 = false;
            boolean $i$f$buildFunctionCall = false;
            boolean bl16 = false;
            firAnnotationContainerBuilder = new FirFunctionCallBuilder();
            boolean bl17 = false;
            boolean bl18 = false;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder3 = firAnnotationContainerBuilder;
            void var34_81 = $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29;
            boolean bl19 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount));
            boolean $i$f$buildSimpleNamedReference2 = false;
            boolean bl20 = false;
            firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            boolean bl21 = false;
            boolean bl22 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder4 = firSimpleNamedReferenceBuilder;
            void var41_98 = $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28;
            boolean bl23 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28_u24lambda_u2d27.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28_u24lambda_u2d27.setName(GET_VALUE);
            Unit unit4 = Unit.INSTANCE;
            var41_98.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setOrigin(FirFunctionCallOrigin.Operator);
            Unit unit5 = Unit.INSTANCE;
            var34_81.setResult(((FirFunctionCallBuilder)firAnnotationContainerBuilder).build());
            $this$generateAccessorsByDelegate_u24lambda_u2d30_u24lambda_u2d29.setTarget(returnTarget);
            Unit unit6 = Unit.INSTANCE;
            FirStatement firStatement = firReturnExpressionBuilder2.build();
            unit.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2d30.getAnnotations().addAll((Collection<FirAnnotationCall>)annotations2);
            }
            unit2 = Unit.INSTANCE;
            FirPropertyAccessor firPropertyAccessor = firPropertyAccessorBuilder.build();
            bl4 = false;
            bl3 = false;
            FirPropertyAccessor $i$a$-buildFunctionCall-ConversionUtilsKt$generateAccessorsByDelegate$22 = firPropertyAccessor;
            boolean bl24 = false;
            returnTarget.bind((FirTargetElement)((Object)it));
            unit2 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setGetter(firPropertyAccessor);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34;
            void $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            FirArgumentListBuilder $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33;
            void $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37;
            void $this$generateAccessorsByDelegate_u24lambda_u2d38;
            FirPropertyAccessor returnTarget = $this$generateAccessorsByDelegate.getSetter();
            annotations2 = returnTarget == null ? null : returnTarget.getAnnotations();
            boolean $i$f$buildPropertyAccessor = false;
            boolean bl25 = false;
            FirPropertyAccessorBuilder firPropertyAccessorBuilder = new FirPropertyAccessorBuilder();
            bl4 = false;
            bl3 = false;
            it = firPropertyAccessorBuilder;
            firAnnotationContainerBuilder2 = $this$generateAccessorsByDelegate;
            boolean bl26 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setReturnTypeRef(moduleData.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setGetter(false);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setStatus(new FirDeclarationStatusImpl(Visibilities.Unknown.INSTANCE, Modality.FINAL));
            boolean $i$f$buildValueParameter22 = false;
            bl2 = false;
            Object object = new FirValueParameterBuilder();
            bl = false;
            boolean bl27 = false;
            FirAnnotationContainerBuilder $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32 = object;
            boolean bl28 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setModuleData(moduleData);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            boolean bl29 = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            boolean bl30 = false;
            boolean bl31 = false;
            FirImplicitTypeRefBuilder $i$f$buildFunctionCall = firImplicitTypeRefBuilder;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32;
            Unit unit7 = Unit.INSTANCE;
            ((FirValueParameterBuilder)firAnnotationContainerBuilder).setReturnTypeRef(firImplicitTypeRefBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setName(DELEGATED_SETTER_PARAM);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setSymbol(new FirVariableSymbol<FirValueParameter>($this$generateAccessorsByDelegate.getName()));
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setCrossinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setNoinline(false);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32.setVararg(false);
            FirValueParameter parameter = ((FirValueParameterBuilder)object).build();
            void $i$f$buildValueParameter22 = $this$generateAccessorsByDelegate_u24lambda_u2d38;
            object = $i$f$buildValueParameter22.getValueParameters();
            bl = false;
            object.add(parameter);
            $this$generateAccessorsByDelegate_u24lambda_u2d38.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildFunctionCall2 = false;
            boolean bl32 = false;
            FirFunctionCallBuilder firFunctionCallBuilder = new FirFunctionCallBuilder();
            bl = false;
            bl27 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d32 = firFunctionCallBuilder;
            void var35_83 = $this$generateAccessorsByDelegate_u24lambda_u2d38;
            boolean bl33 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount));
            boolean $i$f$buildSimpleNamedReference = false;
            boolean bl34 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder5 = new FirSimpleNamedReferenceBuilder();
            bl30 = false;
            bl31 = false;
            FirSimpleNamedReferenceBuilder $this$null = firSimpleNamedReferenceBuilder5;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37;
            boolean bl35 = false;
            ((FirSimpleNamedReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33)).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33)).setName(SET_VALUE);
            Unit unit8 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setCalleeReference(firSimpleNamedReferenceBuilder5.build());
            boolean $i$f$buildArgumentList = false;
            boolean bl36 = false;
            FirArgumentListBuilder firArgumentListBuilder = new FirArgumentListBuilder();
            bl30 = false;
            bl31 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d33 = firArgumentListBuilder;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37;
            boolean bl37 = false;
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            Collection collection = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            FirExpression firExpression3 = ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, false, 32, null);
            boolean bl38 = false;
            collection.add(firExpression3);
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            collection = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            firExpression3 = ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate);
            bl38 = false;
            collection.add(firExpression3);
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            collection = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            boolean $i$f$buildQualifiedAccessExpression = false;
            bl38 = false;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
            boolean bl39 = false;
            boolean bl40 = false;
            FirQualifiedAccessExpressionBuilder $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35 = firQualifiedAccessExpressionBuilder;
            boolean bl41 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            boolean bl42 = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            boolean bl43 = false;
            boolean bl44 = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
            FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35;
            boolean bl45 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.setName(DELEGATED_SETTER_PARAM);
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36_u24lambda_u2d35_u24lambda_u2d34.setResolvedSymbol((AbstractFirBasedSymbol)parameter.getSymbol());
            Unit unit9 = Unit.INSTANCE;
            firQualifiedAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            FirQualifiedAccessExpression firQualifiedAccessExpression = firQualifiedAccessExpressionBuilder.build();
            boolean bl46 = false;
            collection.add(firQualifiedAccessExpression);
            unit8 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)firAnnotationContainerBuilder).setArgumentList(firArgumentListBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d38_u24lambda_u2d37.setOrigin(FirFunctionCallOrigin.Operator);
            Unit unit10 = Unit.INSTANCE;
            FirStatement firStatement = firFunctionCallBuilder.build();
            var35_83.setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2d38.getAnnotations().addAll((Collection<FirAnnotationCall>)annotations2);
            }
            unit2 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder2).setSetter(firPropertyAccessorBuilder.build());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<FirBlock, FirContractDescription> extractContractDescriptionIfPossible(@Nullable FirBlock $this$extractContractDescriptionIfPossible) {
        void $this$extractContractDescriptionIfPossible_u24lambda_u2d39;
        if ($this$extractContractDescriptionIfPossible == null) {
            return TuplesKt.to(null, null);
        }
        if (!ConversionUtilsKt.isContractPresentFirCheck($this$extractContractDescriptionIfPossible)) {
            return TuplesKt.to((Object)$this$extractContractDescriptionIfPossible, null);
        }
        FirFunctionCall contractCall = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement($this$extractContractDescriptionIfPossible, FirStubStatement.INSTANCE);
        boolean $i$f$buildLegacyRawContractDescription = false;
        boolean bl = false;
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder2 = firLegacyRawContractDescriptionBuilder;
        FirBlock firBlock = $this$extractContractDescriptionIfPossible;
        boolean bl4 = false;
        $this$extractContractDescriptionIfPossible_u24lambda_u2d39.setSource(contractCall.getSource());
        $this$extractContractDescriptionIfPossible_u24lambda_u2d39.setContractCall(contractCall);
        Unit unit = Unit.INSTANCE;
        return TuplesKt.to((Object)firBlock, (Object)firLegacyRawContractDescriptionBuilder.build());
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        FirFunctionCall firFunctionCall;
        Intrinsics.checkNotNullParameter((Object)$this$isContractPresentFirCheck, (String)"<this>");
        FirStatement firStatement = (FirStatement)CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        FirFunctionCall firFunctionCall2 = firFunctionCall = firstStatement instanceof FirFunctionCall ? (FirFunctionCall)firstStatement : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall = firFunctionCall;
        if (!Intrinsics.areEqual((Object)contractCall.getCalleeReference().getName().asString(), (Object)"contract")) {
            return false;
        }
        FirExpression firExpression2 = contractCall.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirExpression firExpression4 = firExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firExpression2 == null) {
            return false;
        }
        FirExpression receiverOfReceiver = firExpression2;
        return ((FirQualifiedAccessExpression)receiverOfReceiver).getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name) {
        String string2;
        FirNamedReference firNamedReference;
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        Object object = receiver.getCalleeReference();
        FirNamedReference firNamedReference2 = firNamedReference = object instanceof FirNamedReference ? (FirNamedReference)object : null;
        String string3 = firNamedReference == null ? null : (string2 = (object = firNamedReference.getName()) == null ? null : ((Name)object).asString());
        if (string2 == null) {
            return false;
        }
        FirExpression receiverName = firExpression2 = string2;
        return Intrinsics.areEqual((Object)receiverName, (Object)name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression wrapWithSafeCall(@NotNull FirQualifiedAccess $this$wrapWithSafeCall, @NotNull FirExpression receiver, @NotNull FirSourceElement source) {
        void $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42;
        FirExpressionRef<FirCheckedSafeCallSubject> $this$wrapWithSafeCall_u24lambda_u2d41_u24lambda_u2d40;
        Intrinsics.checkNotNullParameter((Object)$this$wrapWithSafeCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        boolean bl = false;
        FirCheckedSafeCallSubjectBuilder firCheckedSafeCallSubjectBuilder = new FirCheckedSafeCallSubjectBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirCheckedSafeCallSubjectBuilder $this$wrapWithSafeCall_u24lambda_u2d41 = firCheckedSafeCallSubjectBuilder;
        boolean bl4 = false;
        FirExpressionRef<FirCheckedSafeCallSubject> firExpressionRef = new FirExpressionRef<FirExpression>();
        boolean bl5 = false;
        boolean bl6 = false;
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = $this$wrapWithSafeCall_u24lambda_u2d41;
        boolean bl7 = false;
        $this$wrapWithSafeCall_u24lambda_u2d41_u24lambda_u2d40.bind((FirCheckedSafeCallSubject)receiver);
        Unit unit = Unit.INSTANCE;
        ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder).setOriginalReceiverRef(firExpressionRef);
        firExpressionRef = receiver.getSource();
        $this$wrapWithSafeCall_u24lambda_u2d41.setSource(firExpressionRef == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)((Object)firExpressionRef), FirFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE));
        FirCheckedSafeCallSubject checkedSafeCallSubject = firCheckedSafeCallSubjectBuilder.build();
        $this$wrapWithSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        boolean $i$f$buildSafeCallExpression = false;
        boolean bl8 = false;
        FirSafeCallExpressionBuilder firSafeCallExpressionBuilder = new FirSafeCallExpressionBuilder();
        bl2 = false;
        bl3 = false;
        FirSafeCallExpressionBuilder $this$wrapWithSafeCall_u24lambda_u2d43 = firSafeCallExpressionBuilder;
        boolean bl9 = false;
        $this$wrapWithSafeCall_u24lambda_u2d43.setReceiver(receiver);
        firExpressionRef = new FirExpressionRef<FirCheckedSafeCallSubject>();
        bl5 = false;
        bl6 = false;
        $this$wrapWithSafeCall_u24lambda_u2d41_u24lambda_u2d40 = firExpressionRef;
        firAnnotationContainerBuilder = $this$wrapWithSafeCall_u24lambda_u2d43;
        boolean bl10 = false;
        $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42.bind((FirExpression)checkedSafeCallSubject);
        unit = Unit.INSTANCE;
        ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder).setCheckedSubjectRef(firExpressionRef);
        $this$wrapWithSafeCall_u24lambda_u2d43.setRegularQualifiedAccess($this$wrapWithSafeCall);
        $this$wrapWithSafeCall_u24lambda_u2d43.setSource(source);
        return firSafeCallExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Integer $ownerRegularClassTypeParametersCount, boolean forDispatchReceiver) {
        FirExpression firExpression2;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17_u24lambda_u2d16;
            boolean $i$f$buildThisReceiverExpression = false;
            boolean bl = false;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17 = firThisReceiverExpressionBuilder;
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            boolean bl5 = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17;
            boolean bl8 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17_u24lambda_u2d16.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            Unit unit = Unit.INSTANCE;
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d19;
            FirResolvedTypeRefBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d18;
            boolean $i$f$buildThisReceiverExpression = false;
            boolean bl = false;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl9 = false;
            boolean bl10 = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20 = firThisReceiverExpressionBuilder;
            boolean bl11 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            boolean bl12 = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            boolean bl13 = false;
            boolean bl14 = false;
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17_u24lambda_u2d16 = firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20;
            boolean bl15 = false;
            ((FirImplicitThisReferenceBuilder)((Object)$this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d18)).setBoundSymbol((AbstractFirBasedSymbol)$ownerRegularOrAnonymousObjectSymbol);
            Unit unit = Unit.INSTANCE;
            firThisReceiverExpressionBuilder3.setCalleeReference(firImplicitThisReferenceBuilder.build());
            boolean $i$f$buildResolvedTypeRef = false;
            boolean bl16 = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            bl13 = false;
            bl14 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d18 = firResolvedTypeRefBuilder;
            firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20;
            boolean bl17 = false;
            Integer n = $ownerRegularClassTypeParametersCount;
            int typeParameterNumber = n == null ? 0 : n;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d19.setType(SymbolUtilsKt.constructStarProjectedType($ownerRegularOrAnonymousObjectSymbol, typeParameterNumber));
            unit = Unit.INSTANCE;
            firThisReceiverExpressionBuilder3.setTypeRef(firResolvedTypeRefBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Null.INSTANCE, null, null, 8, null);
        }
        return firExpression2;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl, FirClassSymbol firClassSymbol, FirSourceElement firSourceElement, FirPropertyBuilder firPropertyBuilder, Integer n, boolean bl2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl, firClassSymbol, firSourceElement, firPropertyBuilder, n, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final FirQualifiedAccessExpression generateAccessorsByDelegate$delegateAccess(FirSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol<FirProperty> delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Integer $ownerRegularClassTypeParametersCount) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22_u24lambda_u2d21;
        boolean $i$f$buildQualifiedAccessExpression = false;
        boolean bl = false;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder = new FirQualifiedAccessExpressionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirQualifiedAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22 = firQualifiedAccessExpressionBuilder;
        boolean bl4 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        boolean bl5 = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22;
        boolean bl8 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22_u24lambda_u2d21.setResolvedSymbol(delegateFieldSymbol);
        Unit unit = Unit.INSTANCE;
        firQualifiedAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $ownerRegularClassTypeParametersCount, true));
        }
        return firQualifiedAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(FirSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23;
        boolean $i$f$buildCallableReferenceAccess = false;
        boolean bl = false;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24 = firCallableReferenceAccessBuilder;
        boolean bl4 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference = false;
        boolean bl5 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl6 = false;
        boolean bl7 = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24;
        boolean bl8 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        Unit unit = Unit.INSTANCE;
        firCallableReferenceAccessBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24.setTypeRef(!isMember && !$isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty0TypeRef(null, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty0TypeRef(null, ConeStarProjection.INSTANCE)) : (isMember && $isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE)) : (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE))));
        return firCallableReferenceAccessBuilder.build();
    }

    static {
        Name name = Name.identifier("getValue");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"getValue\")");
        GET_VALUE = name;
        name = Name.identifier("setValue");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"setValue\")");
        SET_VALUE = name;
        name = Name.identifier("provideDelegate");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"provideDelegate\")");
        PROVIDE_DELEGATE = name;
        name = Name.special("<set-?>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<set-?>\")");
        DELEGATED_SETTER_PARAM = name;
    }
}

