/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\f\u0010%\u001a\u00020\u0015*\u00020\u0002H\u0002J\u0014\u0010&\u001a\u00020\u0015*\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "BUILTIN_SUSPEND_NAME", "Lorg/jetbrains/kotlin/name/Name;", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers", "()Lorg/jetbrains/kotlin/name/CallableId;", "RESTRICTS_SUSPENSION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkNonLocalReturnUsage", "", "enclosingSuspendFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkRestrictsSuspension", "calledDeclarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkSuspendModifierForm", "reference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "symbol", "findEnclosingSuspendFunction", "sameInstanceOfReceiver", "useSiteReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "declarationSiteReceiverOwner", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "hasFormOfSuspendModifierForLambda", "isRestrictSuspensionReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers"})
public final class FirSuspendCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuspendCallChecker INSTANCE = new FirSuspendCallChecker();
    @NotNull
    private static final ClassId RESTRICTS_SUSPENSION_CLASS_ID = new ClassId(StandardNames.COROUTINES_PACKAGE_FQ_NAME, Name.identifier("RestrictsSuspension"));
    @NotNull
    private static final Name BUILTIN_SUSPEND_NAME;
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID;

    private FirSuspendCallChecker() {
    }

    @NotNull
    public final CallableId getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers() {
        return KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID;
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirFunction enclosingSuspendFunction;
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object = expression2.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        Object object2 = reference.getResolvedSymbol();
        Object object3 = object = object2 instanceof FirCallableSymbol ? (FirCallableSymbol)object2 : null;
        if (object == null) {
            return;
        }
        Object symbol2 = object;
        if (Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) || symbol2 instanceof FirNamedFunctionSymbol && Intrinsics.areEqual((Object)((FirCallableSymbol)symbol2).getName(), (Object)BUILTIN_SUSPEND_NAME)) {
            this.checkSuspendModifierForm(expression2, reference, (FirCallableSymbol<?>)symbol2, context2, reporter);
        }
        if (reference instanceof FirResolvedCallableReference) {
            return;
        }
        object = symbol2;
        if (object instanceof FirNamedFunctionSymbol) {
            Object $this$isSuspend$iv = symbol2;
            boolean $i$f$isSuspend = false;
            if (!((FirCallableSymbol)$this$isSuspend$iv).getResolvedStatus().isSuspend()) {
                return;
            }
        } else if (object instanceof FirPropertySymbol) {
            if (!Intrinsics.areEqual((Object)((FirCallableSymbol)symbol2).getCallableId().asSingleFqName(), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = this.findEnclosingSuspendFunction(context2)) == null) {
            object2 = symbol2;
            if (object2 instanceof FirNamedFunctionSymbol) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), symbol2, context2, null, 16, null);
            } else if (object2 instanceof FirPropertySymbol) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), symbol2, context2, null, 16, null);
            }
        } else {
            if (!this.checkNonLocalReturnUsage(enclosingSuspendFunction, context2)) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), context2, null, 8, null);
            }
            if (!this.checkRestrictsSuspension(expression2, enclosingSuspendFunction, (FirCallableSymbol<?>)symbol2, context2)) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), context2, null, 8, null);
            }
        }
    }

    private final void checkSuspendModifierForm(FirQualifiedAccessExpression expression2, FirResolvedNamedReference reference, FirCallableSymbol<?> symbol2, CheckerContext context2, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID)) {
            if (!Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) || expression2.getExplicitReceiver() != null || !this.hasFormOfSuspendModifierForLambda(expression2)) {
                DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), context2, null, 8, null);
            }
        } else if (Intrinsics.areEqual((Object)reference.getName(), (Object)BUILTIN_SUSPEND_NAME) && this.hasFormOfSuspendModifierForLambda(expression2)) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), context2, null, 8, null);
        }
    }

    private final boolean hasFormOfSuspendModifierForLambda(FirQualifiedAccessExpression $this$hasFormOfSuspendModifierForLambda) {
        boolean bl;
        block19: {
            if (!($this$hasFormOfSuspendModifierForLambda instanceof FirFunctionCall)) {
                return false;
            }
            FirNamedReference reference = ((FirFunctionCall)$this$hasFormOfSuspendModifierForLambda).getCalleeReference();
            if (reference instanceof FirResolvedCallableReference) {
                return false;
            }
            Iterable $this$any$iv = $this$hasFormOfSuspendModifierForLambda.getTypeArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeProjection it = (FirTypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSource() != null)) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        FirCall $this$arguments$iv = (FirCall)((Object)$this$hasFormOfSuspendModifierForLambda);
        boolean $i$f$getArguments2 = false;
        if (CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments()) instanceof FirLambdaArgumentExpression) {
            FirSourceElement firSourceElement;
            FirSourceElement callExpressionSource;
            Object object;
            FirSourceElement firSourceElement2;
            if ($this$hasFormOfSuspendModifierForLambda.getExplicitReceiver() == null) {
                firSourceElement2 = $this$hasFormOfSuspendModifierForLambda.getSource();
            } else {
                FirSourceElement $i$f$getArguments2 = $this$hasFormOfSuspendModifierForLambda.getSource();
                if ($i$f$getArguments2 == null) {
                    firSourceElement2 = null;
                } else {
                    object = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CALL_EXPRESSION");
                    firSourceElement2 = FirSourceUtilsKt.getChild($i$f$getArguments2, (IElementType)object, 1, 1);
                }
            }
            FirSourceElement $i$f$getArguments2 = callExpressionSource = firSourceElement2;
            if ($i$f$getArguments2 == null) {
                firSourceElement = null;
            } else {
                object = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VALUE_ARGUMENT_LIST");
                firSourceElement = FirSourceUtilsKt.getChild$default($i$f$getArguments2, (IElementType)object, 0, 1, 2, null);
            }
            if (firSourceElement == null) {
                return true;
            }
        }
        if (((FirFunctionCall)$this$hasFormOfSuspendModifierForLambda).getOrigin() == FirFunctionCallOrigin.Infix) {
            FirCall $this$arguments$iv2 = (FirCall)((Object)$this$hasFormOfSuspendModifierForLambda);
            boolean $i$f$getArguments3 = false;
            FirExpression lastArgument = (FirExpression)CollectionsKt.lastOrNull($this$arguments$iv2.getArgumentList().getArguments());
            if (lastArgument instanceof FirAnonymousFunctionExpression) {
                FirSourceElement firSourceElement;
                FirSourceElement firSourceElement3 = $this$hasFormOfSuspendModifierForLambda.getSource();
                if (firSourceElement3 == null) {
                    firSourceElement = null;
                } else {
                    IElementType iElementType = KtNodeTypes.PARENTHESIZED;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PARENTHESIZED");
                    firSourceElement = FirSourceUtilsKt.getChild$default(firSourceElement3, iElementType, 0, 1, 2, null);
                }
                if (firSourceElement == null) {
                    return true;
                }
            }
        }
        return false;
    }

    private final FirFunction findEnclosingSuspendFunction(CheckerContext context2) {
        FirDeclaration firDeclaration;
        block5: {
            List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean bl;
                FirDeclaration element$iv;
                FirDeclaration it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                FirDeclaration firDeclaration2 = it;
                if (firDeclaration2 instanceof FirAnonymousFunction) {
                    bl = InferenceUtilsKt.isSuspendFunctionType(FirTypeUtilsKt.getConeType(((FirAnonymousFunction)it).getTypeRef()), context2.getSession());
                } else if (firDeclaration2 instanceof FirSimpleFunction) {
                    FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)((Object)it);
                    boolean $i$f$isSuspend = false;
                    bl = $this$isSuspend$iv.getStatus().isSuspend();
                } else {
                    bl = false;
                }
                if (!bl) continue;
                firDeclaration = element$iv;
                break block5;
            }
            firDeclaration = null;
        }
        FirDeclaration firDeclaration3 = firDeclaration;
        return firDeclaration3 instanceof FirFunction ? (FirFunction)firDeclaration3 : null;
    }

    private final boolean checkNonLocalReturnUsage(FirFunction enclosingSuspendFunction, CheckerContext context2) {
        Object v0;
        block6: {
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            Iterable iterable = $this$lastIsInstanceOrNull$iv;
            if (iterable instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object element$iv;
                        if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirFunction)) continue;
                        v0 = element$iv;
                        break block6;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirFunction)) continue;
                    v0 = element$iv$iv;
                    break block6;
                }
                v0 = null;
            }
        }
        FirFunction firFunction = v0;
        if (firFunction == null) {
            return false;
        }
        FirFunction containingFunction = firFunction;
        return containingFunction instanceof FirAnonymousFunction && enclosingSuspendFunction != containingFunction ? ((FirAnonymousFunction)containingFunction).getInlineStatus().getReturnAllowed() : enclosingSuspendFunction == containingFunction;
    }

    private final boolean checkRestrictsSuspension(FirQualifiedAccessExpression expression2, FirFunction enclosingSuspendFunction, FirCallableSymbol<?> calledDeclarationSymbol, CheckerContext context2) {
        ConeKotlinType coneKotlinType;
        Object object;
        FirRegularClass firRegularClass;
        ConeClassLikeType coneClassLikeType;
        FirSession session2 = context2.getSession();
        Object object2 = enclosingSuspendFunction.getDispatchReceiverType();
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object2 instanceof ConeClassLikeType ? (ConeClassLikeType)object2 : null;
        if (coneClassLikeType == null) {
            firRegularClass = null;
        } else {
            object2 = coneClassLikeType.getLookupTag();
            firRegularClass = LookupTagUtilsKt.toFirRegularClass((ConeClassLikeLookupTag)object2, session2);
        }
        FirRegularClass enclosingSuspendFunctionDispatchReceiverOwner = firRegularClass;
        Object it = object2 = enclosingSuspendFunction;
        boolean bl = false;
        Object enclosingSuspendFunctionExtensionReceiverOwner = ((FirFunction)it).getReceiverTypeRef() != null ? object2 : null;
        Object it2 = it = expression2.getDispatchReceiver();
        boolean bl2 = false;
        Object dispatchReceiverExpression = !(it2 instanceof FirNoReceiverExpression) ? it : null;
        Object object3 = expression2.getExtensionReceiver();
        Object[] it3 = object3;
        boolean bl3 = false;
        Object[] extensionReceiverExpression = !(it3 instanceof FirNoReceiverExpression) ? object3 : null;
        it3 = new FirExpression[]{dispatchReceiverExpression, extensionReceiverExpression};
        for (FirExpression receiverExpression : CollectionsKt.listOfNotNull((Object[])it3)) {
            if (!this.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(receiverExpression.getTypeRef()), session2) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionDispatchReceiverOwner) || this.sameInstanceOfReceiver(receiverExpression, (FirDeclaration)enclosingSuspendFunctionExtensionReceiverOwner)) continue;
            return false;
        }
        object3 = enclosingSuspendFunctionExtensionReceiverOwner;
        if (!(object3 == null ? false : ((object = ((FirFunction)object3).getReceiverTypeRef()) == null ? false : this.isRestrictSuspensionReceiver(coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)object), session2)))) {
            return true;
        }
        if (this.sameInstanceOfReceiver((FirExpression)dispatchReceiverExpression, (FirDeclaration)enclosingSuspendFunctionExtensionReceiverOwner)) {
            return true;
        }
        return this.sameInstanceOfReceiver((FirExpression)extensionReceiverExpression, (FirDeclaration)enclosingSuspendFunctionExtensionReceiverOwner) && ((object3 = calledDeclarationSymbol.getResolvedReceiverTypeRef()) == null ? false : this.isRestrictSuspensionReceiver((ConeKotlinType)(object = FirTypeUtilsKt.getConeType((FirTypeRef)object3)), session2));
    }

    private final boolean isRestrictSuspensionReceiver(ConeKotlinType $this$isRestrictSuspensionReceiver, FirSession session2) {
        ConeKotlinType coneKotlinType = $this$isRestrictSuspensionReceiver;
        if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl;
            block10: {
                FirRegularClass firRegularClass = LookupTagUtilsKt.toFirRegularClass(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isRestrictSuspensionReceiver, session2, null, 2, null).getLookupTag(), session2);
                if (firRegularClass == null) {
                    return false;
                }
                FirRegularClass regularClass = firRegularClass;
                if (FirAnnotationUtilsKt.hasAnnotation(regularClass, RESTRICTS_SUSPENSION_CLASS_ID)) {
                    return true;
                }
                Iterable $this$any$iv = regularClass.getSuperTypeRefs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(it), session2)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        if (coneKotlinType instanceof ConeTypeParameterType) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = ((ConeTypeParameterType)$this$isRestrictSuspensionReceiver).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(FirTypeUtilsKt.getConeType(it), session2)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean sameInstanceOfReceiver(FirExpression useSiteReceiverExpression, FirDeclaration declarationSiteReceiverOwner) {
        if (declarationSiteReceiverOwner == null || useSiteReceiverExpression == null) {
            return false;
        }
        if (useSiteReceiverExpression instanceof FirThisReceiverExpression) {
            return Intrinsics.areEqual(((FirThisReceiverExpression)useSiteReceiverExpression).getCalleeReference().getBoundSymbol(), declarationSiteReceiverOwner.getSymbol());
        }
        return false;
    }

    static {
        Name name = SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"KOTLIN_SUSPEND_BUILT_IN_\u2026CTION_FQ_NAME.shortName()");
        BUILTIN_SUSPEND_NAME = name;
        KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID = new CallableId(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE(), BUILTIN_SUSPEND_NAME);
    }
}

