/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/ArrayConstructor;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "", "unwind", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class ArrayConstructor
extends IntrinsicBase {
    @NotNull
    public static final ArrayConstructor INSTANCE = new ArrayConstructor();

    private ArrayConstructor() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        Object[] objectArray = new String[]{"kotlin.Array.<init>", "kotlin.ByteArray.<init>", "kotlin.CharArray.<init>", "kotlin.ShortArray.<init>", "kotlin.IntArray.<init>", "kotlin.LongArray.<init>", "kotlin.FloatArray.<init>", "kotlin.DoubleArray.<init>", "kotlin.BooleanArray.<init>"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        KFunctionState kFunctionState;
        State state;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (irFunction2.getValueParameters().size() == 1) {
            return CollectionsKt.listOf((Object)this.customEvaluateInstruction(irFunction2, environment));
        }
        CallStack callStack = environment.getCallStack$ir_interpreter();
        Object[] objectArray = new Instruction[]{this.customEvaluateInstruction(irFunction2, environment)};
        List instructions = CollectionsKt.mutableListOf((Object[])objectArray);
        IrValueParameterSymbol sizeSymbol = irFunction2.getValueParameters().get(0).getSymbol();
        int size = StateKt.asInt(callStack.loadState(sizeSymbol));
        IrValueParameterSymbol initSymbol = irFunction2.getValueParameters().get(1).getSymbol();
        State it = state = callStack.loadState(initSymbol);
        boolean bl = false;
        KFunctionState kFunctionState2 = kFunctionState = it instanceof KFunctionState ? (KFunctionState)it : null;
        KFunctionState state2 = kFunctionState == null ? ((KPropertyState)it).convertGetterToKFunctionState(environment) : kFunctionState;
        callStack.rewriteState(initSymbol, state2);
        int n = size - 1;
        if (0 <= n) {
            do {
                int i = n--;
                IrCall call2 = IrTreeBuildUtilsKt.createCall$default((IrSimpleFunction)state2.getInvokeSymbol().getOwner(), null, 1, null);
                call2.setDispatchReceiver(IrTreeBuildUtilsKt.createGetValue(initSymbol.getOwner()));
                call2.putValueArgument(0, IrTreeBuildUtilsKt.toIrConst$default(i, environment.getIrBuiltIns().getIntType(), 0, 0, 6, null));
                ((Collection)instructions).add(new CompoundInstruction(call2));
            } while (0 <= n);
        }
        return instructions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        int n;
        List<Object> list2;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrValueParameterSymbol sizeDescriptor = irFunction2.getValueParameters().get(0).getSymbol();
        int size = StateKt.asInt(environment.getCallStack$ir_interpreter().loadState(sizeDescriptor));
        ArrayList<Character> arrayList = new ArrayList<Character>(size);
        int n2 = 0;
        while (n2 < size) {
            int n3;
            int n4;
            int n5 = n4 = (n3 = n2++);
            list2 = arrayList;
            boolean bl = false;
            Character c = IrTypePredicatesKt.isCharArray(irFunction2.getReturnType()) ? Character.valueOf('\u0000') : (IrTypePredicatesKt.isBooleanArray(irFunction2.getReturnType()) ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0));
            ((ArrayList)list2).add(c);
        }
        List arrayValue = arrayList;
        if (irFunction2.getValueParameters().size() == 2 && 0 <= (n = size - 1)) {
            do {
                void it;
                State state;
                int i = n--;
                State state2 = state = environment.getCallStack$ir_interpreter().popState();
                int n6 = i;
                list2 = arrayValue;
                boolean bl = false;
                void var11_14 = it;
                Object object = var11_14 instanceof Wrapper ? ((Wrapper)it).getValue() : (var11_14 instanceof Primitive ? (IrTypePredicatesKt.isArray(((Primitive)it).getType()) || UtilsKt.isPrimitiveArray(((Primitive)it).getType()) ? it : ((Primitive)it).getValue()) : it);
                list2.set(n6, object);
            } while (0 <= n);
        }
        IrType type2 = ((KTypeState)environment.getCallStack$ir_interpreter().loadState(irFunction2.getSymbol())).getIrType();
        environment.getCallStack$ir_interpreter().pushState(UtilsKt.toPrimitiveStateArray(arrayValue, type2));
    }
}

