/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u001e2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver;", "", "()V", "getCallerName", "Lorg/jetbrains/kotlin/name/Name;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getContainingCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getElementsByLabelName", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "labelName", "labelExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getExpressionUnderLabel", "labeledExpression", "getLabelForFunctionalExpression", "element", "getLabelNameIfAny", "Lcom/intellij/psi/PsiElement;", "resolveControlLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolveNamedLabel", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveThisOrSuperLabel", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "Lorg/jetbrains/kotlin/psi/KtInstanceExpressionWithLabel;", "LabeledReceiverResolutionResult", "frontend"})
public final class LabelResolver {
    @NotNull
    public static final LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    private final Set<KtElement> getElementsByLabelName(Name labelName, KtSimpleNameExpression labelExpression) {
        LinkedHashSet<KtExpression> elements = new LinkedHashSet<KtExpression>();
        PsiElement parent2 = labelExpression.getParent();
        while (parent2 != null) {
            Name name = this.getLabelNameIfAny(parent2);
            if (name != null && Intrinsics.areEqual((Object)name, (Object)labelName)) {
                PsiElement psiElement = parent2;
                elements.add(this.getExpressionUnderLabel((KtExpression)psiElement));
            }
            parent2 = parent2 instanceof KtCodeFragment ? ((KtCodeFragment)parent2).getContext() : parent2.getParent();
        }
        return elements;
    }

    @Nullable
    public final Name getLabelNameIfAny(@NotNull PsiElement element) {
        Name name;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof KtLabeledExpression) {
            name = ((KtLabeledExpression)element).getLabelNameAsName();
        } else if (psiElement instanceof KtFunctionLiteral) {
            PsiElement psiElement2 = ((KtFunctionLiteral)element).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
            name = this.getLabelNameIfAny(psiElement2);
        } else {
            Name name2;
            name = psiElement instanceof KtLambdaExpression ? this.getLabelForFunctionalExpression((KtExpression)element) : (psiElement instanceof KtNamedFunction ? ((name2 = ((KtNamedFunction)element).getNameAsName()) == null ? this.getLabelForFunctionalExpression((KtExpression)element) : name2) : null);
        }
        return name;
    }

    private final Name getLabelForFunctionalExpression(KtExpression element) {
        Name name;
        PsiElement parent2 = element.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtLabeledExpression) {
            Intrinsics.checkNotNullExpressionValue((Object)parent2, (String)"parent");
            name = this.getLabelNameIfAny(parent2);
        } else {
            name = psiElement instanceof KtBinaryExpression ? ((KtBinaryExpression)parent2).getOperationReference().getReferencedNameAsName() : this.getCallerName(element);
        }
        return name;
    }

    private final KtExpression getExpressionUnderLabel(KtExpression labeledExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(labeledExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"safeDeparenthesize(labeledExpression)");
        KtExpression expression2 = ktExpression2;
        if (expression2 instanceof KtLambdaExpression) {
            ktExpression2 = ((KtLambdaExpression)expression2).getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.functionLiteral");
            ktExpression = ktExpression2;
        } else {
            ktExpression = expression2;
        }
        return ktExpression;
    }

    private final Name getCallerName(KtExpression expression2) {
        KtCallExpression ktCallExpression = this.getContainingCallExpression(expression2);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        KtSimpleNameExpression calleeExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        ktExpression = calleeExpression;
        return ktExpression == null ? null : ktExpression.getReferencedNameAsName();
    }

    private final KtCallExpression getContainingCallExpression(KtExpression expression2) {
        PsiElement call2;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtLambdaArgument && (call2 = ((KtLambdaArgument)parent2).getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call2;
        }
        if (parent2 instanceof KtValueArgument) {
            PsiElement psiElement = ((KtValueArgument)parent2).getParent();
            if (psiElement == null) {
                return null;
            }
            PsiElement argList = psiElement;
            PsiElement call3 = argList.getParent();
            if (call3 instanceof KtCallExpression) {
                return (KtCallExpression)call3;
            }
        }
        return null;
    }

    @Nullable
    public final KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression2, @NotNull ResolutionContext<?> context2) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        KtSimpleNameExpression labelElement = expression2.getTargetLabel();
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        ReservedCheckingKt.checkReservedYield(labelElement, bindingTrace);
        Name labelName = expression2.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        Object object = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace");
        KtElement ktElement2 = this.resolveNamedLabel(labelName, labelElement, (BindingTrace)object);
        if (ktElement2 == null) {
            object = this;
            LabelResolver $this$resolveControlLabel_u24lambda_u2d0 = (LabelResolver)object;
            boolean bl = false;
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)labelElement), labelElement));
            ktElement = null;
        } else {
            ktElement = ktElement2;
        }
        return ktElement;
    }

    private final KtElement resolveNamedLabel(Name labelName, KtSimpleNameExpression labelExpression, BindingTrace trace) {
        Set<KtElement> list2 = this.getElementsByLabelName(labelName, labelExpression);
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)labelExpression)));
        }
        Object object = CollectionsKt.first((Iterable)list2);
        KtElement it = (KtElement)object;
        boolean bl = false;
        trace.record(BindingContext.LABEL_TARGET, labelExpression, it);
        return (KtElement)object;
    }

    @NotNull
    public final LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression2, @NotNull ResolutionContext<?> context2, @NotNull Name labelName) {
        int size;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        KtReferenceExpression ktReferenceExpression = expression2.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"expression.instanceReference");
        KtReferenceExpression referenceExpression = ktReferenceExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(((Object)expression2).toString());
        }
        KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"context.scope");
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(lexicalScope, labelName);
        int n = size = declarationsByLabel.size();
        switch (n) {
            case 1: {
                ReceiverParameterDescriptor receiverParameterDescriptor;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)CollectionsKt.single((Iterable)declarationsByLabel);
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
                } else if (declarationDescriptor2 instanceof FunctionDescriptor) {
                    receiverParameterDescriptor = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
                    receiverParameterDescriptor = ((PropertyDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else {
                    throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unsupported descriptor: ", (Object)declarationDescriptor));
                }
                ReceiverParameterDescriptor thisReceiver2 = receiverParameterDescriptor;
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    String string2 = Intrinsics.stringPlus((String)"No PSI element for descriptor: ", (Object)declarationDescriptor);
                    throw new IllegalStateException(string2.toString());
                }
                PsiElement element = psiElement;
                context2.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                context2.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context2.scope, context2.trace, targetLabel, (ClassDescriptor)declarationDescriptor)) {
                    return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                }
                return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver2);
            }
            case 0: {
                BindingTrace thisReceiver2 = context2.trace;
                Intrinsics.checkNotNullExpressionValue((Object)thisReceiver2, (String)"context.trace");
                KtElement element = this.resolveNamedLabel(labelName, targetLabel, thisReceiver2);
                DeclarationDescriptor declarationDescriptor = context2.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    ReceiverParameterDescriptor thisReceiver3 = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                    if (thisReceiver3 != null) {
                        context2.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context2.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                    }
                    return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver3);
                }
                context2.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)targetLabel), targetLabel));
                break;
            }
            default: {
                BindingContextUtils.reportAmbiguousLabel(context2.trace, targetLabel, declarationsByLabel);
            }
        }
        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "", "code", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "(Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)V", "getCode", "()Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "getReceiverParameterDescriptor", "success", "", "Code", "Companion", "frontend"})
    public static final class LabeledReceiverResolutionResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Code code;
        @Nullable
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        @NotNull
        public final Code getCode() {
            return this.code;
        }

        public final boolean success() {
            return this.code == Code.SUCCESS;
        }

        @Nullable
        public final ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            boolean bl = this.success();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = Intrinsics.stringPlus((String)"Don't try to obtain the receiver when resolution failed with ", (Object)((Object)this.getCode()));
                throw new AssertionError((Object)string2);
            }
            return this.receiverParameterDescriptor;
        }

        public /* synthetic */ LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor, DefaultConstructorMarker $constructor_marker) {
            this(code, receiverParameterDescriptor);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "", "(Ljava/lang/String;I)V", "LABEL_RESOLUTION_ERROR", "NO_THIS", "SUCCESS", "frontend"})
        public static final class Code
        extends Enum<Code> {
            public static final /* enum */ Code LABEL_RESOLUTION_ERROR = new Code();
            public static final /* enum */ Code NO_THIS = new Code();
            public static final /* enum */ Code SUCCESS = new Code();
            private static final /* synthetic */ Code[] $VALUES;

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            public static Code valueOf(String value2) {
                return Enum.valueOf(Code.class, value2);
            }

            static {
                $VALUES = codeArray = new Code[]{Code.LABEL_RESOLUTION_ERROR, Code.NO_THIS, Code.SUCCESS};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Companion;", "", "()V", "labelResolutionFailed", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "labelResolutionSuccess", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
                if (receiverParameterDescriptor == null) {
                    return new LabeledReceiverResolutionResult(Code.NO_THIS, null, null);
                }
                return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor, null);
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionFailed() {
                return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

