/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInfixFunctionDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "hasExtensionOrDispatchReceiver", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
public final class FirInfixFunctionDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirInfixFunctionDeclarationChecker INSTANCE = new FirInfixFunctionDeclarationChecker();

    private FirInfixFunctionDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirDeclarationStatus firDeclarationStatus;
        FirMemberDeclaration firMemberDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration = declaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)((Object)declaration2) : null;
        if (!(firMemberDeclaration == null ? false : (firDeclarationStatus = firMemberDeclaration.getStatus()).isInfix())) {
            return;
        }
        if (declaration2 instanceof FirSimpleFunction) {
            if (((FirSimpleFunction)declaration2).getValueParameters().size() != 1 || !this.hasExtensionOrDispatchReceiver((FirSimpleFunction)declaration2, context2)) {
                DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_INFIX_MODIFIER(), context2, null, 8, null);
            }
            return;
        }
        DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_INFIX_MODIFIER(), context2, null, 8, null);
    }

    private final boolean hasExtensionOrDispatchReceiver(FirSimpleFunction function2, CheckerContext context2) {
        if (function2.getReceiverTypeRef() != null) {
            return true;
        }
        return CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirClass;
    }
}

