/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.PsiJavaFileImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParserDefinition
implements ParserDefinition {
    public static final IStubFileElementType JAVA_FILE = new JavaFileElementType();

    @Override
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        LanguageLevel level = project != null ? LanguageLevelProjectExtension.getInstance(project).getLanguageLevel() : LanguageLevel.HIGHEST;
        return JavaParserDefinition.createLexer(level);
    }

    @NotNull
    public static Lexer createLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaParserDefinition.$$$reportNull$$$0(0);
        }
        return new JavaLexer(level);
    }

    @NotNull
    public static Lexer createDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaParserDefinition.$$$reportNull$$$0(1);
        }
        return new JavaDocLexer(level);
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JAVA_FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.WHITE_SPACE;
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = ElementType.JAVA_COMMENT_BIT_SET;
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create(JavaElementType.LITERAL_EXPRESSION);
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 instanceof JavaStubElementType) {
            Object PsiT = ((JavaStubElementType)type2).createPsi(node);
            if (PsiT == null) {
                JavaParserDefinition.$$$reportNull$$$0(5);
            }
            return PsiT;
        }
        throw new IllegalArgumentException("Not a Java node: " + node + " (" + type2 + ", " + type2.getLanguage() + ")");
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiJavaFileImpl(viewProvider);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text2;
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN || left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        PsiFile containingFile = left.getTreeParent().getPsi().getContainingFile();
        LanguageLevel level = containingFile instanceof PsiJavaFile ? ((PsiJavaFile)containingFile).getLanguageLevel() : LanguageLevel.HIGHEST;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer(left, right, lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text2 = left.getText()).length() > 0 && Character.isWhitespace(text2.charAt(text2.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text2 = right.getText()).length() > 0 && Character.isWhitespace(text2.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/JavaParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/JavaParserDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDocLexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

