/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamerBase;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTables;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerImpl;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamerBase;", "newNameTables", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getNameForMemberField", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForStaticDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "backend.js"})
public final class IrNamerImpl
extends IrNamerBase {
    @NotNull
    private final NameTables newNameTables;
    @NotNull
    private final JsIrBackendContext context;

    public IrNamerImpl(@NotNull NameTables newNameTables, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)newNameTables, (String)"newNameTables");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.newNameTables = newNameTables;
        this.context = context2;
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        return this.toJsName(this.newNameTables.getNameForStaticDeclaration(declaration2));
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (!(function2.getDispatchReceiverParameter() != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        String signature2 = NameTablesKt.jsFunctionSignature(function2, this.context);
        return this.toJsName(signature2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        if (!(!field2.isStatic())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.toJsName(this.newNameTables.getNameForMemberField(field2));
    }
}

