/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirSealedClassConstructorCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSealedClassConstructorCallChecker INSTANCE = new FirSealedClassConstructorCallChecker();

    private FirSealedClassConstructorCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol typeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeType coneClassLikeType;
        void $this$safeAs$iv;
        FirConstructorSymbol firConstructorSymbol;
        FirResolvedNamedReference firResolvedNamedReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference $this$safeAs$iv2 = expression2.getCalleeReference();
        boolean $i$f$safeAs22 = false;
        FirReference firReference = $this$safeAs$iv2;
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        FirRegularClassSymbol firRegularClassSymbol = (firResolvedNamedReference = (FirResolvedNamedReference)firReference) == null ? null : firResolvedNamedReference.getResolvedSymbol();
        FirConstructorSymbol firConstructorSymbol2 = firConstructorSymbol = firRegularClassSymbol instanceof FirConstructorSymbol ? (FirConstructorSymbol)((Object)firRegularClassSymbol) : null;
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol constructorSymbol = firConstructorSymbol;
        ConeKotlinType $i$f$safeAs22 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(constructorSymbol.getResolvedReturnTypeRef()), context2.getSession());
        boolean $i$f$safeAs = false;
        Object v2 = $this$safeAs$iv;
        if (!(v2 instanceof ConeClassLikeType)) {
            v2 = null;
        }
        if ((coneClassLikeType = (ConeClassLikeType)v2) == null) {
            firClassLikeSymbol = null;
        } else {
            ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassLikeType.getLookupTag();
            firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession());
        }
        firResolvedNamedReference = firClassLikeSymbol;
        FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firResolvedNamedReference instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)((Object)firResolvedNamedReference) : null;
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol $this$modality$iv = typeSymbol = firRegularClassSymbol;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getSEALED_CLASS_CONSTRUCTOR_CALL(), context2, null, 8, null);
        }
    }
}

