/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00182\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ContinueReplacingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "loopLabelName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "guardLabelName", "(Lorg/jetbrains/kotlin/js/backend/ast/JsName;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "getGuardLabelName", "()Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getLoopLabelName", "loopNestingLevel", "", "getLoopNestingLevel", "()I", "setLoopNestingLevel", "(I)V", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsLoop;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "visit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
public final class ContinueReplacingVisitor
extends JsVisitorWithContextImpl {
    @Nullable
    private final JsName loopLabelName;
    @NotNull
    private final JsName guardLabelName;
    private int loopNestingLevel;

    public ContinueReplacingVisitor(@Nullable JsName loopLabelName, @NotNull JsName guardLabelName) {
        Intrinsics.checkNotNullParameter((Object)guardLabelName, (String)"guardLabelName");
        this.loopLabelName = loopLabelName;
        this.guardLabelName = guardLabelName;
    }

    @Nullable
    public final JsName getLoopLabelName() {
        return this.loopLabelName;
    }

    @NotNull
    public final JsName getGuardLabelName() {
        return this.guardLabelName;
    }

    public final int getLoopNestingLevel() {
        return this.loopNestingLevel;
    }

    public final void setLoopNestingLevel(int n) {
        this.loopNestingLevel = n;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx2) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        return false;
    }

    public boolean visit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx2) {
        boolean bl;
        JsName target;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        JsNameRef jsNameRef = x.getLabel();
        JsName jsName = target = jsNameRef == null ? null : jsNameRef.getName();
        boolean shouldReplace = target == null ? this.loopNestingLevel == 0 : Intrinsics.areEqual((Object)target, (Object)this.loopLabelName);
        boolean bl2 = bl = this.loopNestingLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (shouldReplace) {
            ctx2.replaceMe((JsNode)new JsBreak(this.guardLabelName.makeRef()));
        }
        return false;
    }

    public boolean visit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx2) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        if (this.loopLabelName == null) {
            return false;
        }
        ContinueReplacingVisitor continueReplacingVisitor = this;
        int n = continueReplacingVisitor.loopNestingLevel;
        continueReplacingVisitor.loopNestingLevel = n + 1;
        return super.visit(x, ctx2);
    }

    public void endVisit(@NotNull JsLoop x, @NotNull JsContext<JsNode> ctx2) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        super.endVisit(x, ctx2);
        if (this.loopLabelName == null) {
            return;
        }
        ContinueReplacingVisitor continueReplacingVisitor = this;
        int n = continueReplacingVisitor.loopNestingLevel;
        continueReplacingVisitor.loopNestingLevel = n + -1;
    }
}

