/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016Jr\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u001a\b\u0002\u0010\u0018\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\u0018\u00010\u00132\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkSpecialFunctionCall", "", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "reportSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "ambiguityFactory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory1;", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "missingFactory", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "noneApplicableFactory", "unsafeCallFactory", "checkers"})
public final class FirForLoopChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirForLoopChecker INSTANCE = new FirForLoopChecker();

    private FirForLoopChecker() {
    }

    @Override
    public void check(@NotNull FirBlock expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirPureAbstractElement firPureAbstractElement;
        FirSourceElement source;
        FirProperty firProperty;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSourceElement firSourceElement = expression2.getSource();
        if (!Intrinsics.areEqual((Object)(firSourceElement == null ? null : firSourceElement.getKind()), (Object)FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        List<FirStatement> statements2 = expression2.getStatements();
        Object object = statements2.get(0);
        FirProperty firProperty2 = firProperty = object instanceof FirProperty ? (FirProperty)object : null;
        if (firProperty == null) {
            return;
        }
        FirProperty iteratorDeclaration = firProperty;
        FirStatement firStatement = statements2.get(1);
        Object object2 = object = firStatement instanceof FirWhileLoop ? (FirWhileLoop)firStatement : null;
        if (object == null) {
            return;
        }
        FirStatement whileLoop = object;
        object = iteratorDeclaration.getSource();
        if (!Intrinsics.areEqual((Object)(object == null ? null : ((FirSourceElement)object).getKind()), (Object)FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        firStatement = iteratorDeclaration.getInitializer();
        if (firStatement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        }
        FirFunctionCall iteratorCall = (FirFunctionCall)firStatement;
        FirExpression firExpression2 = iteratorCall.getExplicitReceiver();
        FirSourceElement firSourceElement2 = firExpression2 == null ? null : firExpression2.getSource();
        FirSourceElement firSourceElement3 = source = firSourceElement2 == null ? iteratorCall.getSource() : firSourceElement2;
        if (FirForLoopChecker.checkSpecialFunctionCall$default(this, iteratorCall, reporter, source, context2, FirErrors.INSTANCE.getITERATOR_AMBIGUITY(), FirErrors.INSTANCE.getITERATOR_MISSING(), null, FirErrors.INSTANCE.getITERATOR_ON_NULLABLE(), 64, null)) {
            return;
        }
        FirFunctionCall hasNextCall = (FirFunctionCall)((FirWhileLoop)whileLoop).getCondition();
        FirForLoopChecker.checkSpecialFunctionCall$default(this, hasNextCall, reporter, source, context2, FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_AMBIGUITY(), FirErrors.INSTANCE.getHAS_NEXT_MISSING(), FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_NONE_APPLICABLE(), null, 128, null);
        Object object3 = CollectionsKt.firstOrNull(((FirWhileLoop)whileLoop).getBlock().getStatements());
        FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement = object3 instanceof FirProperty ? (FirProperty)object3 : null;
        if (firPureAbstractElement == null) {
            return;
        }
        FirPureAbstractElement loopParameter = firPureAbstractElement;
        if (!Intrinsics.areEqual((firPureAbstractElement = loopParameter.getInitializer()) == null ? null : ((object3 = ((FirExpression)firPureAbstractElement).getSource()) == null ? null : ((FirSourceElement)object3).getKind()), (Object)FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        object3 = loopParameter.getInitializer();
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        }
        FirFunctionCall nextCall = (FirFunctionCall)object3;
        FirForLoopChecker.checkSpecialFunctionCall$default(this, nextCall, reporter, source, context2, FirErrors.INSTANCE.getNEXT_AMBIGUITY(), FirErrors.INSTANCE.getNEXT_MISSING(), FirErrors.INSTANCE.getNEXT_NONE_APPLICABLE(), null, 128, null);
        FirSourceElement loopParameterSource = loopParameter.getSource();
        KtKeywordToken ktKeywordToken = FirKeywordUtilsKt.getValOrVarKeyword(loopParameterSource);
        if (ktKeywordToken != null) {
            KtKeywordToken ktKeywordToken2;
            KtKeywordToken it = ktKeywordToken2 = ktKeywordToken;
            boolean bl = false;
            DiagnosticReporterKt.reportOn$default(reporter, loopParameterSource, FirErrors.INSTANCE.getVAL_OR_VAR_ON_LOOP_PARAMETER(), (Object)it, context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSpecialFunctionCall(FirFunctionCall call2, DiagnosticReporter reporter, FirSourceElement reportSource, CheckerContext context2, FirDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ambiguityFactory, FirDiagnosticFactory0 missingFactory, FirDiagnosticFactory1<Collection<FirBasedSymbol<?>>> noneApplicableFactory, FirDiagnosticFactory0 unsafeCallFactory) {
        FirBasedSymbol<?> symbol2;
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (calleeReference instanceof FirErrorNamedReference) {
            ConeDiagnostic diagnostic = ((FirErrorNamedReference)calleeReference).getDiagnostic();
            if (diagnostic instanceof ConeAmbiguityError) {
                if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
                    Collection<FirBasedSymbol<?>> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                    FirDiagnosticFactory1<Collection<FirBasedSymbol<?>>> firDiagnosticFactory1 = ambiguityFactory;
                    FirSourceElement firSourceElement = reportSource;
                    DiagnosticReporter diagnosticReporter = reporter;
                    boolean $i$f$map = false;
                    void var13_26 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Candidate candidate2 = (Candidate)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
                        collection.add(firBasedSymbol);
                    }
                    collection = (List)destination$iv$iv;
                    DiagnosticReporterKt.reportOn$default(diagnosticReporter, firSourceElement, firDiagnosticFactory1, (Object)collection, context2, null, 16, null);
                } else if (noneApplicableFactory != null) {
                    Collection<FirBasedSymbol<?>> collection;
                    Iterable $this$map$iv = ((ConeAmbiguityError)diagnostic).getCandidates();
                    FirDiagnosticFactory1<Collection<FirBasedSymbol<?>>> firDiagnosticFactory1 = noneApplicableFactory;
                    FirSourceElement firSourceElement = reportSource;
                    DiagnosticReporter diagnosticReporter = reporter;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Candidate it = (Candidate)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
                        collection.add(firBasedSymbol);
                    }
                    collection = (List)destination$iv$iv;
                    DiagnosticReporterKt.reportOn$default(diagnosticReporter, firSourceElement, firDiagnosticFactory1, (Object)collection, context2, null, 16, null);
                }
            } else if (diagnostic instanceof ConeUnresolvedNameError) {
                DiagnosticReporterKt.reportOn$default(reporter, reportSource, missingFactory, context2, null, 8, null);
            } else if (diagnostic instanceof ConeInapplicableCandidateError && (unsafeCallFactory != null || noneApplicableFactory != null)) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getDiagnostics();
                boolean $i$f$filter = false;
                Iterable $this$mapTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getApplicability() == ((ConeInapplicableCandidateError)diagnostic).getApplicability())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv;
                    boolean bl = false;
                    if (!(it instanceof UnsafeCall)) continue;
                    if (unsafeCallFactory != null) {
                        DiagnosticReporterKt.reportOn$default(reporter, reportSource, unsafeCallFactory, context2, null, 8, null);
                    } else {
                        FirDiagnosticFactory1<Collection<FirBasedSymbol<?>>> firDiagnosticFactory1 = noneApplicableFactory;
                        Intrinsics.checkNotNull(firDiagnosticFactory1);
                        DiagnosticReporterKt.reportOn$default(reporter, reportSource, firDiagnosticFactory1, (Object)CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()), context2, null, 16, null);
                    }
                    return true;
                }
            }
            return true;
        }
        if (calleeReference instanceof FirResolvedNamedReference && (symbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol()) instanceof FirNamedFunctionSymbol) {
            FirCallableSymbol $this$isOperator$iv = (FirCallableSymbol)symbol2;
            boolean $i$f$isOperator = false;
            if (!$this$isOperator$iv.getResolvedStatus().isOperator()) {
                FirDiagnosticFactory2<FirNamedFunctionSymbol, String> firDiagnosticFactory2 = FirErrors.INSTANCE.getOPERATOR_MODIFIER_REQUIRED();
                String string2 = ((FirNamedFunctionSymbol)symbol2).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"symbol.name.asString()");
                DiagnosticReporterKt.reportOn$default(reporter, reportSource, firDiagnosticFactory2, symbol2, (Object)string2, context2, null, 32, null);
            }
        }
        return false;
    }

    static /* synthetic */ boolean checkSpecialFunctionCall$default(FirForLoopChecker firForLoopChecker, FirFunctionCall firFunctionCall, DiagnosticReporter diagnosticReporter, FirSourceElement firSourceElement, CheckerContext checkerContext, FirDiagnosticFactory1 firDiagnosticFactory1, FirDiagnosticFactory0 firDiagnosticFactory0, FirDiagnosticFactory1 firDiagnosticFactory12, FirDiagnosticFactory0 firDiagnosticFactory02, int n, Object object) {
        if ((n & 0x40) != 0) {
            firDiagnosticFactory12 = null;
        }
        if ((n & 0x80) != 0) {
            firDiagnosticFactory02 = null;
        }
        return firForLoopChecker.checkSpecialFunctionCall(firFunctionCall, diagnosticReporter, firSourceElement, checkerContext, firDiagnosticFactory1, firDiagnosticFactory0, firDiagnosticFactory12, firDiagnosticFactory02);
    }
}

