/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface CachedValueProvider<T> {
    @Nullable
    public Result<T> compute();

    public static class Result<T> {
        private static final Logger LOG = Logger.getInstance(Result.class);
        private final T myValue;
        private final Object[] myDependencyItems;

        public Result(@Nullable T value2, Object ... dependencyItems) {
            if (dependencyItems == null) {
                Result.$$$reportNull$$$0(0);
            }
            this.myValue = value2;
            this.myDependencyItems = dependencyItems;
            if (dependencyItems.length == 0) {
                LOG.error("No dependencies provided which causes CachedValue to be never recalculated again. If this is intentional, please use ModificationTracker.NEVER_CHANGED");
            }
            for (int i = 0; i < dependencyItems.length; ++i) {
                if (dependencyItems[i] != null) continue;
                LOG.error("Null dependencies are not allowed, index=" + i);
            }
            if (CachedValueProfiler.canProfile()) {
                CachedValueProfiler.getInstance().createInfo(this);
            }
        }

        public T getValue() {
            return this.myValue;
        }

        public Object @NotNull [] getDependencyItems() {
            if (this.myDependencyItems == null) {
                Result.$$$reportNull$$$0(1);
            }
            return this.myDependencyItems;
        }

        @NotNull
        public static <T> Result<T> createSingleDependency(@Nullable T value2, @NotNull Object dependency) {
            if (dependency == null) {
                Result.$$$reportNull$$$0(2);
            }
            return Result.create(value2, dependency);
        }

        @NotNull
        public static <T> Result<T> create(@Nullable T value2, Object ... dependencies2) {
            if (dependencies2 == null) {
                Result.$$$reportNull$$$0(3);
            }
            return new Result<T>(value2, dependencies2);
        }

        @NotNull
        public static <T> Result<T> create(@Nullable T value2, @NotNull Collection<?> dependencies2) {
            if (dependencies2 == null) {
                Result.$$$reportNull$$$0(4);
            }
            return new Result<T>(value2, ArrayUtil.toObjectArray(dependencies2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyItems";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/util/CachedValueProvider$Result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/util/CachedValueProvider$Result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencyItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createSingleDependency";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

