/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.SpecialJvmAnnotations;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.AbstractBinaryClassAnnotationLoader;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.MemberSignature;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\rH\u0014J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0014H\u0004J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/AnnotationLoaderForClassFileStubBuilder;", "Lorg/jetbrains/kotlin/load/kotlin/AbstractBinaryClassAnnotationLoader;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/AnnotationLoaderForClassFileStubBuilder$AnnotationsClassIdContainer;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "cachedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cachedFileContent", "", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;Lcom/intellij/openapi/vfs/VirtualFile;[B)V", "getAnnotationsContainer", "binaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getCachedFileContent", "kotlinClass", "isRepeatableWithImplicitContainer", "", "annotationClassId", "arguments", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "loadAnnotation", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "result", "", "loadAnnotationsAndInitializers", "loadTypeAnnotation", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "AnnotationsClassIdContainer", "decompiler-to-file-stubs"})
final class AnnotationLoaderForClassFileStubBuilder
extends AbstractBinaryClassAnnotationLoader<ClassId, AnnotationsClassIdContainer> {
    @NotNull
    private final VirtualFile cachedFile;
    @NotNull
    private final byte[] cachedFileContent;

    public AnnotationLoaderForClassFileStubBuilder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull VirtualFile cachedFile, @NotNull byte[] cachedFileContent) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkNotNullParameter((Object)cachedFile, (String)"cachedFile");
        Intrinsics.checkNotNullParameter((Object)cachedFileContent, (String)"cachedFileContent");
        super(kotlinClassFinder);
        this.cachedFile = cachedFile;
        this.cachedFileContent = cachedFileContent;
    }

    @Override
    @NotNull
    protected AnnotationsClassIdContainer getAnnotationsContainer(@NotNull KotlinJvmBinaryClass binaryClass) {
        Intrinsics.checkNotNullParameter((Object)binaryClass, (String)"binaryClass");
        return this.loadAnnotationsAndInitializers(binaryClass);
    }

    @Override
    @Nullable
    protected byte[] getCachedFileContent(@NotNull KotlinJvmBinaryClass kotlinClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinClass, (String)"kotlinClass");
        VirtualFileKotlinClass virtualFileKotlinClass = kotlinClass instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinClass : null;
        if (Intrinsics.areEqual((Object)(virtualFileKotlinClass != null ? virtualFileKotlinClass.getFile() : null), (Object)this.cachedFile)) {
            return this.cachedFileContent;
        }
        return null;
    }

    @Override
    @NotNull
    protected ClassId loadTypeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        return NameResolverUtilKt.getClassId(nameResolver2, proto.getId());
    }

    @Override
    @Nullable
    protected KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<ClassId> result2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)SpecialJvmAnnotations.INSTANCE.getJAVA_LANG_ANNOTATION_REPEATABLE())) {
            ((Collection)result2).add(annotationClassId);
            return null;
        }
        return new KotlinJvmBinaryClass.AnnotationArgumentVisitor(this, annotationClassId, result2){
            @NotNull
            private final Map<Name, ConstantValue<?>> arguments;
            final /* synthetic */ AnnotationLoaderForClassFileStubBuilder this$0;
            final /* synthetic */ ClassId $annotationClassId;
            final /* synthetic */ List<ClassId> $result;
            {
                this.this$0 = $receiver;
                this.$annotationClassId = $annotationClassId;
                this.$result = $result;
                this.arguments = new LinkedHashMap<K, V>();
            }

            public void visitClassLiteral(@Nullable Name name, @NotNull ClassLiteralValue value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (name != null) {
                    this.arguments.put(name, new KClassValue(value2));
                }
            }

            public void visitEnd() {
                if (!this.this$0.isRepeatableWithImplicitContainer(this.$annotationClassId, this.arguments)) {
                    this.$result.add(this.$annotationClassId);
                }
            }

            public void visit(@Nullable Name name, @Nullable Object value2) {
            }

            public void visitEnum(@Nullable Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@Nullable Name name) {
                return null;
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@Nullable Name name, @NotNull ClassId classId) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                return null;
            }
        };
    }

    protected final boolean isRepeatableWithImplicitContainer(@NotNull ClassId annotationClassId, @NotNull Map<Name, ? extends ConstantValue<?>> arguments2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)SpecialJvmAnnotations.INSTANCE.getJAVA_LANG_ANNOTATION_REPEATABLE())) {
            return false;
        }
        ConstantValue<?> constantValue = arguments2.get(JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME);
        KClassValue kClassValue = constantValue instanceof KClassValue ? (KClassValue)constantValue : null;
        if (kClassValue == null) {
            return false;
        }
        KClassValue containerKClassValue = kClassValue;
        Object t = containerKClassValue.getValue();
        KClassValue.Value.NormalClass normalClass = t instanceof KClassValue.Value.NormalClass ? (KClassValue.Value.NormalClass)t : null;
        if (normalClass == null) {
            return false;
        }
        KClassValue.Value.NormalClass normalClass2 = normalClass;
        return this.isImplicitRepeatableContainer(normalClass2.getClassId());
    }

    private final AnnotationsClassIdContainer loadAnnotationsAndInitializers(KotlinJvmBinaryClass kotlinClass) {
        HashMap<MemberSignature, List<ClassId>> memberAnnotations = new HashMap<MemberSignature, List<ClassId>>();
        kotlinClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, memberAnnotations){
            final /* synthetic */ AnnotationLoaderForClassFileStubBuilder this$0;
            final /* synthetic */ HashMap<MemberSignature, List<ClassId>> $memberAnnotations;
            {
                this.this$0 = $receiver;
                this.$memberAnnotations = $memberAnnotations;
            }

            @NotNull
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                String string2 = name.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
                return new loadAnnotationsAndInitializers.AnnotationVisitorForMethod(this, MemberSignature.Companion.fromMethodNameAndDesc(string2, desc));
            }

            @NotNull
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                String string2 = name.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
                MemberSignature signature2 = MemberSignature.Companion.fromFieldNameAndDesc(string2, desc);
                return new loadAnnotationsAndInitializers.MemberAnnotationVisitor(this, signature2);
            }
        }, this.getCachedFileContent(kotlinClass));
        return new AnnotationsClassIdContainer((Map<MemberSignature, ? extends List<ClassId>>)memberAnnotations);
    }

    public static final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor access$loadAnnotationIfNotSpecial(AnnotationLoaderForClassFileStubBuilder $this, ClassId annotationClassId, SourceElement source, List result2) {
        return $this.loadAnnotationIfNotSpecial(annotationClassId, source, result2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/AnnotationLoaderForClassFileStubBuilder$AnnotationsClassIdContainer;", "Lorg/jetbrains/kotlin/load/kotlin/AbstractBinaryClassAnnotationLoader$AnnotationsContainer;", "Lorg/jetbrains/kotlin/name/ClassId;", "memberAnnotations", "", "Lorg/jetbrains/kotlin/load/kotlin/MemberSignature;", "", "(Ljava/util/Map;)V", "getMemberAnnotations", "()Ljava/util/Map;", "decompiler-to-file-stubs"})
    public static final class AnnotationsClassIdContainer
    extends AbstractBinaryClassAnnotationLoader.AnnotationsContainer<ClassId> {
        @NotNull
        private final Map<MemberSignature, List<ClassId>> memberAnnotations;

        public AnnotationsClassIdContainer(@NotNull Map<MemberSignature, ? extends List<ClassId>> memberAnnotations) {
            Intrinsics.checkNotNullParameter(memberAnnotations, (String)"memberAnnotations");
            this.memberAnnotations = memberAnnotations;
        }

        @Override
        @NotNull
        public Map<MemberSignature, List<ClassId>> getMemberAnnotations() {
            return this.memberAnnotations;
        }
    }
}

