/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingFromLineStartOffsets;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.ExternalPackageParentPatcher;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponentsStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrPluginContext;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.backend.Fir2IrSpecialSymbolProvider;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.FirIrProvider;
import org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import org.jetbrains.kotlin.fir.backend.WrappedDescriptorSignatureComposer;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrConstTransformer;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u008b\u00012\u00020\u0001:\u0002\u008b\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020Z2\u0006\u0010^\u001a\u00020_J\u0014\u0010`\u001a\u00020Z2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020>0*J\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020c0*2\u0006\u0010d\u001a\u00020\\H\u0002J\u001e\u0010e\u001a\u00020\\2\u0006\u0010f\u001a\u00020g2\u0006\u0010d\u001a\u00020\\2\u0006\u0010h\u001a\u00020XJ\u0016\u0010i\u001a\u00020Z2\u0006\u0010f\u001a\u00020g2\u0006\u0010d\u001a\u00020\\J\u0010\u0010j\u001a\u00020Z2\u0006\u0010k\u001a\u00020lH\u0002J\u000e\u0010m\u001a\u00020Z2\u0006\u0010^\u001a\u00020_J\u001f\u0010n\u001a\u00020\\2\u0006\u0010k\u001a\u00020l2\b\b\u0002\u0010d\u001a\u00020\\H\u0000\u00a2\u0006\u0002\boJ\u0010\u0010p\u001a\u00020Z2\u0006\u0010^\u001a\u00020_H\u0002J\u0016\u0010q\u001a\u00020\\2\u0006\u0010k\u001a\u00020l2\u0006\u0010r\u001a\u00020sJ\u0016\u0010t\u001a\u00020\\2\u0006\u0010k\u001a\u00020l2\u0006\u0010r\u001a\u00020sJ$\u0010u\u001a\u0004\u0018\u00010>2\u0006\u0010v\u001a\u00020c2\b\u0010w\u001a\u0004\u0018\u00010x2\u0006\u0010r\u001a\u00020sH\u0002J\u0010\u0010y\u001a\u00020Z2\u0006\u0010[\u001a\u00020xH\u0002J\u0018\u0010z\u001a\u00020\\2\u0006\u0010k\u001a\u00020l2\u0006\u0010r\u001a\u00020sH\u0002J\u0018\u0010{\u001a\u00020Z2\u0006\u0010^\u001a\u00020_2\u0006\u0010|\u001a\u00020}H\u0002J\u0018\u0010~\u001a\u00020Z2\u0006\u0010[\u001a\u00020x2\u0006\u0010d\u001a\u00020\\H\u0002JC\u0010\u007f\u001a\u00020Z2\r\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020_0*2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u000f\u0010\u0083\u0001\u001a\n\u0012\u0005\u0012\u00030\u0085\u00010\u0084\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020\"J\u001e\u0010\u0089\u0001\u001a\t\u0012\u0004\u0012\u00020c0\u008a\u00012\f\u0010a\u001a\b\u0012\u0004\u0012\u00020c0*H\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0018\u00104\u001a\b\u0012\u0004\u0012\u0002050*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010?\u001a\u00020@X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0012\u0010C\u001a\u00020DX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0012\u0010G\u001a\u00020HX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0012\u0010K\u001a\u00020LX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0012\u0010O\u001a\u00020PX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0012\u0010S\u001a\u00020TX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u000e\u0010W\u001a\u00020XX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008c\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "moduleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "components", "(Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "converter", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "generatorExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "postponedDeclarationsForFakeOverridesBinding", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "wereSourcesFakeOverridesBound", "", "bindFakeOverridesInClass", "", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "bindFakeOverridesInFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "bindFakeOverridesOrPostpone", "declarations", "delegatedMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "irClass", "processAnonymousObjectMembers", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "processHeaders", "processAnonymousObjectOnTheFly", "processClassAndNestedClassHeaders", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "processClassHeaders", "processClassMembers", "processClassMembers$fir2ir", "processFileAndClassMembers", "processLocalClassAndNestedClasses", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "processLocalClassAndNestedClassesOnTheFly", "processMemberDeclaration", "declaration", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "processNestedClassHeaders", "registerClassAndNestedClasses", "registerFileAndClasses", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "registerNestedClasses", "runSourcesConversion", "allFirFiles", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "irGenerationExtensions", "", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "fir2irVisitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "fir2IrExtensions", "syntheticPropertiesLast", "", "Companion", "fir2ir"})
public final class Fir2IrConverter
implements Fir2IrComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final List<FirDeclarationGenerationExtension> generatorExtensions;
    private boolean wereSourcesFakeOverridesBound;
    @NotNull
    private final List<IrDeclaration> postponedDeclarationsForFakeOverridesBinding;

    public Fir2IrConverter(@NotNull FirModuleDescriptor moduleDescriptor, @NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.moduleDescriptor = moduleDescriptor;
        this.components = components2;
        this.generatorExtensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        this.postponedDeclarationsForFakeOverridesBinding = new ArrayList();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public Fir2IrSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    public final void runSourcesConversion(@NotNull List<? extends FirFile> allFirFiles, @NotNull IrModuleFragmentImpl irModuleFragment, @NotNull Collection<? extends IrGenerationExtension> irGenerationExtensions, @NotNull Fir2IrVisitor fir2irVisitor, @NotNull Fir2IrExtensions fir2IrExtensions) {
        Intrinsics.checkNotNullParameter(allFirFiles, (String)"allFirFiles");
        Intrinsics.checkNotNullParameter((Object)irModuleFragment, (String)"irModuleFragment");
        Intrinsics.checkNotNullParameter(irGenerationExtensions, (String)"irGenerationExtensions");
        Intrinsics.checkNotNullParameter((Object)fir2irVisitor, (String)"fir2irVisitor");
        Intrinsics.checkNotNullParameter((Object)fir2IrExtensions, (String)"fir2IrExtensions");
        for (FirFile firFile : allFirFiles) {
            this.registerFileAndClasses(firFile, irModuleFragment);
        }
        this.getClassifierStorage().preCacheBuiltinClasses();
        for (FirFile firFile : allFirFiles) {
            this.processClassHeaders(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.processFileAndClassMembers(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.bindFakeOverridesInFile(firFile);
        }
        this.wereSourcesFakeOverridesBound = true;
        this.getFakeOverrideGenerator().bindOverriddenSymbols(this.postponedDeclarationsForFakeOverridesBinding);
        this.postponedDeclarationsForFakeOverridesBinding.clear();
        this.getClassifierStorage().processMembersOfClassesCreatedOnTheFly();
        this.getDelegatedMemberGenerator().generateBodies();
        for (FirFile firFile : allFirFiles) {
            firFile.accept(fir2irVisitor, null);
        }
        if (!irGenerationExtensions.isEmpty()) {
            Fir2IrPluginContext pluginContext2 = new Fir2IrPluginContext(this.components);
            for (IrGenerationExtension irGenerationExtension : irGenerationExtensions) {
                irGenerationExtension.generate(irModuleFragment, pluginContext2);
            }
        }
        IrVisitorsKt.acceptVoid(irModuleFragment, new ExternalPackageParentPatcher(this.components, fir2IrExtensions));
        Fir2IrConverter.Companion.evaluateConstants(irModuleFragment);
    }

    public final void bindFakeOverridesOrPostpone(@NotNull List<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        if (this.wereSourcesFakeOverridesBound) {
            this.getFakeOverrideGenerator().bindOverriddenSymbols(declarations2);
        } else {
            CollectionsKt.addAll((Collection)this.postponedDeclarationsForFakeOverridesBinding, (Iterable)declarations2);
        }
    }

    @NotNull
    public final IrClass processLocalClassAndNestedClassesOnTheFly(@NotNull FirRegularClass regularClass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass2 = this.registerClassAndNestedClasses(regularClass, parent2);
        this.processClassAndNestedClassHeaders(regularClass);
        return irClass2;
    }

    public final void processAnonymousObjectOnTheFly(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        this.registerNestedClasses(anonymousObject, irClass2);
        this.processNestedClassHeaders(anonymousObject);
    }

    @NotNull
    public final IrClass processLocalClassAndNestedClasses(@NotNull FirRegularClass regularClass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass2 = this.registerClassAndNestedClasses(regularClass, parent2);
        this.processClassAndNestedClassHeaders(regularClass);
        this.processClassMembers$fir2ir(regularClass, irClass2);
        this.bindFakeOverridesInClass(irClass2);
        return irClass2;
    }

    private final void registerFileAndClasses(FirFile file2, IrModuleFragment moduleFragment2) {
        IrFileEntry irFileEntry;
        FirDeclarationOrigin firDeclarationOrigin = file2.getOrigin();
        if (Intrinsics.areEqual((Object)firDeclarationOrigin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            PsiElement psiElement = UtilsKt.getPsi(file2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                irFileEntry = new PsiIrFileEntry((KtFile)it);
            } else {
                KtSourceFileLinesMapping linesMapping = file2.getSourceFileLinesMapping();
                if (linesMapping instanceof KtSourceFileLinesMappingFromLineStartOffsets) {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    irFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLineStartOffsets(), ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLastOffset());
                } else if (linesMapping instanceof KtPsiSourceFileLinesMapping) {
                    irFileEntry = new PsiIrFileEntry(((KtPsiSourceFileLinesMapping)linesMapping).getPsiFile());
                } else {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    irFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, null, 0, 6, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)firDeclarationOrigin, (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) {
            irFileEntry = new NaiveSourceBasedFileEntryImpl(file2.getName(), null, 0, 6, null);
        } else {
            throw new IllegalStateException(("Unsupported file origin: " + file2.getOrigin()).toString());
        }
        IrFileEntry fileEntry = irFileEntry;
        IrFileImpl irFile = new IrFileImpl(fileEntry, (PackageFragmentDescriptor)CollectionsKt.first(this.moduleDescriptor.getPackage(UtilsKt.getPackageFqName(file2)).getFragments()), moduleFragment2);
        this.getDeclarationStorage().registerFile(file2, irFile);
        Iterable $this$forEach$iv = file2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirRegularClass)it, irFile);
        }
        ((Collection)moduleFragment2.getFiles()).add(irFile);
    }

    public final void processClassHeaders(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Iterable $this$forEach$iv = file2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirRegularClass)it);
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().registerTypeAlias((FirTypeAlias)it, this.getDeclarationStorage().getIrFile(file2));
        }
    }

    private final void processFileAndClassMembers(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            IrDeclaration irDeclaration2;
            if (this.processMemberDeclaration(declaration, null, irFile) == null) continue;
            ((Collection)irFile.getDeclarations()).add(irDeclaration2);
        }
    }

    @NotNull
    public final IrClass processAnonymousObjectMembers(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass2, boolean processHeaders) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        if (processHeaders) {
            this.registerNestedClasses(anonymousObject, irClass2);
            this.processNestedClassHeaders(anonymousObject);
        }
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(anonymousObject, this.getSession());
        if (firConstructorSymbol != null) {
            FirConstructorSymbol it = firConstructorSymbol;
            boolean bl = false;
            ((Collection)irClass2.getDeclarations()).add(Fir2IrDeclarationStorage.createIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), irClass2, null, true, false, 20, null));
        }
        for (FirDeclaration declaration : this.syntheticPropertiesLast(anonymousObject.getDeclarations())) {
            IrDeclaration irDeclaration2;
            if (this.processMemberDeclaration(declaration, anonymousObject, irClass2) == null) continue;
            ((Collection)irClass2.getDeclarations()).add(irDeclaration2);
        }
        List realDeclarations = CollectionsKt.plus((Collection)this.delegatedMembers(irClass2), (Iterable)anonymousObject.getDeclarations());
        FakeOverrideGenerator $this$processAnonymousObjectMembers_u24lambda_u244 = this.getFakeOverrideGenerator();
        boolean bl = false;
        $this$processAnonymousObjectMembers_u24lambda_u244.addFakeOverrides(irClass2, anonymousObject, realDeclarations);
        this.bindFakeOverridesInClass(irClass2);
        return irClass2;
    }

    @NotNull
    public final IrClass processClassMembers$fir2ir(@NotNull FirRegularClass regularClass, @NotNull IrClass irClass2) {
        IrConstructor irConstructor2;
        IrConstructor irConstructor3;
        Object v0;
        List allDeclarations;
        block10: {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            List list2 = new ArrayList();
            List $this$processClassMembers_u24lambda_u245 = list2;
            boolean bl = false;
            $this$processClassMembers_u24lambda_u245.addAll(CollectionsKt.toMutableList((Collection)regularClass.getDeclarations()));
            if (!((Collection)this.generatorExtensions).isEmpty()) {
                $this$processClassMembers_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers(regularClass, this.getSession()));
                $this$processClassMembers_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers(regularClass, this.getSession()));
            }
            allDeclarations = list2;
            Iterable $this$firstOrNull$iv = allDeclarations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl2 = false;
                if (!(it instanceof FirConstructor && ((FirConstructor)it).isPrimary())) continue;
                v0 = element$iv;
                break block10;
            }
            v0 = null;
        }
        FirDeclaration firDeclaration = v0;
        if (firDeclaration != null) {
            FirDeclaration it = firDeclaration;
            boolean bl = false;
            FirClassLikeDeclaration $this$isLocal$iv = regularClass;
            boolean $i$f$isLocal = false;
            irConstructor3 = Fir2IrDeclarationStorage.getOrCreateIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it, irClass2, null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), false, 20, null);
        } else {
            irConstructor3 = irConstructor2 = null;
        }
        if (irConstructor2 != null) {
            ((Collection)irClass2.getDeclarations()).add(irConstructor2);
        }
        for (FirDeclaration declaration : this.syntheticPropertiesLast(allDeclarations)) {
            IrDeclaration irDeclaration2;
            if (this.processMemberDeclaration(declaration, regularClass, irClass2) == null) continue;
            ((Collection)irClass2.getDeclarations()).add(irDeclaration2);
        }
        CollectionsKt.addAll((Collection)allDeclarations, (Iterable)this.delegatedMembers(irClass2));
        if (irConstructor2 != null && (irClass2.isValue() || irClass2.isData())) {
            this.getDeclarationStorage().enterScope(irConstructor2);
            DataClassMembersGenerator dataClassMembersGenerator = new DataClassMembersGenerator(this.components);
            if (IrDeclarationsKt.isSingleFieldValueClass(irClass2)) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)dataClassMembersGenerator.generateSingleFieldValueClassMembers(regularClass, irClass2));
            }
            if (IrDeclarationsKt.isMultiFieldValueClass(irClass2)) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)dataClassMembersGenerator.generateMultiFieldValueClassMembers(regularClass, irClass2));
            }
            if (irClass2.isData()) {
                CollectionsKt.addAll((Collection)allDeclarations, (Iterable)dataClassMembersGenerator.generateDataClassMembers(regularClass, irClass2));
            }
            this.getDeclarationStorage().leaveScope(irConstructor2);
        }
        FakeOverrideGenerator $this$processClassMembers_u24lambda_u248 = this.getFakeOverrideGenerator();
        boolean bl = false;
        $this$processClassMembers_u24lambda_u248.addFakeOverrides(irClass2, regularClass, allDeclarations);
        return irClass2;
    }

    public static /* synthetic */ IrClass processClassMembers$fir2ir$default(Fir2IrConverter fir2IrConverter, FirRegularClass firRegularClass, IrClass irClass2, int n, Object object) {
        if ((n & 2) != 0) {
            IrClass irClass3 = fir2IrConverter.getClassifierStorage().getCachedIrClass(firRegularClass);
            Intrinsics.checkNotNull((Object)irClass3);
            irClass2 = irClass3;
        }
        return fir2IrConverter.processClassMembers$fir2ir(firRegularClass, irClass2);
    }

    public final void bindFakeOverridesInFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (IrDeclaration irDeclaration2 : irFile.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    public final void bindFakeOverridesInClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.getFakeOverrideGenerator().bindOverriddenSymbols(klass.getDeclarations());
        this.getDelegatedMemberGenerator().bindDelegatedMembersOverriddenSymbols(klass);
        for (IrDeclaration irDeclaration2 : klass.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirDeclaration> delegatedMembers(IrClass irClass2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irClass2.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.DELEGATED_MEMBER.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.components.getDeclarationStorage().originalDeclarationForDelegated(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<FirDeclaration> syntheticPropertiesLast(List<? extends FirDeclaration> declarations2) {
        Iterable $this$sortedBy$iv = declarations2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            /*
             * Unable to fully structure code
             */
            public final int compare(T a, T b) {
                it = (FirDeclaration)a;
                $i$a$-sortedBy-Fir2IrConverter$syntheticPropertiesLast$1 = false;
                if (it instanceof FirField) ** GOTO lbl-1000
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                it = (FirDeclaration)b;
                var7_7 = Boolean.valueOf(v0);
                $i$a$-sortedBy-Fir2IrConverter$syntheticPropertiesLast$1 = false;
                if (it instanceof FirField) ** GOTO lbl-1000
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                return ComparisonsKt.compareValues((Comparable)var7_7, (Comparable)Boolean.valueOf(v1));
            }
        });
    }

    private final IrClass registerClassAndNestedClasses(FirRegularClass regularClass, IrDeclarationParent parent2) {
        IrClass irClass2;
        IrClass irClass3 = this.getClassifierStorage().getCachedIrClass(regularClass);
        if (irClass3 != null) {
            IrClass irClass4;
            IrClass $this$registerClassAndNestedClasses_u24lambda_u2412 = irClass4 = irClass3;
            boolean bl = false;
            $this$registerClassAndNestedClasses_u24lambda_u2412.setParent(parent2);
            irClass2 = irClass4;
        } else {
            irClass2 = Fir2IrClassifierStorage.registerIrClass$default(this.getClassifierStorage(), regularClass, parent2, null, 4, null);
        }
        IrClass irClass5 = irClass2;
        this.registerNestedClasses(regularClass, irClass5);
        return irClass5;
    }

    private final void registerNestedClasses(FirClass klass, IrClass irClass2) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirRegularClass)it, irClass2);
        }
        if (!((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers(klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.registerClassAndNestedClasses((FirRegularClass)it, irClass2);
            }
        }
    }

    private final void processClassAndNestedClassHeaders(FirRegularClass regularClass) {
        Fir2IrClassifierStorage.processClassHeader$default(this.getClassifierStorage(), regularClass, null, 2, null);
        this.processNestedClassHeaders(regularClass);
    }

    private final void processNestedClassHeaders(FirClass klass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.processClassAndNestedClassHeaders((FirRegularClass)it);
        }
        if (!((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers(klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.processClassAndNestedClassHeaders((FirRegularClass)it);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final IrDeclaration processMemberDeclaration(FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent) {
        if (containingClass == null) ** GOTO lbl-1000
        if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
        $this$isLocal$iv = containingClass;
        $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isLocal = v0;
        var5_4 = declaration;
        if (var5_4 instanceof FirRegularClass) {
            v1 = Fir2IrConverter.processClassMembers$fir2ir$default(this, (FirRegularClass)declaration, null, 2, null);
        } else if (var5_4 instanceof FirSimpleFunction) {
            v1 = Fir2IrDeclarationStorage.getOrCreateIrFunction$default(this.getDeclarationStorage(), (FirSimpleFunction)declaration, parent, isLocal, false, 8, null);
        } else if (var5_4 instanceof FirProperty) {
            v1 = Fir2IrDeclarationStorage.getOrCreateIrProperty$default(this.getDeclarationStorage(), (FirProperty)declaration, parent, isLocal, false, 8, null);
        } else if (var5_4 instanceof FirField) {
            $this$isSynthetic$iv = declaration;
            $i$f$isSynthetic = false;
            if (!Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) {
                throw new AssertionError((Object)("Unexpected non-synthetic field: " + Reflection.getOrCreateKotlinClass(declaration.getClass())));
            }
            v2 = this.getDeclarationStorage();
            v3 = (FirField)declaration;
            v4 = containingClass;
            Intrinsics.checkNotNull((Object)v4);
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v1 = v2.createIrFieldAndDelegatedMembers(v3, v4, (IrClass)parent);
        } else if (var5_4 instanceof FirConstructor) {
            if (!((FirConstructor)declaration).isPrimary()) {
                v5 = this.getDeclarationStorage();
                v6 = (FirConstructor)declaration;
                Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                v7 = Fir2IrDeclarationStorage.getOrCreateIrConstructor$default(v5, v6, (IrClass)parent, null, isLocal, false, 20, null);
            } else {
                v7 = null;
            }
            v1 = v7;
        } else if (var5_4 instanceof FirEnumEntry) {
            v8 = this.getClassifierStorage();
            v9 = (FirEnumEntry)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v1 = Fir2IrClassifierStorage.createIrEnumEntry$default(v8, v9, (IrClass)parent, null, false, 12, null);
        } else if (var5_4 instanceof FirAnonymousInitializer) {
            v10 = this.getDeclarationStorage();
            v11 = (FirAnonymousInitializer)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v1 = v10.createIrAnonymousInitializer(v11, (IrClass)parent);
        } else if (var5_4 instanceof FirTypeAlias) {
            v1 = null;
        } else {
            throw new IllegalStateException(("Unexpected member: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
        }
        return v1;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jr\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion;", "", "()V", "createModuleFragment", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "firFiles", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "signaturer", "Lorg/jetbrains/kotlin/ir/util/IdSignatureComposer;", "fir2IrExtensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "mangler", "Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "specialSymbolProvider", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSpecialSymbolProvider;", "irGenerationExtensions", "", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "evaluateConstants", "", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        private final void evaluateConstants(IrModuleFragment irModuleFragment) {
            IrInterpreter interpreter2 = new IrInterpreter(irModuleFragment.getIrBuiltins(), null, 2, null);
            Iterable $this$forEach$iv = irModuleFragment.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrFile it = (IrFile)element$iv;
                boolean bl = false;
                it.transformChildren(new IrConstTransformer(interpreter2, it, EvaluationMode.ONLY_BUILTINS, null, null, 24, null), null);
            }
        }

        @NotNull
        public final Fir2IrResult createModuleFragment(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull IdSignatureComposer signaturer, @NotNull Fir2IrExtensions fir2IrExtensions, @NotNull FirMangler mangler, @NotNull KotlinMangler.IrMangler irMangler, @NotNull IrFactory irFactory, @NotNull Fir2IrVisibilityConverter visibilityConverter, @NotNull Fir2IrSpecialSymbolProvider specialSymbolProvider, @NotNull Collection<? extends IrGenerationExtension> irGenerationExtensions) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)signaturer, (String)"signaturer");
            Intrinsics.checkNotNullParameter((Object)fir2IrExtensions, (String)"fir2IrExtensions");
            Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
            Intrinsics.checkNotNullParameter((Object)irMangler, (String)"irMangler");
            Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
            Intrinsics.checkNotNullParameter((Object)visibilityConverter, (String)"visibilityConverter");
            Intrinsics.checkNotNullParameter((Object)specialSymbolProvider, (String)"specialSymbolProvider");
            Intrinsics.checkNotNullParameter(irGenerationExtensions, (String)"irGenerationExtensions");
            FirModuleDescriptor moduleDescriptor = new FirModuleDescriptor(session2);
            FirBasedSignatureComposer signatureComposer = new FirBasedSignatureComposer(mangler);
            WrappedDescriptorSignatureComposer wrappedSignaturer = new WrappedDescriptorSignatureComposer(signaturer, signatureComposer);
            SymbolTable symbolTable = new SymbolTable(wrappedSignaturer, irFactory, null, 4, null);
            Fir2IrComponentsStorage components2 = new Fir2IrComponentsStorage(session2, scopeSession, symbolTable, irFactory, signatureComposer, fir2IrExtensions);
            Fir2IrConverter converter = new Fir2IrConverter(moduleDescriptor, components2);
            components2.setConverter(converter);
            Fir2IrClassifierStorage classifierStorage = new Fir2IrClassifierStorage(components2);
            components2.setClassifierStorage(classifierStorage);
            components2.setDelegatedMemberGenerator(new DelegatedMemberGenerator(components2));
            Fir2IrDeclarationStorage declarationStorage = new Fir2IrDeclarationStorage(components2, moduleDescriptor);
            components2.setDeclarationStorage(declarationStorage);
            components2.setVisibilityConverter(visibilityConverter);
            Fir2IrTypeConverter typeConverter = new Fir2IrTypeConverter(components2);
            components2.setTypeConverter(typeConverter);
            IrBuiltInsOverFir irBuiltIns = new IrBuiltInsOverFir(components2, languageVersionSettings, moduleDescriptor, irMangler, languageVersionSettings.getFlag(AnalysisFlags.getBuiltInsFromSources()));
            components2.setIrBuiltIns(irBuiltIns);
            Fir2IrConversionScope conversionScope = new Fir2IrConversionScope();
            Fir2IrVisitor fir2irVisitor = new Fir2IrVisitor(components2, conversionScope);
            Fir2IrBuiltIns builtIns = new Fir2IrBuiltIns(components2, specialSymbolProvider);
            AnnotationGenerator annotationGenerator = new AnnotationGenerator(components2);
            components2.setBuiltIns(builtIns);
            components2.setAnnotationGenerator(annotationGenerator);
            FakeOverrideGenerator fakeOverrideGenerator = new FakeOverrideGenerator(components2, conversionScope);
            components2.setFakeOverrideGenerator(fakeOverrideGenerator);
            CallAndReferenceGenerator callGenerator = new CallAndReferenceGenerator(components2, fir2irVisitor, conversionScope);
            components2.setCallGenerator(callGenerator);
            FirIrProvider irProvider = new FirIrProvider(components2);
            components2.setIrProviders(CollectionsKt.listOf((Object)irProvider));
            fir2IrExtensions.registerDeclarations(symbolTable);
            IrModuleFragmentImpl irModuleFragment = new IrModuleFragmentImpl(moduleDescriptor, irBuiltIns, null, 4, null);
            List $this$createModuleFragment_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createModuleFragment_u24lambda_u241.addAll((Collection)firFiles);
            $this$createModuleFragment_u24lambda_u241.addAll((Collection)ConversionUtilsKt.createFilesWithGeneratedDeclarations(session2));
            List allFirFiles = CollectionsKt.build((List)list2);
            converter.runSourcesConversion(allFirFiles, irModuleFragment, irGenerationExtensions, fir2irVisitor, fir2IrExtensions);
            return new Fir2IrResult(irModuleFragment, components2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

