/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SAMInfo;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentTypeMismatch;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSinkKt;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.NullForNotNullType;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.calls.UnstableSmartCast;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableTypeConstructor;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a \u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aR\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u0005*\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0012\u0010\u001f\u001a\u00020\u0005*\u00020\u00122\u0006\u0010 \u001a\u00020!\u001a6\u0010\"\u001a\u0004\u0018\u00010\u0005*\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u001c\u0010$\u001a\u00020\u0017*\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020'H\u0002\u001a,\u0010(\u001a\u00020\u0017*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020+\u001a\u001a\u0010,\u001a\u00020\u0005*\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c\u001a@\u0010-\u001a\u0004\u0018\u00010\u0005*\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a>\u00100\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001aN\u00101\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u001aP\u00104\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00105\u001a\u0002062\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u001aV\u00107\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u00108\u001a\u00020\u0017\u001aN\u00109\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u00108\u001a\u00020\u0017\u001aN\u0010:\u001a\u00020\u000e*\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020;2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u00108\u001a\u00020\u0017\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006<"}, d2={"SAM_LOOKUP_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getSAM_LOOKUP_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "argumentTypeWithSuspendConversion", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "expectedType", "argumentType", "captureFromTypeParameterUpperBoundIfNeeded", "checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "argumentTypeBeforeCapturing", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "isDispatch", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "captureTypeFromExpressionOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getExpectedType", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "candidateExpectedType", "hasSupertypeWithGivenClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "isFunctional", "expectedFunctionType", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "prepareCapturedType", "prepareExpectedType", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "resolveArgument", "resolveArgumentExpression", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "useNullableArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "resolve"})
public final class ArgumentsKt {
    @NotNull
    private static final Name SAM_LOOKUP_NAME;

    @NotNull
    public static final Name getSAM_LOOKUP_NAME() {
        return SAM_LOOKUP_NAME;
    }

    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @Nullable ConeKotlinType expectedType, @Nullable FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgumentExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FirExpression firExpression2 = argument2;
        if ((((firExpression2 instanceof FirFunctionCall ? true : firExpression2 instanceof FirWhenExpression) ? true : firExpression2 instanceof FirTryExpression) ? true : firExpression2 instanceof FirCheckNotNullCall) ? true : firExpression2 instanceof FirElvisExpression) {
            ArgumentsKt.resolveSubCallArgument$default($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument2), expectedType, sink, context, isReceiver, isDispatch, false, 128, null);
        } else if (firExpression2 instanceof FirSafeCallExpression) {
            FirStatement nestedQualifier = ((FirSafeCallExpression)argument2).getSelector();
            if (nestedQualifier instanceof FirQualifiedAccessExpression) {
                ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)nestedQualifier), expectedType, sink, context, isReceiver, isDispatch, true);
            } else {
                boolean $i$f$emptyArray = false;
                ConeKotlinType coneKotlinType = expectedType;
                ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argument2, TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getUnit(), (ConeTypeProjection[])((Object[])new ConeTypeProjection[0]), false, null, 4, null), coneKotlinType != null ? coneKotlinType.getType() : null, SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context);
            }
        } else if (firExpression2 instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument2).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument2, expectedType, sink, context, isReceiver, isDispatch, false, 128, null);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument2, expectedType, context);
            }
        } else if (firExpression2 instanceof FirAnonymousFunctionExpression) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunctionExpression)argument2, expectedType, expectedTypeRef, context, sink, false, null, 192, null);
        } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument2).getExpression(), expectedType, expectedTypeRef, sink, context, isReceiver, isDispatch);
        } else if (firExpression2 instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument2, expectedType, expectedTypeRef, sink, context, isReceiver, isDispatch);
        } else {
            ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument2, expectedType, sink, context, isReceiver, isDispatch, false, 128, null);
        }
    }

    private static final void resolveBlockArgument(Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType, FirTypeRef expectedTypeRef, CheckerSink sink, ResolutionContext context, boolean isReceiver, boolean isDispatch) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            ConeKotlinType coneKotlinType = expectedType;
            ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, block, FirTypeUtilsKt.getConeType(block.getTypeRef()), coneKotlinType != null ? coneKotlinType.getType() : null, SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context);
            return;
        }
        for (FirExpression argument2 : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument2, expectedType, expectedTypeRef, sink, context, isReceiver, isDispatch);
        }
    }

    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument2, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveSubCallArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(argument2 instanceof FirExpression)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Candidate candidate2 = CandidateFactoryKt.candidate(argument2);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument2), expectedType, sink, context, isReceiver, isDispatch, useNullableArgumentType);
            return;
        }
        Candidate candidate3 = candidate2;
        ReturnTypeCalculator returnTypeCalculator = context.getReturnTypeCalculator();
        Object obj = candidate3.getSymbol().getFir();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration");
        ConeKotlinType type2 = returnTypeCalculator.tryCalculateReturnType((FirCallableDeclaration)obj).getType();
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument2), argumentType, expectedType, sink, context, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolveSubCallArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirResolvable firResolvable, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolveSubCallArgument(candidate2, constraintSystemBuilder, firResolvable, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainExpressionArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (expectedType == null) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = argument2.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType argumentType = coneKotlinType;
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, argument2, argumentType, expectedType, sink, context, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolvePlainExpressionArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression2, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainExpressionArgument(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @NotNull ConeKotlinType argumentType, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainArgumentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        FirSession session2 = context.getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType($this$resolvePlainArgumentType, argumentType, context);
        ConeKotlinType argumentTypeForApplicabilityCheck = null;
        ConeKotlinType coneKotlinType2 = argumentTypeForApplicabilityCheck = useNullableArgumentType ? TypeUtilsKt.withNullability$default(capturedType, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(session2), null, 4, null) : capturedType;
        if (expectedType != null && (coneKotlinType = ArgumentsKt.argumentTypeWithSuspendConversion(session2, context.getBodyResolveComponents().getScopeSession(), expectedType, argumentTypeForApplicabilityCheck)) != null) {
            ConeKotlinType it = coneKotlinType;
            boolean bl = false;
            argumentTypeForApplicabilityCheck = it;
            $this$resolvePlainArgumentType.getSubstitutor().substituteOrSelf(argumentTypeForApplicabilityCheck);
            $this$resolvePlainArgumentType.setUsesSuspendConversion(true);
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argument2, argumentTypeForApplicabilityCheck, expectedType, position, isReceiver, isDispatch, sink, context);
    }

    public static /* synthetic */ void resolvePlainArgumentType$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression2, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainArgumentType(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType, coneKotlinType2, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType argumentTypeWithSuspendConversion(FirSession session2, ScopeSession scopeSession, ConeKotlinType expectedType, ConeKotlinType argumentType) {
        ConeLookupTagBasedType coneLookupTagBasedType;
        FirFunctionSymbol<?> firFunctionSymbol;
        if (!InferenceUtilsKt.isSuspendFunctionType(expectedType, session2)) {
            return null;
        }
        ConeClassLikeType expectedFunctionalType = InferenceUtilsKt.suspendFunctionTypeToFunctionType(expectedType, session2);
        ConeKotlinType argumentTypeWithInvoke = InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(argumentType, session2, expectedFunctionalType);
        if (argumentTypeWithInvoke != null && (firFunctionSymbol = InferenceUtilsKt.findContributedInvokeSymbol(argumentTypeWithInvoke, session2, scopeSession, expectedFunctionalType, false)) != null) {
            void $this$mapTo$iv$iv;
            FirFunctionSymbol<?> invokeSymbol2 = firFunctionSymbol;
            boolean bl = false;
            Iterable $this$map$iv = ((FirFunction)invokeSymbol2.getFir()).getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()));
            }
            coneLookupTagBasedType = ResolveUtilsKt.createFunctionalType$default((List)destination$iv$iv, null, FirTypeUtilsKt.getConeType(((FirFunction)invokeSymbol2.getFir()).getReturnTypeRef()), true, null, InferenceUtilsKt.isKFunctionType(argumentType, session2), 16, null);
        } else {
            coneLookupTagBasedType = null;
        }
        return coneLookupTagBasedType;
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull Candidate $this$prepareCapturedType, @NotNull ConeKotlinType argumentType, @NotNull ResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareCapturedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConeKotlinType coneKotlinType = ArgumentsKt.captureTypeFromExpressionOrNull($this$prepareCapturedType, argumentType, context);
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType captureTypeFromExpressionOrNull(Candidate $this$captureTypeFromExpressionOrNull, ConeKotlinType argumentType, ResolutionContext context) {
        if (argumentType instanceof ConeFlexibleType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, ((ConeFlexibleType)argumentType).getLowerBound(), context);
        }
        if (argumentType instanceof ConeIntersectionType) {
            ConeKotlinType coneKotlinType;
            ConeKotlinType $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ConeIntersectionType)argumentType).getIntersectedTypes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ConeKotlinType coneKotlinType2 = (ConeKotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType3 = ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, (ConeKotlinType)it, context);
                if (coneKotlinType3 == null) {
                    coneKotlinType3 = it;
                }
                collection.add(coneKotlinType3);
            }
            List intersectedTypes = (List)destination$iv$iv;
            if (Intrinsics.areEqual((Object)intersectedTypes, ((ConeIntersectionType)argumentType).getIntersectedTypes())) {
                return null;
            }
            Collection collection = intersectedTypes;
            ConeKotlinType coneKotlinType4 = ((ConeIntersectionType)argumentType).getAlternativeType();
            if (coneKotlinType4 != null) {
                void it;
                $this$mapTo$iv$iv = coneKotlinType4;
                Collection collection2 = collection;
                boolean bl = false;
                ConeKotlinType coneKotlinType5 = ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, (ConeKotlinType)it, context);
                if (coneKotlinType5 == null) {
                    coneKotlinType5 = it;
                }
                coneKotlinType = coneKotlinType5;
                collection = collection2;
            } else {
                coneKotlinType = null;
            }
            ConeKotlinType coneKotlinType6 = coneKotlinType;
            Collection collection3 = collection;
            return new ConeIntersectionType(collection3, coneKotlinType6);
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        ConeClassLikeType it = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)argumentType, context.getSession(), null, 2, null);
        boolean bl = false;
        if (it != argumentType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, it, context);
        }
        if (argumentType.getTypeArguments().length == 0) {
            return null;
        }
        SimpleTypeMarker simpleTypeMarker = TypeComponentsKt.getTypeContext(context.getSession()).captureFromArguments((SimpleTypeMarker)((Object)argumentType), CaptureStatus.FROM_EXPRESSION);
        return simpleTypeMarker instanceof ConeKotlinType ? (ConeKotlinType)((Object)simpleTypeMarker) : null;
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, FirExpression argument2, ConeKotlinType argumentTypeBeforeCapturing, ConeKotlinType expectedType, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, boolean isDispatch, CheckerSink sink, ResolutionContext context) {
        if (expectedType == null) {
            return;
        }
        ConeKotlinType argumentType = ArgumentsKt.captureFromTypeParameterUpperBoundIfNeeded(argumentTypeBeforeCapturing, expectedType, context.getSession());
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportDiagnostic(new InapplicableWrongReceiver(expectedType, argumentType));
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            ConeKotlinType unstableType;
            FirExpressionWithSmartcast smartcastExpression;
            FirExpressionWithSmartcast firExpressionWithSmartcast = smartcastExpression = argument2 instanceof FirExpressionWithSmartcast ? (FirExpressionWithSmartcast)argument2 : null;
            if (smartcastExpression != null && !smartcastExpression.isStable() && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType = FirTypeUtilsKt.getConeType(smartcastExpression.getSmartcastType()), expectedType, position)) {
                sink.reportDiagnostic(new UnstableSmartCast(smartcastExpression, expectedType, InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context.getSession()), argumentType, expectedType)));
                return;
            }
            if (!isReceiver) {
                CheckerSinkKt.reportDiagnosticIfNotNull(sink, ArgumentsKt.checkApplicabilityForArgumentType$subtypeError(argument2, argumentType, context, csBuilder, expectedType));
                return;
            }
            ConeKotlinType nullableExpectedType = TypeUtilsKt.withNullability$default(expectedType, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(context.getSession()), null, 4, null);
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportDiagnostic(new UnsafeCall(argumentType));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                sink.reportDiagnostic(new InapplicableWrongReceiver(expectedType, argumentType));
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull CallInfo callInfo, @NotNull FirExpression argument2, @Nullable FirValueParameter parameter, boolean isReceiver, @NotNull CheckerSink sink, @NotNull ResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FirExpression $this$resultType$iv = argument2;
        boolean $i$f$getResultType = false;
        PhaseUtilsKt.ensureResolvedTypeDeclaration$default($this$resultType$iv.getTypeRef(), context.getSession(), null, 2, null);
        ConeKotlinType expectedType = ArgumentsKt.prepareExpectedType($this$resolveArgument, context.getSession(), context.getBodyResolveComponents().getScopeSession(), callInfo, argument2, parameter, context);
        FirValueParameter firValueParameter = parameter;
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument2, expectedType, firValueParameter != null ? firValueParameter.getReturnTypeRef() : null, sink, context, isReceiver, false);
    }

    private static final ConeKotlinType prepareExpectedType(Candidate $this$prepareExpectedType, FirSession session2, ScopeSession scopeSession, CallInfo callInfo, FirExpression argument2, FirValueParameter parameter, ResolutionContext context) {
        ConeKotlinType coneKotlinType;
        if (parameter == null) {
            return null;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedType(argument2, parameter);
        ConeKotlinType coneKotlinType2 = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session2, scopeSession, argument2, basicExpectedType, context);
        if (coneKotlinType2 != null) {
            ConeKotlinType coneKotlinType3;
            ConeKotlinType it = coneKotlinType3 = coneKotlinType2;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(session2);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponent lookupTracker = firLookupTrackerComponent;
                boolean bl2 = false;
                ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())));
                if (classId != null) {
                    ClassId classId2;
                    ClassId it2 = classId2 = classId;
                    boolean bl3 = false;
                    classId = !it2.isLocal() ? classId2 : null;
                    if (classId != null) {
                        ClassId classId3 = classId;
                        boolean bl4 = false;
                        String string2 = classId3.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.asString()");
                        lookupTracker.recordLookup(SAM_LOOKUP_NAME, string2, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                        Name name = classId3.getShortClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
                        String string3 = classId3.getPackageFqName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classId.packageFqName.asString()");
                        lookupTracker.recordLookup(name, string3, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                    }
                }
            }
            coneKotlinType = coneKotlinType3;
        } else {
            coneKotlinType = basicExpectedType;
        }
        ConeKotlinType expectedType = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(Candidate $this$getExpectedTypeWithSAMConversion, FirSession session2, ScopeSession scopeSession, FirExpression argument2, ConeKotlinType candidateExpectedType, ResolutionContext context) {
        ConeKotlinType coneKotlinType;
        if (InferenceUtilsKt.isBuiltinFunctionalType(candidateExpectedType, session2)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        FirFunction firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction firFunction2 = firFunction;
        if (!context.getBodyResolveComponents().getSamResolver().shouldRunSamConversionForFunction(firFunction2)) {
            return null;
        }
        SAMInfo<ConeKotlinType> sAMInfo = context.getBodyResolveComponents().getSamResolver().getSamInfoForPossibleSamType(candidateExpectedType);
        if (sAMInfo == null) {
            return null;
        }
        ConeKotlinType expectedFunctionType = sAMInfo.component2();
        boolean condition$iv = ArgumentsKt.isFunctional(argument2, session2, scopeSession, expectedFunctionType, context.getReturnTypeCalculator());
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            $this$getExpectedTypeWithSAMConversion.setUsesSAM(true);
            coneKotlinType = expectedFunctionType;
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isFunctional(@NotNull FirExpression $this$isFunctional, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @Nullable ConeKotlinType expectedFunctionType, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        boolean bl;
        block11: {
            boolean returnTypeCompatible;
            ConeClassLikeType classLikeExpectedFunctionType;
            Intrinsics.checkNotNullParameter((Object)$this$isFunctional, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter((Object)returnTypeCalculator, (String)"returnTypeCalculator");
            FirExpression firExpression2 = FirExpressionUtilKt.unwrapArgument($this$isFunctional);
            if (firExpression2 instanceof FirAnonymousFunctionExpression ? true : firExpression2 instanceof FirCallableReferenceAccess) {
                return true;
            }
            Object $this$coneTypeSafe$iv = $this$isFunctional.getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            if (coneKotlinType == null) {
                return false;
            }
            ConeKotlinType coneType = coneKotlinType;
            if (InferenceUtilsKt.isBuiltinFunctionalType(coneType, session2)) {
                return true;
            }
            ConeKotlinType coneKotlinType2 = expectedFunctionType;
            $this$coneTypeSafe$iv = coneKotlinType2 != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType2) : null;
            ConeClassLikeType coneClassLikeType = classLikeExpectedFunctionType = $this$coneTypeSafe$iv instanceof ConeClassLikeType ? (ConeClassLikeType)$this$coneTypeSafe$iv : null;
            if (classLikeExpectedFunctionType == null || coneType instanceof ConeIntegerLiteralType) {
                return false;
            }
            FirFunctionSymbol<?> firFunctionSymbol = InferenceUtilsKt.findContributedInvokeSymbol(coneType, session2, scopeSession, classLikeExpectedFunctionType, false);
            if (firFunctionSymbol == null) {
                return false;
            }
            FirFunctionSymbol<?> invokeSymbol2 = firFunctionSymbol;
            ConeSimpleKotlinType expectedReturnType = ConeTypeUtilsKt.lowerBoundIfFlexible(InferenceUtilsKt.returnType(classLikeExpectedFunctionType, session2));
            boolean bl2 = returnTypeCompatible = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(expectedReturnType) instanceof ConeTypeParameterType || AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(session2).newTypeCheckerState(false, true), (KotlinTypeMarker)returnTypeCalculator.tryCalculateReturnType((FirCallableDeclaration)invokeSymbol2.getFir()).getType(), (KotlinTypeMarker)expectedReturnType, false);
            if (!returnTypeCompatible) {
                return false;
            }
            if (((FirFunction)invokeSymbol2.getFir()).getValueParameters().size() != classLikeExpectedFunctionType.getTypeArguments().length - 1) {
                return false;
            }
            List parameterPairs = CollectionsKt.zip((Iterable)((FirFunction)invokeSymbol2.getFir()).getValueParameters(), (Iterable)InferenceUtilsKt.valueParameterTypesIncludingReceiver(classLikeExpectedFunctionType, session2));
            Iterable $this$all$iv = parameterPairs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl3 = false;
                    FirValueParameter invokeParameter = (FirValueParameter)pair.component1();
                    ConeKotlinType expectedParameter = (ConeKotlinType)pair.component2();
                    ConeSimpleKotlinType expectedParameterType = ConeTypeUtilsKt.lowerBoundIfFlexible(expectedParameter);
                    if (ConeTypeUtilsKt.originalIfDefinitelyNotNullable(expectedParameterType) instanceof ConeTypeParameterType || AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(session2).newTypeCheckerState(false, true), (KotlinTypeMarker)FirTypeUtilsKt.getConeType(invokeParameter.getReturnTypeRef()), (KotlinTypeMarker)expectedParameterType, false)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        FirExpression firExpression2 = $this$getExpectedType;
        boolean shouldUnwrapVarargType = (firExpression2 instanceof FirSpreadArgumentExpression ? true : firExpression2 instanceof FirNamedArgumentExpression) ? false : parameter.isVararg();
        return shouldUnwrapVarargType ? ArrayUtilsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull FirSession session2) {
        ConeKotlinType coneKotlinType;
        Object v2;
        ConeInferenceContext context;
        block9: {
            void $this$singleOrNull$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.upperBoundIfFlexible(expectedType));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeSimpleKotlinType coneSimpleKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            FirTypeParameter typeParameter = (FirTypeParameter)simplifiedArgumentType.getLookupTag().getTypeParameterSymbol().getFir();
            context = TypeComponentsKt.getTypeContext(session2);
            Iterable $this$map$iv = typeParameter.getSymbol().getResolvedBounds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                if (!ArgumentsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context)) continue;
                if (found$iv) {
                    v2 = null;
                    break block9;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeKotlinType coneKotlinType2 = v2;
        if (coneKotlinType2 == null) {
            return argumentType;
        }
        ConeKotlinType chosenSupertype = coneKotlinType2;
        ConeKotlinType coneKotlinType3 = (ConeKotlinType)context.captureFromExpression(chosenSupertype);
        if (coneKotlinType3 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType3;
        if (argumentType instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, TypeComponentsKt.getTypeContext(session2), false, 4, null);
            coneKotlinType = coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : capturedType;
        } else {
            coneKotlinType = capturedType;
        }
        return coneKotlinType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context) {
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u2415 = context;
        boolean bl = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u2415.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super SimpleTypeMarker, Boolean>)((Function1)new Function1<SimpleTypeMarker, Boolean>($this$hasSupertypeWithGivenClassId_u24lambda_u2415, classId){
            final /* synthetic */ TypeSystemCommonSuperTypesContext $this_with;
            final /* synthetic */ ClassId $classId;
            {
                this.$this_with = $receiver;
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SimpleTypeMarker it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TypeConstructorMarker typeConstructor2 = this.$this_with.typeConstructor(it);
                return typeConstructor2 instanceof ConeClassLikeLookupTag && Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)typeConstructor2).getClassId(), (Object)this.$classId);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType(ConstraintSystemBuilder $csBuilder, ResolutionContext $context, ConeKotlinType type2) {
        if (type2 instanceof ConeTypeVariableType) {
            ConeTypeParameterLookupTag originalTypeParameter;
            List constraintTypes;
            List list2;
            List<Constraint> constraints;
            ConeTypeVariableTypeConstructor lookupTag2 = ((ConeTypeVariableType)type2).getLookupTag();
            Intrinsics.checkNotNull((Object)$csBuilder, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder.Context");
            VariableWithConstraints variableWithConstraints = ((VariableFixationFinder.Context)((Object)$csBuilder)).getNotFixedTypeVariables().get(lookupTag2);
            List<Constraint> list3 = constraints = variableWithConstraints != null ? variableWithConstraints.getConstraints() : null;
            if (list3 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list3;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ConeKotlinType it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    Constraint it = (Constraint)element$iv$iv;
                    boolean bl2 = false;
                    KotlinTypeMarker kotlinTypeMarker = it.getType();
                    if ((kotlinTypeMarker instanceof ConeKotlinType ? (ConeKotlinType)kotlinTypeMarker : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = constraintTypes = null;
            }
            if (constraintTypes != null && !((Collection)constraintTypes).isEmpty()) {
                return ConeTypeIntersector.INSTANCE.intersectTypes(TypeComponentsKt.getTypeContext($context.getSession()), constraintTypes);
            }
            ConeTypeVariableTypeConstructor coneTypeVariableTypeConstructor = lookupTag2 instanceof ConeTypeVariableTypeConstructor ? lookupTag2 : null;
            TypeParameterMarker typeParameterMarker = coneTypeVariableTypeConstructor != null ? coneTypeVariableTypeConstructor.getOriginalTypeParameter() : null;
            ConeTypeParameterLookupTag coneTypeParameterLookupTag = originalTypeParameter = typeParameterMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeParameterMarker : null;
            if (originalTypeParameter != null) {
                return new ConeTypeParameterTypeImpl(originalTypeParameter, ConeTypeUtilsKt.isNullable(type2), type2.getAttributes());
            }
        } else if (type2 instanceof ConeIntegerLiteralType) {
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)CollectionsKt.firstOrNull((Iterable)((ConeIntegerLiteralType)type2).getPossibleTypes());
            return coneClassLikeType != null ? (ConeKotlinType)coneClassLikeType : type2;
        }
        return type2;
    }

    private static final ResolutionDiagnostic checkApplicabilityForArgumentType$subtypeError(FirExpression $argument, ConeKotlinType argumentType, ResolutionContext $context, ConstraintSystemBuilder $csBuilder, ConeKotlinType actualExpectedType) {
        if (FirTypeUtilsKt.isNullLiteral($argument) && actualExpectedType.getNullability() == ConeNullability.NOT_NULL) {
            return new NullForNotNullType($argument);
        }
        return new ArgumentTypeMismatch(ArgumentsKt.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($csBuilder, $context, actualExpectedType), ArgumentsKt.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($csBuilder, $context, argumentType), $argument, InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext($context.getSession()), argumentType, actualExpectedType));
    }

    static {
        Name name = Name.special("<SAM-CONSTRUCTOR>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<SAM-CONSTRUCTOR>\")");
        SAM_LOOKUP_NAME = name;
    }
}

