/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.KotlinClassInfo;
import org.jetbrains.kotlin.incremental.PackagePartProtoData;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.classpathDiff.BasicClassInfo;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassFileWithContents;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshotGranularity;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotterKt;
import org.jetbrains.kotlin.incremental.classpathDiff.InaccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaClassSnapshotter;
import org.jetbrains.kotlin.incremental.classpathDiff.KotlinClassInfoExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.KotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.MultifileClassKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.PackageFacadeKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.RegularKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshotter;", "", "()V", "findInaccessibleClasses", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/BasicClassInfo;", "classesInfo", "", "snapshot", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshot;", "classes", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassFileWithContents;", "granularity", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshotGranularity;", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "snapshotKotlinClass", "Lorg/jetbrains/kotlin/incremental/classpathDiff/KotlinClassSnapshot;", "classFile", "incremental-compilation-impl"})
public final class ClassSnapshotter {
    @NotNull
    public static final ClassSnapshotter INSTANCE = new ClassSnapshotter();

    private ClassSnapshotter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassSnapshot> snapshot(@NotNull List<ClassFileWithContents> classes2, @NotNull ClassSnapshotGranularity granularity, @NotNull BuildMetricsReporter metrics) {
        void $this$mapTo$iv$iv;
        Set<BasicClassInfo> $i$f$map2;
        void $this$measure$iv;
        Object object;
        void $this$measure$iv2;
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)((Object)granularity), (String)"granularity");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        BuildMetricsReporter buildMetricsReporter = metrics;
        Object time$iv = BuildTime.READ_CLASSES_BASIC_INFO;
        boolean $i$f$measure = false;
        $this$measure$iv2.startMeasure((BuildTime)time$iv);
        try {
            void $this$mapTo$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv = classes2;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                ClassFileWithContents classFileWithContents = (ClassFileWithContents)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getClassInfo());
            }
            object = (List)destination$iv$iv;
        }
        finally {
            $this$measure$iv2.endMeasure((BuildTime)time$iv);
        }
        List classesInfo = object;
        time$iv = metrics;
        BuildTime time$iv2 = BuildTime.FIND_INACCESSIBLE_CLASSES;
        boolean $i$f$measure22 = false;
        $this$measure$iv.startMeasure(time$iv2);
        try {
            boolean bl = false;
            $i$f$map2 = INSTANCE.findInaccessibleClasses(classesInfo);
        }
        finally {
            $this$measure$iv.endMeasure(time$iv2);
        }
        Set<BasicClassInfo> inaccessibleClassesInfo = $i$f$map2;
        Iterable $this$map$iv = classes2;
        boolean $i$f$map3 = false;
        Iterable $i$f$measure22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BuildMetricsReporter $this$measure$iv3;
            boolean $i$f$measure3;
            BuildTime time$iv3;
            ClassSnapshot classSnapshot;
            void it;
            ClassFileWithContents $i$f$mapTo2 = (ClassFileWithContents)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (inaccessibleClassesInfo.contains(it.getClassInfo())) {
                classSnapshot = InaccessibleClassSnapshot.INSTANCE;
            } else if (it.getClassInfo().isKotlinClass()) {
                Object item$iv$iv2;
                item$iv$iv2 = metrics;
                time$iv3 = BuildTime.SNAPSHOT_KOTLIN_CLASSES;
                $i$f$measure3 = false;
                $this$measure$iv3.startMeasure(time$iv3);
                try {
                    boolean bl3 = false;
                    object = INSTANCE.snapshotKotlinClass((ClassFileWithContents)it, granularity);
                }
                finally {
                    $this$measure$iv3.endMeasure(time$iv3);
                }
                classSnapshot = (ClassSnapshot)object;
            } else {
                $this$measure$iv3 = metrics;
                time$iv3 = BuildTime.SNAPSHOT_JAVA_CLASSES;
                $i$f$measure3 = false;
                $this$measure$iv3.startMeasure(time$iv3);
                try {
                    boolean bl4 = false;
                    object = JavaClassSnapshotter.INSTANCE.snapshot((ClassFileWithContents)it, granularity);
                }
                finally {
                    $this$measure$iv3.endMeasure(time$iv3);
                }
                classSnapshot = (ClassSnapshot)object;
            }
            collection.add(classSnapshot);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List snapshot$default(ClassSnapshotter classSnapshotter, List list2, ClassSnapshotGranularity classSnapshotGranularity, BuildMetricsReporter buildMetricsReporter, int n, Object object) {
        if ((n & 2) != 0) {
            classSnapshotGranularity = ClassSnapshotGranularity.CLASS_MEMBER_LEVEL;
        }
        if ((n & 4) != 0) {
            buildMetricsReporter = DoNothingBuildMetricsReporter.INSTANCE;
        }
        return classSnapshotter.snapshot(list2, classSnapshotGranularity, buildMetricsReporter);
    }

    private final KotlinClassSnapshot snapshotKotlinClass(ClassFileWithContents classFile, ClassSnapshotGranularity granularity) {
        KotlinClassSnapshot kotlinClassSnapshot;
        KotlinClassInfo kotlinClassInfo;
        ClassId classId = classFile.getClassInfo().getClassId();
        KotlinClassHeader kotlinClassHeader = classFile.getClassInfo().getKotlinClassHeader();
        Intrinsics.checkNotNull((Object)kotlinClassHeader);
        KotlinClassInfo kotlinClassInfo2 = KotlinClassInfo.Companion.createFrom(classId, kotlinClassHeader, classFile.getContents());
        ClassId classId2 = kotlinClassInfo2.getClassId();
        long classAbiHash = ClasspathSnapshotterKt.hashToLong(ExternalizersKt.toByteArray(KotlinClassInfoExternalizer.INSTANCE, kotlinClassInfo2));
        KotlinClassInfo it = kotlinClassInfo = kotlinClassInfo2;
        boolean bl = false;
        KotlinClassInfo classMemberLevelSnapshot = granularity == ClassSnapshotGranularity.CLASS_MEMBER_LEVEL ? kotlinClassInfo : null;
        switch (WhenMappings.$EnumSwitchMapping$0[kotlinClassInfo2.getClassKind().ordinal()]) {
            case 1: {
                kotlinClassSnapshot = new RegularKotlinClassSnapshot(classId2, classAbiHash, classMemberLevelSnapshot, classFile.getClassInfo().getSupertypes());
                break;
            }
            case 2: 
            case 3: {
                ProtoData protoData2 = kotlinClassInfo2.getProtoData();
                Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.PackagePartProtoData");
                kotlinClassSnapshot = new PackageFacadeKotlinClassSnapshot(classId2, classAbiHash, classMemberLevelSnapshot, ChangesCollector.Companion.getNonPrivateMemberNames((PackagePartProtoData)protoData2));
                break;
            }
            case 4: {
                Set<String> set = kotlinClassInfo2.getConstantsMap().keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"kotlinClassInfo.constantsMap.keys");
                kotlinClassSnapshot = new MultifileClassKotlinClassSnapshot(classId2, classAbiHash, classMemberLevelSnapshot, set);
                break;
            }
            case 5: {
                throw new IllegalStateException(("Unexpected class " + classId2 + " with class kind " + KotlinClassHeader.Kind.SYNTHETIC_CLASS.name() + " (synthetic classes should have been removed earlier)").toString());
            }
            case 6: {
                throw new IllegalStateException(("Can't handle class " + classId2 + " with class kind " + KotlinClassHeader.Kind.UNKNOWN.name()).toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kotlinClassSnapshot;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<BasicClassInfo> findInaccessibleClasses(List<BasicClassInfo> classesInfo) {
        void destination$iv;
        void $this$filterTo$iv;
        void $this$associateByTo$iv$iv;
        Map classIsInaccessible = new HashMap(classesInfo.size());
        Iterable $this$associateBy$iv = classesInfo;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            BasicClassInfo basicClassInfo = (BasicClassInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getClassId(), element$iv$iv);
        }
        Map classIdToClassInfo = destination$iv$iv;
        $this$associateBy$iv = classesInfo;
        Collection $i$f$associateBy22 = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            BasicClassInfo it = (BasicClassInfo)element$iv;
            boolean bl = false;
            if (!ClassSnapshotter.findInaccessibleClasses$isTransitivelyInaccessible(it, classIsInaccessible, classIdToClassInfo)) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    private static final boolean findInaccessibleClasses$isInaccessible(BasicClassInfo $this$findInaccessibleClasses_u24isInaccessible) {
        boolean bl;
        if ($this$findInaccessibleClasses_u24isInaccessible.isKotlinClass()) {
            KotlinClassHeader kotlinClassHeader = $this$findInaccessibleClasses_u24isInaccessible.getKotlinClassHeader();
            Intrinsics.checkNotNull((Object)kotlinClassHeader);
            switch (WhenMappings.$EnumSwitchMapping$0[kotlinClassHeader.getKind().ordinal()]) {
                case 1: {
                    if ($this$findInaccessibleClasses_u24isInaccessible.isPrivate() || $this$findInaccessibleClasses_u24isInaccessible.isLocal() || $this$findInaccessibleClasses_u24isInaccessible.isAnonymous() || $this$findInaccessibleClasses_u24isInaccessible.isSynthetic()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 5: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        } else {
            bl = $this$findInaccessibleClasses_u24isInaccessible.isPrivate() || $this$findInaccessibleClasses_u24isInaccessible.isLocal() || $this$findInaccessibleClasses_u24isInaccessible.isAnonymous() || $this$findInaccessibleClasses_u24isInaccessible.isSynthetic();
        }
        return bl;
    }

    private static final boolean findInaccessibleClasses$isTransitivelyInaccessible(BasicClassInfo $this$findInaccessibleClasses_u24isTransitivelyInaccessible, Map<BasicClassInfo, Boolean> classIsInaccessible, Map<ClassId, BasicClassInfo> classIdToClassInfo) {
        boolean inaccessible;
        boolean bl;
        boolean bl2;
        Boolean bl3 = classIsInaccessible.get($this$findInaccessibleClasses_u24isTransitivelyInaccessible);
        if (bl3 != null) {
            boolean it = bl3;
            boolean bl4 = false;
            return it;
        }
        if (ClassSnapshotter.findInaccessibleClasses$isInaccessible($this$findInaccessibleClasses_u24isTransitivelyInaccessible)) {
            bl2 = true;
        } else {
            ClassId classId = $this$findInaccessibleClasses_u24isTransitivelyInaccessible.getClassId().getOuterClassId();
            if (classId != null) {
                ClassId outerClassId = classId;
                boolean bl5 = false;
                BasicClassInfo basicClassInfo = classIdToClassInfo.get(outerClassId);
                bl2 = basicClassInfo != null ? ClassSnapshotter.findInaccessibleClasses$isTransitivelyInaccessible(basicClassInfo, classIsInaccessible, classIdToClassInfo) : false;
            } else {
                bl2 = false;
            }
        }
        boolean it = bl = (inaccessible = bl2);
        boolean bl6 = false;
        Boolean bl7 = inaccessible;
        classIsInaccessible.put($this$findInaccessibleClasses_u24isTransitivelyInaccessible, bl7);
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.SYNTHETIC_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

