/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R$\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "value", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getField", "symbol", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "toString", "", "Companion", "ir.interpreter"})
public final class Primitive<T>
implements State {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final T value;
    @NotNull
    private final IrType type;
    @NotNull
    private final Map<IrSymbol, State> fields;
    @NotNull
    private final IrClass irClass;

    public Primitive(T value2, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.value = value2;
        this.type = type2;
        this.fields = new LinkedHashMap();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.type);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this.irClass = (IrClass)irClassSymbol.getOwner();
    }

    public final T getValue() {
        return this.value;
    }

    @NotNull
    public final IrType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return null;
    }

    @Override
    @NotNull
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction owner = (IrSimpleFunction)expression2.getSymbol().getOwner();
        return owner.isFakeOverride() ? UtilsKt.getFirstNonInterfaceOverridden(owner) : (IrFunction)owner;
    }

    @NotNull
    public String toString() {
        return "Primitive(value=" + this.value + ", type=" + IrUtilsKt.getDefaultType(this.getIrClass()) + ')';
    }

    @Override
    public void setField(@NotNull IrSymbol symbol2, @NotNull State state) {
        State.DefaultImpls.setField(this, symbol2, state);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive$Companion;", "", "()V", "nullStateOfType", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Primitive<?> nullStateOfType(@NotNull IrType irType) {
            Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
            return new Primitive<Object>(null, irType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

