/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.FilteredAnnotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributesKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a`\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020\u00022\b\b\u0002\u0010!\u001a\u00020\u0001H\u0007\u001a\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0001\u001aR\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001e\u0010)\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0001\u001a\u000e\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020/\u001a\n\u00100\u001a\u00020%*\u00020\u0002\u001a\n\u00101\u001a\u00020\u0002*\u00020\u0002\u001a\f\u00102\u001a\u0004\u0018\u00010\u001f*\u00020\u0002\u001a\u0010\u00103\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c*\u00020\u0002\u001a\f\u00104\u001a\u0004\u0018\u000105*\u00020\u0005\u001a\u000e\u00104\u001a\u0004\u0018\u000105*\u00020/H\u0002\u001a\u0010\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c*\u00020\u0002\u001a\f\u00107\u001a\u0004\u0018\u00010\u0002*\u00020\u0002\u001a\n\u00108\u001a\u00020\u0002*\u00020\u0002\u001a\u0018\u00109\u001a\b\u0012\u0004\u0012\u00020(0\u001c*\u00020\u00022\u0006\u0010:\u001a\u00020\u0001\u001a\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020(0\u001c*\u00020\u0002\u001a\n\u0010<\u001a\u00020\u0001*\u00020\u0019\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00022\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010>\u001a \u0010?\u001a\u00020\u0001*\u00020\u00022\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010>H\u0002\u001a\u0012\u0010@\u001a\u00020\u0002*\u00020\u00022\u0006\u0010A\u001a\u00020\u0002\u001a\u001a\u0010B\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010C\u001a\u00020%\u001a\u0012\u0010D\u001a\u00020\u0019*\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017\u001a\n\u0010E\u001a\u00020F*\u00020\u0019\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0003\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0003\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0003\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0003\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0003\"\u0015\u0010\u000e\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0003\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0003\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0003\"\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0003\"\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0003\"\u0018\u0010\u0013\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0003\u00a8\u0006G"}, d2={"isBuiltinExtensionFunctionalType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isBuiltinFunctionalClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isBuiltinFunctionalType", "isBuiltinFunctionalTypeOrSubtype", "isExtensionFunctionType", "isFunctionOrKFunctionTypeWithAnySuspendability", "isFunctionOrSuspendFunctionType", "isFunctionType", "isFunctionTypeOrSubtype", "isKFunctionType", "isKSuspendFunctionType", "isNonExtensionFunctionType", "isSuspendFunctionType", "isSuspendFunctionTypeOrSubtype", "isTypeAnnotatedWithExtensionFunctionType", "createFunctionType", "Lorg/jetbrains/kotlin/types/SimpleType;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "receiverType", "contextReceiverTypes", "", "parameterTypes", "parameterNames", "Lorg/jetbrains/kotlin/name/Name;", "returnType", "suspendFunction", "getFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "parameterCount", "", "isSuspendFunction", "getFunctionTypeArgumentProjections", "Lorg/jetbrains/kotlin/types/TypeProjection;", "getKFunctionDescriptor", "isBuiltinFunctionClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNumberedFunctionClassFqName", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "contextFunctionTypeParamsCount", "extractFunctionalTypeFromSupertypes", "extractParameterNameFromFunctionTypeArgument", "getContextReceiverTypesFromFunctionType", "getFunctionalClassKind", "Lorg/jetbrains/kotlin/builtins/functions/FunctionClassKind;", "getPureArgumentsForFunctionalTypeOrSubtype", "getReceiverTypeFromFunctionType", "getReturnTypeFromFunctionType", "getValueParameterTypesFromCallableReflectionType", "isCallableTypeWithExtension", "getValueParameterTypesFromFunctionType", "hasExtensionFunctionAnnotation", "predicate", "Lkotlin/Function1;", "isTypeOrSubtypeOf", "replaceReturnType", "newReturnType", "withContextReceiversFunctionAnnotation", "contextReceiversCount", "withExtensionFunctionAnnotation", "withoutExtensionFunctionAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/FilteredAnnotations;", "descriptors"})
public final class FunctionTypesKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTypeOrSubtypeOf(KotlinType $this$isTypeOrSubtypeOf, Function1<? super KotlinType, Boolean> predicate) {
        if ((Boolean)predicate.invoke((Object)$this$isTypeOrSubtypeOf) != false) return true;
        Object r = DFS.dfsFromNode($this$isTypeOrSubtypeOf, isTypeOrSubtypeOf.1.INSTANCE, new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<KotlinType, Boolean>(predicate){
            private boolean result;
            final /* synthetic */ Function1<KotlinType, Boolean> $predicate;
            {
                this.$predicate = $predicate;
            }

            public boolean beforeChildren(@NotNull KotlinType current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                if (((Boolean)this.$predicate.invoke((Object)current)).booleanValue()) {
                    this.result = true;
                }
                return !this.result;
            }

            @NotNull
            public Boolean result() {
                return this.result;
            }
        });
        Intrinsics.checkNotNullExpressionValue(r, (String)"predicate: (KotlinType) \u2026              }\n        )");
        if ((Boolean)r == false) return false;
        return true;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionTypeOrSubtype, (String)"<this>");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isFunctionTypeOrSubtype, (Function1<? super KotlinType, Boolean>)((Function1)isFunctionTypeOrSubtype.1.INSTANCE));
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull KotlinType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionTypeOrSubtype, (String)"<this>");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, (Function1<? super KotlinType, Boolean>)((Function1)isSuspendFunctionTypeOrSubtype.1.INSTANCE));
    }

    public static final boolean isBuiltinFunctionalTypeOrSubtype(@NotNull KotlinType $this$isBuiltinFunctionalTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalTypeOrSubtype, (String)"<this>");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isBuiltinFunctionalTypeOrSubtype, (Function1<? super KotlinType, Boolean>)((Function1)isBuiltinFunctionalTypeOrSubtype.1.INSTANCE));
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull KotlinType $this$isFunctionTypeOrSubtype, @NotNull Function1<? super KotlinType, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionTypeOrSubtype, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return FunctionTypesKt.isTypeOrSubtypeOf($this$isFunctionTypeOrSubtype, (Function1<? super KotlinType, Boolean>)((Function1)new Function1<KotlinType, Boolean>(predicate){
            final /* synthetic */ Function1<KotlinType, Boolean> $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FunctionTypesKt.isFunctionType(it) && (Boolean)this.$predicate.invoke((Object)it) != false;
            }
        }));
    }

    public static final boolean isFunctionType(@NotNull KotlinType $this$isFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassKind.Function;
    }

    public static final boolean isKFunctionType(@NotNull KotlinType $this$isKFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunctionType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isKFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassKind.KFunction;
    }

    public static final boolean isSuspendFunctionType(@NotNull KotlinType $this$isSuspendFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isSuspendFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isKSuspendFunctionType(@NotNull KotlinType $this$isKSuspendFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunctionType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isKSuspendFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassKind.KSuspendFunction;
    }

    public static final boolean isFunctionOrSuspendFunctionType(@NotNull KotlinType $this$isFunctionOrSuspendFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionOrSuspendFunctionType, (String)"<this>");
        return FunctionTypesKt.isFunctionType($this$isFunctionOrSuspendFunctionType) || FunctionTypesKt.isSuspendFunctionType($this$isFunctionOrSuspendFunctionType);
    }

    public static final boolean isFunctionOrKFunctionTypeWithAnySuspendability(@NotNull KotlinType $this$isFunctionOrKFunctionTypeWithAnySuspendability) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionOrKFunctionTypeWithAnySuspendability, (String)"<this>");
        return FunctionTypesKt.isFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isSuspendFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isKFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability) || FunctionTypesKt.isKSuspendFunctionType($this$isFunctionOrKFunctionTypeWithAnySuspendability);
    }

    public static final boolean isBuiltinFunctionalType(@NotNull KotlinType $this$isBuiltinFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isBuiltinFunctionalType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor) : false;
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(@NotNull DeclarationDescriptor $this$isBuiltinFunctionalClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalClassDescriptor, (String)"<this>");
        FunctionClassKind functionalClassKind = FunctionTypesKt.getFunctionalClassKind($this$isBuiltinFunctionalClassDescriptor);
        return functionalClassKind == FunctionClassKind.Function || functionalClassKind == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isBuiltinFunctionClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (!classId.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME)) {
            return false;
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"classId.asSingleFqName().toUnsafe()");
        FunctionClassKind kind = FunctionTypesKt.getFunctionalClassKind(fqNameUnsafe);
        return kind == FunctionClassKind.Function || kind == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isNonExtensionFunctionType(@NotNull KotlinType $this$isNonExtensionFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonExtensionFunctionType, (String)"<this>");
        return FunctionTypesKt.isFunctionType($this$isNonExtensionFunctionType) && !FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isNonExtensionFunctionType);
    }

    public static final boolean isExtensionFunctionType(@NotNull KotlinType $this$isExtensionFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionFunctionType, (String)"<this>");
        return FunctionTypesKt.isFunctionType($this$isExtensionFunctionType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isExtensionFunctionType);
    }

    public static final boolean isBuiltinExtensionFunctionalType(@NotNull KotlinType $this$isBuiltinExtensionFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinExtensionFunctionalType, (String)"<this>");
        return FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinExtensionFunctionalType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isBuiltinExtensionFunctionalType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType $this$isTypeAnnotatedWithExtensionFunctionType) {
        return $this$isTypeAnnotatedWithExtensionFunctionType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
    }

    public static final boolean isNumberedFunctionClassFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return fqName2.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME) && FunctionTypesKt.getFunctionalClassKind(fqName2) == FunctionClassKind.Function;
    }

    @Nullable
    public static final FunctionClassKind getFunctionalClassKind(@NotNull DeclarationDescriptor $this$getFunctionalClassKind) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionalClassKind, (String)"<this>");
        if (!($this$getFunctionalClassKind instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage($this$getFunctionalClassKind)) {
            return null;
        }
        return FunctionTypesKt.getFunctionalClassKind(DescriptorUtilsKt.getFqNameUnsafe($this$getFunctionalClassKind));
    }

    private static final FunctionClassKind getFunctionalClassKind(FqNameUnsafe $this$getFunctionalClassKind) {
        if (!$this$getFunctionalClassKind.isSafe() || $this$getFunctionalClassKind.isRoot()) {
            return null;
        }
        String string2 = $this$getFunctionalClassKind.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortName().asString()");
        FqName fqName2 = $this$getFunctionalClassKind.toSafe().parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe().parent()");
        return FunctionClassKind.Companion.getFunctionalClassKind(string2, fqName2);
    }

    public static final int contextFunctionTypeParamsCount(@NotNull KotlinType $this$contextFunctionTypeParamsCount) {
        Intrinsics.checkNotNullParameter((Object)$this$contextFunctionTypeParamsCount, (String)"<this>");
        AnnotationDescriptor annotationDescriptor = $this$contextFunctionTypeParamsCount.getAnnotations().findAnnotation(StandardNames.FqNames.contextFunctionTypeParams);
        if (annotationDescriptor == null) {
            return 0;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        ConstantValue constantValue = (ConstantValue)MapsKt.getValue(annotationDescriptor2.getAllValueArguments(), (Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        Intrinsics.checkNotNull((Object)constantValue, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntValue");
        return ((Number)((IntValue)constantValue).getValue()).intValue();
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $this$getReceiverTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiverTypeFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReceiverTypeFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Not a function type: " + $this$getReceiverTypeFromFunctionType;
            throw new AssertionError((Object)string2);
        }
        if (!FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$getReceiverTypeFromFunctionType)) {
            return null;
        }
        int index2 = FunctionTypesKt.contextFunctionTypeParamsCount($this$getReceiverTypeFromFunctionType);
        return $this$getReceiverTypeFromFunctionType.getArguments().get(index2).getType();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> getContextReceiverTypesFromFunctionType(@NotNull KotlinType $this$getContextReceiverTypesFromFunctionType) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$getContextReceiverTypesFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getContextReceiverTypesFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getContextReceiverTypesFromFunctionType$22 = false;
            String $i$a$-assert-FunctionTypesKt$getContextReceiverTypesFromFunctionType$22 = "Not a function type: " + $this$getContextReceiverTypesFromFunctionType;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getContextReceiverTypesFromFunctionType$22);
        }
        int contextReceiversCount = FunctionTypesKt.contextFunctionTypeParamsCount($this$getContextReceiverTypesFromFunctionType);
        if (contextReceiversCount == 0) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getContextReceiverTypesFromFunctionType.getArguments().subList(0, contextReceiversCount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                collection.add(kotlinType);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $this$getReturnTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getReturnTypeFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReturnTypeFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Not a function type: " + $this$getReturnTypeFromFunctionType;
            throw new AssertionError((Object)string2);
        }
        KotlinType kotlinType = ((TypeProjection)kotlin.collections.CollectionsKt.last($this$getReturnTypeFromFunctionType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final KotlinType replaceReturnType(@NotNull KotlinType $this$replaceReturnType, @NotNull KotlinType newReturnType) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$replaceReturnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newReturnType, (String)"newReturnType");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$replaceReturnType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Not a function type: " + $this$replaceReturnType;
            throw new AssertionError((Object)string2);
        }
        List $this$replaceReturnType_u24lambda_u245 = list2 = kotlin.collections.CollectionsKt.toMutableList((Collection)$this$replaceReturnType.getArguments());
        boolean bl3 = false;
        $this$replaceReturnType_u24lambda_u245.set($this$replaceReturnType_u24lambda_u245.size() - 1, new TypeProjectionImpl(newReturnType));
        List argumentsWithNewReturnType = list2;
        return TypeSubstitutionKt.replace$default($this$replaceReturnType, argumentsWithNewReturnType, null, null, 6, null);
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $this$getValueParameterTypesFromFunctionType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$getValueParameterTypesFromFunctionType, (String)"<this>");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType($this$getValueParameterTypesFromFunctionType);
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = "Not a function type: " + $this$getValueParameterTypesFromFunctionType;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32);
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromFunctionType.getArguments();
        int first = FunctionTypesKt.contextFunctionTypeParamsCount($this$getValueParameterTypesFromFunctionType) + (FunctionTypesKt.isBuiltinExtensionFunctionalType($this$getValueParameterTypesFromFunctionType) ? 1 : 0);
        int last = arguments2.size() - 1;
        boolean bl3 = bl = first <= last;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Not an exact function type: " + $this$getValueParameterTypesFromFunctionType;
            throw new AssertionError((Object)string2);
        }
        return arguments2.subList(first, last);
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromCallableReflectionType(@NotNull KotlinType $this$getValueParameterTypesFromCallableReflectionType, boolean isCallableTypeWithExtension) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$getValueParameterTypesFromCallableReflectionType, (String)"<this>");
        boolean bl2 = ReflectionTypes.Companion.isKCallableType($this$getValueParameterTypesFromCallableReflectionType);
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32 = "Not a callable reflection type: " + $this$getValueParameterTypesFromCallableReflectionType;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromCallableReflectionType$32);
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromCallableReflectionType.getArguments();
        int first = isCallableTypeWithExtension ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl3 = bl = first <= last;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Not an exact function type: " + $this$getValueParameterTypesFromCallableReflectionType;
            throw new AssertionError((Object)string2);
        }
        return arguments2.subList(first, last);
    }

    @NotNull
    public static final KotlinType extractFunctionalTypeFromSupertypes(@NotNull KotlinType $this$extractFunctionalTypeFromSupertypes) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$extractFunctionalTypeFromSupertypes, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype($this$extractFunctionalTypeFromSupertypes);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$extractFunctionalTypeFromSupertypes$22 = false;
            String $i$a$-assert-FunctionTypesKt$extractFunctionalTypeFromSupertypes$22 = "Not a function type or subtype: " + $this$extractFunctionalTypeFromSupertypes;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$extractFunctionalTypeFromSupertypes$22);
        }
        if (FunctionTypesKt.isBuiltinFunctionalType($this$extractFunctionalTypeFromSupertypes)) {
            kotlinType = $this$extractFunctionalTypeFromSupertypes;
        } else {
            Object element$iv2;
            block4: {
                Iterable $this$first$iv = TypeUtilsKt.supertypes($this$extractFunctionalTypeFromSupertypes);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    KotlinType it = (KotlinType)element$iv2;
                    boolean bl2 = false;
                    if (!FunctionTypesKt.isBuiltinFunctionalType(it)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            kotlinType = (KotlinType)element$iv2;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> getPureArgumentsForFunctionalTypeOrSubtype(@NotNull KotlinType $this$getPureArgumentsForFunctionalTypeOrSubtype) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getPureArgumentsForFunctionalTypeOrSubtype, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype($this$getPureArgumentsForFunctionalTypeOrSubtype);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = false;
            String $i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22 = "Not a function type or subtype: " + $this$getPureArgumentsForFunctionalTypeOrSubtype;
            throw new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getPureArgumentsForFunctionalTypeOrSubtype$22);
        }
        Iterable $this$map$iv = kotlin.collections.CollectionsKt.dropLast(FunctionTypesKt.extractFunctionalTypeFromSupertypes($this$getPureArgumentsForFunctionalTypeOrSubtype).getArguments(), (int)1);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $this$extractParameterNameFromFunctionTypeArgument) {
        Object object;
        block5: {
            block4: {
                Object object2;
                StringValue stringValue;
                Intrinsics.checkNotNullParameter((Object)$this$extractParameterNameFromFunctionTypeArgument, (String)"<this>");
                AnnotationDescriptor annotationDescriptor = $this$extractParameterNameFromFunctionTypeArgument.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
                if (annotationDescriptor == null) {
                    return null;
                }
                AnnotationDescriptor annotation2 = annotationDescriptor;
                Object object3 = kotlin.collections.CollectionsKt.singleOrNull((Iterable)annotation2.getAllValueArguments().values());
                StringValue stringValue2 = stringValue = object3 instanceof StringValue ? (StringValue)object3 : null;
                if (stringValue == null || (object3 = (String)stringValue.getValue()) == null) break block4;
                Object it = object2 = object3;
                boolean bl = false;
                Object object4 = object = Name.isValidIdentifier((String)it) ? object2 : null;
                if (object != null) break block5;
            }
            return null;
        }
        Object name = object;
        return Name.identifier((String)name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2, @NotNull KotlinBuiltIns builtIns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + contextReceiverTypes.size() + (receiverType != null ? 1 : 0) + 1);
        Iterable iterable = contextReceiverTypes;
        Collection<TypeProjection> collection = arguments2;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TypeUtilsKt.asTypeProjection((KotlinType)it));
        }
        ((ArrayList)collection).addAll((List)destination$iv$iv);
        KotlinType kotlinType = receiverType;
        CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable $this$mapIndexedTo$iv = parameterTypes;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            KotlinType kotlinType2;
            void type2;
            List<Name> name;
            List<Name> list2;
            void index2;
            int n;
            Object item$iv$iv;
            Collection collection3 = arguments2;
            if ((n = index$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (KotlinType)item$iv;
            int it = n;
            collection = collection3;
            boolean bl = false;
            List<Name> list3 = parameterNames;
            if (list3 != null && (list3 = list3.get((int)index2)) != null) {
                List<Name> list4;
                List<Name> it2 = list4 = list3;
                boolean bl2 = false;
                list2 = !((Name)((Object)it2)).isSpecial() ? list4 : null;
            } else {
                list2 = name = null;
            }
            if (name != null) {
                Name name2 = Name.identifier("name");
                String string2 = ((Name)((Object)name)).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
                BuiltInAnnotationDescriptor parameterNameAnnotation = new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.parameterName, MapsKt.mapOf((Pair)TuplesKt.to((Object)name2, (Object)new StringValue(string2))));
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)type2.getAnnotations(), (Object)parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            collection.add(TypeUtilsKt.asTypeProjection((KotlinType)typeToUse));
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType2));
        return arguments2;
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2, boolean suspendFunction) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        List<TypeProjection> arguments2 = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, contextReceiverTypes, parameterTypes, parameterNames, returnType2, builtIns);
        int parameterCount = parameterTypes.size() + contextReceiverTypes.size() + (receiverType == null ? 0 : 1);
        ClassDescriptor classDescriptor = FunctionTypesKt.getFunctionDescriptor(builtIns, parameterCount, suspendFunction);
        Annotations typeAnnotations = annotations2;
        if (receiverType != null) {
            typeAnnotations = FunctionTypesKt.withExtensionFunctionAnnotation(typeAnnotations, builtIns);
        }
        if (!((Collection)contextReceiverTypes).isEmpty()) {
            typeAnnotations = FunctionTypesKt.withContextReceiversFunctionAnnotation(typeAnnotations, builtIns, contextReceiverTypes.size());
        }
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(typeAnnotations), classDescriptor, arguments2);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list2, List list3, List list4, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list2, list3, list4, kotlinType2, bl);
    }

    public static final boolean hasExtensionFunctionAnnotation(@NotNull Annotations $this$hasExtensionFunctionAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasExtensionFunctionAnnotation, (String)"<this>");
        return $this$hasExtensionFunctionAnnotation.hasAnnotation(StandardNames.FqNames.extensionFunctionType);
    }

    @NotNull
    public static final FilteredAnnotations withoutExtensionFunctionAnnotation(@NotNull Annotations $this$withoutExtensionFunctionAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$withoutExtensionFunctionAnnotation, (String)"<this>");
        return new FilteredAnnotations($this$withoutExtensionFunctionAnnotation, true, (Function1<? super FqName, Boolean>)((Function1)withoutExtensionFunctionAnnotation.1.INSTANCE));
    }

    @NotNull
    public static final Annotations withExtensionFunctionAnnotation(@NotNull Annotations $this$withExtensionFunctionAnnotation, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)$this$withExtensionFunctionAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        return $this$withExtensionFunctionAnnotation.hasAnnotation(StandardNames.FqNames.extensionFunctionType) ? $this$withExtensionFunctionAnnotation : Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)$this$withExtensionFunctionAnnotation, (Object)new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.extensionFunctionType, MapsKt.emptyMap())));
    }

    @NotNull
    public static final Annotations withContextReceiversFunctionAnnotation(@NotNull Annotations $this$withContextReceiversFunctionAnnotation, @NotNull KotlinBuiltIns builtIns, int contextReceiversCount) {
        Intrinsics.checkNotNullParameter((Object)$this$withContextReceiversFunctionAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        return $this$withContextReceiversFunctionAnnotation.hasAnnotation(StandardNames.FqNames.contextFunctionTypeParams) ? $this$withContextReceiversFunctionAnnotation : Annotations.Companion.create(kotlin.collections.CollectionsKt.plus((Iterable)$this$withContextReceiversFunctionAnnotation, (Object)new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.contextFunctionTypeParams, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME, (Object)new IntValue(contextReceiversCount))))));
    }

    @NotNull
    public static final ClassDescriptor getFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = isSuspendFunction ? builtIns.getSuspendFunction(parameterCount) : builtIns.getFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"if (isSuspendFunction) b\u2026tFunction(parameterCount)");
        return classDescriptor;
    }

    @NotNull
    public static final ClassDescriptor getKFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = isSuspendFunction ? builtIns.getKSuspendFunction(parameterCount) : builtIns.getKFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"if (isSuspendFunction) b\u2026KFunction(parameterCount)");
        return classDescriptor;
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> contextReceiverTypes, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType2) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType2, (String)"returnType");
        return FunctionTypesKt.createFunctionType$default(builtIns, annotations2, receiverType, contextReceiverTypes, parameterTypes, parameterNames, returnType2, false, 128, null);
    }
}

