/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.preprocessing;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/psi2ir/preprocessing/SourceDeclarationsPreprocessor;", "", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "processClassOrObject", "", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "processDeclaration", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "run", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ir.psi2ir"})
public final class SourceDeclarationsPreprocessor {
    @NotNull
    private final GeneratorContext context;

    public SourceDeclarationsPreprocessor(@NotNull GeneratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public final void run(@NotNull Collection<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        for (KtFile ktFile : CollectionsKt.toSet((Iterable)ktFiles)) {
            for (KtDeclaration ktDeclaration : ktFile.getDeclarations()) {
                this.processDeclaration(ktDeclaration);
            }
        }
    }

    private final void processDeclaration(KtDeclaration ktDeclaration) {
        if (ktDeclaration instanceof KtClassOrObject) {
            this.processClassOrObject((KtClassOrObject)ktDeclaration);
        }
    }

    private final void processClassOrObject(KtClassOrObject ktClassOrObject) {
        block2: {
            ClassDescriptor classDescriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(ktClassOrObject, this.context.getBindingContext());
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return;
            }
            this.context.getSymbolTable().referenceClass(classDescriptor);
            KtClassBody ktClassBody = ktClassOrObject.getBody();
            if (ktClassBody == null) break block2;
            KtClassBody ktClassBody2 = ktClassBody;
            boolean bl = false;
            Iterable $this$forEach$iv = ktClassBody2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.processDeclaration(it);
            }
        }
    }
}

