/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithNavigationSubstitute;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.synthetic.SyntheticMemberDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0012H\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorToSourceUtils;", "", "()V", "collectEffectiveReferencedDescriptors", "", "result", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "descriptorToDeclaration", "Lcom/intellij/psi/PsiElement;", "findTopLevelParent", "declarationDescriptor", "getContainingFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getEffectiveReferencedDescriptors", "", "getSourceForExtensionReceiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getSourceFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getSourceFromDescriptor", "frontend"})
public final class DescriptorToSourceUtils {
    @NotNull
    public static final DescriptorToSourceUtils INSTANCE = new DescriptorToSourceUtils();

    private DescriptorToSourceUtils() {
    }

    private final void collectEffectiveReferencedDescriptors(List<DeclarationDescriptor> result2, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof DeclarationDescriptorWithNavigationSubstitute) {
            this.collectEffectiveReferencedDescriptors(result2, ((DeclarationDescriptorWithNavigationSubstitute)descriptor2).getSubstitute());
            return;
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor.Kind kind = ((CallableMemberDescriptor)descriptor2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"descriptor.kind");
            CallableMemberDescriptor.Kind kind2 = kind;
            if (kind2 != CallableMemberDescriptor.Kind.DECLARATION && kind2 != CallableMemberDescriptor.Kind.SYNTHESIZED) {
                for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors()) {
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor.getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor2, (String)"overridden.original");
                    this.collectEffectiveReferencedDescriptors(result2, callableMemberDescriptor2);
                }
                return;
            }
            if (descriptor2 instanceof SyntheticMemberDescriptor) {
                this.collectEffectiveReferencedDescriptors(result2, (DeclarationDescriptor)((SyntheticMemberDescriptor)((Object)descriptor2)).getBaseDescriptorForSynthetic());
                return;
            }
        }
        result2.add(descriptor2);
    }

    @JvmStatic
    @NotNull
    public static final Collection<DeclarationDescriptor> getEffectiveReferencedDescriptors(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ArrayList result2 = new ArrayList();
        List list2 = result2;
        DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.original");
        INSTANCE.collectEffectiveReferencedDescriptors(list2, declarationDescriptor);
        return result2;
    }

    @JvmStatic
    private static final PsiElement getSourceForExtensionReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor2) {
        if (!Intrinsics.areEqual((Object)descriptor2.getSource(), (Object)SourceElement.NO_SOURCE) || !(descriptor2.getValue() instanceof ExtensionReceiver)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            return null;
        }
        CallableDescriptor containingDeclaration = callableDescriptor;
        SourceElement sourceElement = containingDeclaration.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"containingDeclaration.source");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtCallableDeclaration ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        if (ktCallableDeclaration == null) {
            return null;
        }
        KtCallableDeclaration psi = ktCallableDeclaration;
        return psi.getReceiverTypeReference();
    }

    @JvmStatic
    @Nullable
    public static final PsiElement getSourceFromDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            PsiElement psiElement = DescriptorToSourceUtils.getSourceForExtensionReceiverParameterDescriptor((ReceiverParameterDescriptor)descriptor2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                return it;
            }
        }
        return (object = descriptor2 instanceof DeclarationDescriptorWithSource ? (DeclarationDescriptorWithSource)descriptor2 : null) != null && (object = object.getSource()) != null ? PsiSourceElementKt.getPsi((SourceElement)object) : null;
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry getSourceFromAnnotation(@NotNull AnnotationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = PsiSourceElementKt.getPsi(descriptor2.getSource());
        return psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
    }

    @JvmStatic
    @Nullable
    public static final PsiElement descriptorToDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Collection<DeclarationDescriptor> effectiveReferencedDescriptors = DescriptorToSourceUtils.getEffectiveReferencedDescriptors(descriptor2);
        if (effectiveReferencedDescriptors.size() == 1) {
            Object object = CollectionsKt.firstOrNull((Iterable)effectiveReferencedDescriptors);
            Intrinsics.checkNotNull((Object)object);
            psiElement = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)object);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @JvmStatic
    @Nullable
    public static final KtFile getContainingFile(@NotNull DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"declarationDescriptor");
        DeclarationDescriptor declarationDescriptor2 = INSTANCE.findTopLevelParent(declarationDescriptor);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor2;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (psiElement == null) {
            return null;
        }
        PsiElement declaration = psiElement;
        PsiFile psiFile = declaration.getContainingFile();
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    private final DeclarationDescriptor findTopLevelParent(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            Intrinsics.checkNotNull((Object)declarationDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor");
            descriptor2 = ((PropertyAccessorDescriptor)declarationDescriptor2).getCorrespondingProperty();
        }
        while (descriptor2 != null && !DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return descriptor2;
    }
}

