/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationArgumentMapping;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ5\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010#\"\u0004\b\u0001\u0010$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H$0&2\u0006\u0010'\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\tH\u0016J\u0016\u0010+\u001a\u00020\"2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0007H\u0016J)\u0010/\u001a\u00020\u0000\"\u0004\b\u0000\u0010$2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H$012\u0006\u0010'\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u00102J)\u00103\u001a\u00020\u0000\"\u0004\b\u0000\u0010$2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H$012\u0006\u0010'\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u00102J)\u00104\u001a\u00020\u0000\"\u0004\b\u0000\u0010$2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H$012\u0006\u0010'\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u00102J)\u00105\u001a\u00020\u0000\"\u0004\b\u0000\u0010$2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H$012\u0006\u0010'\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u00102R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/fir/expressions/impl/FirAnnotationImpl;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "useSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "annotationTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "argumentMapping", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationArgumentMapping;", "typeArguments", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "(Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationArgumentMapping;Ljava/util/List;)V", "getAnnotationTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "setAnnotationTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "annotations", "", "getAnnotations", "()Ljava/util/List;", "getArgumentMapping", "()Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationArgumentMapping;", "setArgumentMapping", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationArgumentMapping;)V", "getSource", "()Lorg/jetbrains/kotlin/KtSourceElement;", "getTypeArguments", "typeRef", "getTypeRef", "getUseSiteTarget", "()Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "acceptChildren", "", "R", "D", "visitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "data", "(Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;Ljava/lang/Object;)V", "replaceArgumentMapping", "newArgumentMapping", "replaceTypeArguments", "newTypeArguments", "replaceTypeRef", "newTypeRef", "transformAnnotationTypeRef", "transformer", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "(Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/impl/FirAnnotationImpl;", "transformAnnotations", "transformChildren", "transformTypeArguments", "tree"})
public final class FirAnnotationImpl
extends FirAnnotation {
    @Nullable
    private final KtSourceElement source;
    @Nullable
    private final AnnotationUseSiteTarget useSiteTarget;
    @NotNull
    private FirTypeRef annotationTypeRef;
    @NotNull
    private FirAnnotationArgumentMapping argumentMapping;
    @NotNull
    private final List<FirTypeProjection> typeArguments;

    public FirAnnotationImpl(@Nullable KtSourceElement source2, @Nullable AnnotationUseSiteTarget useSiteTarget, @NotNull FirTypeRef annotationTypeRef, @NotNull FirAnnotationArgumentMapping argumentMapping, @NotNull List<FirTypeProjection> typeArguments2) {
        Intrinsics.checkNotNullParameter((Object)annotationTypeRef, (String)"annotationTypeRef");
        Intrinsics.checkNotNullParameter((Object)argumentMapping, (String)"argumentMapping");
        Intrinsics.checkNotNullParameter(typeArguments2, (String)"typeArguments");
        this.source = source2;
        this.useSiteTarget = useSiteTarget;
        this.annotationTypeRef = annotationTypeRef;
        this.argumentMapping = argumentMapping;
        this.typeArguments = typeArguments2;
    }

    @Override
    @Nullable
    public KtSourceElement getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public AnnotationUseSiteTarget getUseSiteTarget() {
        return this.useSiteTarget;
    }

    @Override
    @NotNull
    public FirTypeRef getAnnotationTypeRef() {
        return this.annotationTypeRef;
    }

    public void setAnnotationTypeRef(@NotNull FirTypeRef firTypeRef) {
        Intrinsics.checkNotNullParameter((Object)firTypeRef, (String)"<set-?>");
        this.annotationTypeRef = firTypeRef;
    }

    @Override
    @NotNull
    public FirAnnotationArgumentMapping getArgumentMapping() {
        return this.argumentMapping;
    }

    public void setArgumentMapping(@NotNull FirAnnotationArgumentMapping firAnnotationArgumentMapping) {
        Intrinsics.checkNotNullParameter((Object)firAnnotationArgumentMapping, (String)"<set-?>");
        this.argumentMapping = firAnnotationArgumentMapping;
    }

    @Override
    @NotNull
    public List<FirTypeProjection> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    @NotNull
    public FirTypeRef getTypeRef() {
        return this.getAnnotationTypeRef();
    }

    @Override
    @NotNull
    public List<FirAnnotation> getAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    public <R, D> void acceptChildren(@NotNull FirVisitor<? extends R, ? super D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        this.getAnnotationTypeRef().accept(visitor2, data);
        this.getArgumentMapping().accept(visitor2, data);
        Iterable $this$forEach$iv = this.getTypeArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeProjection it = (FirTypeProjection)element$iv;
            boolean bl = false;
            it.accept(visitor2, data);
        }
    }

    @Override
    @NotNull
    public <D> FirAnnotationImpl transformChildren(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        this.transformAnnotationTypeRef((FirTransformer)transformer2, (Object)data);
        this.setArgumentMapping((FirAnnotationArgumentMapping)this.getArgumentMapping().transform(transformer2, data));
        this.transformTypeArguments((FirTransformer)transformer2, (Object)data);
        return this;
    }

    @Override
    @NotNull
    public <D> FirAnnotationImpl transformAnnotations(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        return this;
    }

    @Override
    @NotNull
    public <D> FirAnnotationImpl transformAnnotationTypeRef(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        this.setAnnotationTypeRef((FirTypeRef)this.getAnnotationTypeRef().transform(transformer2, data));
        return this;
    }

    @Override
    @NotNull
    public <D> FirAnnotationImpl transformTypeArguments(@NotNull FirTransformer<? super D> transformer2, D data) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        FirTransformerUtilKt.transformInplace(this.getTypeArguments(), transformer2, data);
        return this;
    }

    @Override
    public void replaceTypeRef(@NotNull FirTypeRef newTypeRef) {
        Intrinsics.checkNotNullParameter((Object)newTypeRef, (String)"newTypeRef");
    }

    @Override
    public void replaceArgumentMapping(@NotNull FirAnnotationArgumentMapping newArgumentMapping) {
        Intrinsics.checkNotNullParameter((Object)newArgumentMapping, (String)"newArgumentMapping");
        this.setArgumentMapping(newArgumentMapping);
    }

    @Override
    public void replaceTypeArguments(@NotNull List<? extends FirTypeProjection> newTypeArguments) {
        Intrinsics.checkNotNullParameter(newTypeArguments, (String)"newTypeArguments");
        this.getTypeArguments().clear();
        this.getTypeArguments().addAll((Collection<FirTypeProjection>)newTypeArguments);
    }
}

