/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "operandType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "boxedOperandType", "getOperandType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "backend.jvm.codegen"})
public final class Ieee754Equals
extends IntrinsicMethod {
    @NotNull
    private final Type operandType;
    @NotNull
    private final Type boxedOperandType;

    public Ieee754Equals(@NotNull Type operandType) {
        Intrinsics.checkNotNullParameter((Object)operandType, (String)"operandType");
        this.operandType = operandType;
        Type type2 = AsmUtil.boxType(this.operandType);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"boxType(operandType)");
        this.boxedOperandType = type2;
    }

    @NotNull
    public final Type getOperandType() {
        return this.operandType;
    }

    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull ClassCodegen classCodegen) {
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"org/jetbrains/kotlin/backend/jvm/intrinsics/Ieee754Equals$toCallable$Ieee754AreEqual", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "left", "Lorg/jetbrains/org/objectweb/asm/Type;", "right", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getLeft", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getRight", "genInvokeInstruction", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "backend.jvm.codegen"})
        public final class Ieee754AreEqual
        extends IrIntrinsicFunction {
            @NotNull
            private final Type left;
            @NotNull
            private final Type right;

            public Ieee754AreEqual(@NotNull IrFunctionAccessExpression $expression, @NotNull JvmMethodSignature $signature, @NotNull ClassCodegen $classCodegen, @NotNull Type left, @NotNull Type right) {
                Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
                Intrinsics.checkNotNullParameter((Object)$signature, (String)"$signature");
                Intrinsics.checkNotNullParameter((Object)$classCodegen, (String)"$classCodegen");
                Intrinsics.checkNotNullParameter((Object)left, (String)"left");
                Intrinsics.checkNotNullParameter((Object)right, (String)"right");
                Object[] objectArray = new Type[]{left, right};
                super($expression, $signature, $classCodegen, CollectionsKt.listOf((Object[])objectArray));
                this.left = left;
                this.right = right;
            }

            @NotNull
            public final Type getLeft() {
                return this.left;
            }

            @NotNull
            public final Type getRight() {
                return this.right;
            }

            public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Type[] typeArray = new Type[]{this.left, this.right};
                v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, typeArray), false);
            }
        }
        IrIntrinsicFunction irIntrinsicFunction;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        IrExpression irExpression = expression2.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression arg0 = irExpression;
        IrExpression irExpression2 = expression2.getValueArgument(1);
        Intrinsics.checkNotNull((Object)irExpression2);
        IrExpression arg1 = irExpression2;
        KotlinType arg0Type = IrBasedDescriptorsKt.toIrBasedKotlinType(arg0.getType());
        if (!TypeUtilsKt.isPrimitiveNumberOrNullableType(arg0Type) && !TypeUtilsKt.upperBoundedByPrimitiveNumberOrNullableType(arg0Type)) {
            throw new AssertionError((Object)("Should be primitive or nullable primitive type: " + arg0Type));
        }
        KotlinType arg1Type = IrBasedDescriptorsKt.toIrBasedKotlinType(arg1.getType());
        if (!TypeUtilsKt.isPrimitiveNumberOrNullableType(arg1Type) && !TypeUtilsKt.upperBoundedByPrimitiveNumberOrNullableType(arg1Type)) {
            throw new AssertionError((Object)("Should be primitive or nullable primitive type: " + arg1Type));
        }
        boolean arg0isNullable = KotlinTypeKt.isNullable(arg0Type);
        boolean arg1isNullable = KotlinTypeKt.isNullable(arg1Type);
        boolean useNonIEEE754Comparison = !classCodegen.getContext().getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons) && (JvmIrUtilsKt.isSmartcastFromHigherThanNullable(arg0, classCodegen.getContext()) || JvmIrUtilsKt.isSmartcastFromHigherThanNullable(arg1, classCodegen.getContext()));
        if (useNonIEEE754Comparison) {
            Type type2 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"OBJECT_TYPE");
            Type type3 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"OBJECT_TYPE");
            irIntrinsicFunction = new Ieee754AreEqual(expression2, signature2, classCodegen, type2, type3);
        } else if (!arg0isNullable && !arg1isNullable) {
            Object[] objectArray = new Type[]{this.operandType, this.operandType};
            List list2 = CollectionsKt.listOf((Object[])objectArray);
            irIntrinsicFunction = new IrIntrinsicFunction(expression2, signature2, classCodegen, this, list2){
                final /* synthetic */ Ieee754Equals this$0;
                {
                    this.this$0 = $receiver;
                    super($expression, $signature, $classCodegen, $super_call_param$1);
                }

                public void genInvokeInstruction(@NotNull InstructionAdapter v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    StackValue.cmp(KtTokens.EQEQ, this.this$0.getOperandType(), StackValue.onStack(this.this$0.getOperandType()), StackValue.onStack(this.this$0.getOperandType())).put(Type.BOOLEAN_TYPE, v);
                }
            };
        } else {
            irIntrinsicFunction = arg0isNullable && !arg1isNullable ? (IrIntrinsicFunction)new Ieee754AreEqual(expression2, signature2, classCodegen, this.boxedOperandType, this.operandType) : (!arg0isNullable && arg1isNullable ? (IrIntrinsicFunction)new Ieee754AreEqual(expression2, signature2, classCodegen, this.operandType, this.boxedOperandType) : (IrIntrinsicFunction)new Ieee754AreEqual(expression2, signature2, classCodegen, this.boxedOperandType, this.boxedOperandType));
        }
        return irIntrinsicFunction;
    }
}

