/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analyzer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analyzer/DiagnoseUnknownModuleInfoReporter;", "", "()V", "errorInLibrariesResolver", "Lorg/jetbrains/kotlin/utils/KotlinExceptionWithAttachments;", "message", "", "errorInModulesResolver", "errorInModulesResolverWithEmptyInfos", "errorInModulesResolverWithLibraryInfo", "errorInModulesResolverWithScriptDependencies", "errorInScriptDependenciesInfoResolver", "errorInScriptModuleInfoResolver", "errorInSdkResolver", "errorInSpecialModuleInfoResolver", "otherError", "report", "", "name", "infos", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "allModules", "", "frontend"})
final class DiagnoseUnknownModuleInfoReporter {
    @NotNull
    public static final DiagnoseUnknownModuleInfoReporter INSTANCE = new DiagnoseUnknownModuleInfoReporter();

    private DiagnoseUnknownModuleInfoReporter() {
    }

    @NotNull
    public final Void report(@NotNull String name, @NotNull List<? extends ModuleInfo> infos, @NotNull Collection<? extends ModuleInfo> allModules2) {
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        Intrinsics.checkNotNullParameter(allModules2, (String)"allModules");
        String message = name + " does not know how to resolve";
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"sdk", (boolean)false, (int)2, null)) {
            kotlinExceptionWithAttachments = this.errorInSdkResolver(message);
        } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"project libraries", (boolean)false, (int)2, null)) {
            kotlinExceptionWithAttachments = this.errorInLibrariesResolver(message);
        } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"project source roots and libraries", (boolean)false, (int)2, null)) {
            if (infos.isEmpty()) {
                kotlinExceptionWithAttachments = this.errorInModulesResolverWithEmptyInfos(message);
            } else if (infos.size() == 1) {
                String infoAsString = CollectionsKt.single(infos).toString();
                kotlinExceptionWithAttachments = StringsKt.contains$default((CharSequence)infoAsString, (CharSequence)"ScriptDependencies", (boolean)false, (int)2, null) ? this.errorInModulesResolverWithScriptDependencies(message) : (StringsKt.contains$default((CharSequence)infoAsString, (CharSequence)"Library", (boolean)false, (int)2, null) ? this.errorInModulesResolverWithLibraryInfo(message) : this.errorInModulesResolver(message));
            } else {
                kotlinExceptionWithAttachments = this.errorInModulesResolver(message);
            }
        } else {
            kotlinExceptionWithAttachments = StringsKt.contains$default((CharSequence)name, (CharSequence)"dependencies of scripts", (boolean)false, (int)2, null) ? this.errorInScriptDependenciesInfoResolver(message) : (StringsKt.contains$default((CharSequence)name, (CharSequence)"completion/highlighting in ", (boolean)false, (int)2, null) ? (StringsKt.contains$default((CharSequence)name, (CharSequence)"ScriptModuleInfo", (boolean)false, (int)2, null) ? this.errorInScriptModuleInfoResolver(message) : this.errorInSpecialModuleInfoResolver(message)) : this.otherError(message));
        }
        KotlinExceptionWithAttachments error = kotlinExceptionWithAttachments;
        throw error.withAttachment("infos.txt", infos).withAttachment("allModules.txt", allModules2);
    }

    private final KotlinExceptionWithAttachments errorInSdkResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInLibrariesResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolverWithEmptyInfos(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolverWithScriptDependencies(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInModulesResolverWithLibraryInfo(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInScriptDependenciesInfoResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInScriptModuleInfoResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments errorInSpecialModuleInfoResolver(String message) {
        return new KotlinExceptionWithAttachments(message);
    }

    private final KotlinExceptionWithAttachments otherError(String message) {
        return new KotlinExceptionWithAttachments(message);
    }
}

