/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector;", "", "<init>", "()V", "actualClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualTypeAliasesWithoutExpansion", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "actualTopLevels", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbolsToFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitedActualClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "currentFile", "collect", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "recordActualCallable", "callableDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "Companion", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,318:1\n372#2,7:319\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n*L\n180#1:319,7\n*E\n"})
final class ActualDeclarationsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ClassId, IrClassSymbol> actualClasses = new LinkedHashMap();
    @NotNull
    private final Map<ClassId, IrTypeAliasSymbol> actualTypeAliasesWithoutExpansion = new LinkedHashMap();
    @NotNull
    private final Map<CallableId, List<IrSymbol>> actualTopLevels = new LinkedHashMap();
    @NotNull
    private final Map<IrSymbol, IrFile> actualSymbolsToFile = new LinkedHashMap();
    @NotNull
    private final Set<IrClass> visitedActualClasses = new LinkedHashSet();
    @Nullable
    private IrFile currentFile;

    private final void collect(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrModuleFragment) {
            for (IrFile file2 : ((IrModuleFragment)element).getFiles()) {
                this.collect(file2);
            }
        } else if (irElement instanceof IrFile) {
            this.currentFile = (IrFile)element;
            for (IrDeclaration declaration : ((IrFile)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrTypeAlias) {
            if (!((IrTypeAlias)element).isActual()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail((IrTypeAlias)element);
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrTypeAlias)element).getExpandedType());
            Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol expandedTypeSymbol = (IrClassSymbol)irClassifierSymbol;
            this.actualClasses.put(classId, expandedTypeSymbol);
            this.actualTypeAliasesWithoutExpansion.put(classId, ((IrTypeAlias)element).getSymbol());
            this.actualSymbolsToFile.put(expandedTypeSymbol, this.currentFile);
            this.actualSymbolsToFile.put(((IrTypeAlias)element).getSymbol(), this.currentFile);
            this.collect((IrElement)expandedTypeSymbol.getOwner());
        } else if (irElement instanceof IrClass) {
            if (((IrClass)element).isExpect() || !this.visitedActualClasses.add((IrClass)element)) {
                return;
            }
            this.actualClasses.put(AdditionalIrUtilsKt.getClassIdOrFail((IrClass)element), ((IrClass)element).getSymbol());
            this.actualSymbolsToFile.put(((IrClass)element).getSymbol(), this.currentFile);
            for (IrDeclaration declaration : ((IrClass)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrDeclarationContainer) {
            for (IrDeclaration declaration : ((IrDeclarationContainer)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrEnumEntry) {
            this.recordActualCallable((IrDeclarationWithName)element, AdditionalIrUtilsKt.getCallableId((IrEnumEntry)element));
        } else if (irElement instanceof IrProperty) {
            if (((IrProperty)element).isExpect()) {
                return;
            }
            this.recordActualCallable((IrDeclarationWithName)element, AdditionalIrUtilsKt.getCallableId((IrProperty)element));
        } else if (irElement instanceof IrFunction) {
            if (((IrFunction)element).isExpect()) {
                return;
            }
            this.recordActualCallable((IrDeclarationWithName)element, AdditionalIrUtilsKt.getCallableId((IrFunction)element));
        }
    }

    private final void recordActualCallable(IrDeclarationWithName callableDeclaration, CallableId callableId) {
        if (callableId.getClassId() == null) {
            List list2;
            Map<CallableId, List<IrSymbol>> $this$getOrPut$iv = this.actualTopLevels;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(callableId);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(callableId, answer$iv);
                list2 = answer$iv;
            } else {
                list2 = value$iv;
            }
            list2.add((IrSymbol)callableDeclaration.getSymbol());
            this.actualSymbolsToFile.put(callableDeclaration.getSymbol(), this.currentFile);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector$Companion;", "", "<init>", "()V", "collectActualsFromFragments", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "fragments", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassActualizationInfo collectActualsFromFragments(@NotNull List<? extends IrModuleFragment> fragments2) {
            Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
            ActualDeclarationsCollector collector2 = new ActualDeclarationsCollector();
            for (IrModuleFragment irModuleFragment : fragments2) {
                collector2.collect(irModuleFragment);
            }
            return new ClassActualizationInfo(collector2.actualClasses, collector2.actualTypeAliasesWithoutExpansion, collector2.actualTopLevels, collector2.actualSymbolsToFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

