/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ConflictingJvmDeclarationsData;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.MemberKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.RawSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0012\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\nH\u0002J\u0006\u0010\u001e\u001a\u00020\u000eJ\b\u0010\u001f\u001a\u00020\u000eH\u0002J\b\u0010 \u001a\u00020\u000eH\u0002J\b\u0010!\u001a\u00020\u000eH\u0002J,\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020%H\u0002J\u001e\u0010*\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector;", "", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "methodsBySignature", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/RawSignature;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "fieldsBySignature", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "trackField", "", "irField", "rawSignature", "trackMethod", "irFunction", "trackFakeOverrideMethod", "mapRawSignature", "getOverriddenFunctions", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "collectOverridesOf", "result", "collectOverridesTree", "visited", "isSpecialOverride", "", "reportErrors", "reportMethodSignatureConflicts", "reportPredefinedMethodSignatureConflicts", "reportFieldSignatureConflicts", "reportJvmSignatureClash", "diagnosticFactory1", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/ConflictingJvmDeclarationsData;", "irDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "conflictingJvmDeclarationsData", "getConflictingJvmDeclarationsData", "methods", "Companion", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nJvmSignatureClashDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSignatureClashDetector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n372#2,7:187\n372#2,7:194\n1774#3,4:201\n1774#3,4:205\n1747#3,3:209\n766#3:212\n857#3,2:213\n766#3:215\n857#3,2:216\n1549#3:218\n1620#3,3:219\n1620#3,2:222\n1622#3:225\n1855#3,2:226\n1549#3:228\n1620#3,3:229\n1#4:224\n*S KotlinDebug\n*F\n+ 1 JvmSignatureClashDetector.kt\norg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector\n*L\n30#1:187,7\n34#1:194,7\n82#1:201,4\n83#1:205,4\n102#1:209,3\n116#1:212\n116#1:213,2\n127#1:215\n127#1:216,2\n130#1:218\n130#1:219,3\n149#1:222,2\n149#1:225\n153#1:226,2\n163#1:228\n163#1:229,3\n*E\n"})
public final class JvmSignatureClashDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassCodegen classCodegen;
    @NotNull
    private final LinkedHashMap<RawSignature, Set<IrFunction>> methodsBySignature;
    @NotNull
    private final LinkedHashMap<RawSignature, Set<IrField>> fieldsBySignature;
    @NotNull
    private static final Set<IrDeclarationOriginImpl> SPECIAL_BRIDGES_AND_OVERRIDES;
    @NotNull
    private static final List<RawSignature> PREDEFINED_SIGNATURES;

    public JvmSignatureClashDetector(@NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter((Object)classCodegen, (String)"classCodegen");
        this.classCodegen = classCodegen;
        this.methodsBySignature = new LinkedHashMap();
        this.fieldsBySignature = new LinkedHashMap();
    }

    public final void trackField(@NotNull IrField irField, @NotNull RawSignature rawSignature) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)irField, (String)"irField");
        Intrinsics.checkNotNullParameter((Object)rawSignature, (String)"rawSignature");
        Map $this$getOrPut$iv = this.fieldsBySignature;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(rawSignature);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = (Set)((Object)SmartSet.Companion.create());
            $this$getOrPut$iv.put(rawSignature, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(irField);
    }

    public final void trackMethod(@NotNull IrFunction irFunction2, @NotNull RawSignature rawSignature) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)rawSignature, (String)"rawSignature");
        Map $this$getOrPut$iv = this.methodsBySignature;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(rawSignature);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = (Set)((Object)SmartSet.Companion.create());
            $this$getOrPut$iv.put(rawSignature, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(irFunction2);
    }

    public final void trackFakeOverrideMethod(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        if (irFunction2.getDispatchReceiverParameter() != null) {
            for (IrFunction overriddenFunction : this.getOverriddenFunctions((IrSimpleFunction)irFunction2)) {
                if (IrFakeOverrideUtilsKt.isFakeOverride(overriddenFunction)) continue;
                this.trackMethod(irFunction2, this.mapRawSignature(overriddenFunction));
            }
        } else {
            this.trackMethod(irFunction2, this.mapRawSignature(irFunction2));
        }
    }

    private final RawSignature mapRawSignature(IrFunction irFunction2) {
        JvmMethodSignature jvmSignature = this.classCodegen.getMethodSignatureMapper().mapFakeOverrideSignatureSkipGeneric(irFunction2);
        String string2 = jvmSignature.getAsmMethod().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = jvmSignature.getAsmMethod().getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDescriptor(...)");
        return new RawSignature(string2, string3, MemberKind.METHOD);
    }

    private final Set<IrFunction> getOverriddenFunctions(IrSimpleFunction irFunction2) {
        LinkedHashSet result2 = new LinkedHashSet();
        this.collectOverridesOf(irFunction2, result2);
        return result2;
    }

    private final void collectOverridesOf(IrSimpleFunction irFunction2, Set<IrFunction> result2) {
        for (IrSimpleFunctionSymbol overriddenSymbol : irFunction2.getOverriddenSymbols()) {
            this.collectOverridesTree((IrSimpleFunction)overriddenSymbol.getOwner(), result2);
        }
    }

    private final void collectOverridesTree(IrSimpleFunction irFunction2, Set<IrFunction> visited2) {
        if (!visited2.add(irFunction2)) {
            return;
        }
        this.collectOverridesOf(irFunction2, visited2);
    }

    private final boolean isSpecialOverride(IrFunction $this$isSpecialOverride) {
        return CollectionsKt.contains((Iterable)SPECIAL_BRIDGES_AND_OVERRIDES, (Object)$this$isSpecialOverride.getOrigin());
    }

    public final void reportErrors() {
        this.reportMethodSignatureConflicts();
        this.reportPredefinedMethodSignatureConflicts();
        this.reportFieldSignatureConflicts();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportMethodSignatureConflicts() {
        for (Map.Entry entry : ((Map)this.methodsBySignature).entrySet()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable $this$any$iv;
            Object element$iv;
            int n;
            int n2;
            RawSignature rawSignature = (RawSignature)entry.getKey();
            Set methods2 = (Set)entry.getValue();
            if (methods2.size() <= 1) continue;
            Iterable $this$count$iv = methods2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    IrFunction it = (IrFunction)element$iv2;
                    boolean bl = false;
                    if (!IrFakeOverrideUtilsKt.isFakeOverride(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int fakeOverridesCount = n2;
            Iterable $this$count$iv2 = methods2;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n = 0;
            } else {
                Object element$iv2;
                int count$iv = 0;
                element$iv2 = $this$count$iv2.iterator();
                while (element$iv2.hasNext()) {
                    element$iv = element$iv2.next();
                    IrFunction it = (IrFunction)element$iv;
                    boolean bl = false;
                    if (!this.isSpecialOverride(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int specialOverridesCount = n;
            int realMethodsCount = methods2.size() - fakeOverridesCount - specialOverridesCount;
            ConflictingJvmDeclarationsData conflictingJvmDeclarationsData = this.getConflictingJvmDeclarationsData(rawSignature, methods2);
            if (realMethodsCount == 0 && (fakeOverridesCount > 1 || specialOverridesCount > 1)) {
                if (Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE)) continue;
                this.reportJvmSignatureClash(JvmBackendErrors.INSTANCE.getCONFLICTING_INHERITED_JVM_DECLARATIONS(), CollectionsKt.listOf((Object)this.classCodegen.getIrClass()), conflictingJvmDeclarationsData);
                continue;
            }
            if (fakeOverridesCount == 0 && specialOverridesCount == 0) {
                if (Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE)) {
                    boolean bl;
                    block14: {
                        $this$any$iv = methods2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv3 : $this$any$iv) {
                                IrFunction it = (IrFunction)element$iv3;
                                boolean bl2 = false;
                                if (!DescriptorVisibilities.isPrivate(it.getVisibility())) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                }
                this.reportJvmSignatureClash(JvmBackendErrors.INSTANCE.getCONFLICTING_JVM_DECLARATIONS(), methods2, conflictingJvmDeclarationsData);
                continue;
            }
            if (Intrinsics.areEqual((Object)this.classCodegen.getIrClass().getOrigin(), (Object)JvmLoweredDeclarationOrigin.DEFAULT_IMPLS.INSTANCE)) continue;
            $this$any$iv = methods2;
            KtDiagnosticFactory1<ConflictingJvmDeclarationsData> ktDiagnosticFactory1 = JvmBackendErrors.INSTANCE.getACCIDENTAL_OVERRIDE();
            JvmSignatureClashDetector jvmSignatureClashDetector = this;
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!(!IrFakeOverrideUtilsKt.isFakeOverride(it) && !this.isSpecialOverride(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            jvmSignatureClashDetector.reportJvmSignatureClash(ktDiagnosticFactory1, list2, conflictingJvmDeclarationsData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportPredefinedMethodSignatureConflicts() {
        for (RawSignature predefinedSignature : PREDEFINED_SIGNATURES) {
            String string2;
            Collection<FunctionDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Set<IrFunction> knownMethods;
            if (this.methodsBySignature.get(predefinedSignature) == null) continue;
            Iterable $this$filter$iv = knownMethods;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!(!IrFakeOverrideUtilsKt.isFakeOverride(it) && !this.isSpecialOverride(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List methods2 = (List)destination$iv$iv;
            if (methods2.isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)this.classCodegen.getType().getInternalName(), (String)"getInternalName(...)");
            Iterable $i$f$filter22 = methods2;
            Collection<? extends JvmDeclarationOrigin> collection2 = null;
            RawSignature rawSignature = predefinedSignature;
            JvmDeclarationOrigin jvmDeclarationOrigin = null;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IrFunction bl = (IrFunction)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(IrBasedDescriptorsKt.toIrBasedDescriptor((IrFunction)p0));
            }
            collection = (List)destination$iv$iv2;
            Collection collection3 = collection;
            Collection<? extends JvmDeclarationOrigin> collection4 = collection2;
            RawSignature rawSignature2 = rawSignature;
            JvmDeclarationOrigin jvmDeclarationOrigin2 = jvmDeclarationOrigin;
            String string3 = string2;
            ConflictingJvmDeclarationsData conflictingJvmDeclarationsData = new ConflictingJvmDeclarationsData(string3, jvmDeclarationOrigin2, rawSignature2, collection4, collection3);
            this.reportJvmSignatureClash(JvmBackendErrors.INSTANCE.getACCIDENTAL_OVERRIDE(), methods2, conflictingJvmDeclarationsData);
        }
    }

    private final void reportFieldSignatureConflicts() {
        for (Map.Entry entry : ((Map)this.fieldsBySignature).entrySet()) {
            RawSignature rawSignature = (RawSignature)entry.getKey();
            Set fields2 = (Set)entry.getValue();
            if (fields2.size() <= 1) continue;
            ConflictingJvmDeclarationsData conflictingJvmDeclarationsData = this.getConflictingJvmDeclarationsData(rawSignature, fields2);
            this.reportJvmSignatureClash(JvmBackendErrors.INSTANCE.getCONFLICTING_JVM_DECLARATIONS(), fields2, conflictingJvmDeclarationsData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportJvmSignatureClash(KtDiagnosticFactory1<ConflictingJvmDeclarationsData> diagnosticFactory1, Collection<? extends IrDeclaration> irDeclarations2, ConflictingJvmDeclarationsData conflictingJvmDeclarationsData) {
        void $this$forEach$iv;
        Iterable $this$mapTo$iv;
        Iterable iterable = irDeclarations2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void irDeclaration2;
            void var11_14;
            IrDeclaration irDeclaration3 = (IrDeclaration)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            void it = var11_14 = irDeclaration2;
            boolean bl2 = false;
            Object object = !(it.getStartOffset() < 0) ? var11_14 : null;
            if (object == null) {
                object = this.classCodegen.getIrClass();
            }
            IrDeclaration reportOn = object;
            collection.add(this.classCodegen.getContext().getKtDiagnosticReporter().at(UtilsKt.sourceElement(reportOn), reportOn, IrUtilsKt.getFile((IrDeclaration)irDeclaration2)));
        }
        $this$mapTo$iv = destination$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDiagnosticReporterWithContext.DiagnosticContextImpl it = (KtDiagnosticReporterWithContext.DiagnosticContextImpl)element$iv;
            boolean bl = false;
            it.report(diagnosticFactory1, conflictingJvmDeclarationsData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ConflictingJvmDeclarationsData getConflictingJvmDeclarationsData(RawSignature rawSignature, Collection<? extends IrDeclaration> methods2) {
        Collection<DeclarationDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string2 = this.classCodegen.getType().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        Iterable iterable = methods2;
        Collection<? extends JvmDeclarationOrigin> collection2 = null;
        RawSignature rawSignature2 = rawSignature;
        JvmDeclarationOrigin jvmDeclarationOrigin = null;
        String string3 = string2;
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IrBasedDescriptorsKt.toIrBasedDescriptor((IrDeclaration)p0));
        }
        collection = (List)destination$iv$iv;
        Collection collection3 = collection;
        Collection<? extends JvmDeclarationOrigin> collection4 = collection2;
        RawSignature rawSignature3 = rawSignature2;
        JvmDeclarationOrigin jvmDeclarationOrigin2 = jvmDeclarationOrigin;
        String string4 = string3;
        return new ConflictingJvmDeclarationsData(string4, jvmDeclarationOrigin2, rawSignature3, collection4, collection3);
    }

    static {
        Object[] objectArray = new IrDeclarationOriginImpl[]{IrDeclarationOrigin.BRIDGE.INSTANCE, IrDeclarationOrigin.BRIDGE_SPECIAL.INSTANCE, IrDeclarationOrigin.IR_BUILTINS_STUB.INSTANCE, JvmLoweredDeclarationOrigin.TO_ARRAY.INSTANCE, JvmLoweredDeclarationOrigin.SUPER_INTERFACE_METHOD_BRIDGE.INSTANCE, AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION()};
        SPECIAL_BRIDGES_AND_OVERRIDES = SetsKt.setOf((Object[])objectArray);
        objectArray = new RawSignature[]{new RawSignature("getClass", "()Ljava/lang/Class;", MemberKind.METHOD), new RawSignature("notify", "()V", MemberKind.METHOD), new RawSignature("notifyAll", "()V", MemberKind.METHOD), new RawSignature("wait", "()V", MemberKind.METHOD), new RawSignature("wait", "(J)V", MemberKind.METHOD), new RawSignature("wait", "(JI)V", MemberKind.METHOD)};
        PREDEFINED_SIGNATURES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/JvmSignatureClashDetector$Companion;", "", "<init>", "()V", "SPECIAL_BRIDGES_AND_OVERRIDES", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getSPECIAL_BRIDGES_AND_OVERRIDES", "()Ljava/util/Set;", "PREDEFINED_SIGNATURES", "", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/RawSignature;", "getPREDEFINED_SIGNATURES", "()Ljava/util/List;", "backend.jvm.codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<IrDeclarationOriginImpl> getSPECIAL_BRIDGES_AND_OVERRIDES() {
            return SPECIAL_BRIDGES_AND_OVERRIDES;
        }

        @NotNull
        public final List<RawSignature> getPREDEFINED_SIGNATURES() {
            return PREDEFINED_SIGNATURES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

