/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/OrOr;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "BooleanDisjunction", "backend.jvm.codegen"})
public final class OrOr
extends IntrinsicMethod {
    @NotNull
    public static final OrOr INSTANCE = new OrOr();

    private OrOr() {
    }

    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        List<IrExpression> list2 = JvmIrUtilsKt.receiverAndArgs(expression2);
        IrExpression left = list2.get(0);
        IrExpression right = list2.get(1);
        return new BooleanDisjunction(left, right, codegen2, data2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/OrOr$BooleanDisjunction;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "arg0", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "arg1", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;)V", "getArg0", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getArg1", "getData", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "jumpIfFalse", "", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "discard", "backend.jvm.codegen"})
    private static final class BooleanDisjunction
    extends BooleanValue {
        @NotNull
        private final IrExpression arg0;
        @NotNull
        private final IrExpression arg1;
        @NotNull
        private final BlockInfo data;

        public BooleanDisjunction(@NotNull IrExpression arg0, @NotNull IrExpression arg1, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
            Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
            Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            super(codegen2);
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.data = data2;
        }

        @NotNull
        public final IrExpression getArg0() {
            return this.arg0;
        }

        @NotNull
        public final IrExpression getArg1() {
            return this.arg1;
        }

        @NotNull
        public final BlockInfo getData() {
            return this.data;
        }

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Label stayLabel = new Label();
            PromisedValueKt.coerceToBoolean((PromisedValue)this.arg0.accept(this.getCodegen(), this.data)).jumpIfTrue(stayLabel);
            PromisedValueKt.coerceToBoolean((PromisedValue)this.arg1.accept(this.getCodegen(), this.data)).jumpIfFalse(target);
            this.getMv().visitLabel(stayLabel);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            PromisedValueKt.coerceToBoolean((PromisedValue)this.arg0.accept(this.getCodegen(), this.data)).jumpIfTrue(target);
            PromisedValueKt.coerceToBoolean((PromisedValue)this.arg1.accept(this.getCodegen(), this.data)).jumpIfTrue(target);
        }

        @Override
        public void discard() {
            Label end = new Label();
            PromisedValueKt.coerceToBoolean((PromisedValue)this.arg0.accept(this.getCodegen(), this.data)).jumpIfTrue(end);
            ((PromisedValue)this.arg1.accept(this.getCodegen(), this.data)).discard();
            this.getMv().visitLabel(end);
        }
    }
}

