/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.jvm.CachedSyntheticDeclarations;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocatorKt;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineScopeResolver;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.SyntheticAccessorLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0082\b\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u001d*\u0002H\u0018H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u0016*\u00020 2\u0006\u0010!\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010#H\u0002J\u0016\u0010,\u001a\u00020\u0016*\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010#H\u0002J\u0010\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020%2\u0006\u0010&\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020%2\u0006\u0010&\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020%2\u0006\u0010&\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020\u001dH\u0002J\u0010\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0=H\u0002J\u0018\u0010?\u001a\u00020*2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020*2\u0006\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020@H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "pendingAccessorsToAdd", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Ljava/util/Set;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getPendingAccessorsToAdd", "()Ljava/util/Set;", "accessorGenerator", "Lorg/jetbrains/kotlin/backend/jvm/CachedSyntheticDeclarations;", "inlineScopeResolver", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrInlineScopeResolver;", "processingIrInlinedFun", "", "withinIrInlinedFun", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "save", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;)Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "isAccessible", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "withSuper", "thisObjReference", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "handleLambdaMetafactoryIntrinsic", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "thisSymbol", "isAccessibleFromSyntheticProxy", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "modifyFunctionAccessExpression", "oldExpression", "accessorSymbol", "createAccessorMarkerArgument", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "modifyGetterExpression", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "modifySetterExpression", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nSyntheticAccessorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorTransformer\n+ 2 IrElementTransformerVoidWithContext.kt\norg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,389:1\n110#1,4:390\n115#1:402\n47#2,2:394\n47#2,4:396\n49#2,2:400\n1864#3,3:403\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/SyntheticAccessorTransformer\n*L\n294#1:390,4\n294#1:402\n295#1:394,2\n296#1:396,4\n295#1:400,2\n333#1:403,3\n*E\n"})
final class SyntheticAccessorTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final Set<IrFunction> pendingAccessorsToAdd;
    @NotNull
    private final CachedSyntheticDeclarations accessorGenerator;
    @NotNull
    private final IrInlineScopeResolver inlineScopeResolver;
    private boolean processingIrInlinedFun;

    public SyntheticAccessorTransformer(@NotNull JvmBackendContext context2, @NotNull IrFile irFile, @NotNull Set<IrFunction> pendingAccessorsToAdd) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter(pendingAccessorsToAdd, (String)"pendingAccessorsToAdd");
        this.context = context2;
        this.irFile = irFile;
        this.pendingAccessorsToAdd = pendingAccessorsToAdd;
        this.accessorGenerator = this.context.getCachedDeclarations().getSyntheticAccessorGenerator();
        this.inlineScopeResolver = IrInlineReferenceLocatorKt.findInlineCallSites(this.irFile, this.context);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final Set<IrFunction> getPendingAccessorsToAdd() {
        return this.pendingAccessorsToAdd;
    }

    private final <T extends IrFunctionSymbol> T save(T $this$save) {
        boolean bl;
        boolean bl2 = bl = Intrinsics.areEqual((Object)IrUtilsKt.getFileOrNull($this$save.getOwner()), (Object)this.irFile) || this.processingIrInlinedFun;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "SyntheticAccessorLowering should not attempt to modify other files!\nWhile lowering this file: " + RenderIrElementKt.render$default(this.irFile, null, 1, null) + "\nTrying to add this accessor: " + RenderIrElementKt.render$default($this$save.getOwner(), null, 1, null);
            throw new AssertionError((Object)string2);
        }
        if (Intrinsics.areEqual((Object)IrUtilsKt.getFileOrNull($this$save.getOwner()), (Object)this.irFile)) {
            ((Collection)this.pendingAccessorsToAdd).add($this$save.getOwner());
        }
        return $this$save;
    }

    private final boolean isAccessible(IrSymbol $this$isAccessible, boolean withSuper, IrClassSymbol thisObjReference) {
        SyntheticAccessorLowering.Companion $this$isAccessible_u24lambda_u241 = SyntheticAccessorLowering.Companion;
        boolean bl = false;
        return SyntheticAccessorLowering.Companion.isAccessible$default($this$isAccessible_u24lambda_u241, $this$isAccessible, this.context, this.getCurrentScope(), this.inlineScopeResolver, withSuper, thisObjReference, false, 32, null);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrFunctionSymbol irFunctionSymbol;
        IrClassSymbol thisSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (IrUtilsKt.usesDefaultArguments(expression2)) {
            return super.visitFunctionAccess(expression2);
        }
        IrFunction callee = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        boolean withSuper = (irCall != null ? irCall.getSuperQualifierSymbol() : null) != null;
        Object object = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        IrClassifierSymbol irClassifierSymbol = object != null && (object = ((IrMemberAccessExpression)object).getDispatchReceiver()) != null && (object = ((IrExpression)object).getType()) != null ? IrTypesKt.getClassifierOrNull((IrType)object) : null;
        IrClassSymbol irClassSymbol = thisSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (expression2 instanceof IrCall && Intrinsics.areEqual((Object)callee.getSymbol(), (Object)this.context.getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic())) {
            return super.visitExpression(this.handleLambdaMetafactoryIntrinsic((IrCall)expression2, thisSymbol));
        }
        if (callee instanceof IrConstructor && this.accessorGenerator.isOrShouldBeHiddenAsSealedClassConstructor((IrConstructor)callee)) {
            irFunctionSymbol = this.accessorGenerator.getSyntheticConstructorOfSealedClass((IrConstructor)callee).getSymbol();
        } else if (callee instanceof IrConstructor && this.accessorGenerator.isOrShouldBeHiddenSinceHasMangledParams((IrConstructor)callee)) {
            irFunctionSymbol = this.accessorGenerator.getSyntheticConstructorWithMangledParams((IrConstructor)callee).getSymbol();
        } else if (!this.isAccessible((IrSymbol)expression2.getSymbol(), withSuper, thisSymbol)) {
            irFunctionSymbol = this.save(this.accessorGenerator.getSyntheticFunctionAccessor(expression2, this.getAllScopes()));
        } else {
            return super.visitFunctionAccess(expression2);
        }
        IrFunctionSymbol accessor = irFunctionSymbol;
        return super.visitExpression(this.modifyFunctionAccessExpression(expression2, accessor));
    }

    private final IrExpression handleLambdaMetafactoryIntrinsic(IrCall call2, IrClassSymbol thisSymbol) {
        IrExpression irExpression = call2.getValueArgument(1);
        IrFunctionReference irFunctionReference = irExpression instanceof IrFunctionReference ? (IrFunctionReference)irExpression : null;
        if (irFunctionReference == null) {
            throw new AssertionError((Object)("'implMethodReference' is expected to be 'IrFunctionReference': " + DumpIrTreeKt.dump$default(call2, null, 1, null)));
        }
        IrFunctionReference implFunRef = irFunctionReference;
        IrFunctionSymbol implFunSymbol = (IrFunctionSymbol)implFunRef.getSymbol();
        if (this.isAccessibleFromSyntheticProxy(implFunSymbol, thisSymbol)) {
            return call2;
        }
        IrFunctionSymbol accessorSymbol = this.save(this.accessorGenerator.getSyntheticFunctionAccessor(implFunRef, this.getAllScopes()));
        IrFunction accessorFun = accessorSymbol.getOwner();
        IrFunctionReferenceImpl accessorRef = new IrFunctionReferenceImpl(implFunRef.getStartOffset(), implFunRef.getEndOffset(), implFunRef.getType(), accessorSymbol, accessorFun.getTypeParameters().size(), accessorFun.getValueParameters().size(), implFunRef.getReflectionTarget(), implFunRef.getOrigin());
        IrExpressionsKt.copyTypeArgumentsFrom$default(accessorRef, implFunRef, 0, 2, null);
        IrFunction implFun = implFunSymbol.getOwner();
        int accessorArgIndex = 0;
        if (implFun.getDispatchReceiverParameter() != null) {
            accessorRef.putValueArgument(accessorArgIndex++, implFunRef.getDispatchReceiver());
        }
        if (implFun.getExtensionReceiverParameter() != null) {
            accessorRef.putValueArgument(accessorArgIndex++, implFunRef.getExtensionReceiver());
        }
        int n = implFunRef.getValueArgumentsCount();
        for (int implArgIndex = 0; implArgIndex < n; ++implArgIndex) {
            accessorRef.putValueArgument(accessorArgIndex++, implFunRef.getValueArgument(implArgIndex));
        }
        if (accessorFun instanceof IrConstructor) {
            accessorRef.putValueArgument(accessorArgIndex, this.createAccessorMarkerArgument());
        }
        call2.putValueArgument(1, accessorRef);
        return call2;
    }

    private final boolean isAccessibleFromSyntheticProxy(IrFunctionSymbol $this$isAccessibleFromSyntheticProxy, IrClassSymbol thisSymbol) {
        if (!this.isAccessible($this$isAccessibleFromSyntheticProxy, false, thisSymbol)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$isAccessibleFromSyntheticProxy.getOwner().getVisibility(), (Object)DescriptorVisibilities.PROTECTED) && !Intrinsics.areEqual((Object)$this$isAccessibleFromSyntheticProxy.getOwner().getVisibility(), (Object)JavaDescriptorVisibilities.PROTECTED_STATIC_VISIBILITY)) {
            return true;
        }
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return Intrinsics.areEqual((Object)this.inlineScopeResolver.findContainer(scopeWithIr.getIrElement()), (Object)IrUtilsKt.getParentAsClass($this$isAccessibleFromSyntheticProxy.getOwner()));
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        IrClassSymbol dispatchReceiverClassSymbol;
        IrType dispatchReceiverType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrExpression irExpression = expression2.getReceiver();
        IrType irType = dispatchReceiverType = irExpression != null ? irExpression.getType() : null;
        IrClassifierSymbol irClassifierSymbol = irType != null ? IrTypesKt.getClassifierOrNull(irType) : null;
        IrClassSymbol irClassSymbol = dispatchReceiverClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (this.isAccessible(expression2.getSymbol(), false, dispatchReceiverClassSymbol)) {
            return super.visitExpression(expression2);
        }
        return super.visitExpression(this.modifyGetterExpression(expression2, (IrSimpleFunctionSymbol)this.save((IrFunctionSymbol)this.accessorGenerator.getSyntheticGetter(expression2, this.getAllScopes()))));
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        IrClassSymbol dispatchReceiverClassSymbol;
        IrType dispatchReceiverType;
        IrProperty correspondingProperty2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        IrProperty irProperty2 = correspondingProperty2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
        if (correspondingProperty2 != null && !correspondingProperty2.isVar()) {
            return super.visitExpression(expression2);
        }
        IrExpression irExpression = expression2.getReceiver();
        IrType irType = dispatchReceiverType = irExpression != null ? irExpression.getType() : null;
        IrClassifierSymbol irClassifierSymbol = irType != null ? IrTypesKt.getClassifierOrNull(irType) : null;
        IrClassSymbol irClassSymbol = dispatchReceiverClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (this.isAccessible(expression2.getSymbol(), false, dispatchReceiverClassSymbol)) {
            return super.visitExpression(expression2);
        }
        return super.visitExpression(this.modifySetterExpression(expression2, (IrSimpleFunctionSymbol)this.save((IrFunctionSymbol)this.accessorGenerator.getSyntheticSetter(expression2, this.getAllScopes()))));
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.accessorGenerator.isOrShouldBeHiddenSinceHasMangledParams(declaration)) {
            this.save((IrFunctionSymbol)this.accessorGenerator.getSyntheticConstructorWithMangledParams(declaration).getSymbol());
            declaration.setVisibility(DescriptorVisibilities.PRIVATE);
        } else if (this.accessorGenerator.isOrShouldBeHiddenAsSealedClassConstructor(declaration)) {
            this.save((IrFunctionSymbol)this.accessorGenerator.getSyntheticConstructorOfSealedClass(declaration).getSymbol());
            declaration.setVisibility(DescriptorVisibilities.PRIVATE);
        }
        return super.visitConstructor(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        if (!IrUtilsKt.isLambda(expression2.getOrigin()) && function2 instanceof IrConstructor) {
            IrConstructor irConstructor2;
            if (this.accessorGenerator.isOrShouldBeHiddenSinceHasMangledParams((IrConstructor)function2)) {
                irConstructor2 = this.accessorGenerator.getSyntheticConstructorWithMangledParams((IrConstructor)function2);
            } else if (this.accessorGenerator.isOrShouldBeHiddenAsSealedClassConstructor((IrConstructor)function2)) {
                irConstructor2 = this.accessorGenerator.getSyntheticConstructorOfSealedClass((IrConstructor)function2);
            } else {
                return super.visitFunctionReference(expression2);
            }
            IrConstructor generatedAccessor = irConstructor2;
            this.transformChildrenVoid(expression2);
            return new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), generatedAccessor.getSymbol(), generatedAccessor.getTypeParameters().size(), generatedAccessor.getValueParameters().size(), generatedAccessor.getSymbol(), expression2.getOrigin());
        }
        return super.visitFunctionReference(expression2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2 instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)expression2)) {
            IrExpression irExpression;
            IrDeclaration callee = IrInlineUtilsKt.getInlineDeclaration((IrInlinedFunctionBlock)expression2);
            IrClass irClass2 = IrUtilsKt.getParentClassOrNull(callee);
            if (irClass2 == null) {
                return super.visitBlock(expression2);
            }
            IrClass parentClass = irClass2;
            SyntheticAccessorTransformer this_$iv = this;
            boolean $i$f$withinIrInlinedFun = false;
            boolean oldProcessingInline$iv = this_$iv.processingIrInlinedFun;
            try {
                this_$iv.processingIrInlinedFun = true;
                boolean bl = false;
                IrElementTransformerVoidWithContext this_$iv2 = this;
                boolean $i$f$withinScope = false;
                IrElementTransformerVoidWithContext.access$unsafeEnterScope(this_$iv2, parentClass);
                boolean bl2 = false;
                IrElementTransformerVoidWithContext this_$iv3 = this;
                boolean $i$f$withinScope2 = false;
                IrElementTransformerVoidWithContext.access$unsafeEnterScope(this_$iv3, callee);
                boolean bl3 = false;
                IrExpression result$iv = super.visitBlock(expression2);
                IrElementTransformerVoidWithContext.access$unsafeLeaveScope(this_$iv3);
                IrExpression result$iv2 = result$iv;
                IrElementTransformerVoidWithContext.access$unsafeLeaveScope(this_$iv2);
                irExpression = result$iv2;
            }
            finally {
                this_$iv.processingIrInlinedFun = oldProcessingInline$iv;
            }
            return irExpression;
        }
        return super.visitBlock(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunctionAccessExpression modifyFunctionAccessExpression(IrFunctionAccessExpression oldExpression, IrFunctionSymbol accessorSymbol) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression irFunctionAccessExpression2 = oldExpression;
        if (irFunctionAccessExpression2 instanceof IrCall) {
            int n = ((IrCall)oldExpression).getStartOffset();
            int n2 = ((IrCall)oldExpression).getEndOffset();
            IrType irType = ((IrCall)oldExpression).getType();
            Intrinsics.checkNotNull((Object)accessorSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol");
            irFunctionAccessExpression = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, n, n2, irType, (IrSimpleFunctionSymbol)accessorSymbol, ((IrCall)oldExpression).getTypeArgumentsCount(), 0, ((IrCall)oldExpression).getOrigin(), null, 160, null);
        } else if (irFunctionAccessExpression2 instanceof IrDelegatingConstructorCall) {
            int n = ((IrDelegatingConstructorCall)oldExpression).getStartOffset();
            int n3 = ((IrDelegatingConstructorCall)oldExpression).getEndOffset();
            IrType irType = this.context.getIrBuiltIns().getUnitType();
            Intrinsics.checkNotNull((Object)accessorSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
            irFunctionAccessExpression = IrDelegatingConstructorCallImpl.Companion.fromSymbolOwner$default(IrDelegatingConstructorCallImpl.Companion, n, n3, irType, (IrConstructorSymbol)accessorSymbol, ((IrDelegatingConstructorCall)oldExpression).getTypeArgumentsCount(), 0, 32, null);
        } else if (irFunctionAccessExpression2 instanceof IrConstructorCall) {
            int n = ((IrConstructorCall)oldExpression).getStartOffset();
            int n4 = ((IrConstructorCall)oldExpression).getEndOffset();
            IrType irType = ((IrConstructorCall)oldExpression).getType();
            Intrinsics.checkNotNull((Object)accessorSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol");
            irFunctionAccessExpression = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, n, n4, irType, (IrConstructorSymbol)accessorSymbol, null, 16, null);
        } else {
            throw new IllegalStateException(("Unexpected IrFunctionAccessExpression: " + oldExpression).toString());
        }
        IrFunctionAccessExpression newExpression = irFunctionAccessExpression;
        IrExpressionsKt.copyTypeArgumentsFrom$default(newExpression, oldExpression, 0, 2, null);
        List<IrExpression> receiverAndArgs = JvmIrUtilsKt.receiverAndArgs(oldExpression);
        Iterable $this$forEachIndexed$iv = receiverAndArgs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void irExpression;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrExpression irExpression2 = (IrExpression)item$iv;
            int i = n;
            boolean bl = false;
            newExpression.putValueArgument(i, (IrExpression)irExpression);
        }
        if (accessorSymbol instanceof IrConstructorSymbol) {
            newExpression.putValueArgument(receiverAndArgs.size(), this.createAccessorMarkerArgument());
        }
        return newExpression;
    }

    private final IrConstImpl createAccessorMarkerArgument() {
        return IrConstImpl.Companion.constNull(-1, -1, IrTypesKt.makeNullable(IrTypesKt.getDefaultType(this.context.getIr().getSymbols().getDefaultConstructorMarker())));
    }

    private final IrCall modifyGetterExpression(IrGetField oldExpression, IrSimpleFunctionSymbol accessorSymbol) {
        IrCallImpl call2;
        block0: {
            call2 = new IrCallImpl(oldExpression.getStartOffset(), oldExpression.getEndOffset(), oldExpression.getType(), accessorSymbol, 0, ((IrSimpleFunction)accessorSymbol.getOwner()).getValueParameters().size(), oldExpression.getOrigin(), null, 128, null);
            IrExpression irExpression = oldExpression.getReceiver();
            if (irExpression == null) break block0;
            IrExpression it = irExpression;
            boolean bl = false;
            call2.putValueArgument(0, oldExpression.getReceiver());
        }
        return call2;
    }

    private final IrCall modifySetterExpression(IrSetField oldExpression, IrSimpleFunctionSymbol accessorSymbol) {
        IrCallImpl call2 = new IrCallImpl(oldExpression.getStartOffset(), oldExpression.getEndOffset(), oldExpression.getType(), accessorSymbol, 0, ((IrSimpleFunction)accessorSymbol.getOwner()).getValueParameters().size(), oldExpression.getOrigin(), null, 128, null);
        IrExpression irExpression = oldExpression.getReceiver();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            call2.putValueArgument(0, oldExpression.getReceiver());
        }
        call2.putValueArgument(call2.getValueArgumentsCount() - 1, oldExpression.getValue());
        return call2;
    }
}

