/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.backend.js.JsCommonInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/utils/WasmInlineClassesUtils;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;)V", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassInlineLike", "", "klass", "boxIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getBoxIntrinsic", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "unboxIntrinsic", "getUnboxIntrinsic", "backend.wasm"})
public final class WasmInlineClassesUtils
implements JsCommonInlineClassesUtils {
    @NotNull
    private final WasmSymbols wasmSymbols;

    public WasmInlineClassesUtils(@NotNull WasmSymbols wasmSymbols) {
        Intrinsics.checkNotNullParameter((Object)wasmSymbols, (String)"wasmSymbols");
        this.wasmSymbols = wasmSymbols;
    }

    @Override
    @Nullable
    public IrClass getInlinedClass(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (type2 instanceof IrSimpleType) {
            if (org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(type2)) {
                return null;
            }
            IrClass irClass2 = IrTypeUtilsKt.erase(type2);
            if (irClass2 == null) {
                return null;
            }
            IrClass erased = irClass2;
            if (this.isClassInlineLike(erased)) {
                return erased;
            }
        }
        return null;
    }

    @Override
    public boolean isClassInlineLike(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return JsCommonInlineClassesUtils.super.isClassInlineLike(klass) || AnnotationsKt.hasWasmAutoboxedAnnotation(klass);
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getBoxIntrinsic() {
        return this.wasmSymbols.getBoxIntrinsic();
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getUnboxIntrinsic() {
        return this.wasmSymbols.getUnboxIntrinsic();
    }
}

