/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Trinity;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0019\u001a\f0\u001aR\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0018\u0010\u001b\u001a\f0\u001aR\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001c\u001a\u00020\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/FrameMapBase;", "T", "", "<init>", "()V", "myVarIndex", "Lgnu/trove/TObjectIntHashMap;", "myVarSizes", "value", "", "currentSize", "getCurrentSize", "()I", "enter", "key", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/Object;Lorg/jetbrains/org/objectweb/asm/Type;)I", "leave", "(Ljava/lang/Object;)I", "enterTemp", "leaveTemp", "", "getIndex", "descriptor", "mark", "Lorg/jetbrains/kotlin/codegen/FrameMapBase$Mark;", "skipTo", "target", "toString", "", "Mark", "backend"})
@SourceDebugExtension(value={"SMAP\nFrameMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameMap.kt\norg/jetbrains/kotlin/codegen/FrameMapBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1002#2,2:130\n*S KotlinDebug\n*F\n+ 1 FrameMap.kt\norg/jetbrains/kotlin/codegen/FrameMapBase\n*L\n113#1:130,2\n*E\n"})
public class FrameMapBase<T> {
    @NotNull
    private final TObjectIntHashMap<T> myVarIndex = new TObjectIntHashMap();
    @NotNull
    private final TObjectIntHashMap<T> myVarSizes = new TObjectIntHashMap();
    private int currentSize;

    public final int getCurrentSize() {
        return this.currentSize;
    }

    public int enter(@NotNull T key, @NotNull Type type2) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        int index2 = this.currentSize;
        this.myVarIndex.put(key, index2);
        this.currentSize += type2.getSize();
        this.myVarSizes.put(key, type2.getSize());
        return index2;
    }

    public int leave(@NotNull T key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int size = this.myVarSizes.get(key);
        this.currentSize -= size;
        this.myVarSizes.remove(key);
        int oldIndex = this.myVarIndex.remove(key);
        if (oldIndex != this.currentSize) {
            throw new IllegalStateException("Descriptor can be left only if it is last: " + key);
        }
        return oldIndex;
    }

    public final int enterTemp(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        int result2 = this.currentSize;
        this.currentSize += type2.getSize();
        return result2;
    }

    public final void leaveTemp(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.currentSize -= type2.getSize();
    }

    public int getIndex(@NotNull T descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, (String)"descriptor");
        return this.myVarIndex.contains(descriptor2) ? this.myVarIndex.get(descriptor2) : -1;
    }

    @NotNull
    public final Mark mark() {
        return new Mark(this.currentSize);
    }

    @NotNull
    public final Mark skipTo(int target) {
        Mark mark2;
        Mark it = mark2 = this.mark();
        boolean bl = false;
        if (this.currentSize < target) {
            this.currentSize = target;
        }
        return mark2;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.myVarIndex.size() != this.myVarSizes.size()) {
            return "inconsistent";
        }
        ArrayList descriptors = Lists.newArrayList();
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.myVarIndex.keys());
        while (iterator2.hasNext()) {
            Object descriptor0 = iterator2.next();
            Intrinsics.checkNotNull(descriptor0, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.codegen.FrameMapBase");
            Object descriptor2 = descriptor0;
            int varIndex = this.myVarIndex.get(descriptor2);
            int varSize = this.myVarSizes.get(descriptor2);
            descriptors.add(Trinity.create(descriptor2, varIndex, varSize));
        }
        Intrinsics.checkNotNull(descriptors);
        List $this$sortBy$iv = descriptors;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Trinity left = (Trinity)a;
                    boolean bl = false;
                    left = (Trinity)b;
                    Comparable comparable = (Integer)left.second;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)left.second));
                }
            });
        }
        sb.append("size=").append(this.currentSize);
        boolean first = true;
        Iterator iterator3 = descriptors.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            Trinity t = (Trinity)iterator4.next();
            if (!first) {
                sb.append(", ");
            }
            first = false;
            StringBuilder stringBuilder2 = sb.append(t.first).append(",i=");
            Object b = t.second;
            Intrinsics.checkNotNullExpressionValue(b, (String)"second");
            StringBuilder stringBuilder3 = stringBuilder2.append(((Number)b).intValue()).append(",s=");
            Object c = t.third;
            Intrinsics.checkNotNullExpressionValue(c, (String)"third");
            stringBuilder3.append(((Number)c).intValue());
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/codegen/FrameMapBase$Mark;", "", "myIndex", "", "<init>", "(Lorg/jetbrains/kotlin/codegen/FrameMapBase;I)V", "dropTo", "", "backend"})
    public final class Mark {
        private final int myIndex;

        public Mark(int myIndex) {
            this.myIndex = myIndex;
        }

        public final void dropTo() {
            ArrayList<Object> descriptorsToDrop = new ArrayList<Object>();
            TObjectIntIterator iterator2 = FrameMapBase.this.myVarIndex.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                if (iterator2.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator2.key());
            }
            Iterator iterator3 = descriptorsToDrop.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Object declarationDescriptor;
                Intrinsics.checkNotNullExpressionValue(iterator4.next(), (String)"next(...)");
                FrameMapBase.this.myVarIndex.remove(declarationDescriptor);
                FrameMapBase.this.myVarSizes.remove(declarationDescriptor);
            }
            FrameMapBase.this.currentSize = this.myIndex;
        }
    }
}

