/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.forLoop;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.range.forLoop.AbstractForLoopGenerator;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/codegen/range/forLoop/ForInArrayLoopGenerator;", "Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "canCacheArrayLength", "", "shouldAlwaysStoreArrayInNewVar", "<init>", "(Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/psi/KtForExpression;ZZ)V", "indexVar", "", "arrayVar", "arrayLengthVar", "loopRangeType", "Lorg/jetbrains/kotlin/types/KotlinType;", "beforeLoop", "", "checkEmptyLoop", "loopExit", "Lorg/jetbrains/org/objectweb/asm/Label;", "checkPreCondition", "assignToLoopParameter", "checkPostConditionAndIncrement", "backend"})
public final class ForInArrayLoopGenerator
extends AbstractForLoopGenerator {
    private final boolean canCacheArrayLength;
    private final boolean shouldAlwaysStoreArrayInNewVar;
    private int indexVar;
    private int arrayVar;
    private int arrayLengthVar;
    @NotNull
    private final KotlinType loopRangeType;

    public ForInArrayLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression, boolean canCacheArrayLength, boolean shouldAlwaysStoreArrayInNewVar) {
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)forExpression, (String)"forExpression");
        super(codegen2, forExpression);
        this.canCacheArrayLength = canCacheArrayLength;
        this.shouldAlwaysStoreArrayInNewVar = shouldAlwaysStoreArrayInNewVar;
        BindingContext bindingContext = this.getBindingContext();
        KtExpression ktExpression = forExpression.getLoopRange();
        Intrinsics.checkNotNull((Object)ktExpression);
        KotlinType kotlinType = bindingContext.getType(ktExpression);
        Intrinsics.checkNotNull((Object)kotlinType);
        this.loopRangeType = kotlinType;
    }

    @Override
    public void beforeLoop() {
        super.beforeLoop();
        Type type2 = Type.INT_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"INT_TYPE");
        this.indexVar = this.createLoopTempVariable(type2);
        KtExpression loopRange = this.getForExpression().getLoopRange();
        StackValue value2 = this.getCodegen().gen(loopRange);
        Type type3 = this.getCodegen().asmType(this.loopRangeType);
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"asmType(...)");
        Type asmLoopRangeType = type3;
        if (!this.shouldAlwaysStoreArrayInNewVar && value2 instanceof StackValue.Local && Intrinsics.areEqual((Object)((StackValue.Local)value2).type, (Object)asmLoopRangeType)) {
            this.arrayVar = ((StackValue.Local)value2).index;
        } else {
            Type type4 = AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"OBJECT_TYPE");
            this.arrayVar = this.createLoopTempVariable(type4);
            value2.put(asmLoopRangeType, this.loopRangeType, this.getV());
            this.getV().store(this.arrayVar, AsmTypes.OBJECT_TYPE);
        }
        if (this.canCacheArrayLength) {
            Type type5 = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"INT_TYPE");
            this.arrayLengthVar = this.createLoopTempVariable(type5);
            this.getV().load(this.arrayVar, AsmTypes.OBJECT_TYPE);
            this.getV().arraylength();
            this.getV().store(this.arrayLengthVar, Type.INT_TYPE);
        }
        this.getV().iconst(0);
        this.getV().store(this.indexVar, Type.INT_TYPE);
    }

    @Override
    public void checkEmptyLoop(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter((Object)loopExit, (String)"loopExit");
    }

    @Override
    public void checkPreCondition(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter((Object)loopExit, (String)"loopExit");
        this.getV().load(this.indexVar, Type.INT_TYPE);
        if (this.canCacheArrayLength) {
            this.getV().load(this.arrayLengthVar, Type.INT_TYPE);
        } else {
            this.getV().load(this.arrayVar, AsmTypes.OBJECT_TYPE);
            this.getV().arraylength();
        }
        this.getV().ificmpge(loopExit);
    }

    @Override
    protected void assignToLoopParameter() {
        Type type2 = KotlinBuiltIns.isArray(this.loopRangeType) ? DescriptorAsmUtil.boxType(this.getAsmElementType(), this.getElementType(), this.getCodegen().getState().getTypeMapper()) : this.getAsmElementType();
        Intrinsics.checkNotNull((Object)type2);
        Type arrayElParamType = type2;
        this.getV().load(this.arrayVar, AsmTypes.OBJECT_TYPE);
        this.getV().load(this.indexVar, Type.INT_TYPE);
        this.getV().aload(arrayElParamType);
        StackValue.local(this.getLoopParameterVar(), this.getLoopParameterType(), this.getLoopParameterKotlinType()).store(StackValue.onStack(arrayElParamType, this.getElementType()), this.getV());
    }

    @Override
    protected void checkPostConditionAndIncrement(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter((Object)loopExit, (String)"loopExit");
        this.getV().iinc(this.indexVar, 1);
    }
}

