/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentRegistry;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorageState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.DataStructuresKt;
import org.jetbrains.kotlin.container.DefaultInstanceComponentDescriptor;
import org.jetbrains.kotlin.container.DefaultSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.ImplicitSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.InvalidCardinalityException;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;
import org.jetbrains.kotlin.container.ValueResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0(2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eJ\u001f\u0010)\u001a\u00020 2\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170+H\u0000\u00a2\u0006\u0002\b,J#\u0010-\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0+H\u0000\u00a2\u0006\u0002\b0J\u000e\u00101\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020.J\u001e\u00102\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020.2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f03H\u0002J\u001e\u00104\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020.2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000f03H\u0002J$\u00106\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001d\u001a\u00020.2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f03H\u0002J4\u00107\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020.2\u0006\u00108\u001a\u00020\u000f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010<\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020.2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030>H\u0002J\u0018\u00104\u001a\u00020 2\u0006\u0010?\u001a\u00020@2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010A\u001a\u00020 J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000f0+H\u0002J\u0010\u0010C\u001a\u00020 2\u0006\u00108\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0010\u001a#\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u00130\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/container/ComponentStorage;", "Lorg/jetbrains/kotlin/container/ValueResolver;", "myId", "", "parent", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/ComponentStorage;)V", "state", "Lorg/jetbrains/kotlin/container/ComponentStorageState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentStorageState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentStorageState;)V", "descriptors", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "dependencies", "Lcom/intellij/util/containers/MultiMap;", "kotlin.jvm.PlatformType", "Ljava/lang/reflect/Type;", "Lorg/jetbrains/annotations/NotNull;", "clashResolvers", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "registry", "Lorg/jetbrains/kotlin/container/ComponentRegistry;", "resolve", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "request", "context", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "registerDependency", "", "dump", "printer", "Ljava/io/PrintStream;", "containerId", "getContainerId", "()Ljava/lang/String;", "resolveMultiple", "", "registerClashResolvers", "resolvers", "", "registerClashResolvers$container", "registerDescriptors", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "items", "registerDescriptors$container", "compose", "composeDescriptors", "", "injectProperties", "components", "inspectDependenciesAndRegisterAdhoc", "collectAdhocComponents", "descriptor", "visitedTypes", "Ljava/util/HashSet;", "adhocDescriptors", "getImplicitlyDefinedDependency", "rawType", "Ljava/lang/Class;", "instance", "", "dispose", "getDescriptorsInDisposeOrder", "disposeDescriptor", "container"})
@SourceDebugExtension(value={"SMAP\nStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Storage.kt\norg/jetbrains/kotlin/container/ComponentStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n819#2:257\n847#2,2:258\n1855#2:260\n1855#2,2:261\n1856#2:263\n1855#2,2:265\n1#3:264\n*S KotlinDebug\n*F\n+ 1 Storage.kt\norg/jetbrains/kotlin/container/ComponentStorage\n*L\n67#1:257\n67#1:258,2\n93#1:260\n95#1:261,2\n93#1:263\n220#1:265,2\n*E\n"})
public final class ComponentStorage
implements ValueResolver {
    @NotNull
    private final String myId;
    @NotNull
    private ComponentStorageState state;
    @NotNull
    private final LinkedHashSet<ComponentDescriptor> descriptors;
    @NotNull
    private final MultiMap<ComponentDescriptor, Type> dependencies;
    @NotNull
    private final ArrayList<PlatformExtensionsClashResolver<?>> clashResolvers;
    @NotNull
    private final ComponentRegistry registry;

    public ComponentStorage(@NotNull String myId, @Nullable ComponentStorage parent2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)myId, (String)"myId");
            this.myId = myId;
            this.state = ComponentStorageState.Initial;
            this.descriptors = new LinkedHashSet();
            MultiMap multiMap = MultiMap.createLinkedSet();
            Intrinsics.checkNotNullExpressionValue(multiMap, (String)"createLinkedSet(...)");
            this.dependencies = multiMap;
            this.clashResolvers = new ArrayList();
            this.registry = new ComponentRegistry();
            ComponentStorage componentStorage = parent2;
            if (componentStorage == null) break block0;
            ComponentStorage it = componentStorage;
            boolean bl = false;
            this.registry.addAll(it.registry);
            this.clashResolvers.addAll((Collection)it.clashResolvers);
        }
    }

    @NotNull
    public final ComponentStorageState getState() {
        return this.state;
    }

    public final void setState(@NotNull ComponentStorageState componentStorageState) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentStorageState), (String)"<set-?>");
        this.state = componentStorageState;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.state == ComponentStorageState.Initial) {
            throw new ContainerConsistencyException("Container was not composed before resolving");
        }
        Collection<ComponentDescriptor> entry = this.registry.tryGetEntry(request);
        if (!entry.isEmpty()) {
            void $this$filterNotTo$iv$iv;
            this.registerDependency(request, context2);
            if (entry.size() == 1) {
                return (ValueDescriptor)CollectionsKt.single((Iterable)entry);
            }
            Iterable $this$filterNot$iv = entry;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ComponentDescriptor it = (ComponentDescriptor)element$iv$iv;
                boolean bl = false;
                if (ComponentStorage.resolve$isDefaultComponent(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonDefault = (List)destination$iv$iv;
            if (nonDefault.isEmpty()) {
                return (ValueDescriptor)CollectionsKt.first((Iterable)entry);
            }
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)CollectionsKt.singleOrNull((List)nonDefault);
            if (componentDescriptor == null) {
                throw new InvalidCardinalityException(this.getContainerId() + ": Request " + request + " cannot be satisfied because there is more than one type registered\nClashed registrations: " + CollectionsKt.joinToString$default((Iterable)entry, null, null, null, (int)0, null, null, (int)63, null));
            }
            return componentDescriptor;
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context2) {
        ValueDescriptor descriptor2;
        if (context2 instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context2).getRequestingDescriptor()) instanceof ComponentDescriptor) {
            this.dependencies.putValue((ComponentDescriptor)descriptor2, request);
        }
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        PrintStream $this$dump_u24lambda_u244 = printer;
        boolean bl = false;
        String heading = this.getContainerId();
        $this$dump_u24lambda_u244.println(heading);
        $this$dump_u24lambda_u244.println(StringsKt.repeat((CharSequence)"=", (int)heading.length()));
        $this$dump_u24lambda_u244.println();
        Iterable $this$forEach$iv = this.getDescriptorsInDisposeOrder();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentDescriptor descriptor2 = (ComponentDescriptor)element$iv;
            boolean bl2 = false;
            $this$dump_u24lambda_u244.println(descriptor2);
            Collection<Type> collection = this.dependencies.get(descriptor2);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"get(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Type it = (Type)element$iv2;
                boolean bl3 = false;
                $this$dump_u24lambda_u244.print("   -> ");
                String typeName = it.toString();
                $this$dump_u24lambda_u244.print(StringsKt.substringBefore$default((String)typeName, (String)" ", null, (int)2, null));
                $this$dump_u24lambda_u244.print(" ");
                $this$dump_u24lambda_u244.print(StringsKt.substringAfterLast$default((String)typeName, (String)".", null, (int)2, null));
                Intrinsics.checkNotNull((Object)it);
                Collection<ComponentDescriptor> resolve2 = this.registry.tryGetEntry(it);
                $this$dump_u24lambda_u244.print(" as ");
                $this$dump_u24lambda_u244.print(resolve2);
                $this$dump_u24lambda_u244.println();
            }
            $this$dump_u24lambda_u244.println();
        }
    }

    @NotNull
    public final String getContainerId() {
        return "Container: " + this.myId;
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.registerDependency(request, context2);
        return this.registry.tryGetEntry(request);
    }

    public final void registerClashResolvers$container(@NotNull List<? extends PlatformExtensionsClashResolver<?>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        this.clashResolvers.addAll((Collection)resolvers);
    }

    public final void registerDescriptors$container(@NotNull ComponentResolveContext context2, @NotNull List<? extends ComponentDescriptor> items) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.state == ComponentStorageState.Disposed) {
            throw new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        for (ComponentDescriptor componentDescriptor : items) {
            this.descriptors.add(componentDescriptor);
        }
        if (this.state == ComponentStorageState.Initialized) {
            this.composeDescriptors(context2, (Collection<? extends ComponentDescriptor>)items);
        }
    }

    public final void compose(@NotNull ComponentResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.state != ComponentStorageState.Initial) {
            throw new ContainerConsistencyException(this.getContainerId() + ' ' + this.myId + " was already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        this.composeDescriptors(context2, (Collection<? extends ComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context2, Collection<? extends ComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        LinkedHashSet<ComponentDescriptor> implicits = this.inspectDependenciesAndRegisterAdhoc(context2, descriptors);
        this.registry.resolveClashesIfAny(context2.getContainer(), (List)this.clashResolvers);
        this.injectProperties(context2, CollectionsKt.plus(descriptors, (Iterable)implicits));
    }

    private final void injectProperties(ComponentResolveContext context2, Collection<? extends ComponentDescriptor> components2) {
        for (ComponentDescriptor componentDescriptor : components2) {
            if (!componentDescriptor.getShouldInjectProperties()) continue;
            this.injectProperties(componentDescriptor.getValue(), context2.getContainer().createResolveContext(componentDescriptor));
        }
    }

    private final LinkedHashSet<ComponentDescriptor> inspectDependenciesAndRegisterAdhoc(ComponentResolveContext context2, Collection<? extends ComponentDescriptor> descriptors) {
        LinkedHashSet<ComponentDescriptor> adhoc = new LinkedHashSet<ComponentDescriptor>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            this.collectAdhocComponents(context2, componentDescriptor, visitedTypes, adhoc);
        }
        this.registry.addAll((Collection<? extends ComponentDescriptor>)adhoc);
        return adhoc;
    }

    private final void collectAdhocComponents(ComponentResolveContext context2, ComponentDescriptor descriptor2, HashSet<Type> visitedTypes, LinkedHashSet<ComponentDescriptor> adhocDescriptors) {
        Collection<Type> dependencies2 = descriptor2.getDependencies(context2);
        for (Type type2 : dependencies2) {
            Type type3;
            Collection<ComponentDescriptor> entry;
            if (!visitedTypes.add(type2) || !(entry = this.registry.tryGetEntry(type2)).isEmpty()) continue;
            Type type4 = type2;
            Class rawType = type4 instanceof Class ? (Class)type2 : (type4 instanceof ParameterizedType ? ((type3 = ((ParameterizedType)type2).getRawType()) instanceof Class ? (Class)type3 : null) : null);
            Class clazz = rawType;
            if (clazz == null) continue;
            Class it = clazz;
            boolean bl = false;
            ComponentDescriptor componentDescriptor = this.getImplicitlyDefinedDependency(context2, it);
            clazz = componentDescriptor;
            if (componentDescriptor == null) {
                continue;
            }
            Class implicitDependency = clazz;
            adhocDescriptors.add((ComponentDescriptor)((Object)implicitDependency));
            this.collectAdhocComponents(context2, (ComponentDescriptor)((Object)implicitDependency), visitedTypes, adhocDescriptors);
        }
    }

    private final ComponentDescriptor getImplicitlyDefinedDependency(ComponentResolveContext context2, Class<?> rawType) {
        if (!Modifier.isAbstract(rawType.getModifiers()) && !rawType.isPrimitive()) {
            return new ImplicitSingletonTypeComponentDescriptor(context2.getContainer(), rawType);
        }
        Class<?> defaultImplementation = CacheKt.getInfo(rawType).getDefaultImplementation();
        if (defaultImplementation != null && CacheKt.getInfo(defaultImplementation).getConstructorInfo() != null) {
            return new DefaultSingletonTypeComponentDescriptor(context2.getContainer(), defaultImplementation);
        }
        if (defaultImplementation != null) {
            DefaultInstanceComponentDescriptor defaultInstanceComponentDescriptor;
            Object object = defaultImplementation.getField("INSTANCE");
            if (object != null && (object = ((Field)object).get(null)) != null) {
                Object p0 = object;
                boolean bl = false;
                defaultInstanceComponentDescriptor = new DefaultInstanceComponentDescriptor(p0);
            } else {
                defaultInstanceComponentDescriptor = null;
            }
            return defaultInstanceComponentDescriptor;
        }
        return null;
    }

    private final void injectProperties(Object instance2, ValueResolveContext context2) {
        ClassInfo classInfo2 = CacheKt.getInfo(instance2.getClass());
        Iterable $this$forEach$iv = classInfo2.getSetterInfos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SetterInfo setterInfo = (SetterInfo)element$iv;
            boolean bl = false;
            Method method = setterInfo.component1();
            MethodBinding methodBinding = ResolveKt.bindToMethod(method, this.getContainerId(), context2);
            methodBinding.invoke(instance2);
        }
    }

    public final void dispose() {
        if (this.state != ComponentStorageState.Initialized) {
            if (this.state == ComponentStorageState.Initial) {
                return;
            }
            throw new ContainerConsistencyException("Component container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<ComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder();
        for (ComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    private final List<ComponentDescriptor> getDescriptorsInDisposeOrder() {
        return DataStructuresKt.topologicalSort$default(this.descriptors, false, (Function1)new Function1<ComponentDescriptor, Iterable<? extends ComponentDescriptor>>(this){
            final /* synthetic */ ComponentStorage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<ComponentDescriptor> invoke(ComponentDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ArrayList<ComponentDescriptor> dependent = new ArrayList<ComponentDescriptor>();
                for (Type interfaceType2 : ComponentStorage.access$getDependencies$p(this.this$0).get(it)) {
                    ComponentRegistry componentRegistry = ComponentStorage.access$getRegistry$p(this.this$0);
                    Intrinsics.checkNotNull((Object)interfaceType2);
                    for (ComponentDescriptor dependency : componentRegistry.tryGetEntry(interfaceType2)) {
                        dependent.add(dependency);
                    }
                }
                return dependent;
            }
        }, 2, null);
    }

    private final void disposeDescriptor(ComponentDescriptor descriptor2) {
        if (descriptor2 instanceof Closeable) {
            ((Closeable)((Object)descriptor2)).close();
        }
    }

    private static final boolean resolve$isDefaultComponent(ComponentDescriptor $this$resolve_u24isDefaultComponent) {
        return $this$resolve_u24isDefaultComponent instanceof DefaultInstanceComponentDescriptor || $this$resolve_u24isDefaultComponent instanceof DefaultSingletonTypeComponentDescriptor;
    }

    public static final /* synthetic */ MultiMap access$getDependencies$p(ComponentStorage $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ ComponentRegistry access$getRegistry$p(ComponentStorage $this) {
        return $this.registry;
    }
}

