/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContextForProvider;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.PersistentImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.name.Name;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u00a9\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\u0006\u0010\u001c\u001a\u00020\u0010\u0012\u0006\u0010\u001d\u001a\u00020\u0010\u0012\u0006\u0010\u001e\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001f\u0010 B\u0019\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001f\u0010!J\u001e\u00107\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u0001092\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H\u0016J\u0010\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0006H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\bH\u0016J\b\u0010B\u001a\u00020?H\u0016J\u0010\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\nH\u0016J\b\u0010E\u001a\u00020?H\u0016J\u0010\u0010F\u001a\u00020\u00012\u0006\u0010G\u001a\u00020\fH\u0016J\b\u0010H\u001a\u00020?H\u0016J\u0010\u0010I\u001a\u00020\u00012\u0006\u0010J\u001a\u00020\u000eH\u0016J\b\u0010K\u001a\u00020?H\u0016J.\u0010L\u001a\u00020\u00012\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001b0N2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010O\u001a\u00020\u0001H\u0016J\b\u0010P\u001a\u00020\u0001H\u0016J\u0010\u0010/\u001a\u00020\u00012\u0006\u0010Q\u001a\u00020\u0012H\u0016J\b\u0010R\u001a\u00020\u0001H\u0016J\u0010\u0010S\u001a\u00020\u00012\u0006\u0010T\u001a\u00020\u0014H\u0016J\u0010\u0010U\u001a\u00020\u00012\u0006\u0010T\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010%R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010*\"\u0004\b+\u0010,R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006V"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/MutableCheckerContext;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextForProvider;", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "callsOrAssignments", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "annotationContainers", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "containingElements", "Lorg/jetbrains/kotlin/fir/FirElement;", "isContractBody", "", "inlineFunctionBodyContext", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "containingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "suppressedDiagnostics", "Lkotlinx/collections/immutable/PersistentSet;", "", "allInfosSuppressed", "allWarningsSuppressed", "allErrorsSuppressed", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;Lkotlinx/collections/immutable/PersistentSet;ZZZ)V", "(Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;)V", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "getContainingDeclarations", "()Ljava/util/List;", "getCallsOrAssignments", "getGetClassCalls", "getAnnotationContainers", "getContainingElements", "()Z", "setContractBody", "(Z)V", "getInlineFunctionBodyContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "setInlineFunctionBodyContext", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;)V", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "setContainingFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getSuppressedDiagnostics", "()Lkotlinx/collections/immutable/PersistentSet;", "addImplicitReceiver", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "addDeclaration", "declaration", "dropDeclaration", "", "addCallOrAssignment", "qualifiedAccessOrAnnotationCall", "dropCallOrAssignment", "addGetClassCall", "getClassCall", "dropGetClassCall", "addAnnotationContainer", "annotationContainer", "dropAnnotationContainer", "addElement", "element", "dropElement", "addSuppressedDiagnostics", "diagnosticNames", "", "enterContractBody", "exitContractBody", "context", "unsetInlineFunctionBodyContext", "enterFile", "file", "exitFile", "checkers"})
public final class MutableCheckerContext
extends CheckerContextForProvider {
    @NotNull
    private final PersistentImplicitReceiverStack implicitReceiverStack;
    @NotNull
    private final List<FirDeclaration> containingDeclarations;
    @NotNull
    private final List<FirStatement> callsOrAssignments;
    @NotNull
    private final List<FirGetClassCall> getClassCalls;
    @NotNull
    private final List<FirAnnotationContainer> annotationContainers;
    @NotNull
    private final List<FirElement> containingElements;
    private boolean isContractBody;
    @Nullable
    private FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext;
    @Nullable
    private FirFile containingFile;
    @NotNull
    private final PersistentSet<String> suppressedDiagnostics;

    private MutableCheckerContext(PersistentImplicitReceiverStack implicitReceiverStack, List<FirDeclaration> containingDeclarations, List<FirStatement> callsOrAssignments, List<FirGetClassCall> getClassCalls, List<FirAnnotationContainer> annotationContainers, List<FirElement> containingElements, boolean isContractBody, FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext, FirFile containingFile, SessionHolder sessionHolder, ReturnTypeCalculator returnTypeCalculator, PersistentSet<String> suppressedDiagnostics, boolean allInfosSuppressed, boolean allWarningsSuppressed, boolean allErrorsSuppressed) {
        super(sessionHolder, returnTypeCalculator, allInfosSuppressed, allWarningsSuppressed, allErrorsSuppressed);
        this.implicitReceiverStack = implicitReceiverStack;
        this.containingDeclarations = containingDeclarations;
        this.callsOrAssignments = callsOrAssignments;
        this.getClassCalls = getClassCalls;
        this.annotationContainers = annotationContainers;
        this.containingElements = containingElements;
        this.isContractBody = isContractBody;
        this.inlineFunctionBodyContext = inlineFunctionBodyContext;
        this.containingFile = containingFile;
        this.suppressedDiagnostics = suppressedDiagnostics;
    }

    @Override
    @NotNull
    public PersistentImplicitReceiverStack getImplicitReceiverStack() {
        return this.implicitReceiverStack;
    }

    @Override
    @NotNull
    public List<FirDeclaration> getContainingDeclarations() {
        return this.containingDeclarations;
    }

    @Override
    @NotNull
    public List<FirStatement> getCallsOrAssignments() {
        return this.callsOrAssignments;
    }

    @Override
    @NotNull
    public List<FirGetClassCall> getGetClassCalls() {
        return this.getClassCalls;
    }

    @Override
    @NotNull
    public List<FirAnnotationContainer> getAnnotationContainers() {
        return this.annotationContainers;
    }

    @Override
    @NotNull
    public List<FirElement> getContainingElements() {
        return this.containingElements;
    }

    @Override
    public boolean isContractBody() {
        return this.isContractBody;
    }

    public void setContractBody(boolean bl) {
        this.isContractBody = bl;
    }

    @Override
    @Nullable
    public FirInlineDeclarationChecker.InlineFunctionBodyContext getInlineFunctionBodyContext() {
        return this.inlineFunctionBodyContext;
    }

    public void setInlineFunctionBodyContext(@Nullable FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext) {
        this.inlineFunctionBodyContext = inlineFunctionBodyContext;
    }

    @Override
    @Nullable
    public FirFile getContainingFile() {
        return this.containingFile;
    }

    public void setContainingFile(@Nullable FirFile firFile) {
        this.containingFile = firFile;
    }

    @NotNull
    public PersistentSet<String> getSuppressedDiagnostics() {
        return this.suppressedDiagnostics;
    }

    public MutableCheckerContext(@NotNull SessionHolder sessionHolder, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)returnTypeCalculator, (String)"returnTypeCalculator");
        this(new PersistentImplicitReceiverStack(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), false, null, null, sessionHolder, returnTypeCalculator, ExtensionsKt.persistentSetOf(), false, false, false);
    }

    @Override
    @NotNull
    public MutableCheckerContext addImplicitReceiver(@Nullable Name name2, @NotNull ImplicitReceiverValue<?> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return new MutableCheckerContext(PersistentImplicitReceiverStack.add$default(this.getImplicitReceiverStack(), name2, value2, null, 4, null), this.getContainingDeclarations(), this.getCallsOrAssignments(), this.getGetClassCalls(), this.getAnnotationContainers(), this.getContainingElements(), this.isContractBody(), this.getInlineFunctionBodyContext(), this.getContainingFile(), this.getSessionHolder(), this.getReturnTypeCalculator(), (PersistentSet<String>)this.getSuppressedDiagnostics(), this.getAllInfosSuppressed(), this.getAllWarningsSuppressed(), this.getAllErrorsSuppressed());
    }

    @Override
    @NotNull
    public MutableCheckerContext addDeclaration(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.getContainingDeclarations().add(declaration);
        return this;
    }

    @Override
    public void dropDeclaration() {
        CollectionsKt.removeLast(this.getContainingDeclarations());
    }

    @Override
    @NotNull
    public MutableCheckerContext addCallOrAssignment(@NotNull FirStatement qualifiedAccessOrAnnotationCall) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessOrAnnotationCall, (String)"qualifiedAccessOrAnnotationCall");
        this.getCallsOrAssignments().add(qualifiedAccessOrAnnotationCall);
        return this;
    }

    @Override
    public void dropCallOrAssignment() {
        CollectionsKt.removeLast(this.getCallsOrAssignments());
    }

    @Override
    @NotNull
    public MutableCheckerContext addGetClassCall(@NotNull FirGetClassCall getClassCall) {
        Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
        this.getGetClassCalls().add(getClassCall);
        return this;
    }

    @Override
    public void dropGetClassCall() {
        CollectionsKt.removeLast(this.getGetClassCalls());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addAnnotationContainer(@NotNull FirAnnotationContainer annotationContainer) {
        Intrinsics.checkNotNullParameter((Object)annotationContainer, (String)"annotationContainer");
        this.getAnnotationContainers().add(annotationContainer);
        return this;
    }

    @Override
    public void dropAnnotationContainer() {
        CollectionsKt.removeLast(this.getAnnotationContainers());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addElement(@NotNull FirElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean bl2 = bl = CollectionsKt.lastOrNull(this.getContainingElements()) != element;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getContainingElements().add(element);
        return this;
    }

    @Override
    public void dropElement() {
        CollectionsKt.removeLast(this.getContainingElements());
    }

    @Override
    @NotNull
    public CheckerContextForProvider addSuppressedDiagnostics(@NotNull Collection<String> diagnosticNames, boolean allInfosSuppressed, boolean allWarningsSuppressed, boolean allErrorsSuppressed) {
        Intrinsics.checkNotNullParameter(diagnosticNames, (String)"diagnosticNames");
        if (diagnosticNames.isEmpty()) {
            return this;
        }
        return new MutableCheckerContext(this.getImplicitReceiverStack(), this.getContainingDeclarations(), this.getCallsOrAssignments(), this.getGetClassCalls(), this.getAnnotationContainers(), this.getContainingElements(), this.isContractBody(), this.getInlineFunctionBodyContext(), this.getContainingFile(), this.getSessionHolder(), this.getReturnTypeCalculator(), this.getSuppressedDiagnostics().addAll(diagnosticNames), this.getAllInfosSuppressed() || allInfosSuppressed, this.getAllWarningsSuppressed() || allWarningsSuppressed, this.getAllErrorsSuppressed() || allErrorsSuppressed);
    }

    @Override
    @NotNull
    public CheckerContextForProvider enterContractBody() {
        if (!(!this.isContractBody())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        this.setContractBody(true);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider exitContractBody() {
        if (!this.isContractBody()) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        this.setContractBody(false);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider setInlineFunctionBodyContext(@NotNull FirInlineDeclarationChecker.InlineFunctionBodyContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.setInlineFunctionBodyContext(context2);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider unsetInlineFunctionBodyContext() {
        this.setInlineFunctionBodyContext(null);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider enterFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setContainingFile(file2);
        return this;
    }

    @Override
    @NotNull
    public CheckerContextForProvider exitFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.setContainingFile(file2);
        return this;
    }
}

