/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirNonExpansiveInheritanceRestrictionCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001:\u0003\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "buildTypeGraph", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$Graph;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$TypeParameterNode;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "TypeParameterNode", "ExpansiveEdge", "Graph", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirNonExpansiveInheritanceRestrictionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n857#2,2:177\n1446#2,5:179\n1747#2,3:184\n1549#2:187\n1620#2,3:188\n1360#2:191\n1446#2,5:192\n1620#2,3:197\n1446#2,5:201\n1446#2,5:206\n1#3:200\n*S KotlinDebug\n*F\n+ 1 FirNonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker\n*L\n32#1:177,2\n35#1:179,5\n44#1:184,3\n46#1:187\n46#1:188,3\n89#1:191\n89#1:192,5\n112#1:197,3\n114#1:201,5\n118#1:206,5\n*E\n"})
public final class FirNonExpansiveInheritanceRestrictionChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNonExpansiveInheritanceRestrictionChecker INSTANCE = new FirNonExpansiveInheritanceRestrictionChecker();

    private FirNonExpansiveInheritanceRestrictionChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Set problemNodes;
        Object element$iv2;
        block11: {
            void destination$iv;
            Iterator<FirTypeParameterRef> $this$flatMapTo$iv;
            Object it;
            void $this$filterTo$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration.getTypeParameters().isEmpty()) {
                return;
            }
            Graph<TypeParameterNode> graph = this.buildTypeGraph(declaration, context2.getSession());
            Iterable iterable = (Iterable)((Object)graph.getExpansiveEdges());
            Iterable destination$iv2 = (Collection)((Object)SmartSet.Companion.create());
            boolean $i$f$filterTo22 = false;
            for (Object element$iv2 : $this$filterTo$iv) {
                it = (ExpansiveEdge)element$iv2;
                boolean bl2 = false;
                if (!graph.isEdgeInCycle((ExpansiveEdge<TypeParameterNode>)it)) continue;
                destination$iv2.add(element$iv2);
            }
            SmartSet edgesInCycles = (SmartSet)((Object)destination$iv2);
            if (edgesInCycles.isEmpty()) {
                return;
            }
            destination$iv2 = (Iterable)((Object)edgesInCycles);
            Collection $i$f$filterTo22 = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            element$iv2 = $this$flatMapTo$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv3 = element$iv2.next();
                ExpansiveEdge it2 = (ExpansiveEdge)element$iv3;
                boolean bl3 = false;
                Object[] objectArray = new TypeParameterNode[]{it2.getFrom(), it2.getTo()};
                Iterable list$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            problemNodes = (Set)destination$iv;
            for (FirTypeParameterRef ref : declaration.getTypeParameters()) {
                if (!problemNodes.remove(new TypeParameterNode(declaration.getSymbol(), ref.getSymbol()))) continue;
                KtSourceElement ktSourceElement = ref.getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = declaration.getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getEXPANSIVE_INHERITANCE(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            Iterable $this$any$iv = problemNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    it = (TypeParameterNode)element$iv2;
                    boolean bl4 = false;
                    if (!(((TypeParameterNode)it).getTypeParameter().getSource() != null)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$map$iv = problemNodes;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeParameterNode typeParameterNode = (TypeParameterNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.getContainer());
        }
        List containers = (List)destination$iv$iv;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPANSIVE_INHERITANCE_IN_JAVA(), (Object)containers, (DiagnosticContext)context2, null, 16, null);
    }

    private final Graph<TypeParameterNode> buildTypeGraph(FirRegularClass declaration, FirSession session2) {
        Graph<TypeParameterNode> graph = new Graph<TypeParameterNode>();
        SmartSet<FirClassifierSymbol<?>> visitedSymbols = SmartSet.Companion.create();
        visitedSymbols.add(declaration.getSymbol());
        FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$visit(session2, visitedSymbols, graph, declaration.getSymbol());
        return graph;
    }

    private static final void buildTypeGraph$addEdges(Graph<TypeParameterNode> graph, List<FirTypeParameterSymbol> typeParameters2, Set<? extends ConeKotlinType> constituentTypes2, FirRegularClassSymbol symbol2, FirRegularClassSymbol constituentTypeSymbol, FirTypeParameterSymbol constituentTypeParameterSymbol, boolean expansive) {
        for (FirTypeParameterSymbol typeParameter2 : typeParameters2) {
            if (!constituentTypes2.contains(FirNestedClassifierScopeKt.toConeType(typeParameter2, false)) && !constituentTypes2.contains(FirNestedClassifierScopeKt.toConeType(typeParameter2, true))) continue;
            graph.addEdge(new TypeParameterNode(symbol2, typeParameter2), new TypeParameterNode(constituentTypeSymbol, constituentTypeParameterSymbol), expansive);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildTypeGraph$visit(FirSession $session, SmartSet<FirClassifierSymbol<?>> visitedSymbols, Graph<TypeParameterNode> graph, FirRegularClassSymbol symbol2) {
        void $this$flatMapTo$iv$iv;
        List<FirTypeParameterSymbol> typeParameters2 = symbol2.getTypeParameterSymbols();
        ConeTypeProjection[] $this$flatMap$iv = (ConeTypeProjection[])symbol2.getResolvedSuperTypes();
        boolean $i$f$flatMap = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConeKotlinType it = (ConeKotlinType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = FirNonExpansiveInheritanceRestrictionCheckerKt.access$constituentTypes(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (ConeKotlinType constituentType : (List)destination$iv$iv) {
            FirRegularClassSymbol constituentTypeSymbol;
            if (TypeUtilsKt.toRegularClassSymbol(constituentType, $session) == null) continue;
            if (visitedSymbols.add(constituentTypeSymbol)) {
                FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$visit($session, visitedSymbols, graph, constituentTypeSymbol);
            }
            if (constituentTypeSymbol.getTypeParameterSymbols().size() != constituentType.getTypeArguments().length) continue;
            coneTypeProjectionArray = constituentType.getTypeArguments();
            int n = coneTypeProjectionArray.length;
            for (int i = 0; i < n; ++i) {
                Iterable list$iv;
                ConeKotlinType it;
                Iterable $this$flatMapTo$iv;
                Object object;
                int i2 = i;
                ConeTypeProjection typeProjection = coneTypeProjectionArray[i];
                FirTypeParameterSymbol constituentTypeParameterSymbol = constituentTypeSymbol.getTypeParameterSymbols().get(i2);
                if (typeProjection.getKind() == ProjectionKind.INVARIANT) {
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeProjection);
                    Intrinsics.checkNotNull((Object)coneKotlinType);
                    Set constituents = FirNonExpansiveInheritanceRestrictionCheckerKt.access$constituentTypes(coneKotlinType);
                    ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType(typeProjection);
                    Intrinsics.checkNotNull((Object)coneKotlinType2);
                    FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$addEdges(graph, typeParameters2, constituents, symbol2, constituentTypeSymbol, constituentTypeParameterSymbol, !(ConeTypeUtilsKt.unwrapLowerBound(coneKotlinType2) instanceof ConeTypeParameterType));
                    continue;
                }
                SmartSet<ConeKotlinType> bounds = SmartSet.Companion.create();
                Iterable $this$mapTo$iv = constituentTypeParameterSymbol.getResolvedBounds();
                boolean $i$f$mapTo22 = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it2;
                    Iterator iterator2 = (FirResolvedTypeRef)item$iv;
                    object = (Collection)((Object)bounds);
                    boolean bl = false;
                    object.add(it2.getType());
                }
                Collection cfr_ignored_0 = (Collection)((Object)bounds);
                if (ConeTypeProjectionKt.getType(typeProjection) != null) {
                    ConeKotlinType p0;
                    boolean bl = false;
                    bounds.add(p0);
                }
                Iterable $i$f$mapTo22 = (Iterable)((Object)bounds);
                Collection destination$iv = (Collection)((Object)SmartSet.Companion.create());
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    it = (ConeKotlinType)element$iv;
                    boolean bl = false;
                    list$iv = FirHelpersKt.collectUpperBounds(it);
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                SmartSet boundClosure2 = (SmartSet)((Object)destination$iv);
                $this$flatMapTo$iv = (Iterable)((Object)boundClosure2);
                destination$iv = (Collection)((Object)SmartSet.Companion.create());
                List<FirTypeParameterSymbol> list2 = typeParameters2;
                object = graph;
                $i$f$flatMapTo2 = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    it = (ConeClassLikeType)element$iv;
                    boolean bl = false;
                    list$iv = FirNonExpansiveInheritanceRestrictionCheckerKt.access$constituentTypes(it);
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Collection collection = destination$iv;
                FirNonExpansiveInheritanceRestrictionChecker.buildTypeGraph$addEdges((Graph<TypeParameterNode>)object, list2, (Set)collection, symbol2, constituentTypeSymbol, constituentTypeParameterSymbol, true);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ(\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "T", "", "from", "to", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class ExpansiveEdge<T> {
        private final T from;
        private final T to;

        public ExpansiveEdge(T from2, T to) {
            this.from = from2;
            this.to = to;
        }

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final ExpansiveEdge<T> copy(T from2, T to) {
            return new ExpansiveEdge<T>(from2, to);
        }

        public static /* synthetic */ ExpansiveEdge copy$default(ExpansiveEdge expansiveEdge, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = expansiveEdge.from;
            }
            if ((n & 2) != 0) {
                object2 = expansiveEdge.to;
            }
            return expansiveEdge.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "ExpansiveEdge(from=" + this.from + ", to=" + this.to + ')';
        }

        public int hashCode() {
            int result2 = this.from == null ? 0 : this.from.hashCode();
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpansiveEdge)) {
                return false;
            }
            ExpansiveEdge expansiveEdge = (ExpansiveEdge)other;
            if (!Intrinsics.areEqual(this.from, expansiveEdge.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, expansiveEdge.to);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018R\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$Graph;", "T", "", "<init>", "()V", "expansiveEdges", "Lorg/jetbrains/kotlin/utils/SmartSet;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "getExpansiveEdges", "()Lorg/jetbrains/kotlin/utils/SmartSet;", "edgeLists", "", "", "addEdge", "", "from", "to", "expansive", "", "(Ljava/lang/Object;Ljava/lang/Object;Z)V", "isEdgeInCycle", "edge", "collectReachable", "", "(Ljava/lang/Object;)Ljava/util/List;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirNonExpansiveInheritanceRestrictionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$Graph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,176:1\n372#2,7:177\n*S KotlinDebug\n*F\n+ 1 FirNonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$Graph\n*L\n147#1:177,7\n*E\n"})
    private static final class Graph<T> {
        @NotNull
        private final SmartSet<ExpansiveEdge<T>> expansiveEdges = SmartSet.Companion.create();
        @NotNull
        private final Map<T, Set<T>> edgeLists = new LinkedHashMap();

        @NotNull
        public final SmartSet<ExpansiveEdge<T>> getExpansiveEdges() {
            return this.expansiveEdges;
        }

        public final void addEdge(T from2, T to, boolean expansive) {
            Set set;
            Map<T, Set<T>> $this$getOrPut$iv = this.edgeLists;
            boolean $i$f$getOrPut = false;
            Set value$iv = $this$getOrPut$iv.get(from2);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = (Set)((Object)SmartSet.Companion.create());
                $this$getOrPut$iv.put(from2, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add(to);
            if (expansive) {
                this.expansiveEdges.add(new ExpansiveEdge<T>(from2, to));
            }
        }

        public static /* synthetic */ void addEdge$default(Graph graph, Object object, Object object2, boolean bl, int n, Object object3) {
            if ((n & 4) != 0) {
                bl = false;
            }
            graph.addEdge(object, object2, bl);
        }

        public final boolean isEdgeInCycle(@NotNull ExpansiveEdge<? extends T> edge) {
            Intrinsics.checkNotNullParameter(edge, (String)"edge");
            return this.collectReachable(edge.getTo()).contains(edge.getFrom());
        }

        private final List<T> collectReachable(T from2) {
            DFS.NodeHandlerWithListResult handler2 = new DFS.NodeHandlerWithListResult<T, T>(){

                public void afterChildren(T current) {
                    ((LinkedList)this.result).add(current);
                }
            };
            DFS.Neighbors<Object> neighbors2 = arg_0 -> Graph.collectReachable$lambda$1(this, arg_0);
            DFS.dfs(CollectionsKt.listOf(from2), neighbors2, handler2);
            Object object = handler2.result();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result(...)");
            return (List)object;
        }

        private static final Iterable collectReachable$lambda$1(Graph this$0, Object current) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Set set = this$0.edgeLists.get(current);
            return set != null ? (Iterable)set : (Iterable)SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNonExpansiveInheritanceRestrictionChecker$TypeParameterNode;", "", "container", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "typeParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;)V", "getContainer", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getTypeParameter", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class TypeParameterNode {
        @NotNull
        private final FirRegularClassSymbol container;
        @NotNull
        private final FirTypeParameterSymbol typeParameter;

        public TypeParameterNode(@NotNull FirRegularClassSymbol container, @NotNull FirTypeParameterSymbol typeParameter2) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
            this.container = container;
            this.typeParameter = typeParameter2;
        }

        @NotNull
        public final FirRegularClassSymbol getContainer() {
            return this.container;
        }

        @NotNull
        public final FirTypeParameterSymbol getTypeParameter() {
            return this.typeParameter;
        }

        @NotNull
        public final FirRegularClassSymbol component1() {
            return this.container;
        }

        @NotNull
        public final FirTypeParameterSymbol component2() {
            return this.typeParameter;
        }

        @NotNull
        public final TypeParameterNode copy(@NotNull FirRegularClassSymbol container, @NotNull FirTypeParameterSymbol typeParameter2) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)typeParameter2, (String)"typeParameter");
            return new TypeParameterNode(container, typeParameter2);
        }

        public static /* synthetic */ TypeParameterNode copy$default(TypeParameterNode typeParameterNode, FirRegularClassSymbol firRegularClassSymbol, FirTypeParameterSymbol firTypeParameterSymbol, int n, Object object) {
            if ((n & 1) != 0) {
                firRegularClassSymbol = typeParameterNode.container;
            }
            if ((n & 2) != 0) {
                firTypeParameterSymbol = typeParameterNode.typeParameter;
            }
            return typeParameterNode.copy(firRegularClassSymbol, firTypeParameterSymbol);
        }

        @NotNull
        public String toString() {
            return "TypeParameterNode(container=" + this.container + ", typeParameter=" + this.typeParameter + ')';
        }

        public int hashCode() {
            int result2 = this.container.hashCode();
            result2 = result2 * 31 + this.typeParameter.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeParameterNode)) {
                return false;
            }
            TypeParameterNode typeParameterNode = (TypeParameterNode)other;
            if (!Intrinsics.areEqual((Object)this.container, (Object)typeParameterNode.container)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.typeParameter, (Object)typeParameterNode.typeParameter);
        }
    }
}

