/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeLocalVariableNoTypeOrInitializer;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\tH\u0000\u001a\f\u0010\u000f\u001a\u00020\t*\u00020\u0010H\u0002\u001aB\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010$\u001a\u0004\u0018\u00010%*\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a \u0010$\u001a\u0004\u0018\u00010%*\u00020\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020'H\u0002\"\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u0019\u001a\u00020\t*\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0018\u0010\u001d\u001a\u00020\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0018\u0010 \u001a\u00020\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\"\u0018\u0010\"\u001a\u00020\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001f\u00a8\u0006("}, d2={"checkPropertyInitializer", "", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "isDefinitelyAssigned", "", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reachable", "noExplicitType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "reportMustBeInitialized", "propertySource", "Lorg/jetbrains/kotlin/KtSourceElement;", "isOpenValDeferredInitDeprecationWarning", "deprecationWarning", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "getDeprecationWarning", "(Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "hasImplementation", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "getHasImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)Z", "hasSetterAccessorImplementation", "getHasSetterAccessorImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "hasAnyAccessorImplementation", "getHasAnyAccessorImplementation", "hasAllAccessorImplementation", "getHasAllAccessorImplementation", "getEffectiveModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTopLevelPropertiesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTopLevelPropertiesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesCheckerKt\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n57#2:272\n12#2:274\n48#2:275\n72#2:276\n48#2:277\n12#2:278\n72#2:280\n34#3:273\n1#4:279\n*S KotlinDebug\n*F\n+ 1 FirTopLevelPropertiesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelPropertiesCheckerKt\n*L\n82#1:272\n84#1:274\n147#1:275\n178#1:276\n183#1:277\n211#1:278\n251#1:280\n82#1:273\n*E\n"})
public final class FirTopLevelPropertiesCheckerKt {
    public static final void checkPropertyInitializer(@Nullable FirClass containingClass, @NotNull FirProperty property, @Nullable FirModifierList modifierList2, boolean isDefinitelyAssigned, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, boolean reachable) {
        block36: {
            boolean isCorrectlyInitialized;
            KtSourceElement propertySource;
            boolean isExpect;
            boolean backingFieldRequired;
            boolean inInterface;
            block39: {
                block40: {
                    boolean bl;
                    block38: {
                        block37: {
                            block35: {
                                boolean isAbstract;
                                boolean bl2;
                                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                                FirClass firClass = containingClass;
                                if (firClass != null) {
                                    FirClass $this$isInterface$iv = firClass;
                                    boolean $i$f$isInterface = false;
                                    ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                                    boolean $i$f$isInterface2 = false;
                                    bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                                } else {
                                    bl2 = false;
                                }
                                inInterface = bl2;
                                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
                                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ABSTRACT_KEYWORD");
                                boolean hasAbstractModifier = FirKeywordUtilsKt.contains(modifierList2, ktModifierKeywordToken);
                                FirMemberDeclaration $this$isAbstract$iv = property;
                                boolean $i$f$isAbstract = false;
                                boolean bl3 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT || hasAbstractModifier;
                                if (isAbstract) {
                                    FirTypeRef returnTypeRef = property.getReturnTypeRef();
                                    if (property.getInitializer() == null && property.getDelegate() == null && FirTopLevelPropertiesCheckerKt.noExplicitType(returnTypeRef)) {
                                        KtSourceElement ktSourceElement = property.getSource();
                                        if (ktSourceElement != null) {
                                            KtSourceElement it = ktSourceElement;
                                            boolean bl4 = false;
                                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
                                        }
                                    }
                                    return;
                                }
                                backingFieldRequired = DeclarationAttributesKt.getHasBackingField(property);
                                if (inInterface && backingFieldRequired && FirTopLevelPropertiesCheckerKt.getHasAnyAccessorImplementation(property)) {
                                    KtSourceElement ktSourceElement = property.getSource();
                                    if (ktSourceElement != null) {
                                        KtSourceElement it = ktSourceElement;
                                        boolean bl5 = false;
                                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getBACKING_FIELD_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                                    }
                                }
                                isExpect = DeclarationUtilsKt.isEffectivelyExpect(property, containingClass, context2);
                                if (property.getInitializer() == null) break block35;
                                Object object = property.getInitializer();
                                if (object != null && (object = ((FirExpression)object).getSource()) != null) {
                                    Object it = object;
                                    boolean bl6 = false;
                                    if (inInterface) {
                                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                                    } else if (isExpect) {
                                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXPECTED_PROPERTY_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
                                    } else if (!backingFieldRequired) {
                                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_NO_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                                    } else if (property.getReceiverParameter() != null) {
                                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXTENSION_PROPERTY_WITH_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                                    }
                                }
                                break block36;
                            }
                            if (property.getDelegate() == null) break block37;
                            Object object = property.getDelegate();
                            if (object != null && (object = ((FirExpression)object).getSource()) != null) {
                                Object it = object;
                                boolean bl7 = false;
                                if (inInterface) {
                                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getDELEGATED_PROPERTY_IN_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
                                } else if (isExpect) {
                                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it, FirErrors.INSTANCE.getEXPECTED_DELEGATED_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                                }
                            }
                            break block36;
                        }
                        KtSourceElement ktSourceElement = property.getSource();
                        if (ktSourceElement == null) {
                            return;
                        }
                        propertySource = ktSourceElement;
                        boolean isExternal = DeclarationUtilsKt.isEffectivelyExternal(property, containingClass, context2);
                        boolean bl8 = isCorrectlyInitialized = property.getInitializer() != null || isDefinitelyAssigned && !FirTopLevelPropertiesCheckerKt.getHasSetterAccessorImplementation(property) && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass, context2.getLanguageVersionSettings()) != Modality.OPEN;
                        if (!backingFieldRequired || inInterface) break block38;
                        FirMemberDeclaration $this$isLateInit$iv = property;
                        boolean $i$f$isLateInit = false;
                        if ($this$isLateInit$iv.getStatus().isLateInit() || isExpect || isCorrectlyInitialized || isExternal || DeclarationAttributesKt.getHasExplicitBackingField(property)) break block38;
                        if (property.getReceiverParameter() != null && !FirTopLevelPropertiesCheckerKt.getHasAllAccessorImplementation(property)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getEXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT(), (DiagnosticContext)context2, null, 8, null);
                        } else if (reachable) {
                            boolean isFalsePositiveDeferredInitDeprecationWarning;
                            boolean isOpenValDeferredInitDeprecationWarning = !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitOpenValDeferredInitialization) && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass, context2.getLanguageVersionSettings()) == Modality.OPEN && property.isVal() && isDefinitelyAssigned;
                            boolean bl9 = isFalsePositiveDeferredInitDeprecationWarning = isOpenValDeferredInitDeprecationWarning && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass) == Modality.FINAL;
                            if (!isFalsePositiveDeferredInitDeprecationWarning) {
                                FirTopLevelPropertiesCheckerKt.reportMustBeInitialized(property, isDefinitelyAssigned, containingClass, propertySource, isOpenValDeferredInitDeprecationWarning, reporter, context2);
                            }
                        }
                        break block39;
                    }
                    if (!FirTopLevelPropertiesCheckerKt.noExplicitType(property.getReturnTypeRef()) || DeclarationAttributesKt.getHasExplicitBackingField(property)) break block39;
                    if (property.getGetter() instanceof FirDefaultPropertyAccessor) break block40;
                    FirPropertyAccessor firPropertyAccessor = property.getGetter();
                    if (firPropertyAccessor != null) {
                        FirPropertyAccessor $this$hasBody$iv = firPropertyAccessor;
                        boolean $i$f$getHasBody = false;
                        bl = $this$hasBody$iv.getBody() != null;
                    } else {
                        bl = false;
                    }
                    if (!bl) break block39;
                    FirPureAbstractElement firPureAbstractElement = property.getGetter();
                    boolean bl10 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null ? FirTopLevelPropertiesCheckerKt.noExplicitType((FirTypeRef)firPureAbstractElement) : false;
                    if (!bl10) break block39;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
            }
            FirMemberDeclaration $this$isLateInit$iv = property;
            boolean $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                if (isExpect) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getEXPECTED_LATEINIT_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                }
                if (backingFieldRequired && !inInterface && isCorrectlyInitialized && context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)propertySource, FirErrors.INSTANCE.getUNNECESSARY_LATEINIT(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    public static /* synthetic */ void checkPropertyInitializer$default(FirClass firClass, FirProperty firProperty, FirModifierList firModifierList, boolean bl, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        FirTopLevelPropertiesCheckerKt.checkPropertyInitializer(firClass, firProperty, firModifierList, bl, diagnosticReporter, checkerContext, bl2);
    }

    private static final boolean noExplicitType(FirTypeRef $this$noExplicitType) {
        return $this$noExplicitType instanceof FirErrorTypeRef && ((FirErrorTypeRef)$this$noExplicitType).getDiagnostic() instanceof ConeLocalVariableNoTypeOrInitializer;
    }

    private static final void reportMustBeInitialized(FirProperty property, boolean isDefinitelyAssigned, FirClass containingClass, KtSourceElement propertySource, boolean isOpenValDeferredInitDeprecationWarning, DiagnosticReporter reporter, CheckerContext context2) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        boolean bl;
        boolean suggestMakingItAbstract;
        FirMemberDeclaration $this$isAbstract$iv = property;
        boolean $i$f$isAbstract = false;
        if (!(!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT))) {
            boolean $i$a$-check-FirTopLevelPropertiesCheckerKt$reportMustBeInitialized$22 = false;
            String $i$a$-check-FirTopLevelPropertiesCheckerKt$reportMustBeInitialized$22 = "reportMustBeInitialized isn't called for abstract properties";
            throw new IllegalStateException($i$a$-check-FirTopLevelPropertiesCheckerKt$reportMustBeInitialized$22.toString());
        }
        boolean suggestMakingItFinal = containingClass != null && !FirTopLevelPropertiesCheckerKt.getHasSetterAccessorImplementation(property) && FirTopLevelPropertiesCheckerKt.getEffectiveModality(property, containingClass, context2.getLanguageVersionSettings()) != Modality.FINAL && isDefinitelyAssigned;
        boolean bl2 = suggestMakingItAbstract = containingClass != null && !FirTopLevelPropertiesCheckerKt.getHasAnyAccessorImplementation(property);
        if (isOpenValDeferredInitDeprecationWarning && !suggestMakingItFinal && suggestMakingItAbstract) {
            throw new IllegalStateException("Not reachable case. Every \"open val + deferred init\" case that could be made `abstract`, also could be made `final`".toString());
        }
        boolean isMissedMustBeInitializedDeprecationWarning = !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitMissedMustBeInitializedWhenThereIsNoPrimaryConstructor) && containingClass != null && org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(containingClass, context2.getSession()) == null && isDefinitelyAssigned;
        KtDiagnosticFactory0 factory2 = suggestMakingItFinal && suggestMakingItAbstract ? FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT() : (suggestMakingItFinal ? FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL() : (suggestMakingItAbstract ? FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT() : FirErrors.INSTANCE.getMUST_BE_INITIALIZED()));
        AbstractKtSourceElement abstractKtSourceElement = propertySource;
        boolean bl3 = bl = isMissedMustBeInitializedDeprecationWarning || isOpenValDeferredInitDeprecationWarning;
        if (bl) {
            ktDiagnosticFactory0 = FirTopLevelPropertiesCheckerKt.getDeprecationWarning(factory2);
        } else if (!bl) {
            ktDiagnosticFactory0 = factory2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory0, (DiagnosticContext)context2, null, 8, null);
    }

    private static final KtDiagnosticFactory0 getDeprecationWarning(KtDiagnosticFactory0 $this$deprecationWarning) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        KtDiagnosticFactory0 ktDiagnosticFactory02 = $this$deprecationWarning;
        if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_WARNING();
        } else if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING();
        } else if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL_WARNING();
        } else if (Intrinsics.areEqual((Object)ktDiagnosticFactory02, (Object)FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT())) {
            ktDiagnosticFactory0 = FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING();
        } else {
            throw new IllegalStateException("Only MUST_BE_INITIALIZED is supported".toString());
        }
        return ktDiagnosticFactory0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasImplementation(FirPropertyAccessor $this$hasImplementation) {
        if ($this$hasImplementation instanceof FirDefaultPropertyAccessor) return false;
        FirPropertyAccessor firPropertyAccessor = $this$hasImplementation;
        if (firPropertyAccessor == null) return false;
        FirPropertyAccessor $this$hasBody$iv = firPropertyAccessor;
        boolean $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }

    private static final boolean getHasSetterAccessorImplementation(FirProperty $this$hasSetterAccessorImplementation) {
        return FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasSetterAccessorImplementation.getSetter());
    }

    private static final boolean getHasAnyAccessorImplementation(FirProperty $this$hasAnyAccessorImplementation) {
        return FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasAnyAccessorImplementation.getGetter()) || FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasAnyAccessorImplementation.getSetter());
    }

    private static final boolean getHasAllAccessorImplementation(FirProperty $this$hasAllAccessorImplementation) {
        return FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasAllAccessorImplementation.getGetter()) && ($this$hasAllAccessorImplementation.isVal() || FirTopLevelPropertiesCheckerKt.getHasImplementation($this$hasAllAccessorImplementation.getSetter()));
    }

    private static final Modality getEffectiveModality(FirProperty $this$getEffectiveModality, FirClass containingClass) {
        Modality modality;
        boolean bl;
        FirElement firElement;
        boolean bl2 = $this$getEffectiveModality.getStatus().getModality() == Modality.OPEN && ((firElement = containingClass) != null && (firElement = ((FirClass)firElement).getStatus()) != null ? firElement.getModality() : null) == Modality.FINAL ? true : (bl = false);
        if (bl) {
            modality = Modality.FINAL;
        } else if (!bl) {
            modality = $this$getEffectiveModality.getStatus().getModality();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return modality;
    }

    private static final Modality getEffectiveModality(FirProperty $this$getEffectiveModality, FirClass containingClass, LanguageVersionSettings languageVersionSettings2) {
        Modality modality;
        boolean bl = languageVersionSettings2.supportsFeature(LanguageFeature.TakeIntoAccountEffectivelyFinalInMustBeInitializedCheck);
        if (bl) {
            modality = FirTopLevelPropertiesCheckerKt.getEffectiveModality($this$getEffectiveModality, containingClass);
        } else if (!bl) {
            modality = $this$getEffectiveModality.getStatus().getModality();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return modality;
    }
}

