/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u001e\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u001f\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010 \u001a\u00020\u0007*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010!\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\"\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010#\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010$\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010%\u001a\u00020\u000e*\u00020&H\u0002J\f\u0010'\u001a\u00020\u000e*\u00020\u0003H\u0002J\f\u0010(\u001a\u00020\u000e*\u00020)H\u0002R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "allowsReporting", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAllowsReporting", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "varargElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVarargElementType", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "superInterfaces", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkBody", "checkDelegation", "checkAnonymousInitializer", "checkEnumEntry", "checkConstructorPropertyParam", "isDirectlyExternal", "isPrivateMemberOfExternalClass", "isNonAbstractMemberIfInterface", "isNullableProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "hasValidExternalBody", "isDefinedExternallyExpression", "Lorg/jetbrains/kotlin/fir/FirElement;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 7 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,354:1\n60#2:355\n43#2:373\n21#2:396\n21#2:398\n11#2:399\n37#3:356\n1603#4,9:357\n1855#4:366\n1856#4:368\n1612#4:369\n1747#4,3:370\n819#4:374\n847#4,2:375\n766#4:377\n857#4,2:378\n1603#4,9:380\n1855#4:389\n1856#4:391\n1612#4:392\n1#5:367\n1#5:390\n20#6,2:393\n57#7:395\n18#7:397\n*S KotlinDebug\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n*L\n69#1:355\n117#1:373\n314#1:396\n315#1:398\n323#1:399\n69#1:356\n111#1:357,9\n111#1:366\n111#1:368\n111#1:369\n112#1:370,3\n208#1:374\n208#1:375,2\n209#1:377\n209#1:378,2\n244#1:380,9\n244#1:389\n244#1:391\n244#1:392\n111#1:367\n244#1:390\n256#1:393,2\n302#1:395\n314#1:397\n*E\n"})
public final class FirJsExternalChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsExternalChecker INSTANCE = new FirJsExternalChecker();

    private FirJsExternalChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirJsHelpersKt.isNativeObject(declaration.getSymbol(), context2)) {
            return;
        }
        if (!FirHelpersKt.isTopLevel(context2) && !(declaration instanceof FirPropertyAccessor) && this.isDirectlyExternal(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNESTED_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if (declaration instanceof FirClass) {
            String classKind;
            String string2 = ((FirClass)declaration).getStatus().isData() ? "data class" : (((FirClass)declaration).getStatus().isInner() ? "inner class" : (((FirClass)declaration).getStatus().isInline() ? "value class" : (((FirClass)declaration).getStatus().isFun() ? "fun interface" : (classKind = ((FirClass)declaration).getClassKind() == ClassKind.ANNOTATION_CLASS ? "annotation class" : null))));
            if (classKind != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)classKind, (DiagnosticContext)context2, null, 16, null);
            }
            FirClass $this$isEnumClass$iv = (FirClass)declaration;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (declaration instanceof FirPropertyAccessor && this.isDirectlyExternal(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirPropertyAccessor)declaration).getSource(), FirJsErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"property accessor", (DiagnosticContext)context2, null, 16, null);
        } else if (!(declaration instanceof FirPrimaryConstructor) && !(declaration instanceof FirField) && this.isPrivateMemberOfExternalClass(declaration, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"private member of class", (DiagnosticContext)context2, null, 16, null);
        }
        FirDeclaration container = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (declaration instanceof FirClass && ((FirClass)declaration).getClassKind() != ClassKind.INTERFACE && container instanceof FirClass && ((FirClass)container).getClassKind() == ClassKind.INTERFACE) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getNESTED_CLASS_IN_EXTERNAL_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        }
        if (!(declaration instanceof FirPropertyAccessor) && declaration instanceof FirCallableDeclaration && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
            FirCallableDeclaration $i$f$isEnumClass = (FirCallableDeclaration)declaration;
            String target = $i$f$isEnumClass instanceof FirFunction ? "extension function" : ($i$f$isEnumClass instanceof FirProperty ? "extension property" : "extension member");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)target, (DiagnosticContext)context2, null, 16, null);
        }
        if (declaration instanceof FirClass && ((FirClass)declaration).getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl;
            block22: {
                void $this$mapNotNullTo$iv$iv;
                List superClasses2 = CollectionsKt.toMutableList((Collection)this.superInterfaces((FirClass)declaration, context2.getSession()));
                ConeClassLikeType coneClassLikeType = FirJsHelpersKt.superClassNotAny((FirClass)declaration, context2.getSession());
                if (coneClassLikeType != null) {
                    ConeClassLikeType it = coneClassLikeType;
                    boolean bl2 = false;
                    superClasses2.add(it);
                }
                if (((FirClass)declaration).getClassKind() == ClassKind.ENUM_CLASS || ((FirClass)declaration).getClassKind() == ClassKind.ENUM_ENTRY) {
                    CollectionsKt.removeAll((List)superClasses2, (Function1)check.2.INSTANCE);
                }
                Iterable $this$mapNotNull$iv = superClasses2;
                boolean $i$f$mapNotNull = false;
                Iterable bl2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirClassLikeSymbol<?> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    if (TypeUtilsKt.toSymbol(it, context2.getSession()) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superDeclarations = (List)destination$iv$iv;
                Iterable $this$any$iv = superDeclarations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirClassLikeSymbol it = (FirClassLikeSymbol)element$iv;
                        boolean bl6 = false;
                        if (!(!FirJsHelpersKt.isNativeObject((FirBasedSymbol)it, context2) && !Intrinsics.areEqual((Object)it.getClassId().asSingleFqName(), (Object)StandardNames.FqNames.throwable))) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirClass)declaration).getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunction)declaration).getSource(), FirJsErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        KtDiagnosticFactory0 valueClassInExternalDiagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING() : FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION();
        FirJsExternalChecker.check$reportOnParametersAndReturnTypesIf(declaration, reporter, context2, valueClassInExternalDiagnostic, (Function1<? super ConeKotlinType, Boolean>)((Function1)new Function1<ConeKotlinType, Boolean>(context2){
            final /* synthetic */ CheckerContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(ConeKotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FirHelpersKt.isValueClass(it, this.$context.getSession());
            }
        }));
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            FirJsExternalChecker.check$reportOnParametersAndReturnTypesIf(declaration, reporter, context2, FirJsErrors.INSTANCE.getEXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION(), (Function1<? super ConeKotlinType, Boolean>)((Function1)check.5.INSTANCE));
        }
        if (declaration instanceof FirCallableDeclaration && this.isNonAbstractMemberIfInterface(declaration, context2.getSession()) && !this.isNullableProperty((FirCallableDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getNON_ABSTRACT_MEMBER_OF_EXTERNAL_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        }
        this.checkBody(declaration, context2, reporter);
        this.checkDelegation(declaration, context2, reporter);
        this.checkAnonymousInitializer(declaration, context2, reporter);
        this.checkEnumEntry(declaration, context2, reporter);
        this.checkConstructorPropertyParam(declaration, context2, reporter);
    }

    private final boolean getAllowsReporting(KtSourceElement $this$allowsReporting) {
        return !($this$allowsReporting.getKind() instanceof KtFakeSourceElementKind) || Intrinsics.areEqual((Object)$this$allowsReporting.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private final ConeKotlinType getVarargElementType(FirValueParameter $this$varargElementType) {
        ConeKotlinType coneKotlinType;
        if (!$this$varargElementType.isVararg()) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])FirTypeUtilsKt.getConeType($this$varargElementType.getReturnTypeRef()).getTypeArguments());
            coneKotlinType = coneTypeProjection != null ? ConeTypeProjectionKt.getType(coneTypeProjection) : null;
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeClassLikeType> superInterfaces(FirClass $this$superInterfaces, FirSession session2) {
        void $this$filterTo$iv$iv;
        ConeClassLikeType it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = FirDeclarationUtilKt.getSuperConeTypes($this$superInterfaces);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ConeClassLikeType)element$iv$iv;
            boolean bl = false;
            if (ConeBuiltinTypeUtilsKt.isAny(it) || ConeBuiltinTypeUtilsKt.isNullableAny(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConeClassLikeType)element$iv$iv;
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(it, session2);
            if (!((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.INTERFACE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBody(FirDeclaration $this$checkBody, CheckerContext context2, DiagnosticReporter reporter) {
        boolean isWrong;
        FirExpression firExpression2;
        if ($this$checkBody instanceof FirDefaultPropertyAccessor) {
            return;
        }
        FirDeclaration firDeclaration = $this$checkBody;
        FirBlock body2 = firDeclaration instanceof FirFunction ? ((FirFunction)$this$checkBody).getBody() : (firDeclaration instanceof FirAnonymousInitializer ? ((FirAnonymousInitializer)$this$checkBody).getBody() : null);
        if ($this$checkBody instanceof FirEnumEntry) {
            firExpression2 = null;
        } else {
            KtSourceElement ktSourceElement = $this$checkBody.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                firExpression2 = null;
            } else if ($this$checkBody instanceof FirVariable) {
                firExpression2 = ((FirVariable)$this$checkBody).getInitializer();
            } else if (body2 instanceof FirSingleExpressionBlock) {
                FirStatement firStatement = ((FirSingleExpressionBlock)body2).getStatement();
                FirReturnExpression firReturnExpression = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
                firExpression2 = firReturnExpression != null ? firReturnExpression.getResult() : null;
            } else {
                firExpression2 = null;
            }
        }
        FirExpression initializer2 = firExpression2;
        KtSourceElement ktSourceElement = $this$checkBody.getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
            return;
        }
        boolean bl = isWrong = !(body2 instanceof FirSingleExpressionBlock) && !this.hasValidExternalBody($this$checkBody) || initializer2 != null && !this.isDefinedExternallyExpression(initializer2);
        if (isWrong && body2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)body2.getSource(), FirJsErrors.INSTANCE.getWRONG_BODY_OF_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        } else if (isWrong && initializer2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)initializer2.getSource(), FirJsErrors.INSTANCE.getWRONG_INITIALIZER_OF_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
        if ($this$checkBody instanceof FirFunction) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((FirFunction)$this$checkBody).getValueParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                FirValueParameter it = (FirValueParameter)element$iv$iv;
                boolean bl3 = false;
                if (it.getDefaultValue() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (FirExpression defaultValue : (List)destination$iv$iv) {
                if (this.isDefinedExternallyExpression(defaultValue)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirJsErrors.INSTANCE.getWRONG_DEFAULT_VALUE_FOR_EXTERNAL_FUN_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkDelegation(FirDeclaration $this$checkDelegation, CheckerContext context2, DiagnosticReporter reporter) {
        block8: {
            block9: {
                block7: {
                    Object v0;
                    block6: {
                        if (!($this$checkDelegation instanceof FirMemberDeclaration) || !FirJsHelpersKt.isEffectivelyExternal(((FirMemberDeclaration)$this$checkDelegation).getSymbol(), context2)) {
                            return;
                        }
                        if (!($this$checkDelegation instanceof FirClass)) break block7;
                        Iterable $this$firstIsInstanceOrNull$iv = ((FirClass)$this$checkDelegation).getDeclarations();
                        boolean $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof FirPrimaryConstructor)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    FirPrimaryConstructor firPrimaryConstructor = v0;
                    if (firPrimaryConstructor != null) {
                        FirPrimaryConstructor it = firPrimaryConstructor;
                        boolean bl = false;
                        FirDelegatedConstructorCall constructorCall = it.getDelegatedConstructor();
                        Object object = constructorCall;
                        if ((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)constructorCall.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_DELEGATED_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
                        }
                    }
                    for (Map.Entry<FirTypeRef, FirFieldSymbol> entry : FirHelpersKt.collectSupertypesWithDelegates((FirClass)$this$checkDelegation).entrySet()) {
                        FirTypeRef superType2 = entry.getKey();
                        FirFieldSymbol delegate2 = entry.getValue();
                        if (delegate2 == null) continue;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superType2.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
                    }
                    break block8;
                }
                if (!($this$checkDelegation instanceof FirConstructor) || ((FirConstructor)$this$checkDelegation).isPrimary()) break block9;
                FirDelegatedConstructorCall delegationCall = ((FirConstructor)$this$checkDelegation).getDelegatedConstructor();
                Object object = delegationCall;
                if (!((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null) instanceof KtRealSourceElementKind)) break block8;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)delegationCall.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_DELEGATED_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
                break block8;
            }
            if (!($this$checkDelegation instanceof FirProperty)) break block8;
            FirExpression firExpression2 = ((FirProperty)$this$checkDelegation).getDelegate();
            if (firExpression2 != null) {
                FirExpression it = firExpression2;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_DELEGATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkAnonymousInitializer(FirDeclaration $this$checkAnonymousInitializer, CheckerContext context2, DiagnosticReporter reporter) {
        if (!($this$checkAnonymousInitializer instanceof FirClass)) {
            return;
        }
        for (FirAnonymousInitializer anonymousInitializer : FirDeclarationUtilKt.getAnonymousInitializers((FirClass)$this$checkAnonymousInitializer)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)anonymousInitializer.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ANONYMOUS_INITIALIZER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkEnumEntry(FirDeclaration $this$checkEnumEntry, CheckerContext context2, DiagnosticReporter reporter) {
        block1: {
            if (!($this$checkEnumEntry instanceof FirEnumEntry)) {
                return;
            }
            FirExpression firExpression2 = ((FirEnumEntry)$this$checkEnumEntry).getInitializer();
            if (firExpression2 == null) break block1;
            FirExpression it = firExpression2;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ENUM_ENTRY_WITH_BODY(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkConstructorPropertyParam(FirDeclaration $this$checkConstructorPropertyParam, CheckerContext context2, DiagnosticReporter reporter) {
        block6: {
            block5: {
                if (!($this$checkConstructorPropertyParam instanceof FirProperty)) break block5;
                KtSourceElement ktSourceElement = ((FirProperty)$this$checkConstructorPropertyParam).getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) break block6;
            }
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$checkConstructorPropertyParam, context2.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol containingClass = firClassSymbol;
        FirClassLikeSymbol $this$isData$iv = containingClass;
        boolean $i$f$isData = false;
        if ($this$isData$iv.getRawStatus().isData() || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirProperty)$this$checkConstructorPropertyParam).getSource(), FirJsErrors.INSTANCE.getEXTERNAL_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
    }

    private final boolean isDirectlyExternal(FirDeclaration $this$isDirectlyExternal, FirSession session2) {
        block3: {
            block2: {
                if ($this$isDirectlyExternal instanceof FirDefaultPropertyAccessor) break block2;
                KtSourceElement ktSourceElement = $this$isDirectlyExternal.getSource();
                if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) break block3;
            }
            return false;
        }
        FirElement firElement = $this$isDirectlyExternal;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"EXTERNAL_KEYWORD");
        return FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken) || FirAnnotationUtilsKt.hasAnnotation($this$isDirectlyExternal, JsStandardClassIds.Annotations.JsNative, session2);
    }

    private final boolean isPrivateMemberOfExternalClass(FirDeclaration $this$isPrivateMemberOfExternalClass, FirSession session2) {
        block7: {
            block6: {
                boolean $i$f$getVisibility;
                Object $this$visibility$iv;
                if ($this$isPrivateMemberOfExternalClass instanceof FirPropertyAccessor) {
                    $this$visibility$iv = (FirMemberDeclaration)$this$isPrivateMemberOfExternalClass;
                    $i$f$getVisibility = false;
                    Visibility visibility2 = ((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility();
                    $this$visibility$iv = ((FirPropertyAccessor)$this$isPrivateMemberOfExternalClass).getPropertySymbol();
                    $i$f$getVisibility = false;
                    if (Intrinsics.areEqual((Object)visibility2, (Object)((FirCallableSymbol)$this$visibility$iv).getResolvedStatus().getVisibility())) {
                        return false;
                    }
                }
                if (!($this$isPrivateMemberOfExternalClass instanceof FirMemberDeclaration)) break block6;
                $this$visibility$iv = (FirMemberDeclaration)$this$isPrivateMemberOfExternalClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)((FirMemberDeclaration)$this$visibility$iv).getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block7;
            }
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isPrivateMemberOfExternalClass, session2);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> containingDeclaration = firClassLikeSymbol;
        return FirJsHelpersKt.isNativeObject((FirBasedSymbol)containingDeclaration, session2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNonAbstractMemberIfInterface(FirDeclaration $this$isNonAbstractMemberIfInterface, FirSession session2) {
        if (!($this$isNonAbstractMemberIfInterface instanceof FirCallableDeclaration)) return false;
        FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)$this$isNonAbstractMemberIfInterface;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.ABSTRACT) return false;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol($this$isNonAbstractMemberIfInterface, session2);
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if ((firClassSymbol != null ? firClassSymbol.getClassKind() : null) != ClassKind.INTERFACE) return false;
        if ($this$isNonAbstractMemberIfInterface instanceof FirPropertyAccessor) return false;
        return true;
    }

    private final boolean isNullableProperty(FirCallableDeclaration $this$isNullableProperty) {
        return $this$isNullableProperty instanceof FirProperty && ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(((FirProperty)$this$isNullableProperty).getReturnTypeRef()));
    }

    private final boolean hasValidExternalBody(FirDeclaration $this$hasValidExternalBody) {
        boolean bl;
        FirBlock firBlock;
        FirDeclaration firDeclaration = $this$hasValidExternalBody;
        if (firDeclaration instanceof FirFunction) {
            firBlock = ((FirFunction)$this$hasValidExternalBody).getBody();
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            firBlock = ((FirAnonymousInitializer)$this$hasValidExternalBody).getBody();
        } else {
            return true;
        }
        FirBlock body2 = firBlock;
        if (body2 instanceof FirSingleExpressionBlock) {
            bl = this.isDefinedExternallyExpression(body2);
        } else if (body2 != null) {
            FirStatement firStatement = (FirStatement)CollectionsKt.singleOrNull(body2.getStatements());
            if (firStatement == null) {
                return false;
            }
            FirStatement statement2 = firStatement;
            bl = this.isDefinedExternallyExpression(statement2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDefinedExternallyExpression(FirElement $this$isDefinedExternallyExpression) {
        FirPropertySymbol firPropertySymbol;
        FirReference firReference;
        FirPropertyAccessExpression firPropertyAccessExpression;
        FirPropertyAccessExpression firPropertyAccessExpression2 = firPropertyAccessExpression = $this$isDefinedExternallyExpression instanceof FirPropertyAccessExpression ? (FirPropertyAccessExpression)$this$isDefinedExternallyExpression : null;
        if (firPropertyAccessExpression == null || (firReference = firPropertyAccessExpression.getCalleeReference()) == null || (firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(firReference, false, 1, null)) == null) {
            return false;
        }
        FirPropertySymbol declaration = firPropertySymbol;
        return JsStandardClassIds.Callables.definedExternallyPropertyNames.contains(declaration.getCallableId());
    }

    private static final void check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super ConeKotlinType, Boolean> $condition, DiagnosticReporter $reporter, KtDiagnosticFactory0 $diagnosticFactory, CheckerContext $context, ConeKotlinType type2, KtSourceElement elementToReport) {
        if (((Boolean)$condition.invoke((Object)type2)).booleanValue()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)elementToReport, $diagnosticFactory, (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void check$reportOnParametersAndReturnTypesIf(FirDeclaration $declaration, DiagnosticReporter $reporter, CheckerContext $context, KtDiagnosticFactory0 diagnosticFactory, Function1<? super ConeKotlinType, Boolean> condition) {
        if (!($declaration instanceof FirCallableDeclaration) || $declaration instanceof FirDefaultPropertyAccessor || $declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
        boolean bl = ktSourceElement != null ? INSTANCE.getAllowsReporting(ktSourceElement) : false;
        if (bl) {
            KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl2 = false;
                FirJsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, FirTypeUtilsKt.getConeType(((FirCallableDeclaration)$declaration).getReturnTypeRef()), it);
            }
        }
        if (!($declaration instanceof FirFunction)) {
            return;
        }
        for (FirValueParameter parameter2 : ((FirFunction)$declaration).getValueParameters()) {
            KtSourceElement ktParam;
            KtSourceElement ktSourceElement3 = parameter2.getSource();
            KtSourceElement ktSourceElement4 = ktParam = (ktSourceElement3 != null ? KtSourceElementKt.getPsi(ktSourceElement3) : null) instanceof KtParameter ? parameter2.getSource() : ((FirFunction)$declaration).getSource();
            boolean bl3 = ktSourceElement4 != null ? INSTANCE.getAllowsReporting(ktSourceElement4) : false;
            if (!bl3) continue;
            ConeKotlinType coneKotlinType = INSTANCE.getVarargElementType(parameter2);
            if (coneKotlinType == null) {
                coneKotlinType = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
            }
            ConeKotlinType typeToCheck = coneKotlinType;
            FirJsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $reporter, diagnosticFactory, $context, typeToCheck, ktParam);
        }
    }
}

