/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J1\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\u0019\u0010\u001c\u001a\u0015\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\u001d\u00a2\u0006\u0002\b\u001eH\u0082\b\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u000bJ\u0016\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u000fJ\u0016\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage;", "", "<init>", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "enterCallable", "", "leaveCallable", "getParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getLocalFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "putLocalFunction", "firFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "putDelegatedProperty", "firProperty", "irProperty", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrLocalCallableStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n43#1,2:66\n46#1:69\n43#1,2:70\n46#1:73\n43#1,2:74\n46#1:77\n1#2:68\n1#2:72\n1#2:76\n1#2:78\n*S KotlinDebug\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n*L\n34#1:66,2\n34#1:69\n37#1:70,2\n37#1:73\n40#1:74,2\n40#1:77\n34#1:68\n37#1:72\n40#1:76\n*E\n"})
public final class Fir2IrLocalCallableStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack = new ArrayList();

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    public final void leaveCallable() {
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameter local = cache2.getParameter(parameter2);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable variable2) {
        IrVariable irVariable;
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrVariable irVariable2 = $this$getVariable_u24lambda_u240.getVariable(variable2);
                if (irVariable2 == null) continue;
                IrVariable it$iv = irVariable2;
                boolean bl2 = false;
                irVariable = it$iv;
                break block1;
            }
            irVariable = null;
        }
        return irVariable;
    }

    @Nullable
    public final IrSimpleFunctionSymbol getLocalFunctionSymbol(@NotNull FirFunction localFunction) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        block1: {
            Intrinsics.checkNotNullParameter((Object)localFunction, (String)"localFunction");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunctionSymbol_u24lambda_u241 = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = $this$getLocalFunctionSymbol_u24lambda_u241.getLocalFunction(localFunction);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = irSimpleFunction != null ? irSimpleFunction.getSymbol() : null;
                if (irSimpleFunctionSymbol2 == null) continue;
                IrSimpleFunctionSymbol it$iv = irSimpleFunctionSymbol2;
                boolean bl2 = false;
                irSimpleFunctionSymbol = it$iv;
                break block1;
            }
            irSimpleFunctionSymbol = null;
        }
        return irSimpleFunctionSymbol;
    }

    @Nullable
    public final IrLocalDelegatedProperty getDelegatedProperty(@NotNull FirProperty property) {
        IrLocalDelegatedProperty irLocalDelegatedProperty;
        block1: {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u242 = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrLocalDelegatedProperty irLocalDelegatedProperty2 = $this$getDelegatedProperty_u24lambda_u242.getDelegatedProperty(property);
                if (irLocalDelegatedProperty2 == null) continue;
                IrLocalDelegatedProperty it$iv = irLocalDelegatedProperty2;
                boolean bl2 = false;
                irLocalDelegatedProperty = it$iv;
                break block1;
            }
            irLocalDelegatedProperty = null;
        }
        return irLocalDelegatedProperty;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter) {
        Intrinsics.checkNotNullParameter((Object)firParameter, (String)"firParameter");
        Intrinsics.checkNotNullParameter((Object)irParameter, (String)"irParameter");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putParameter(firParameter, irParameter);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariable irVariable) {
        Intrinsics.checkNotNullParameter((Object)firVariable, (String)"firVariable");
        Intrinsics.checkNotNullParameter((Object)irVariable, (String)"irVariable");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putVariable(firVariable, irVariable);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunction irFunction2) {
        Intrinsics.checkNotNullParameter((Object)firFunction, (String)"firFunction");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putLocalFunction(firFunction, irFunction2);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedProperty irProperty2) {
        Intrinsics.checkNotNullParameter((Object)firProperty, (String)"firProperty");
        Intrinsics.checkNotNullParameter((Object)irProperty2, (String)"irProperty");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putDelegatedProperty(firProperty, irProperty2);
    }
}

