/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAssignmentOperatorStatement;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\t2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J0\u0010\u0019\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u0013J\u0014\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "<init>", "()V", "rootFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "assignedLocalVariablesByDeclaration", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "scopes", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "postponedLambdas", "", "", "reset", "", "isAccessToUnstableLocalVariable", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getInfoForDeclaration", "symbol", "enterScope", "evaluatedInPlace", "enterFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "exitFunction", "enterClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "exitClass", "enterFunctionCall", "lambdaArgs", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "exitFunctionCall", "callCompleted", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1747#2,2:416\n1749#2:421\n1603#2,9:423\n1855#2:432\n1856#2:434\n1612#2:435\n1285#2,4:436\n1285#2,4:440\n187#3,3:418\n1#4:422\n1#4:433\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n*L\n62#1:416,2\n62#1:421\n153#1:423,9\n153#1:432\n153#1:434\n153#1:435\n153#1:436,4\n174#1:440,4\n66#1:418,3\n153#1:433\n*E\n"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FirFunctionSymbol<?> rootFunction;
    @Nullable
    private Map<FirBasedSymbol<?>, Companion.Fork> assignedLocalVariablesByDeclaration;
    @NotNull
    private final Stack<Pair<Companion.Fork, Set<FirProperty>>> scopes = StackKt.stackOf(new Pair[0]);
    @NotNull
    private final Stack<Map<Companion.Fork, Boolean>> postponedLambdas = StackKt.stackOf(new Map[0]);

    public final void reset() {
        this.rootFunction = null;
        this.assignedLocalVariablesByDeclaration = null;
        this.postponedLambdas.reset();
        this.scopes.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAccessToUnstableLocalVariable(@NotNull FirExpression fir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        if (this.assignedLocalVariablesByDeclaration == null) {
            return false;
        }
        FirElement firElement = UtilKt.unwrapElement(fir);
        if (!(firElement instanceof FirQualifiedAccessExpression)) return false;
        FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firElement;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression realFir = firQualifiedAccessExpression;
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(realFir.getCalleeReference(), false, 1, null);
        Object object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        if ((object = (FirProperty)((FirBasedSymbol)object).getFir()) == null) {
            return false;
        }
        Object property = object;
        if (((Set)this.scopes.top().getSecond()).contains(property)) return true;
        Iterable $this$any$iv = this.postponedLambdas.all();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map lambdas = (Map)element$iv;
            boolean bl2 = false;
            Map $this$any$iv2 = lambdas;
            boolean $i$f$any2 = false;
            if ($this$any$iv2.isEmpty()) {
                bl = false;
                continue;
            }
            Iterator iterator3 = $this$any$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator3.next();
                boolean bl3 = false;
                Companion.Fork lambda2 = (Companion.Fork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly && lambda2.getAssignedInside().contains(property)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Companion.Fork getInfoForDeclaration(FirBasedSymbol<?> symbol2) {
        FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
        if (firFunctionSymbol == null) {
            return null;
        }
        FirFunctionSymbol<?> root2 = firFunctionSymbol;
        if (Intrinsics.areEqual(root2, symbol2)) {
            return null;
        }
        Map<FirBasedSymbol<?>, Companion.Fork> map = this.assignedLocalVariablesByDeclaration;
        if (map == null) {
            Map<FirBasedSymbol<?>, Companion.Fork> map2;
            FirLocalVariableAssignmentAnalyzer $this$getInfoForDeclaration_u24lambda_u243 = this;
            boolean bl = false;
            Companion.MiniCfgBuilder.MiniCfgData data2 = new Companion.MiniCfgBuilder.MiniCfgData();
            new Companion.MiniCfgBuilder().visitElement((FirElement)root2.getFir(), data2);
            Map<FirBasedSymbol<?>, Companion.Fork> it = map2 = data2.getForks();
            boolean bl2 = false;
            $this$getInfoForDeclaration_u24lambda_u243.assignedLocalVariablesByDeclaration = it;
            map = map2;
        }
        Map<FirBasedSymbol<?>, Companion.Fork> cachedMap = map;
        return cachedMap.get(symbol2);
    }

    private final Pair<Companion.Fork, Set<FirProperty>> enterScope(FirBasedSymbol<?> symbol2, boolean evaluatedInPlace) {
        Companion.Fork currentInfo = this.getInfoForDeclaration(symbol2);
        Set prohibitInThisScope = CollectionsKt.toMutableSet((Iterable)((Iterable)this.scopes.top().getSecond()));
        this.scopes.push((Pair<Companion.Fork, Set<FirProperty>>)TuplesKt.to((Object)currentInfo, (Object)prohibitInThisScope));
        if (!evaluatedInPlace) {
            for (Pair<Companion.Fork, Set<FirProperty>> pair : this.scopes.all()) {
                Object object;
                Collection p0;
                Companion.Fork outerInfo = (Companion.Fork)pair.component1();
                Set prohibitInOuterScope = (Set)pair.component2();
                Object object2 = currentInfo;
                if (object2 != null && (object2 = ((Companion.Fork)object2).getAssignedInside()) != null) {
                    p0 = (Collection)object2;
                    boolean bl = false;
                    prohibitInOuterScope.addAll(p0);
                }
                if ((object = outerInfo) == null || (object = ((Companion.Fork)object).getAssignedLater()) == null) continue;
                p0 = (Collection)object;
                boolean bl = false;
                prohibitInThisScope.addAll(p0);
            }
        }
        return this.scopes.top();
    }

    public final void enterFunction(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (this.rootFunction == null) {
            this.rootFunction = function2.getSymbol();
            this.scopes.push((Pair<Companion.Fork, Set<FirProperty>>)TuplesKt.to(null, (Object)new LinkedHashSet()));
            return;
        }
        Pair<Companion.Fork, Set<FirProperty>> pair = this.enterScope((FirBasedSymbol)function2.getSymbol(), function2 instanceof FirAnonymousFunction && EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)function2).getInvocationKind()));
        Companion.Fork info = (Companion.Fork)pair.component1();
        Set prohibitSmartCasts = (Set)pair.component2();
        for (Map<Companion.Fork, Boolean> concurrentLambdas : this.postponedLambdas.all()) {
            for (Map.Entry<Companion.Fork, Boolean> entry : concurrentLambdas.entrySet()) {
                Companion.Fork otherLambda = entry.getKey();
                boolean dataFlowOnly = entry.getValue();
                if (dataFlowOnly || Intrinsics.areEqual((Object)otherLambda, (Object)info)) continue;
                CollectionsKt.addAll((Collection)prohibitSmartCasts, (Iterable)otherLambda.getAssignedInside());
            }
        }
    }

    public final void exitFunction() {
        this.scopes.pop();
        if (StackKt.isEmpty(this.scopes)) {
            this.rootFunction = null;
            this.assignedLocalVariablesByDeclaration = null;
        }
    }

    public final void enterClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.rootFunction == null) {
            return;
        }
        Pair<Companion.Fork, Set<FirProperty>> pair = this.enterScope((FirBasedSymbol)klass.getSymbol(), klass instanceof FirAnonymousObject);
        Companion.Fork info = (Companion.Fork)pair.component1();
        Set prohibitSmartCasts = (Set)pair.component2();
        if (klass instanceof FirAnonymousObject && info != null) {
            prohibitSmartCasts.addAll((Collection)info.getAssignedInside());
        }
    }

    public final void exitClass() {
        if (this.rootFunction == null) {
            return;
        }
        this.scopes.pop();
    }

    /*
     * WARNING - void declaration
     */
    public final void enterFunctionCall(@NotNull Collection<? extends FirAnonymousFunction> lambdaArgs) {
        void var3_5;
        void $this$associateWithTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(lambdaArgs, (String)"lambdaArgs");
        if (this.rootFunction == null) {
            return;
        }
        Iterable iterable = lambdaArgs;
        Stack<Map<Companion.Fork, Boolean>> stack = this.postponedLambdas;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Companion.Fork $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.Fork it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnonymousFunction it = (FirAnonymousFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getInfoForDeclaration(it.getSymbol()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map $i$f$mapNotNull22 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            void destination$iv;
            $this$forEach$iv$iv$iv = (Companion.Fork)element$iv;
            Object t = element$iv;
            void var18_21 = destination$iv;
            boolean bl = false;
            Boolean bl4 = false;
            var18_21.put(t, bl4);
        }
        stack.push((Map<Companion.Fork, Boolean>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitFunctionCall(boolean callCompleted) {
        if (this.rootFunction == null) {
            return;
        }
        Map<Companion.Fork, Boolean> lambdasInCall = this.postponedLambdas.pop();
        if (!callCompleted) {
            void $this$associateWithTo$iv;
            Iterable iterable = lambdasInCall.keySet();
            Map<Companion.Fork, Boolean> map = StackKt.topOrNull(this.postponedLambdas);
            if (map == null) {
                return;
            }
            Map<Companion.Fork, Boolean> destination$iv = map;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Companion.Fork fork = (Companion.Fork)element$iv;
                Object t = element$iv;
                Map<Companion.Fork, Boolean> map2 = destination$iv;
                boolean bl = false;
                Boolean bl2 = true;
                map2.put((Companion.Fork)t, bl2);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "<init>", "()V", "Fork", "MiniFlow", "MiniCfgBuilder", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "", "assignedLater", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "assignedInside", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "getAssignedLater", "()Ljava/util/Set;", "getAssignedInside", "resolve"})
        public static final class Fork {
            @NotNull
            private final Set<FirProperty> assignedLater;
            @NotNull
            private final Set<FirProperty> assignedInside;

            public Fork(@NotNull Set<? extends FirProperty> assignedLater, @NotNull Set<? extends FirProperty> assignedInside) {
                Intrinsics.checkNotNullParameter(assignedLater, (String)"assignedLater");
                Intrinsics.checkNotNullParameter(assignedInside, (String)"assignedInside");
                this.assignedLater = assignedLater;
                this.assignedInside = assignedInside;
            }

            @NotNull
            public final Set<FirProperty> getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final Set<FirProperty> getAssignedInside() {
                return this.assignedInside;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001@B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0012\u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020#0\u000bH\u0002J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0014\u0010;\u001a\u00020\u0002*\u00020\u00032\u0006\u0010<\u001a\u00020=H\u0002J\u001a\u0010>\u001a\u00020\u0002*\u00020#2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "<init>", "()V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitElementWithLexicalScope", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitLocalDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "join", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitProperty", "property", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitAssignmentOperatorStatement", "assignmentOperatorStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirAssignmentOperatorStatement;", "recordAssignment", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "recordAssignments", "properties", "MiniCfgData", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1446#2,5:416\n1620#2,3:422\n1620#2,3:425\n1855#2,2:428\n3190#2,10:430\n1855#2,2:440\n1855#2,2:442\n533#2,6:444\n1855#2,2:450\n1#3:421\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n*L\n279#1:416,5\n311#1:422,3\n322#1:425,3\n357#1:428,2\n361#1:430,10\n362#1:440,2\n363#1:442,2\n396#1:444,6\n404#1:450,2\n*E\n"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                element.acceptChildren(this, data2);
            }

            /*
             * WARNING - void declaration
             */
            private final Set<FirProperty> visitElementWithLexicalScope(FirElement element, MiniCfgData data2) {
                void destination$iv;
                void $this$flatMapTo$iv;
                MiniFlow flow = MiniFlow.Companion.start();
                Set<FirProperty> set = (Set<FirProperty>)data2.getVariableDeclarations();
                Collection collection = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Map it = (Map)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.values();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Set freeVariables = (Set)destination$iv;
                data2.setFlow(flow);
                element.acceptChildren(this, data2);
                Set<FirProperty> $this$visitElementWithLexicalScope_u24lambda_u241 = set = flow.getAssignedLater();
                boolean bl = false;
                $this$visitElementWithLexicalScope_u24lambda_u241.retainAll(freeVariables);
                return set;
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(anonymousFunction, data2);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(simpleFunction, data2);
            }

            @Override
            public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(regularClass, data2);
            }

            @Override
            public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(anonymousObject, data2);
            }

            private final void visitLocalDeclaration(FirDeclaration declaration, MiniCfgData data2) {
                MiniFlow flow = data2.getFlow();
                Set<FirProperty> assignedInside = this.visitElementWithLexicalScope(declaration, data2);
                this.recordAssignments(flow, assignedInside);
                data2.setFlow(flow.fork());
                data2.getForks().put(declaration.getSymbol(), new Fork(data2.getFlow().getAssignedLater(), assignedInside));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data2) {
                void var13_13;
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                FirVariable firVariable = whenExpression.getSubjectVariable();
                FirElement firElement = firVariable != null ? (FirElement)firVariable : (FirElement)whenExpression.getSubject();
                if (firElement != null) {
                    ((FirStatement)firElement).accept(this, data2);
                }
                MiniFlow flow = data2.getFlow();
                Iterable iterable = whenExpression.getBranches();
                Object object = new MiniFlow[]{flow};
                object = SetsKt.mutableSetOf((Object[])object);
                MiniCfgBuilder miniCfgBuilder = this;
                MiniCfgData miniCfgData = data2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirWhenBranch firWhenBranch = (FirWhenBranch)item$iv;
                    var13_13 = destination$iv;
                    boolean bl = false;
                    data2.setFlow(flow);
                    it.accept(this, data2);
                    var13_13.add(data2.getFlow());
                }
                var13_13 = destination$iv;
                miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull MiniCfgData data2) {
                block1: {
                    void var13_13;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    tryExpression.getTryBlock().accept(this, data2);
                    MiniFlow flow = data2.getFlow();
                    Iterable iterable = tryExpression.getCatches();
                    Object object = new MiniFlow[]{flow};
                    object = SetsKt.mutableSetOf((Object[])object);
                    MiniCfgBuilder miniCfgBuilder = this;
                    MiniCfgData miniCfgData = data2;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        FirCatch firCatch = (FirCatch)item$iv;
                        var13_13 = destination$iv;
                        boolean bl = false;
                        data2.setFlow(flow);
                        it.accept(this, data2);
                        var13_13.add(data2.getFlow());
                    }
                    var13_13 = destination$iv;
                    miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
                    FirBlock firBlock = tryExpression.getFinallyBlock();
                    if (firBlock == null) break block1;
                    firBlock.accept(this, data2);
                }
            }

            private final MiniFlow join(Set<MiniFlow> $this$join) {
                MiniFlow miniFlow = (MiniFlow)CollectionsKt.singleOrNull((Iterable)$this$join);
                if (miniFlow == null) {
                    miniFlow = new MiniFlow($this$join);
                }
                return miniFlow;
            }

            @Override
            public void visitLoop(@NotNull FirLoop loop2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniFlow entry = data2.getFlow();
                Set<FirProperty> assignedInside = this.visitElementWithLexicalScope(loop2, data2);
                this.recordAssignments(data2.getFlow(), assignedInside);
                Object[] objectArray = new MiniFlow[]{entry, data2.getFlow()};
                data2.setFlow(this.join(SetsKt.setOf((Object[])objectArray)));
            }

            @Override
            public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLoop((FirLoop)whileLoop, data2);
            }

            @Override
            public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLoop((FirLoop)doWhileLoop, data2);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data2) {
                FirExpression it;
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u248 = functionCall;
                boolean bl = false;
                FirExpression[] firExpressionArray = new FirExpression[]{$this$visitFunctionCall_u24lambda_u248.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u248.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u248.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull((Object[])firExpressionArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data2);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u248.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    if (it instanceof FirAnonymousFunctionExpression) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                firExpressionArray = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)firExpressionArray.component1();
                List normalArgs = (List)firExpressionArray.component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl4 = false;
                    it.accept(visitor2, data2);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data2);
                }
                $this$visitFunctionCall_u24lambda_u248.getCalleeReference().accept(visitor2, data2);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                data2.getVariableDeclarations().addLast((Object)new LinkedHashMap());
                this.visitElement((FirElement)block, data2);
                data2.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)property, data2);
                if (property.isLocal()) {
                    ((Map)data2.getVariableDeclarations().last()).put(property.getName(), property);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data2) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    this.visitElement((FirElement)variableAssignment, data2);
                    if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                        return;
                    }
                    FirReference firReference = FirExpressionUtilKt.getCalleeReference(variableAssignment);
                    if (firReference == null) break block1;
                    FirReference it = firReference;
                    boolean bl = false;
                    this.recordAssignment(data2, it);
                }
            }

            @Override
            public void visitAssignmentOperatorStatement(@NotNull FirAssignmentOperatorStatement assignmentOperatorStatement, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)assignmentOperatorStatement, (String)"assignmentOperatorStatement");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)assignmentOperatorStatement, data2);
                FirExpression firExpression2 = assignmentOperatorStatement.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data2, lhs.getCalleeReference());
            }

            private final void recordAssignment(MiniCfgData $this$recordAssignment, FirReference reference2) {
                Object object;
                Object v1;
                Object name2;
                block3: {
                    Object object2 = reference2 instanceof FirNamedReference ? (FirNamedReference)reference2 : null;
                    if (object2 == null || (object2 = ((FirNamedReference)object2).getName()) == null) {
                        return;
                    }
                    name2 = object2;
                    List $this$lastOrNull$iv = (List)$this$recordAssignment.getVariableDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!it.containsKey(name2)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                if ((object = (Map)v1) == null || (object = (FirProperty)object.get(name2)) == null) {
                    return;
                }
                Object property = object;
                this.recordAssignments($this$recordAssignment.getFlow(), SetsKt.setOf((Object)property));
            }

            private final void recordAssignments(MiniFlow $this$recordAssignments, Set<? extends FirProperty> properties2) {
                if (!$this$recordAssignments.getAssignedLater().addAll((Collection<FirProperty>)properties2)) {
                    return;
                }
                Iterable $this$forEach$iv = $this$recordAssignments.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignments(it, properties2);
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0004\u0012\u00020\u00130\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "<init>", "()V", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "forks", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "getForks", "()Ljava/util/Map;", "resolve"})
            public static final class MiniCfgData {
                @NotNull
                private MiniFlow flow = MiniFlow.Companion.start();
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations = new ArrayDeque((Collection)CollectionsKt.listOf((Object)new LinkedHashMap()));
                @NotNull
                private final Map<FirBasedSymbol<?>, Fork> forks = new LinkedHashMap();

                @NotNull
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@NotNull MiniFlow miniFlow) {
                    Intrinsics.checkNotNullParameter((Object)miniFlow, (String)"<set-?>");
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirBasedSymbol<?>, Fork> getForks() {
                    return this.forks;
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "parents", "", "<init>", "(Ljava/util/Set;)V", "getParents", "()Ljava/util/Set;", "assignedLater", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getAssignedLater", "fork", "Companion", "resolve"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final Set<FirProperty> assignedLater;

            public MiniFlow(@NotNull Set<MiniFlow> parents2) {
                Intrinsics.checkNotNullParameter(parents2, (String)"parents");
                this.parents = parents2;
                this.assignedLater = new LinkedHashSet();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final Set<FirProperty> getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf((Object)this));
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "<init>", "()V", "start", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "resolve"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

