/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.IrTranslationResultMap;
import org.jetbrains.kotlin.incremental.PackageMetadataMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDataProvider;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.incremental.storage.SourceToJsOutputMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001FB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040.H\u0016J\"\u0010/\u001a\u00020,2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u000204J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040.2\u0006\u00106\u001a\u00020\u0004J\u0016\u00107\u001a\u00020,2\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u000204J\u0018\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u0002H\u0002J\u0010\u0010=\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0016J\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020201J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020%01J\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A01J\u0014\u0010B\u001a\u00020,2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "irTranslationResults", "Lorg/jetbrains/kotlin/incremental/IrTranslationResultMap;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "packageMetadata", "Lorg/jetbrains/kotlin/incremental/PackageMetadataMap;", "sourceToJsOutputsMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap;", "dirtySources", "Ljava/util/HashSet;", "headerFile", "getHeaderFile", "()Ljava/io/File;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "markDirty", "", "removedAndCompiledSources", "", "compare", "translatedFiles", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "getOutputsBySource", "sourceFile", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "registerOutputForFile", "srcFile", "name", "clearCacheForRemovedClasses", "nonDirtyPackageParts", "", "nonDirtyIrParts", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "updateSourceToOutputMap", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "Companion", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nIncrementalJsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalJsCache.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n1855#2:455\n1549#2:456\n1620#2,3:457\n2333#2,14:460\n1856#2:474\n1855#2,2:476\n1#3:475\n*S KotlinDebug\n*F\n+ 1 IncrementalJsCache.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCache\n*L\n79#1:455\n82#1:456\n82#1:457,3\n82#1:460,14\n79#1:474\n150#1:476,2\n*E\n"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final ProtoDataProvider protoData;
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    @NotNull
    private final TranslationResultMap translationResults;
    @NotNull
    private final IrTranslationResultMap irTranslationResults;
    @NotNull
    private final InlineFunctionsMap inlineFunctions;
    @NotNull
    private final PackageMetadataMap packageMetadata;
    @NotNull
    private final SourceToJsOutputMap sourceToJsOutputsMap;
    @NotNull
    private final HashSet<File> dirtySources;

    public IncrementalJsCache(@NotNull File cachesDir, @NotNull IncrementalCompilationContext icContext, @NotNull SerializerExtensionProtocol serializerProtocol) {
        Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        super(cachesDir, icContext);
        this.icContext = icContext;
        this.protoData = new ProtoDataProvider(serializerProtocol);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.getSOURCE_TO_CLASSES()), this.icContext));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.getDIRTY_OUTPUT_CLASSES()), this.icContext));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile("translation-result"), this.protoData, this.icContext));
        this.irTranslationResults = (IrTranslationResultMap)this.registerMap((BasicMap)new IrTranslationResultMap(this.getStorageFile("ir-translation-result"), this.icContext));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile("inline-functions"), this.icContext));
        this.packageMetadata = (PackageMetadataMap)this.registerMap((BasicMap)new PackageMetadataMap(this.getStorageFile("packages-meta"), this.icContext));
        this.sourceToJsOutputsMap = (SourceToJsOutputMap)this.registerMap((BasicMap)new SourceToJsOutputMap(this.getStorageFile("source-to-js-output"), this.icContext));
        this.dirtySources = new HashSet();
    }

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), "header.meta");
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        CompilationTransaction compilationTransaction = this.icContext.getTransaction();
        Path path = this.getHeaderFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        CompilationTransactionKt.writeBytes(compilationTransaction, path, value2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkNotNullParameter(removedAndCompiledSources, (String)"removedAndCompiledSources");
        Iterable $this$forEach$iv = removedAndCompiledSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Object v1;
            void $this$mapTo$iv$iv;
            File sourceFile = (File)element$iv;
            boolean bl = false;
            this.sourceToJsOutputsMap.remove(sourceFile);
            Iterable $this$map$iv = this.getSourceToClassesMap$kotlin_build_common().get(sourceFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FqName fqName2 = (FqName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object object = FqNamesUtilKt.parentOrNull((FqName)it2);
                if (object == null || (object = ((FqName)object).asString()) == null) {
                    object = "";
                }
                collection.add(object);
            }
            Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    String it3 = (String)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it3.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it4 = (String)e$iv;
                        $i$a$-minByOrNull-IncrementalJsCache$markDirty$1$2 = false;
                        int v$iv = it4.length();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            if ((String)v1 == null) continue;
            boolean bl4 = false;
            this.packageMetadata.remove(it);
        }
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    public final void compare(@NotNull Map<File, TranslationResultValue> translatedFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter(translatedFiles, (String)"translatedFiles");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        for (Map.Entry<File, TranslationResultValue> entry : translatedFiles.entrySet()) {
            Object object;
            TranslationResultValue data2;
            File srcFile;
            block5: {
                block4: {
                    srcFile = entry.getKey();
                    data2 = entry.getValue();
                    object = this.translationResults.get(srcFile);
                    if (object == null) break block4;
                    byte[] byArray = ((TranslationResultValue)object).getMetadata();
                    object = byArray;
                    if (byArray == null) break block4;
                    Map<ClassId, ProtoData> it = object;
                    boolean bl = false;
                    Map<ClassId, ProtoData> map = this.protoData.invoke(srcFile, (byte[])it);
                    object = map;
                    if (map != null) break block5;
                }
                object = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, data2.getMetadata());
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, null, 12, null);
            }
        }
    }

    @NotNull
    public final Collection<File> getOutputsBySource(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.sourceToJsOutputsMap.get(sourceFile);
    }

    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        File srcFile;
        Intrinsics.checkNotNullParameter((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Map<File, TranslationResultValue> translatedFiles = incrementalResults.getPackageParts();
        for (Map.Entry<File, TranslationResultValue> entry : translatedFiles.entrySet()) {
            Object object;
            byte[] inlineData;
            byte[] binaryAst;
            byte[] binaryMetadata;
            block9: {
                block8: {
                    srcFile = entry.getKey();
                    TranslationResultValue data2 = entry.getValue();
                    this.dirtySources.remove(srcFile);
                    binaryMetadata = data2.component1();
                    binaryAst = data2.component2();
                    inlineData = data2.component3();
                    object = this.translationResults.get(srcFile);
                    if (object == null) break block8;
                    byte[] byArray = ((TranslationResultValue)object).getMetadata();
                    object = byArray;
                    if (byArray == null) break block8;
                    Map<ClassId, ProtoData> it = object;
                    boolean bl = false;
                    Map<ClassId, ProtoData> map = this.protoData.invoke(srcFile, (byte[])it);
                    object = map;
                    if (map != null) break block9;
                }
                object = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, binaryMetadata);
            for (Map.Entry<ClassId, ProtoData> entry2 : newProtoMap.entrySet()) {
                ClassId classId = entry2.getKey();
                ProtoData protoData2 = entry2.getValue();
                this.registerOutputForFile(srcFile, classId.asSingleFqName());
                if (!(protoData2 instanceof ClassProtoData)) continue;
                this.addToClassStorage((ClassProtoData)protoData2, srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, null, 12, null);
            }
            this.translationResults.put(srcFile, binaryMetadata, binaryAst, inlineData);
        }
        for (Map.Entry<File, Object> entry : incrementalResults.getInlineFunctions().entrySet()) {
            srcFile = entry.getKey();
            Map inlineDeclarations = (Map)entry.getValue();
            this.inlineFunctions.process(srcFile, inlineDeclarations, changesCollector);
        }
        for (Map.Entry<Object, Object> entry : incrementalResults.getPackageMetadata().entrySet()) {
            String packageName2 = (String)entry.getKey();
            byte[] metadata = (byte[])entry.getValue();
            this.packageMetadata.put(packageName2, metadata);
        }
        for (Map.Entry<Object, Object> entry : incrementalResults.getIrFileData().entrySet()) {
            srcFile = (File)entry.getKey();
            IrTranslationResultValue irData = (IrTranslationResultValue)entry.getValue();
            byte[] fileData = irData.component1();
            byte[] types2 = irData.component2();
            byte[] signatures2 = irData.component3();
            byte[] strings2 = irData.component4();
            byte[] declarations2 = irData.component5();
            byte[] bodies2 = irData.component6();
            byte[] fqn = irData.component7();
            byte[] fileMetadata = irData.component8();
            byte[] debugInfos2 = irData.component9();
            this.irTranslationResults.put(srcFile, fileData, types2, signatures2, strings2, declarations2, bodies2, fqn, fileMetadata, debugInfos2);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name2) {
        this.getSourceToClassesMap$kotlin_build_common().add(srcFile, name2);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name2);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Iterable $this$forEach$iv = this.dirtySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.translationResults.remove(it, changesCollector);
            this.irTranslationResults.remove(it);
            this.inlineFunctions.remove(it);
        }
        this.removeAllFromClassStorage(this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector);
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clear();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        HashMap<File, TranslationResultValue> hashMap;
        HashMap<File, TranslationResultValue> $this$nonDirtyPackageParts_u24lambda_u247 = hashMap = new HashMap<File, TranslationResultValue>();
        boolean bl = false;
        for (File file2 : this.translationResults.keys()) {
            if (this.dirtySources.contains(file2)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(file2);
            Intrinsics.checkNotNull((Object)translationResultValue);
            $this$nonDirtyPackageParts_u24lambda_u247.put(file2, translationResultValue);
        }
        return hashMap;
    }

    @NotNull
    public final Map<String, byte[]> packageMetadata() {
        HashMap hashMap;
        HashMap $this$packageMetadata_u24lambda_u248 = hashMap = new HashMap();
        boolean bl = false;
        for (String fqNameString : this.packageMetadata.keys()) {
            Object VALUE = this.packageMetadata.get(fqNameString);
            Intrinsics.checkNotNull(VALUE);
            $this$packageMetadata_u24lambda_u248.put(fqNameString, VALUE);
        }
        return hashMap;
    }

    @NotNull
    public final Map<File, IrTranslationResultValue> nonDirtyIrParts() {
        HashMap<File, IrTranslationResultValue> hashMap;
        HashMap<File, IrTranslationResultValue> $this$nonDirtyIrParts_u24lambda_u249 = hashMap = new HashMap<File, IrTranslationResultValue>();
        boolean bl = false;
        for (File file2 : this.irTranslationResults.keys()) {
            if (this.dirtySources.contains(file2)) continue;
            IrTranslationResultValue irTranslationResultValue = this.irTranslationResults.get(file2);
            Intrinsics.checkNotNull((Object)irTranslationResultValue);
            $this$nonDirtyIrParts_u24lambda_u249.put(file2, irTranslationResultValue);
        }
        return hashMap;
    }

    public final void updateSourceToOutputMap(@NotNull Iterable<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        for (GeneratedFile generatedFile : generatedFiles) {
            for (File source : generatedFile.getSourceFiles()) {
                if (!this.dirtySources.contains(source)) continue;
                this.sourceToJsOutputsMap.add(source, generatedFile.getOutputFile());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "<init>", "()V", "TRANSLATION_RESULT_MAP", "", "IR_TRANSLATION_RESULT_MAP", "INLINE_FUNCTIONS", "HEADER_FILE_NAME", "PACKAGE_META_FILE", "SOURCE_TO_JS_OUTPUT", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, "header.meta").exists();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

