/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.CachedClasspathSnapshotSerializer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotBuildReporter;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotShrinker;
import org.jetbrains.kotlin.incremental.classpathDiff.ShrinkMode;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.incremental.storage.ListExternalizer;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003H\u0002\u001aH\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"removeDuplicateAndInaccessibleClasses", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/AccessibleClassSnapshot;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshot;", "getNonDuplicateClassSnapshots", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshot;", "shrinkAndSaveClasspathSnapshot", "", "compilationWasIncremental", "", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges$ClasspathSnapshotEnabled;", "lookupStorage", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "currentClasspathSnapshot", "shrunkCurrentClasspathAgainstPreviousLookups", "reporter", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotBuildReporter;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nClasspathSnapshotShrinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshotShrinker.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotShrinkerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,327:1\n800#2,11:328\n1620#2,3:353\n766#2:356\n857#2,2:357\n1#3:339\n31#4,3:340\n31#4,5:343\n31#4,5:348\n35#4:359\n31#4,3:360\n31#4,5:363\n35#4:368\n31#4,5:369\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshotShrinker.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotShrinkerKt\n*L\n148#1:328,11\n270#1:353,3\n271#1:356\n271#1:357,2\n246#1:340,3\n248#1:343,5\n258#1:348,5\n246#1:359\n279#1:360,3\n280#1:363,5\n279#1:368\n298#1:369,5\n*E\n"})
public final class ClasspathSnapshotShrinkerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AccessibleClassSnapshot> removeDuplicateAndInaccessibleClasses(@NotNull ClasspathSnapshot $this$removeDuplicateAndInaccessibleClasses) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$removeDuplicateAndInaccessibleClasses, (String)"<this>");
        Iterable $this$filterIsInstance$iv = ClasspathSnapshotShrinkerKt.getNonDuplicateClassSnapshots($this$removeDuplicateAndInaccessibleClasses);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AccessibleClassSnapshot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ClassSnapshot> getNonDuplicateClassSnapshots(ClasspathSnapshot $this$getNonDuplicateClassSnapshots) {
        Iterable iterable = $this$getNonDuplicateClassSnapshots.getClasspathEntrySnapshots();
        int n = 0;
        Iterator<Object> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object object = iterator2.next();
            ClasspathEntrySnapshot classpathEntrySnapshot = (ClasspathEntrySnapshot)object;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getClassSnapshots().size();
            n = n2 + n3;
        }
        int n4 = n;
        LinkedHashMap<String, ClassSnapshot> classSnapshots = new LinkedHashMap<String, ClassSnapshot>(n4);
        for (ClasspathEntrySnapshot classpathEntrySnapshot : $this$getNonDuplicateClassSnapshots.getClasspathEntrySnapshots()) {
            for (Map.Entry entry : ((Map)classpathEntrySnapshot.getClassSnapshots()).entrySet()) {
                String unixStyleRelativePath = (String)entry.getKey();
                ClassSnapshot classSnapshot = (ClassSnapshot)entry.getValue();
                classSnapshots.putIfAbsent(unixStyleRelativePath, classSnapshot);
            }
        }
        Collection collection = classSnapshots.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void shrinkAndSaveClasspathSnapshot(boolean compilationWasIncremental, @NotNull ClasspathChanges.ClasspathSnapshotEnabled classpathChanges, @NotNull LookupStorage lookupStorage, @Nullable List<? extends AccessibleClassSnapshot> currentClasspathSnapshot, @Nullable List<? extends AccessibleClassSnapshot> shrunkCurrentClasspathAgainstPreviousLookups, @NotNull ClasspathSnapshotBuildReporter reporter) {
        long l;
        Object time$iv;
        Pair pair;
        Set<LookupSymbolKey> addedLookupSymbols;
        ClasspathChanges.ClasspathSnapshotEnabled classpathSnapshotEnabled;
        ShrinkMode shrinkMode;
        Intrinsics.checkNotNullParameter((Object)classpathChanges, (String)"classpathChanges");
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!compilationWasIncremental) {
            shrinkMode = ShrinkMode.NonIncremental.INSTANCE;
        } else {
            classpathSnapshotEnabled = classpathChanges;
            if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.NoChanges) {
                addedLookupSymbols = lookupStorage.getAddedLookupSymbols();
                shrinkMode = addedLookupSymbols.isEmpty() ? (ShrinkMode)ShrinkMode.UnchangedLookupsUnchangedClasspath.INSTANCE : (ShrinkMode)new ShrinkMode.ChangedLookupsUnchangedClasspath(addedLookupSymbols);
            } else if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.ToBeComputedByIncrementalCompiler) {
                addedLookupSymbols = lookupStorage.getAddedLookupSymbols();
                if (addedLookupSymbols.isEmpty()) {
                    List<? extends AccessibleClassSnapshot> list2 = currentClasspathSnapshot;
                    Intrinsics.checkNotNull(list2);
                    List<? extends AccessibleClassSnapshot> list3 = shrunkCurrentClasspathAgainstPreviousLookups;
                    Intrinsics.checkNotNull(list3);
                    shrinkMode = new ShrinkMode.UnchangedLookupsChangedClasspath(list2, list3);
                } else {
                    List<? extends AccessibleClassSnapshot> list4 = currentClasspathSnapshot;
                    Intrinsics.checkNotNull(list4);
                    List<? extends AccessibleClassSnapshot> list5 = shrunkCurrentClasspathAgainstPreviousLookups;
                    Intrinsics.checkNotNull(list5);
                    shrinkMode = new ShrinkMode.ChangedLookupsChangedClasspath(addedLookupSymbols, list4, list5);
                }
            } else if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableDueToMissingClasspathSnapshot) {
                shrinkMode = ShrinkMode.NonIncremental.INSTANCE;
            } else {
                if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableForNonIncrementalRun) {
                    throw new IllegalStateException("NotAvailableForNonIncrementalRun is not expected as compilationWasIncremental==true".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        ShrinkMode shrinkMode2 = shrinkMode;
        addedLookupSymbols = shrinkMode2;
        if (addedLookupSymbols instanceof ShrinkMode.UnchangedLookupsUnchangedClasspath) {
            pair = TuplesKt.to(null, null);
        } else if (addedLookupSymbols instanceof ShrinkMode.UnchangedLookupsChangedClasspath) {
            pair = TuplesKt.to(((ShrinkMode.UnchangedLookupsChangedClasspath)shrinkMode2).getCurrentClasspathSnapshot(), ((ShrinkMode.UnchangedLookupsChangedClasspath)shrinkMode2).getShrunkCurrentClasspathAgainstPreviousLookups());
        } else {
            Object shrunkCurrentClasspathAgainstPrevLookups;
            void $this$measure$iv;
            Object time$iv2;
            BuildMetricsReporter $this$measure$iv2;
            boolean $i$f$measure;
            if (addedLookupSymbols instanceof ShrinkMode.ChangedLookups) {
                BuildMetricsReporter buildMetricsReporter = reporter;
                time$iv = GradleBuildTime.INCREMENTAL_SHRINK_CURRENT_CLASSPATH_SNAPSHOT;
                $i$f$measure = false;
                $this$measure$iv2.startMeasure(time$iv);
                try {
                    void $this$filterTo$iv$iv;
                    void destination$iv;
                    void $this$mapTo$iv;
                    List list6;
                    void $this$measure$iv3;
                    Object object;
                    boolean bl = false;
                    BuildMetricsReporter buildMetricsReporter2 = reporter;
                    time$iv2 = GradleBuildTime.INCREMENTAL_LOAD_CURRENT_CLASSPATH_SNAPSHOT;
                    boolean $i$f$measure2 = false;
                    $this$measure$iv.startMeasure(time$iv2);
                    try {
                        List<AccessibleClassSnapshot> list7;
                        boolean bl2 = false;
                        ShrinkMode.ChangedLookups changedLookups = (ShrinkMode.ChangedLookups)shrinkMode2;
                        if (changedLookups instanceof ShrinkMode.ChangedLookupsUnchangedClasspath) {
                            list7 = ClasspathSnapshotShrinkerKt.removeDuplicateAndInaccessibleClasses(CachedClasspathSnapshotSerializer.INSTANCE.load(classpathChanges.getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles(), reporter));
                        } else if (changedLookups instanceof ShrinkMode.ChangedLookupsChangedClasspath) {
                            list7 = ((ShrinkMode.ChangedLookupsChangedClasspath)shrinkMode2).getCurrentClasspathSnapshot();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        object = list7;
                    }
                    finally {
                        $this$measure$iv.endMeasure(time$iv2);
                    }
                    List<AccessibleClassSnapshot> currentClasspath = object;
                    time$iv2 = reporter;
                    Object time$iv3 = GradleBuildTime.INCREMENTAL_LOAD_SHRUNK_CURRENT_CLASSPATH_SNAPSHOT_AGAINST_PREVIOUS_LOOKUPS;
                    boolean $i$f$measure222 = false;
                    $this$measure$iv3.startMeasure(time$iv3);
                    try {
                        List list8;
                        boolean bl3 = false;
                        object = (ShrinkMode.ChangedLookups)shrinkMode2;
                        if (object instanceof ShrinkMode.ChangedLookupsUnchangedClasspath) {
                            list8 = (List)ExternalizersKt.loadFromFile(new ListExternalizer(AccessibleClassSnapshotExternalizer.INSTANCE), classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile());
                        } else if (object instanceof ShrinkMode.ChangedLookupsChangedClasspath) {
                            list8 = ((ShrinkMode.ChangedLookupsChangedClasspath)shrinkMode2).getShrunkCurrentClasspathAgainstPreviousLookups();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        list6 = list8;
                    }
                    finally {
                        $this$measure$iv3.endMeasure(time$iv3);
                    }
                    shrunkCurrentClasspathAgainstPrevLookups = list6;
                    time$iv3 = (Iterable)shrunkCurrentClasspathAgainstPrevLookups;
                    Collection $i$f$measure222 = new LinkedHashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        AccessibleClassSnapshot accessibleClassSnapshot = (AccessibleClassSnapshot)item$iv;
                        void var22_41 = destination$iv;
                        boolean bl4 = false;
                        var22_41.add(it.getClassId());
                    }
                    Set shrunkClasses = (Set)destination$iv;
                    Iterable $this$filter$iv = currentClasspath;
                    boolean $i$f$filter = false;
                    object = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        AccessibleClassSnapshot it = (AccessibleClassSnapshot)element$iv$iv;
                        boolean bl5 = false;
                        if (!(!shrunkClasses.contains(it.getClassId()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List notYetShrunkClasses = (List)destination$iv$iv;
                    List shrunkRemainingClassesAgainstNewLookups = ClasspathSnapshotShrinker.shrinkClasses$default(ClasspathSnapshotShrinker.INSTANCE, notYetShrunkClasses, ((ShrinkMode.ChangedLookups)shrinkMode2).getAddedLookupSymbols(), null, 4, null);
                    List shrunkCurrentClasspath = CollectionsKt.plus((Collection)((Collection)shrunkCurrentClasspathAgainstPrevLookups), (Iterable)shrunkRemainingClassesAgainstNewLookups);
                    Pair pair2 = TuplesKt.to(currentClasspath, (Object)shrunkCurrentClasspath);
                    pair = pair2;
                }
                finally {
                    $this$measure$iv2.endMeasure(time$iv);
                }
            }
            if (addedLookupSymbols instanceof ShrinkMode.NonIncremental) {
                $this$measure$iv2 = reporter;
                time$iv = GradleBuildTime.NON_INCREMENTAL_SHRINK_CURRENT_CLASSPATH_SNAPSHOT;
                $i$f$measure = false;
                $this$measure$iv2.startMeasure(time$iv);
                try {
                    List<AccessibleClassSnapshot> list9;
                    boolean bl = false;
                    shrunkCurrentClasspathAgainstPrevLookups = reporter;
                    time$iv2 = GradleBuildTime.NON_INCREMENTAL_LOAD_CURRENT_CLASSPATH_SNAPSHOT;
                    boolean $i$f$measure3 = false;
                    $this$measure$iv.startMeasure(time$iv2);
                    try {
                        boolean bl6 = false;
                        list9 = ClasspathSnapshotShrinkerKt.removeDuplicateAndInaccessibleClasses(CachedClasspathSnapshotSerializer.INSTANCE.load(classpathChanges.getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles(), reporter));
                    }
                    finally {
                        $this$measure$iv.endMeasure(time$iv2);
                    }
                    List<AccessibleClassSnapshot> currentClasspath = list9;
                    List shrunkCurrentClasspath = ClasspathSnapshotShrinker.shrinkClasspath$default(ClasspathSnapshotShrinker.INSTANCE, currentClasspath, lookupStorage, null, 4, null);
                    Pair pair3 = TuplesKt.to(currentClasspath, (Object)shrunkCurrentClasspath);
                    pair = pair3;
                }
                finally {
                    $this$measure$iv2.endMeasure(time$iv);
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        classpathSnapshotEnabled = pair;
        List currentClasspath = (List)classpathSnapshotEnabled.component1();
        List shrunkCurrentClasspath = (List)classpathSnapshotEnabled.component2();
        if (Intrinsics.areEqual((Object)shrinkMode2, (Object)ShrinkMode.UnchangedLookupsUnchangedClasspath.INSTANCE)) {
            if (!classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile().isFile()) {
                boolean $i$a$-check-ClasspathSnapshotShrinkerKt$shrinkAndSaveClasspathSnapshot$42 = false;
                String $i$a$-check-ClasspathSnapshotShrinkerKt$shrinkAndSaveClasspathSnapshot$42 = "File '" + classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile().getPath() + "' does not exist";
                throw new IllegalStateException($i$a$-check-ClasspathSnapshotShrinkerKt$shrinkAndSaveClasspathSnapshot$42.toString());
            }
        } else {
            void $this$measure$iv;
            time$iv = reporter;
            BuildTime time$iv4 = GradleBuildTime.SAVE_SHRUNK_CURRENT_CLASSPATH_SNAPSHOT;
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv4);
            try {
                boolean bl = false;
                DataExternalizer dataExternalizer = new ListExternalizer(AccessibleClassSnapshotExternalizer.INSTANCE);
                File file2 = classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile();
                List list10 = shrunkCurrentClasspath;
                Intrinsics.checkNotNull((Object)list10);
                ExternalizersKt.saveToFile(dataExternalizer, file2, list10);
                Object object = Unit.INSTANCE;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv4);
            }
        }
        ICReporterKt.debug(reporter, (Function0<String>)((Function0)new Function0<String>(shrinkMode2, (List<? extends AccessibleClassSnapshot>)shrunkCurrentClasspath, (List<? extends AccessibleClassSnapshot>)currentClasspath){
            final /* synthetic */ ShrinkMode $shrinkMode;
            final /* synthetic */ List<AccessibleClassSnapshot> $shrunkCurrentClasspath;
            final /* synthetic */ List<AccessibleClassSnapshot> $currentClasspath;
            {
                this.$shrinkMode = $shrinkMode;
                this.$shrunkCurrentClasspath = $shrunkCurrentClasspath;
                this.$currentClasspath = $currentClasspath;
                super(0);
            }

            public final String invoke() {
                String string2;
                StringBuilder stringBuilder2 = new StringBuilder().append("Shrunk current classpath snapshot after compilation (shrink mode = ").append(Reflection.getOrCreateKotlinClass(this.$shrinkMode.getClass()).getSimpleName()).append(')');
                if (this.$shrinkMode instanceof ShrinkMode.UnchangedLookupsUnchangedClasspath) {
                    string2 = ", no updates since previous run";
                } else {
                    StringBuilder stringBuilder3 = new StringBuilder().append(", retained ");
                    List<AccessibleClassSnapshot> list2 = this.$shrunkCurrentClasspath;
                    Intrinsics.checkNotNull(list2);
                    StringBuilder stringBuilder4 = stringBuilder3.append(list2.size()).append(" / ");
                    List<AccessibleClassSnapshot> list3 = this.$currentClasspath;
                    Intrinsics.checkNotNull(list3);
                    string2 = stringBuilder4.append(list3.size()).append(" classes").toString();
                }
                return stringBuilder2.append(string2).toString();
            }
        }));
        reporter.addMetric(GradleBuildPerformanceMetric.SHRINK_AND_SAVE_CLASSPATH_SNAPSHOT_EXECUTION_COUNT, 1L);
        reporter.addMetric(GradleBuildPerformanceMetric.CLASSPATH_ENTRY_COUNT, (long)classpathChanges.getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles().size());
        Iterable iterable = classpathChanges.getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles();
        GradleBuildPerformanceMetric gradleBuildPerformanceMetric = GradleBuildPerformanceMetric.CLASSPATH_SNAPSHOT_SIZE;
        ClasspathSnapshotBuildReporter classpathSnapshotBuildReporter = reporter;
        long l2 = 0L;
        for (Object object : iterable) {
            void it;
            File $i$f$measure3 = (File)object;
            l = l2;
            boolean bl = false;
            long l3 = it.length();
            l2 = l + l3;
        }
        l = l2;
        classpathSnapshotBuildReporter.addMetric(gradleBuildPerformanceMetric, l);
        reporter.addMetric(GradleBuildPerformanceMetric.SHRUNK_CLASSPATH_SNAPSHOT_SIZE, classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile().length());
    }
}

