/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;
import org.jetbrains.kotlin.incremental.storage.AppendableBasicStringMap;
import org.jetbrains.kotlin.incremental.storage.NameTransformer;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u0002B%\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u001b\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\bJ\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u000f\u001a\u00020\bH\u0086\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap;", "Name", "Lorg/jetbrains/kotlin/incremental/storage/AppendableBasicStringMap;", "", "", "nameTransformer", "Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;", "storageFile", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "clearOutputsForSource", "", "sourceFile", "add", "className", "(Ljava/io/File;Ljava/lang/Object;)V", "contains", "", "get", "getFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "dumpValue", "value", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nSourceToOutputMaps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceToOutputMaps.kt\norg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1549#2:67\n1620#2,3:68\n1549#2:71\n1620#2,3:72\n*S KotlinDebug\n*F\n+ 1 SourceToOutputMaps.kt\norg/jetbrains/kotlin/incremental/storage/AbstractSourceToOutputMap\n*L\n58#1:67\n58#1:68,3\n61#1:71\n61#1:72,3\n*E\n"})
public abstract class AbstractSourceToOutputMap<Name>
extends AppendableBasicStringMap<String, Collection<? extends String>> {
    @NotNull
    private final NameTransformer<Name> nameTransformer;

    public AbstractSourceToOutputMap(@NotNull NameTransformer<Name> nameTransformer, @NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(nameTransformer, (String)"nameTransformer");
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        KeyDescriptor keyDescriptor = PathStringDescriptor.INSTANCE;
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)enumeratorStringDescriptor, (String)"INSTANCE");
        super(storageFile, keyDescriptor, (DataExternalizer)enumeratorStringDescriptor, icContext);
        this.nameTransformer = nameTransformer;
    }

    public final void clearOutputsForSource(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.remove(this.getPathConverter().toPath(sourceFile));
    }

    public final void add(@NotNull File sourceFile, Name className2) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        this.getStorage().append(this.getPathConverter().toPath(sourceFile), this.nameTransformer.asString(className2));
    }

    @Override
    public final boolean contains(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.getStorage().contains(this.getPathConverter().toPath(sourceFile));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Collection<Name> get(@NotNull File sourceFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Collection collection = (Collection)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable iterable = CollectionsKt.toSet((Iterable)collection);
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(nameTransformer.asName((String)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> getFqNames(@NotNull File sourceFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Collection collection = (Collection)this.getStorage().get(this.getPathConverter().toPath(sourceFile));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Iterable iterable = CollectionsKt.toSet((Iterable)collection);
        NameTransformer<Name> nameTransformer = this.nameTransformer;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(nameTransformer.asFqName((String)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Collection<String> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value2);
    }
}

