/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsPolyfills;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u001c\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsPolyfills;", "", "<init>", "()V", "polyfillsPerFile", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "registerDeclarationNativeImplementation", "", "file", "declaration", "saveOnlyIntersectionOfNextDeclarationsFor", "declarations", "", "getAllPolyfillsFor", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "asImplementationList", "", "Lkotlin/sequences/Sequence;", "backend.js"})
public final class JsPolyfills {
    @NotNull
    private final HashMap<IrFile, HashSet<IrDeclaration>> polyfillsPerFile = new HashMap();

    public final void registerDeclarationNativeImplementation(@NotNull IrFile file2, @NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!AnnotationUtilsKt.hasJsPolyfill(declaration)) {
            return;
        }
        HashSet<IrDeclaration> hashSet = this.polyfillsPerFile.get(file2);
        if (hashSet == null) {
            hashSet = new HashSet<IrDeclaration>();
        }
        HashSet<IrDeclaration> declarations2 = hashSet;
        declarations2.add(declaration);
        ((Map)this.polyfillsPerFile).put(file2, declarations2);
    }

    public final void saveOnlyIntersectionOfNextDeclarationsFor(@NotNull IrFile file2, @NotNull Set<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        HashSet<IrDeclaration> hashSet = this.polyfillsPerFile.get(file2);
        if (hashSet == null) {
            return;
        }
        HashSet<IrDeclaration> polyfills = hashSet;
        ((Map)this.polyfillsPerFile).put(file2, CollectionsKt.toHashSet((Iterable)CollectionsKt.intersect((Iterable)polyfills, (Iterable)declarations2)));
    }

    @NotNull
    public final List<JsStatement> getAllPolyfillsFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Set set = this.polyfillsPerFile.get(file2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return this.asImplementationList(set);
    }

    private final List<JsStatement> asImplementationList(Iterable<? extends IrDeclaration> $this$asImplementationList) {
        return this.asImplementationList((Sequence<? extends IrDeclaration>)CollectionsKt.asSequence($this$asImplementationList));
    }

    private final List<JsStatement> asImplementationList(Sequence<? extends IrDeclaration> $this$asImplementationList) {
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.map($this$asImplementationList, (Function1)asImplementationList.1.INSTANCE), (Function1)asImplementationList.2.INSTANCE), (Function1)asImplementationList.3.INSTANCE));
    }
}

