/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/ArrayOf;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "<init>", "()V", "getListOfAcceptableFunctions", "", "", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "ir.interpreter"})
public final class ArrayOf
extends IntrinsicBase {
    @NotNull
    public static final ArrayOf INSTANCE = new ArrayOf();

    private ArrayOf() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        Object[] objectArray = new String[]{"kotlin.arrayOf", "kotlin.byteArrayOf", "kotlin.charArrayOf", "kotlin.shortArrayOf", "kotlin.intArrayOf", "kotlin.longArrayOf", "kotlin.floatArrayOf", "kotlin.doubleArrayOf", "kotlin.booleanArrayOf"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrValueParameterSymbol elementsSymbol = ((IrValueParameter)CollectionsKt.single(irFunction2.getValueParameters())).getSymbol();
        State varargVariable = environment.getCallStack$ir_interpreter().loadState(elementsSymbol);
        environment.getCallStack$ir_interpreter().pushState(varargVariable);
    }
}

