/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.overrides.IrOverrideCheckerKt;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextWithAdditionalAxioms;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/overrides/IrOverrideChecker;", "", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Ljava/util/List;)V", "getBothWaysOverridability", "Lorg/jetbrains/kotlin/resolve/OverridingUtil$OverrideCompatibilityInfo$Result;", "overriderDescriptor", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "candidateDescriptor", "isOverridableBy", "Lorg/jetbrains/kotlin/resolve/OverridingUtil$OverrideCompatibilityInfo;", "superMember", "subMember", "checkIsInlineFlag", "", "isOverridableByWithoutExternalConditions", "runExternalOverridabilityConditions", "basicResult", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrOverrideChecker.kt\norg/jetbrains/kotlin/ir/overrides/IrOverrideChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1864#2,3:197\n*S KotlinDebug\n*F\n+ 1 IrOverrideChecker.kt\norg/jetbrains/kotlin/ir/overrides/IrOverrideChecker\n*L\n121#1:197,3\n*E\n"})
public final class IrOverrideChecker {
    @NotNull
    private final IrTypeSystemContext typeSystem;
    @NotNull
    private final List<IrExternalOverridabilityCondition> externalOverridabilityConditions;

    public IrOverrideChecker(@NotNull IrTypeSystemContext typeSystem, @NotNull List<? extends IrExternalOverridabilityCondition> externalOverridabilityConditions) {
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        Intrinsics.checkNotNullParameter(externalOverridabilityConditions, (String)"externalOverridabilityConditions");
        this.typeSystem = typeSystem;
        this.externalOverridabilityConditions = externalOverridabilityConditions;
    }

    @NotNull
    public final OverridingUtil.OverrideCompatibilityInfo.Result getBothWaysOverridability(@NotNull IrOverridableMember overriderDescriptor, @NotNull IrOverridableMember candidateDescriptor) {
        Intrinsics.checkNotNullParameter((Object)overriderDescriptor, (String)"overriderDescriptor");
        Intrinsics.checkNotNullParameter((Object)candidateDescriptor, (String)"candidateDescriptor");
        OverridingUtil.OverrideCompatibilityInfo.Result result2 = this.isOverridableBy(candidateDescriptor, overriderDescriptor, false).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result2), (String)"getResult(...)");
        OverridingUtil.OverrideCompatibilityInfo.Result result1 = result2;
        OverridingUtil.OverrideCompatibilityInfo.Result result3 = this.isOverridableBy(overriderDescriptor, candidateDescriptor, false).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result3), (String)"getResult(...)");
        OverridingUtil.OverrideCompatibilityInfo.Result result22 = result3;
        return result1 == result22 ? result1 : OverridingUtil.OverrideCompatibilityInfo.Result.INCOMPATIBLE;
    }

    @NotNull
    public final OverridingUtil.OverrideCompatibilityInfo isOverridableBy(@NotNull IrOverridableMember superMember, @NotNull IrOverridableMember subMember, boolean checkIsInlineFlag) {
        Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
        Intrinsics.checkNotNullParameter((Object)subMember, (String)"subMember");
        OverridingUtil.OverrideCompatibilityInfo basicResult2 = this.isOverridableByWithoutExternalConditions(superMember, subMember, checkIsInlineFlag);
        return this.runExternalOverridabilityConditions(superMember, subMember, basicResult2);
    }

    /*
     * WARNING - void declaration
     */
    private final OverridingUtil.OverrideCompatibilityInfo isOverridableByWithoutExternalConditions(IrOverridableMember superMember, IrOverridableMember subMember, boolean checkIsInlineFlag) {
        List<IrTypeParameter> superTypeParameters = null;
        List<IrTypeParameter> subTypeParameters = null;
        List superValueParameters = null;
        List subValueParameters = null;
        IrOverridableMember irOverridableMember = superMember;
        if (irOverridableMember instanceof IrSimpleFunction) {
            if (!(subMember instanceof IrSimpleFunction)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Member kind mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (IrOverrideCheckerKt.access$getHasExtensionReceiver((IrSimpleFunction)superMember) != IrOverrideCheckerKt.access$getHasExtensionReceiver((IrSimpleFunction)subMember)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (((IrSimpleFunction)superMember).isSuspend() != ((IrSimpleFunction)subMember).isSuspend()) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Incompatible suspendability");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (checkIsInlineFlag && ((IrSimpleFunction)superMember).isInline()) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Inline function can't be overridden");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            superTypeParameters = ((IrSimpleFunction)superMember).getTypeParameters();
            subTypeParameters = ((IrSimpleFunction)subMember).getTypeParameters();
            superValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrSimpleFunction)superMember);
            subValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrSimpleFunction)subMember);
        } else if (irOverridableMember instanceof IrProperty) {
            if (!(subMember instanceof IrProperty)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Member kind mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (IrOverrideCheckerKt.access$getHasExtensionReceiver(((IrProperty)superMember).getGetter()) != IrOverrideCheckerKt.access$getHasExtensionReceiver(((IrProperty)subMember).getGetter())) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            if (checkIsInlineFlag && IrOverrideCheckerKt.access$isInline((IrProperty)superMember)) {
                OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Inline property can't be overridden");
                Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                return overrideCompatibilityInfo;
            }
            superTypeParameters = IrOverrideCheckerKt.access$getTypeParameters((IrProperty)superMember);
            subTypeParameters = IrOverrideCheckerKt.access$getTypeParameters((IrProperty)subMember);
            superValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrProperty)superMember);
            subValueParameters = IrOverrideCheckerKt.access$getCompiledValueParameters((IrProperty)subMember);
        } else {
            throw new IllegalStateException(("Unexpected type of declaration: " + superMember.getClass() + ", " + superMember).toString());
        }
        if (!Intrinsics.areEqual((Object)((IrOverridableDeclaration)superMember).getName(), (Object)((IrOverridableDeclaration)subMember).getName())) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Name mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        if (superTypeParameters.size() != subTypeParameters.size()) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Type parameter number mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        if (superValueParameters.size() != subValueParameters.size()) {
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Value parameter number mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        TypeCheckerState typeCheckerState2 = IrTypeCheckerStateKt.createIrTypeCheckerState(new IrTypeSystemContextWithAdditionalAxioms(this.typeSystem, superTypeParameters, subTypeParameters));
        Iterable $this$forEachIndexed$iv = superValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index2 = n;
            boolean bl = false;
            if (AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState2, ((IrValueParameter)subValueParameters.get(index2)).getType(), parameter2.getType())) continue;
            OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("Value parameter type mismatch");
            Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
            return overrideCompatibilityInfo;
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.success();
        Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"success(...)");
        return overrideCompatibilityInfo;
    }

    private final OverridingUtil.OverrideCompatibilityInfo runExternalOverridabilityConditions(IrOverridableMember superMember, IrOverridableMember subMember, OverridingUtil.OverrideCompatibilityInfo basicResult2) {
        IrExternalOverridabilityCondition.Result result2;
        boolean wasSuccess = basicResult2.getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
        block12: for (IrExternalOverridabilityCondition externalCondition : this.externalOverridabilityConditions) {
            if (externalCondition.getContract() == IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY || wasSuccess && externalCondition.getContract() == IrExternalOverridabilityCondition.Contract.SUCCESS_ONLY) continue;
            result2 = externalCondition.isOverridable(superMember, subMember);
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 1: {
                    wasSuccess = true;
                    continue block12;
                }
                case 2: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.conflict("External condition failed");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"conflict(...)");
                    return overrideCompatibilityInfo;
                }
                case 3: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("External condition");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                    return overrideCompatibilityInfo;
                }
                case 4: {
                    continue block12;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!wasSuccess) {
            return basicResult2;
        }
        block13: for (IrExternalOverridabilityCondition externalCondition : this.externalOverridabilityConditions) {
            if (externalCondition.getContract() != IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY) continue;
            result2 = externalCondition.isOverridable(superMember, subMember);
            switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                case 2: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.conflict("External condition failed");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"conflict(...)");
                    return overrideCompatibilityInfo;
                }
                case 3: {
                    OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.incompatible("External condition");
                    Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"incompatible(...)");
                    return overrideCompatibilityInfo;
                }
                case 1: {
                    throw new IllegalStateException(("Contract violation in " + externalCondition.getClass() + " condition. It's not supposed to end with success").toString());
                }
                case 4: {
                    continue block13;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = OverridingUtil.OverrideCompatibilityInfo.success();
        Intrinsics.checkNotNullExpressionValue((Object)overrideCompatibilityInfo, (String)"success(...)");
        return overrideCompatibilityInfo;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrExternalOverridabilityCondition.Result.values().length];
            try {
                nArray[IrExternalOverridabilityCondition.Result.OVERRIDABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.CONFLICT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.INCOMPATIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrExternalOverridabilityCondition.Result.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

