/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\nH$\u00a2\u0006\u0002\u0010\u000fJ=\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\n2\u0006\u0010\u0012\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/AbstractFilteringTrace;", "Lorg/jetbrains/kotlin/resolve/DelegatingBindingTrace;", "parentTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "name", "", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/lang/String;)V", "shouldBeHiddenFromParent", "", "K", "V", "slice", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "key", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;)Z", "record", "", "value", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;Ljava/lang/Object;)V", "report", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "wantsDiagnostics", "frontend"})
public abstract class AbstractFilteringTrace
extends DelegatingBindingTrace {
    @NotNull
    private final BindingTrace parentTrace;

    public AbstractFilteringTrace(@NotNull BindingTrace parentTrace, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)parentTrace, (String)"parentTrace");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        BindingContext bindingContext = parentTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        super(bindingContext, name2, true, BindingTraceFilter.Companion.getACCEPT_ALL(), false, null, 32, null);
        this.parentTrace = parentTrace;
    }

    protected abstract <K, V> boolean shouldBeHiddenFromParent(@NotNull WritableSlice<K, V> var1, K var2);

    @Override
    public <K, V> void record(@NotNull WritableSlice<K, V> slice, K key, V value2) {
        Intrinsics.checkNotNullParameter(slice, (String)"slice");
        if (this.shouldBeHiddenFromParent(slice, key)) {
            super.record(slice, key, value2);
        } else {
            this.parentTrace.record(slice, key, value2);
        }
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticSink.DiagnosticsCallback diagnosticsCallback = this.getDiagnosticsCallback();
        if (diagnosticsCallback != null) {
            diagnosticsCallback.callback(diagnostic);
        }
        this.parentTrace.report(diagnostic);
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.parentTrace.wantsDiagnostics();
    }
}

