/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\u0005*\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/UnitTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "<init>", "()V", "conversionDefinitelyNotNeeded", "", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedParameterType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "hasUnitOrSubtypeReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "isUnitOrSubtypeOrVariable", "isUnitOrSubtype", "conversionIsNeededBeforeSubtypingCheck", "areSuspendOnlySamConversionsSupported", "conversionIsNeededAfterSubtypingCheck", "convertParameterType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "resolution"})
@SourceDebugExtension(value={"SMAP\nUnitTypeConversions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitTypeConversions.kt\norg/jetbrains/kotlin/resolve/calls/components/UnitTypeConversions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1747#2,3:99\n1549#2:102\n1620#2,3:103\n*S KotlinDebug\n*F\n+ 1 UnitTypeConversions.kt\norg/jetbrains/kotlin/resolve/calls/components/UnitTypeConversions\n*L\n34#1:99,3\n85#1:102\n85#1:103,3\n*E\n"})
public final class UnitTypeConversions
implements ParameterTypeConversion {
    @NotNull
    public static final UnitTypeConversions INSTANCE = new UnitTypeConversions();

    private UnitTypeConversions() {
    }

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull ResolutionCandidate candidate2, @NotNull KotlinCallArgument argument2, @NotNull UnwrappedType expectedParameterType) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
            Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
            if (!(argument2 instanceof SimpleKotlinCallArgument)) {
                return true;
            }
            ReceiverValueWithSmartCastInfo receiver = ((SimpleKotlinCallArgument)argument2).getReceiver();
            ConstraintSystemBuilder csBuilder = candidate2.getSystem().getBuilder();
            KotlinType kotlinType = receiver.getReceiverValue().getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (this.hasUnitOrSubtypeReturnType(kotlinType, csBuilder)) {
                return true;
            }
            Iterable $this$any$iv = receiver.getTypesFromSmartCasts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.hasUnitOrSubtypeReturnType(it, csBuilder)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        return !FunctionTypesKt.isBuiltinFunctionalType(expectedParameterType) || !TypeUtilsKt.isUnit(FunctionTypesKt.getReturnTypeFromFunctionType(expectedParameterType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnitOrSubtypeReturnType(KotlinType $this$hasUnitOrSubtypeReturnType, ConstraintSystemOperation c) {
        if (!FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability($this$hasUnitOrSubtypeReturnType)) return false;
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($this$hasUnitOrSubtypeReturnType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        if (!this.isUnitOrSubtypeOrVariable(kotlinType, c)) return false;
        return true;
    }

    private final boolean isUnitOrSubtypeOrVariable(KotlinType $this$isUnitOrSubtypeOrVariable, ConstraintSystemOperation c) {
        return this.isUnitOrSubtype($this$isUnitOrSubtypeOrVariable) || c.isTypeVariable($this$isUnitOrSubtypeOrVariable);
    }

    private final boolean isUnitOrSubtype(KotlinType $this$isUnitOrSubtype) {
        return TypeUtilsKt.isUnit($this$isUnitOrSubtype) || DynamicTypesKt.isDynamic($this$isUnitOrSubtype) || TypeUtilsKt.isNothing($this$isUnitOrSubtype);
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument2, boolean areSuspendOnlySamConversionsSupported) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return argument2 instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument2).getReceiver()));
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!(argument2 instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        Ref.BooleanRef isFunctionTypeOrSubtype2 = new Ref.BooleanRef();
        boolean hasReturnTypeInSubtypes2 = FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument2).getReceiver()), (Function1<? super KotlinType, Boolean>)((Function1)new Function1<KotlinType, Boolean>(isFunctionTypeOrSubtype2){
            final /* synthetic */ Ref.BooleanRef $isFunctionTypeOrSubtype;
            {
                this.$isFunctionTypeOrSubtype = $isFunctionTypeOrSubtype;
                super(1);
            }

            public final Boolean invoke(KotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$isFunctionTypeOrSubtype.element = true;
                return UnitTypeConversions.access$isUnitOrSubtype(UnitTypeConversions.INSTANCE, FunctionTypesKt.getReturnTypeFromFunctionType(it));
            }
        }));
        if (!isFunctionTypeOrSubtype2.element) {
            return false;
        }
        return !hasReturnTypeInSubtypes2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UnwrappedType convertParameterType(@NotNull ResolutionCandidate candidate2, @NotNull KotlinCallArgument argument2, @NotNull ParameterDescriptor parameter2, @NotNull UnwrappedType expectedParameterType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedParameterType);
        List<KotlinType> list2 = FunctionTypesKt.getContextReceiverTypesFromFunctionType(expectedParameterType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedParameterType);
        Annotations annotations2 = expectedParameterType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = candidate2.getCallComponents().getBuiltIns();
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        SimpleType simpleType2 = candidate2.getCallComponents().getBuiltIns().getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getNullableAnyType(...)");
        SimpleType nonUnitReturnedParameterType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list2, collection, null, simpleType2, FunctionTypesKt.isSuspendFunctionType(expectedParameterType));
        candidate2.getResolvedCall().registerArgumentWithUnitConversion(argument2, nonUnitReturnedParameterType);
        ResolvedCallAtomsKt.markCandidateForCompatibilityResolve$default(candidate2, false, 1, null);
        return nonUnitReturnedParameterType;
    }

    public static final /* synthetic */ boolean access$isUnitOrSubtype(UnitTypeConversions $this, KotlinType $receiver) {
        return $this.isUnitOrSubtype($receiver);
    }
}

