/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import org.jetbrains.kotlin.resolve.multiplatform.K1ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.K1ExpectActualCompatibilityKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectActualInTheSameModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "declarationSource", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "getDeclarationSource", "(Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "frontend"})
@SourceDebugExtension(value={"SMAP\nExpectActualInTheSameModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualInTheSameModuleChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectActualInTheSameModuleChecker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n526#2:71\n511#2,6:72\n76#3:78\n96#3,5:79\n1#4:84\n1726#5,3:85\n*S KotlinDebug\n*F\n+ 1 ExpectActualInTheSameModuleChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ExpectActualInTheSameModuleChecker\n*L\n32#1:71\n32#1:72,6\n33#1:78\n33#1:79,5\n55#1:85,3\n*E\n"})
public final class ExpectActualInTheSameModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final ExpectActualInTheSameModuleChecker INSTANCE = new ExpectActualInTheSameModuleChecker();

    private ExpectActualInTheSameModuleChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        List $this$flatMap$iv;
        ModuleDescriptor module2;
        block22: {
            block21: {
                void $this$flatMapTo$iv$iv;
                void $this$filterTo$iv$iv;
                Iterator $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
                    return;
                }
                if (!(descriptor2 instanceof MemberDescriptor)) {
                    return;
                }
                if (!(declaration instanceof KtNamedDeclaration)) {
                    return;
                }
                if (!((MemberDescriptor)descriptor2).isExpect()) {
                    return;
                }
                if (!(((MemberDescriptor)descriptor2).getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
                    return;
                }
                module2 = DescriptorUtilsKt.getModule(descriptor2);
                Map map = ExpectedActualResolver.findActualForExpected$default(ExpectedActualResolver.INSTANCE, (MemberDescriptor)descriptor2, module2, null, 4, null);
                if (map == null) break block21;
                Map map2 = map;
                boolean $i$f$filter22 = false;
                void var10_9 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    K1ExpectActualCompatibility compatibility = (K1ExpectActualCompatibility)entry.getKey();
                    if (!K1ExpectActualCompatibilityKt.isCompatibleOrWeaklyIncompatible(compatibility)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map $i$f$filter22 = destination$iv$iv;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry bl = element$iv$iv = iterator3.next();
                    boolean bl2 = false;
                    List members = (List)bl.getValue();
                    Iterable list$iv$iv = members;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List p0 = $i$f$flatMap = (List)destination$iv$iv2;
                boolean bl = false;
                List list2 = $this$flatMap$iv = !((Collection)p0).isEmpty() ? $i$f$flatMap : null;
                if ($this$flatMap$iv != null) break block22;
            }
            return;
        }
        List actuals = $this$flatMap$iv;
        if (TargetPlatformKt.isCommon(module2.getPlatform())) {
            boolean bl;
            block20: {
                Iterable $this$all$iv = actuals;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        MemberDescriptor it = (MemberDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule(it), (Object)module2)) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        } else {
            KtFile ktFile = ((KtNamedDeclaration)declaration).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            if (Intrinsics.areEqual((Object)IsCommonSourceKt.isCommonSource(ktFile), (Object)true)) {
                return;
            }
        }
        context2.getTrace().report(Errors.EXPECT_AND_ACTUAL_IN_THE_SAME_MODULE.on((KtNamedDeclaration)declaration, (MemberDescriptor)descriptor2));
        for (MemberDescriptor actual : actuals) {
            KtNamedDeclaration actualSource;
            if (this.getDeclarationSource(actual) == null) continue;
            context2.getTrace().report(Errors.EXPECT_AND_ACTUAL_IN_THE_SAME_MODULE.on((KtNamedDeclaration)((PsiElement)actualSource), (MemberDescriptor)descriptor2));
        }
    }

    private final KtNamedDeclaration getDeclarationSource(MemberDescriptor $this$declarationSource) {
        SourceElement sourceElement = $this$declarationSource.getSource();
        KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
        KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
        return ktElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)ktElement : null;
    }
}

