/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 D2\u00020\u0001:\u0001DB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ1\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\b\u0012\u0006\u0012\u0002\b\u00030!0\u001f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b$J$\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J&\u0010*\u001a\u00020+2\u0014\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010!0-2\u0006\u0010(\u001a\u00020)H\u0002J(\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u00020+H\u0002J,\u00102\u001a\u00020\u00152\n\u00103\u001a\u0006\u0012\u0002\b\u0003042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00192\u0006\u00101\u001a\u00020+H\u0002J\u0018\u00105\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u00106\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010-2\u0006\u0010\u0018\u001a\u0002072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u00108\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010-2\u0006\u0010\u0018\u001a\u0002092\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010-2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002J\u0010\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020)H\u0002J2\u0010=\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003040-2\u0006\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010A\u001a\b\u0012\u0002\b\u0003\u0018\u0001042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u0017J$\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u0017J.\u0010C\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\u00103\u001a\u0006\u0012\u0002\b\u0003042\b\u0010@\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;)V", "getModule$frontend", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getInlineConstTracker$frontend", "()Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "updateNumberType", "", "numberType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveAnnotationArguments", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolveAnnotationArguments$frontend", "getAnnotationArgumentValue", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "isArrayPassedInNamedForm", "", "constants", "", "checkCompileTimeConstant", "argumentExpression", "expressionType", "useDeprecationWarning", "checkInnerPartsOfCompileTimeConstant", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "reportDeprecationWarningOnNonConst", "getArgumentExpressionsForArrayCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForCollectionLiteralCall", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "getArgumentExpressionsForArrayLikeCall", "hasSpread", "argument", "resolveAnnotationValueArguments", "resolvedValueArgument", "deprecatedExpectedType", "expectedType", "evaluateExpression", "evaluateToConstantValue", "checkExperimentalityOfConstantLiteral", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstantExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1293:1\n1549#2:1294\n1620#2,3:1295\n*S KotlinDebug\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator\n*L\n109#1:1294\n109#1:1295,3\n*E\n"})
public final class ConstantExpressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final OptInUsageChecker.OptInReporterMultiplexer EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS;

    public ConstantExpressionEvaluator(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull Project project, @NotNull InlineConstTracker inlineConstTracker) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)inlineConstTracker, (String)"inlineConstTracker");
        this.module = module2;
        this.languageVersionSettings = languageVersionSettings2;
        this.inlineConstTracker = inlineConstTracker;
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    public /* synthetic */ ConstantExpressionEvaluator(ModuleDescriptor moduleDescriptor, LanguageVersionSettings languageVersionSettings2, Project project, InlineConstTracker inlineConstTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            inlineConstTracker = InlineConstTracker.DoNothing.INSTANCE;
        }
        this(moduleDescriptor, languageVersionSettings2, project, inlineConstTracker);
    }

    @NotNull
    public final ModuleDescriptor getModule$frontend() {
        return this.module;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final InlineConstTracker getInlineConstTracker$frontend() {
        return this.inlineConstTracker;
    }

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression2, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)numberType, (String)"numberType");
        Intrinsics.checkNotNullParameter((Object)statementFilter, (String)"statementFilter");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (expression2 == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression2, trace, false);
        if (!(expression2 instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression2, statementFilter);
            if (deparenthesized != expression2) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression2, trace, numberType);
    }

    @NotNull
    public final Map<Name, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        HashMap arguments2 = new HashMap();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall2.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            Intrinsics.checkNotNull((Object)parameterDescriptor);
            Intrinsics.checkNotNull((Object)resolvedArgument);
            ConstantValue<?> value2 = this.getAnnotationArgumentValue(trace, parameterDescriptor, resolvedArgument);
            if (value2 == null) continue;
            ((Map)arguments2).put(parameterDescriptor.getName(), value2);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $this$mapTo$iv$iv;
        KotlinType kotlinType;
        boolean argumentsAsVararg;
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)resolvedArgument, (String)"resolvedArgument");
        KotlinType varargElementType2 = parameterDescriptor.getVarargElementType();
        boolean bl = argumentsAsVararg = varargElementType2 != null && !this.hasSpread(resolvedArgument);
        if (argumentsAsVararg) {
            kotlinType = varargElementType2;
        } else {
            KotlinType kotlinType2 = parameterDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        }
        KotlinType constantType = kotlinType;
        KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(parameterDescriptor, resolvedArgument, this.languageVersionSettings, trace);
        KotlinType kotlinType3 = constantType;
        Intrinsics.checkNotNull((Object)kotlinType3);
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType3, expectedType, trace);
        Iterable $this$map$iv = compileTimeConstants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toConstantValue(expectedType));
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (this.isArrayPassedInNamedForm(constants, resolvedArgument)) {
                return (ConstantValue)CollectionsKt.single((List)constants);
            }
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType4 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"getType(...)");
            return ConstantValueFactory.INSTANCE.createArrayValue(constants, kotlinType4);
        }
        return (ConstantValue)CollectionsKt.lastOrNull((List)constants);
    }

    private final boolean isArrayPassedInNamedForm(List<? extends ConstantValue<? extends Object>> constants, ResolvedValueArgument resolvedArgument) {
        ConstantValue constantValue = (ConstantValue)CollectionsKt.singleOrNull(constants);
        if (constantValue == null) {
            return false;
        }
        ConstantValue constant = constantValue;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(list2);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument2 = valueArgument;
        return constant instanceof ArrayValue && argument2.isNamed();
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expressionType2, BindingTrace trace, boolean useDeprecationWarning) {
        DiagnosticFactory0<KtExpression> diagnosticFactory;
        DiagnosticFactory0<KtExpression> diagnosticFactory0;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            this.checkInnerPartsOfCompileTimeConstant(constant, trace, argumentExpression, useDeprecationWarning);
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType2.getConstructor().getDeclarationDescriptor();
        if (DescriptorUtils.isEnumClass(descriptor2)) {
            diagnosticFactory0 = Errors.ANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST;
        } else if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(expressionType2.getArguments());
            diagnosticFactory0 = Companion.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null) ? Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR : Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL;
        } else {
            diagnosticFactory0 = diagnosticFactory = Errors.ANNOTATION_ARGUMENT_MUST_BE_CONST;
        }
        if (useDeprecationWarning) {
            this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
        } else {
            trace.report(diagnosticFactory.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final void checkInnerPartsOfCompileTimeConstant(CompileTimeConstant<?> constant, BindingTrace trace, KtExpression argumentExpression, boolean useDeprecationWarning) {
        KtExpression lhsExpression;
        List<KtExpression> callArguments;
        KtExpression ktExpression = argumentExpression;
        List<KtExpression> list2 = ktExpression instanceof KtCallExpression ? this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace) : (callArguments = ktExpression instanceof KtCollectionLiteralExpression ? this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression, trace) : null);
        if (callArguments != null) {
            for (KtExpression argument2 : callArguments) {
                KotlinType type2;
                if (trace.getType(argument2) == null) continue;
                this.checkCompileTimeConstant(argument2, type2, trace, useDeprecationWarning);
            }
        }
        if (constant.getUsesNonConstValAsConstant()) {
            if (useDeprecationWarning) {
                this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
            } else {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
        if (argumentExpression instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression).getReceiverExpression()) != null) {
            DoubleColonLHS doubleColonLhs = (DoubleColonLHS)trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression);
            if (doubleColonLhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
                if (useDeprecationWarning) {
                    this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
                } else {
                    trace.report(Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
                }
            } else if (doubleColonLhs instanceof DoubleColonLHS.Type && Companion.isTypeParameterOrArrayOfTypeParameter$frontend(((DoubleColonLHS.Type)doubleColonLhs).getType())) {
                trace.report(Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
    }

    private final void reportDeprecationWarningOnNonConst(KtExpression expression2, BindingTrace trace) {
        trace.report(Errors.ANNOTATION_ARGUMENT_IS_NON_CONST.on((KtExpression)((PsiElement)expression2)));
    }

    private final List<KtExpression> getArgumentExpressionsForArrayCall(KtCallExpression expression2, BindingTrace trace) {
        KtElement ktElement = expression2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForCollectionLiteralCall(KtCollectionLiteralExpression expression2, BindingTrace trace) {
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument = iterator2.next().getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result2.add(valueArgumentExpression);
            }
        }
        return result2;
    }

    private final boolean hasSpread(ResolvedValueArgument argument2) {
        List<ValueArgument> list2 = argument2.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
        List<ValueArgument> arguments2 = list2;
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType deprecatedExpectedType, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument2 : resolvedValueArgument.getArguments()) {
            KotlinType expressionType2;
            KtExpression argumentExpression;
            if (argument2.getArgumentExpression() == null) continue;
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType, argumentExpression, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            if (trace.getType(argumentExpression) == null) continue;
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonConstValuesAsVarargsInAnnotations) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType2, deprecatedExpectedType)) {
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType2, expectedType)) continue;
                this.checkCompileTimeConstant(argumentExpression, expressionType2, trace, true);
                continue;
            }
            this.checkCompileTimeConstant(argumentExpression, expressionType2, trace, false);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression2, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        this.checkExperimentalityOfConstantLiteral(expression2, constant, expectedType, trace);
        return !constant.isError() ? constant : null;
    }

    public static /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression2, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression2, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    private final void checkExperimentalityOfConstantLiteral(KtExpression expression2, CompileTimeConstant<?> constant, KotlinType expectedType, BindingTrace trace) {
        KotlinType kotlinType;
        if (constant.isError()) {
            return;
        }
        if (!constant.getParameters().isUnsignedNumberLiteral() && !constant.getParameters().isUnsignedLongNumberLiteral()) {
            return;
        }
        if (constant instanceof TypedCompileTimeConstant) {
            kotlinType = ((TypedCompileTimeConstant)constant).getType();
        } else {
            KotlinType kotlinType2 = expectedType;
            if (kotlinType2 != null) {
                kotlinType = constant.toConstantValue(kotlinType2).getType(this.module);
            } else {
                return;
            }
        }
        KotlinType constantType = kotlinType;
        if (!UnsignedTypes.isUnsignedType(constantType)) {
            return;
        }
        OptInUsageChecker.Companion $this$checkExperimentalityOfConstantLiteral_u24lambda_u241 = OptInUsageChecker.Companion;
        boolean bl = false;
        ClassifierDescriptor classifierDescriptor = constantType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        Set optInDescriptions = OptInUsageChecker.Companion.loadOptIns$default($this$checkExperimentalityOfConstantLiteral_u24lambda_u241, declarationDescriptor, this.moduleAnnotationsResolver, bindingContext, this.languageVersionSettings, null, false, false, false, 120, null);
        $this$checkExperimentalityOfConstantLiteral_u24lambda_u241.reportNotAllowedOptIns(optInDescriptions, expression2, this.languageVersionSettings, trace, EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getConstant(expression2, bindingContext);
    }

    @JvmStatic
    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
        return Companion.getPossiblyErrorConstant(expression2, bindingContext);
    }

    static {
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"EXPERIMENTAL_UNSIGNED_LITERALS");
        OptInUsageChecker.OptInDiagnosticReporter optInDiagnosticReporter = new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "should");
        DiagnosticFactory1<PsiElement, String> diagnosticFactory12 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory12, (String)"EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        OptInUsageChecker.OptInDiagnosticReporter optInDiagnosticReporter2 = new Companion.ExperimentalityDiagnostic1(diagnosticFactory12, "must");
        DiagnosticFactory1<PsiElement, String> diagnosticFactory13 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory13, (String)"EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS = new OptInUsageChecker.OptInReporterMultiplexer(optInDiagnosticReporter, optInDiagnosticReporter2, new Companion.ExperimentalityDiagnostic1(diagnosticFactory13, "must"));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0017\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "<init>", "()V", "EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "getConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getPossiblyErrorConstant", "isTypeParameterOrArrayOfTypeParameter", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTypeParameterOrArrayOfTypeParameter$frontend", "isComplexBooleanConstant", "constant", "ExperimentalityDiagnostic1", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression2, bindingContext);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @JvmStatic
        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        }

        public final boolean isTypeParameterOrArrayOfTypeParameter$frontend(@Nullable KotlinType type2) {
            boolean bl;
            if (type2 == null) {
                bl = false;
            } else if (KotlinBuiltIns.isArray(type2)) {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(type2.getArguments());
                bl = this.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null);
            } else {
                bl = type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
            }
            return bl;
        }

        public final boolean isComplexBooleanConstant(@NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(constant, (String)"constant");
            if (constant.isError()) {
                return false;
            }
            SimpleType simpleType2 = constant.getModuleDescriptor().getBuiltIns().getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getBooleanType(...)");
            ConstantValue<?> constantValue = constant.toConstantValue(simpleType2);
            if (!TypeUtilsKt.isBoolean(constantValue.getType(constant.getModuleDescriptor()))) {
                return false;
            }
            return !(expression2 instanceof KtConstantExpression) && !constant.getParameters().getUsesVariableAsConstant();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion$ExperimentalityDiagnostic1;", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "verb", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;Ljava/lang/String;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "getVerb", "()Ljava/lang/String;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "frontend"})
        private static final class ExperimentalityDiagnostic1
        implements OptInUsageChecker.OptInDiagnosticReporter {
            @NotNull
            private final DiagnosticFactory1<PsiElement, String> factory;
            @NotNull
            private final String verb;

            public ExperimentalityDiagnostic1(@NotNull DiagnosticFactory1<PsiElement, String> factory2, @NotNull String verb) {
                Intrinsics.checkNotNullParameter(factory2, (String)"factory");
                Intrinsics.checkNotNullParameter((Object)verb, (String)"verb");
                this.factory = factory2;
                this.verb = verb;
            }

            @NotNull
            public final DiagnosticFactory1<PsiElement, String> getFactory() {
                return this.factory;
            }

            @NotNull
            public final String getVerb() {
                return this.verb;
            }

            @Override
            public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message2) {
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                Function1<FqName, String> defaultMessage = OptInUsageChecker.Companion.getDefaultDiagnosticMessage$frontend("Unsigned literals are experimental and their usages " + this.verb + " be marked");
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, (String)defaultMessage.invoke((Object)fqName2));
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
            }
        }
    }
}

